[> Documentation-Index](index.md)

## Classes

<dl>
<dt><a href="#AdPlaylistAPI">AdPlaylistAPI</a></dt>
<dd></dd>
</dl>

## Typedefs

<dl>
<dt><a href="#AdPlaylistSetup">AdPlaylistSetup</a> : <code>Object</code></dt>
<dd><p>Ad configuration for the upcoming content video.</p>
</dd>
</dl>

<a name="AdPlaylistAPI"></a>

## AdPlaylistAPI
**Kind**: global class  

* [AdPlaylistAPI](#AdPlaylistAPI)
    * [.error](#AdPlaylistAPI+error) ⇒ <code>PluginError</code>
    * [.rawVMAP](#AdPlaylistAPI+rawVMAP) ⇒ <code>String</code>
    * [.initAdPlaylist(playlistSpecs, vastMacros)](#AdPlaylistAPI+initAdPlaylist)
    * [.startAdPlaylist()](#AdPlaylistAPI+startAdPlaylist)
    * [.stopAdPlaylist()](#AdPlaylistAPI+stopAdPlaylist)

<a name="AdPlaylistAPI+error"></a>

### adPlaylistAPI.error ⇒ <code>PluginError</code>
Requests details about the most recent error that has occurred.

**Kind**: instance property of <code>[AdPlaylistAPI](#AdPlaylistAPI)</code>  
**Returns**: <code>PluginError</code> - Description object of the most recent error or `null`.  
<a name="AdPlaylistAPI+rawVMAP"></a>

### adPlaylistAPI.rawVMAP ⇒ <code>String</code>
Returns the VMAP that has been collected for the current (content) session

**Kind**: instance property of <code>[AdPlaylistAPI](#AdPlaylistAPI)</code>  
**Returns**: <code>String</code> - XML as String
<a name="AdPlaylistAPI+initAdPlaylist"></a>

### adPlaylistAPI.initAdPlaylist(playlistSpecs, vastMacros)
Starts requesting a VMAP from the ad server

**Kind**: instance method of <code>[AdPlaylistAPI](#AdPlaylistAPI)</code>  

| Param | Type | Description |
| --- | --- | --- |
| playlistSpecs | <code>[AdPlaylistSetup](#AdPlaylistSetup)</code> | Ad configuration for the upcoming content video. |
| vastMacros | <code>VASTMacros</code> | VAST macros and their values as defined in  https://interactiveadvertisingbureau.github.io/vast/vast4macros/vast4-macros-latest.html |

<a name="AdPlaylistAPI+startAdPlaylist"></a>

### adPlaylistAPI.startAdPlaylist()
Starts playback and monitoring of the content and automatically inserts ad-slots
based on the `timeOffset` values of each VMAP AdBreak.
AdBreaks with a `timeOffset` equally to `0`, `"start"` or `"0%"` get requested immediately.

**Kind**: instance method of <code>[AdPlaylistAPI](#AdPlaylistAPI)</code>  

<a name="AdPlaylistAPI+stopAdPlaylist"></a>

### adPlaylistAPI.stopAdPlaylist()
Immediately stops monitoring the content playback.
AdBreaks that have already started remain until they complete. If necessary, they must be canceled
via the `AdSlotAPI.stopAdSlot()`.

**Kind**: instance method of <code>[AdPlaylistAPI](#AdPlaylistAPI)</code> 
	
<a name="AdPlaylistSetup"></a>

## AdPlaylistSetup : <code>AdPlaylistSetup</code>
Ad configuration for the upcoming content video.

**Kind**: global typedef  
**Properties**

| Name          | Type                        | Description                                                                                                                                      |
|---------------|-----------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------|
| tag           | <code>String</code>         | VMAP Request URL                                                                                                                                 |
| response      | <code>String</code>         | direct VMAP XML                                                                                                                                  |
| preroll       | <code>SeperationClip</code> | Separation Clip and Prefetching setup for the adBreak                                                                                            |
| midroll       | <code>SeperationClip</code> | Separation Clip and Prefetching setup                                                                                                            |
| postroll      | <code>SeperationClip</code> | Separation Clip and Prefetching setup                                                                                                            |
| overlay       | <code>SeperationClip</code> | Prefetching setup                                                                                                                                |
| strictOffsets | <code>boolean</code>        | If `true` offsets are maintained accordingly when fast-forwarding, no overspooled ad is delivered. Defaulting to `false` if omitted and ignored. |


