[> Documentation-Index](index.md)

## FacadeBase
**Kind**: interface

* [FacadeBase](#FacadeBase)
    * [.handshakeVersion(apiFacadeVersion)](#FacadeBase+handshakeVersion) ⇒ <code>string</code>
    * [.load(url, autoPlay, disableSeeking)](#FacadeBase+load) ⇒ <code>Boolean</code>
    * [.addEventListener(type, callback)](#FacadeBase+addEventListener)
    * [.removeEventListener(type, callback)](#FacadeBase+removeEventListener)
    * [.getCurrentContentSource()](#FacadeBase+getCurrentContentSource) ⇒ <code>ContentSource(#ContentSource)</code>
    * [.lockContent()](#FacadeBase+lockContent) ⇒ <code>ContentSource(#ContentSource)</code>
    * [.releaseContent()](#FacadeBase+releaseContent) ⇒ <code>Boolean</code>
    * [.getError()](#FacadeBase+getError) ⇒ <code>[MediaError](#MediaError)</code>
    * [.getCurrentTime()](#FacadeBase+getCurrentTime) ⇒ <code>Number</code>
    * [.getDuration()](#FacadeBase+getDuration) ⇒ <code>Number</code>
    * [.getPlayerSize()](#FacadeBase+getPlayerSize) ⇒ <code>[ElementSize](#ElementSize)</code>
    * [.getViewportSize()](#FacadeBase+getViewportSize) ⇒ <code>[ElementSize](#ElementSize)</code>
    * [.setVolume(volume)](#FacadeBase+setVolume)
    * [.getVolume()](#FacadeBase+getVolume)
    * [.isMuted()](#FacadeBase+isMuted) ⇒ <code>Boolean</code>
    * [.mute()](#FacadeBase+mute)
    * [.unmute()](#FacadeBase+unmute)
    * [.isPaused()](#FacadeBase+isPaused) ⇒ <code>Boolean</code>
    * [.pause()](#FacadeBase+pause)
    * [.play()](#FacadeBase+play)
    * [.seek(offset)](#FacadeBase+seek)


<a name="FacadeBase+handshakeVersion"></a>

### handshakeVersion(apiFacadeVersion) ⇒ <code>String</code>
Requests the player facade version (API version) to ensure the particular versions of `smartclientcore` and player facade
are supported.

**Kind**: instance method of <code>[FacadeBase](#FacadeBase)</code>  
**Returns**: <code>String</code> - Supported API version  

| Param | Type | Description |
| --- | --- | --- |
| apiFacadeVersion | <code>string</code> | Required API version |

<a name="FacadeBase+load"></a>

### load(url, autoPlay, disableSeeking)
Requests the video player to load and play the specified media file.

**Kind**: instance method of <code>[FacadeBase](#FacadeBase)</code>  

| Param | Type | Default | Description |
| --- | --- | --- | --- |
| url | <code>string</code> |  | Media file URI |
| autoPlay | <code>Boolean</code> | <code>true</code> | Whether the requested media file starts playback immediately. |
| disableSeeking | <code>Boolean</code> | <code>false</code> | Whether the requested source can be seeked back and forth. |

<a name="FacadeBase+addEventListener"></a>

### addEventListener(type, callback)
Sets up a function that will be called whenever the specified event is delivered to the video player.

**Kind**: instance method of <code>[FacadeBase](#FacadeBase)</code>  

| Param | Type | Description |
| --- | --- | --- |
| type | <code>string</code> | A case-sensitive string representing the player event type to listen for. |
| callback | <code>function</code> | The function which receives a notification when an event of the specified type occurs. |

<a name="FacadeBase+removeEventListener"></a>

### removeEventListener(type, callback)
Removes an event listener from the video player that has been registered with `addEventListener()`
_*Note:* The event listener to be removed must match with the listener that has been added._

**Kind**: instance method of <code>[FacadeBase](#FacadeBase)</code>  

| Param | Type | Description |
| --- | --- | --- |
| type | <code>string</code> | A case-sensitive string representing the player event type to listen for. |
| callback | <code>function</code> | The function which receives a notification when an event of the specified type occurs. |

<a name="FacadeBase+getCurrentContentSource"></a>

### getCurrentContentSource() ⇒ <code>ContentSource</code>
**Kind**: instance method of <code>[FacadeBase](#FacadeBase)</code>  
**Returns**: <code>SourceObject</code> - Current content source and playhead progress  
<a name="FacadeBase+lockContent"></a>

### lockContent() ⇒ <code>ContentSource</code>
Should freeze the current playback state (for later use with `releaseContent()`)
and respond to the PublisherAPI once finished.

**Kind**: instance method of <code>[FacadeBase](#FacadeBase)</code>  
**Returns**: <code>ContentSource</code> - Current content source and playhead progress for VAST tracking enrichment  
<a name="FacadeBase+releaseContent"></a>

### releaseContent()
Should restore the last known playback state, resume playback
and respond to the PublisherAPI once finished.

**Kind**: instance method of <code>[FacadeBase](#FacadeBase)</code>  
<a name="FacadeBase+getError"></a>

### getError() ⇒ <code>[MediaError](#MediaError)</code>
Requests details about the most recent error that has occurred on the video player.

**Kind**: instance method of <code>[FacadeBase](#FacadeBase)</code>  
**Returns**: <code>[MediaError](#MediaError)</code> - Description object of the most recent error or `null`.  
<a name="FacadeBase+getCurrentTime"></a>

### getCurrentTime() ⇒ <code>Double</code>
Requests the current playhead position from the video player.

**Kind**: instance method of <code>[FacadeBase](#FacadeBase)</code>  
**Returns**: <code>Double</code> - Current time in seconds.  
<a name="FacadeBase+getDuration"></a>

### getDuration() ⇒ <code>Double</code>
Requests the content-duration from the video player.

**Kind**: instance method of <code>[FacadeBase](#FacadeBase)</code>  
**Returns**: <code>Double</code> - Total time in seconds.  
<a name="FacadeBase+getPlayerSize"></a>

### getPlayerSize() ⇒ <code>[ElementSize](#ElementSize)</code>
Requests the current size and viewMode from the video player.

**Kind**: instance method of <code>[FacadeBase](#FacadeBase)</code>  
**Returns**: <code>[ElementSize](#ElementSize)</code> - Current player dimension specs  
<a name="FacadeBase+getViewportSize"></a>

### getViewportSize() ⇒ <code>[ElementSize](#ElementSize)</code>
Requests the current size and viewMode from the viewport that surrounds the video player.

**Kind**: instance method of <code>[FacadeBase](#FacadeBase)</code>  
**Returns**: <code>[ElementSize](#ElementSize)</code> - The dimension specs of the element  
<a name="FacadeBase+setVolume"></a>

### setVolume(volume)
Requests the video player to change the volume.

**Kind**: instance method of <code>[FacadeBase](#FacadeBase)</code>  


| Param | Type | Description |
| --- | --- | --- |
| volume | <code>Number</code> | Requested volume level between 0-1 |

<a name="FacadeBase+getVolume"></a>

### getVolume() ⇒ <code>Double</code>
Requests the current volume level from the video player.

**Kind**: instance method of <code>[FacadeBase](#FacadeBase)</code>  
**Returns**: <code>Double</code> - The current volume level between 0-1  
<a name="FacadeBase+isMuted"></a>

### isMuted() ⇒ <code>Boolean</code>
Requests the current muted state from the video player.

**Kind**: instance method of <code>[FacadeBase](#FacadeBase)</code>  
**Returns**: <code>Boolean</code> - Muted state  
<a name="FacadeBase+mute"></a>

### mute()
Requests the video player to mute playback.

**Kind**: instance method of <code>[FacadeBase](#FacadeBase)</code>  
<a name="FacadeBase+unmute"></a>

### unmute()
Requests the video player to unmute playback.

**Kind**: instance method of <code>[FacadeBase](#FacadeBase)</code>  
<a name="FacadeBase+isPaused"></a>

### isPaused() ⇒ <code>Boolean</code>
Requests the current play state from the video player.

**Kind**: instance method of <code>[FacadeBase](#FacadeBase)</code>  
**Returns**: <code>Boolean</code> - Playback state  
<a name="FacadeBase+pause"></a>

### pause()
Requests the video player to pause playback.

**Kind**: instance method of <code>[FacadeBase](#FacadeBase)</code>  
<a name="FacadeBase+play"></a>

### play()
Requests the video player to start (resume) playback.

**Kind**: instance method of <code>[FacadeBase](#FacadeBase)</code>  
<a name="FacadeBase+seek"></a>

### seek(offset)
Requests the video player to change the playhead position to the specified time.

**Kind**: instance method of <code>[FacadeBase](#FacadeBase)</code>  

| Param | Type | Description |
| --- | --- | --- |
| offset | <code>Number</code> | Requested playhead position |

<a name="MediaError"></a>

## MediaError : <code>Object</code>

**Kind**: global typedef  
**Properties**

| Name | Type | Description |
| --- | --- | --- |
| code | <code>Number</code> | A number which represents the general type of error that occurred. |
| message | <code>string</code> | A human-readable string which provides specific diagnostic information to help the reader understand the error condition which occurred. |

<a name="ElementSize"></a>

## ElementSize : <code>Object</code>
**Kind**: global typedef  
**Properties**

| Name | Type | Description |
| --- | --- | --- |
| rect | <code>Rect</code> | A android.graphics.Rect that holds four integer coordinates for a rectangle |
| viewMode | <code>String</code> | Either `normal` or `fullscreen` |

