[> Documentation-Index](index.md) [> Setup Guide](setup.md)

# smartClientCore

## Global Config
- [blockInsecureURL](#blockinsecureurl)
- [maxWrapperDepth](#maxwrapperdepth)
- [skipOffset](#skipoffset)
- [timeouts](#timeouts)
  - [adRequest](#timeouts+adrequest)
  - [adRequestChain](#timeouts+adrequestchain)
  - [adSlotRequest](#timeouts+adslotrequest)
  - [contentRequest](#timeouts+contentrequest)
  - [nonlinearMaxDuration](#timeouts+nonlinearmaxduration)
  - [videoRequest](#timeouts+videorequest)
  - [vpaidReadiness](#timeouts+vpaidreadiness)
  - [vpaidRequest](#timeouts+vpaidrequest)
- [trackImpressionOnStart](#trackimpressiononstart)
- [trackSkippedQuartiles](#trackskippedquartiles)
- [viewability](#viewability)
  - [area](#viewability+area)
  - [time](#viewability+time)
- [urlhandler](#urlhandler)

<a name="blockinsecureurl"></a>

### blockInsecureURL : <code>Boolean</code>
By default insecure URL requests (tags, tracker, media files) will not be executed within secure environment. Default is `true`.

<a name="maxwrapperdepth"></a>

### maxWrapperDepth : <code>Number</code>
When serving an ad involves a chain of wrappers, an infinite loop is possible where a chain of Wrappers never results in a final inline VAST response. 
In general, wrappers should be limited to ten before resulting in an inline response. If the add-on detects more than ten wrappers,
the add-on rejects any subsequent responses in the chain and returns VAST error 302.
Default limit is `10` wrappers.

<a name="skipoffset"></a>

### skipOffset : <code>Number</code>
Time value in seconds that identifies when skip controls are made available to the end user by default.
Advertisers may define a `skipoffset` value in its VAST tag that has higher priority than the publisher setting.


<a name="timeouts"></a>

### timeouts : <code>Timeouts</code>


<a name="timeouts+adrequest"></a>

#### adRequest : <code>Number</code>
The number of seconds a single ad request can take to load before being terminated.  
Default is `1` seconds.
 
<a name="timeouts+adrequestchain"></a>

#### adRequestChain : <code>Number</code>
The total number of seconds a single ad request chain (VAST Wrappers and final VAST Inline tag) can take to load before being terminated.  
Default is `2` seconds.

<a name="timeouts+adslotrequest"></a>

#### adSlotRequest : <code>Number</code>
The total number of seconds an ad-slot request (from calling `initAdSlot` until the Promise resolves or rejects) can take before being terminated.  
Default is `4` seconds.

<a name="timeouts+contentrequest"></a>

#### contentRequest : <code>Number</code>
The total number of seconds the video player can take to answer the `releaseContent` request to the player facade 
(see [FacadeBase.releaseContent()](FacadeBase.md#FacadeBase+releaseContent)). If the Promise is neither resolved nor rejected 
within the specified time, the AdSlot becomes terminated. The add-on responds by sending a general error with code 11 
(`ERROR_CODE.SESSION.NOT_RESTORABLE`) and message _SessionError: Reset content timed out. Player did not respond_.  
Default is `3` seconds.

<a name="timeouts+nonlinearmaxduration"></a>

#### nonlinearMaxDuration : <code>Number</code>
The maximum time in seconds a NonLinear ad is displayed (from triggering the impression) before being terminated.
**_Note_**_: The timer becomes paused for the time a creative has entered the linear state._   
Default is `10` seconds.

<a name="timeouts+videorequest"></a>

#### videoRequest : <code>Number</code>
Representing the number of seconds a video creative can take to load before being terminated.  
Default is `3` seconds.

<a name="timeouts+vpaidreadiness"></a>

#### vpaidReadiness : <code>Number</code>
Representing the number of seconds a VPAID creative can take to initialize and respond 
(from calling `VPAID.initAd()` until the creative triggers the `AdLoaded` event) before being terminated.  
Default is `3` seconds.

<a name="timeouts+vpaidrequest"></a>

#### vpaidRequest : <code>Number</code>
Representing the number of seconds a VPAID creative (JavaScript resource) can take to load before being terminated.  
Default is `1` seconds.

<a name="trackimpressiononstart"></a>

### trackImpressionOnStart : <code>Boolean</code>
Defines whether the trackers **impression** and **creativeView** are requested at the time a video ad is loaded
or when the video player actually starts playing (_start_, 0%). The difference is most noticeable with video players
or browsers that prevent autoplay without user interaction. The impression and creative view trackers are requested
immediately, while the **start** tracker is requested after a delay, depending on when playback starts.
Defaulting to `false` if omitted.

<a name="trackskippedquartiles"></a>

### trackSkippedQuartiles : <code>Boolean</code>
Defines whether to track all VAST progress trackers (**start**, **firstQuartile**, **midpoint**, **thirdQuartile**
and **complete**), regardless of whether some of them were somehow skipped or to just request VAST progress trackers
that were actually triggered by a matching playhead update. Possible "skip" use cases are the user seeks over one or
multiple progress points, or the timeupdate interval from the video player is too long.
Defaulting to `false` if omitted.

<a name="viewability"></a>

### viewability : <code>AdViewabilityConfig</code>
The Media Ratings Council (MRC) has published the following as recommendations for video viewability.
How a video ad is counted when 50% of the ad's pixels are visible for at least two seconds.
Publishers should disclose their process for tracking viewable video impressions.

<a name="viewability+area"></a>

#### area : <code>number</code>
The percentage of how many pixels of an ad must be in the visible area for the visibility time measurement to begin.
Default is `50` percent of pixels.

<a name="viewability+time"></a>

#### time : <code>number</code>
The number of seconds a single ad must be visible before a viewable tracker can be triggered.   
Default is `2` seconds.

<a name="urlhandler"></a>

### urlhandler : <code>URLHandler</code>
Allows switching to a different implementation for fetching ad tags and trackers
valid options are:
- URLHandler.DEFAULT
- URLHandler.NATIVE


[IAB]: https://www.iab.com/omsdk
[OM SDK for Web Video]: https://interactiveadvertisingbureau.github.io/Open-Measurement-SDKJS/#3-create-the-context
