# smartclip smartclientcore-vega - build guide
_Last Modified on 2026-01-15T08:36:43.540Z_  
_Current version 7.6.1_

## Table of contents
- [NPM Scripts](#NPM-scripts)
  - [npm](#install)
- [Documentation](#documentation)
- [SDK Update](#update)


## NPM-Scripts

* npm:install

### install
Download the smartclientcore package from the appropriate location and unzip it into the smartclientcore folder in the
root directory. All important packages are then installed via `npm install` to run the smartclientcore SDK on VegaOS.

## Documentation

### Project Setup Guide for VSCode and K Extension

#### Prerequisites

Ensure that a "K" icon appears under the Extensions tab in VSCode. If it is missing, follow the installation steps
outlined in the Amazon documentation to add the required extensions.

#### Project Preparation

Unpack the project zip file you get from the TPO.
Open the Project in VSCode:

Launch VSCode and use the "Open Folder" option to navigate to and open the extracted project folder.

##### Installing Dependencies

Open the `package.json` file in VSCode.

Hover over the following scripts:

npm:install

A blue popup will appear; click "Run Script" to execute the script.
Make sure that you have carried out the installation steps at the top correctly! [install description](#install)

#### Polyfills

If the app are works with the `Shakaplayer`, the supplied `DocumenPolyfill` must be replaced by ours.
It is recommended to remove the `DocumentPolyfill` from the `ShakaPlayer` section and install it as soon as possible

If another player is used, make sure that the `DocumentPolyfill` is installed in the main index file in the build.
The same applies to the `WindowPolyfill`.

#### Building the Project

Click on the K Extension in VSCode.
Locate your folder name under the extension.

Click on Build (represented by cylinder symbol) to start the build process.
Wait for the build to complete.

##### Running the Simulator

Go to K Extension -> Simulator (under the Devices section).
Start the simulator.
Once the simulator is running, you should see the text: `Simulator:Tv:SSH`.

##### Installing and Running the App

Under K Extension, navigate to your folder name -> Run (represented by a triangle symbol).
The app will start, and the content should load automatically.

##### Verifying Content Playback

Running the demo app will show you content with pre-, mid- and postroll advertisement.

## Update

If there are changes in the sdk, the new package must be unpacked in the root under smartclientcore.
Rerun `npm:install` script in `package.json` or execute it over the terminal as CLI `npm install`.
