[> Documentation-Index](index.md) [> Setup Guide](setup.md)

# smartClientCore

## Global Config
- [debug](#debug)
- [blockInsecureURL](#blockinsecureurl)
- [maxWrapperDepth](#maxwrapperdepth)
- [adRequestMethod](#adrequestmethod)
- [adReinsertion](#adreinsertion)
  - [HOMAD](#adreinsertion+homad)
- [adVerification](#adverification)
- [adSourceSelector](#adsourceselector)
- [playerHandlesNonLinear](#playerHandlesNonLinear)
- [skipOffset](#skipoffset)
- [timeouts](#timeouts)
  - [adRequest](#timeouts+adrequest)
  - [adRequestChain](#timeouts+adrequestchain)
  - [adSlotRequest](#timeouts+adslotrequest)
  - [contentRequest](#timeouts+contentrequest)
  - [nonlinearMaxDuration](#timeouts+nonlinearmaxduration)
  - [videoRequest](#timeouts+videorequest)
  - [vpaidReadiness](#timeouts+vpaidreadiness)
  - [vpaidRequest](#timeouts+vpaidrequest)
- [trackImpressionOnStart](#trackimpressiononstart)
- [trackSkippedQuartiles](#trackskippedquartiles)
- [viewability](#viewability)
  - [area](#viewability+area)
  - [time](#viewability+time)

<a name="debug"></a>

### debug : <code>Boolean</code>
Enables log output to the console from the start.
In addition, the log output can be activated at runtime by calling `localStorage.setItem ('debug', true);`.

<a name="blockinsecureurl"></a>

### blockInsecureURL : <code>Boolean</code>
By default insecure URL requests (tags, tracker, media files) will not be executed within secure environment. Default is `true`.

<a name="maxwrapperdepth"></a>

### maxWrapperDepth : <code>number</code>
When serving an ad involves a chain of wrappers, an infinite loop is possible where a chain of Wrappers never results in a final inline VAST response. 
In general, wrappers should be limited to ten before resulting in an inline response. If the smartclientcore detects more than ten wrappers,
the smartclientcore rejects any subsequent responses in the chain and returns VAST error 302.
Default limit is `10` wrappers.

<a name="adrequestmethod"></a>

### adRequestMethod : <code>string</code>
By default, ads are requested through **XHR**. This may not work with applications which target devices that do not support CORS 
or have not implemented the `XMLHTTPRequest` object, especially HbbTV apps for SmartTVs. As an alternative, ads can be requested through **JSONP**.  
Possible values are `smartclientcore.AD_REQUEST_METHOD.XHR` (the default if omitted) and `smartclientcore.AD_REQUEST_METHOD.JSONP`.

<a name="adreinsertion"></a>

### adReinsertion : <code>Object</code>

<a name="adreinsertion+homad"></a>

#### homad : <code>Object</code>
The smartclientcore has been extended with the **HOMAD HTML5 solution** to help bypassing ad-blockers.
All ad-related resources (tags, creative files, trackers) will be redirected to HOMAD once they get blocked for any reason.

**enabled : <code>Boolean</code>** - Enables HOMAD ad-reinsertion. Disabled by default.

**setup : <code>Object</code>** - HOMAD configuration

| Param | Type | Description |
| --- | --- | --- |
| globalConfig | <code>string</code> | URI to HOMAD's global configuration file. |
| clientConfig | <code>string</code> | URI to the client-specific configuration file. |
| enableSessionCoverage | <code>Boolean</code> | Decide whether ad-blockers should be detected again when requesting a new ad-break (default behavior) or not.<br><br>Disabled by default. |
| forceActivation | <code>Boolean</code> | Forces AdReinsertion through HOMAD from the start and affects all ad-tag requests, tracking and ad asset requests.<br><br> The smartclientcore responds with the `ON_AD_REINSERTION_ACTIVATION` (AdReinsertionActivation) event once HOMAD has been enabled and calling `initAdSlot()` is safe.<br><br> _**_Note_**: AdReinsertion reasons are detected again with each new ad-slot, see `adReinsertion.setup.enableSessionCoverage`. This flag should be turned on (`true`). Otherwise AdReinsertion is turned off after the first ad-slot._
| activationCallback([reason <code>number</code>](#adreinsertion+activation-codes)) | ⇒ <code>Promise</code> | Is called whenever the smartclientcore detects a scenario that blocks or would block an ad-related request.<br>Based on the specified [reason](#adreinsertion+activation-codes) the player has to decide whether the current ad-slot must be requested again through HOMAD or not.<br><br>Resolves if the publisher decides to re-call the current ad-break through HOMAD. |

> _If the `activationCallback` is omitted or does not respond within 250 milliseconds, 
> HOMAD will be automatically activated (if `enabled` before)._


```javascript
let globalAdConfig = smartclientcore.SCHEMA.create(smartclientcore.SCHEMA.GLOBAL_CONFIG);
globalAdConfig.adReinsertion = {
	homad: {
		enabled: true,
		setup: {
			globalConfig: 'https://s3.amazonaws.com/homad-global-configs.schneevonmorgen.com/global_config.json',
			clientConfig: 'https://test.s3.amazonaws.com/homad/homadConfigTestHttps.json',
			enableSessionCoverage: true,
			forceActivation: true,
			activationCallback: (reason) => {
				return new Promise((resolve, reject) => {
					
					// The reason for activating HOMAD sounds reasonable?
					resolve();
					
					// otherwise
					//reject();
				});
			}
		}
	}
};
```

<a name="adreinsertion+activation-codes"></a>

#### Activation Reason - Codes Table

| Code | Description |
| ---- | ----------- |
| 1000 | Timeout of ad-request URIs |
| 1001 | XHR request status is not 200 (ok)  |
| 1002 | XHR request error  |
| 1003 | XML parsing error  |
| 1004 | Timeout of wrapper request chain  |
| 1005 | Requesting the entire AdSlot timed out |
| 1010 | Timeout of media file request URIs |
| 1013 | General load error of media file URIs |
| 1020 | General ad-reinsertion activation request |


<a name="adverification"></a>

### adVerification : <code>Object</code>
Ad-verification vendors that rely on the Open Measurement (**OM**) Interface Definition API are enabled by default.
The following properties may be adjusted to enable selected verification vendors only and to limit the measurement session execution time.

More information on OMID and OM SDK available at: [IAB]

**disabled : <code>Boolean</code>** - Ad verification is enabled by default. Disable carefully.

> _Disabling OM should be limited to two situations: If the OM integration is interfering with your site (app), 
or if there is a bug in the integration that generates bad OM data._

**vendorWhitelist : <code>[ &#x27;Array&#x27; ].&lt;string&gt;</code>** - List of accepted AdVerification vendors
(whitelist). Each specified String has to represent an unique identifier that matches a verification node's vendor
attribute.

If omitted, the smartclientcore tries to load verification code from each vendor.

**sessionCleanupDelay : <code>number</code>** - Time value in seconds that specifies a delay for closing the current measurement session
after the ad has finished playback. 
Default is `3` seconds.

> _The verification code should have sufficient time to ensure any measurement 
and reporting is completed before cleaning up, in order to minimize discrepancies._ 

**timeoutScriptLoad : <code>number</code>** - Representing the number of seconds a OMID vendor can take to load and initialize its code before being terminated.
Defaulting to `1` seconds if omitted.

**playerHandles : <code>Boolean</code>** - Whether the player takes responsibility for Open Measurement, e.g. native implementations of OMID. 
Defaulting to `false` if omitted.

**accessMode : <code>String</code>** - Execution mode of the verification script. Needs to be either limited, domain, creative or full.   
Defaulting to `full` if omitted.

**serviceWindow : <code>Window</code>** - _Optional_. The DOM context into which the OM SDK Service Script was loaded.
The value becomes forwarded to the OM SDK Context `setServiceWindow` method as described in the [OM SDK for Web Video]
documentation. Defaulting to `window.top` if omitted.  

> _If necessary, the context for each ad-slot can be updated by setting the service window again through 
[`EnvironmentVars.omidServiceWindow`](setup-sequential-config.md#environmentvars+omidservicewindow)_


<a name="skipoffset"></a>

### skipOffset : <code>number</code>
Time value in seconds that identifies when skip controls are made available to the end user by default.
Advertisers may define a `skipoffset` value in its VAST tag that has higher priority than the publisher setting.


<a name="timeouts"></a>

### timeouts : <code>Object</code>
```javascript
let globalAdConfig = smartclientcore.SCHEMA.create(smartclientcore.SCHEMA.GLOBAL_CONFIG);
globalAdConfig.timeouts = {
	adRequest: 1,
    adRequestChain: 2,
    adSlotRequest: 4,
    contentRequest: 3,
    nonlinearMaxDuration: 10,
    videoRequest: 3,
    vpaidReadiness: 3,
    vpaidRequest: 1
};
```

<a name="timeouts+adrequest"></a>

#### adRequest : <code>number</code>
The number of seconds a single ad request can take to load before being terminated.  
Default is `1` seconds.
 
<a name="timeouts+adrequestchain"></a>

#### adRequestChain : <code>number</code>
The total number of seconds a single ad request chain (VAST Wrappers and final VAST Inline tag) can take to load before being terminated.  
Default is `2` seconds.

<a name="timeouts+adslotrequest"></a>

#### adSlotRequest : <code>number</code>
The total number of seconds an ad-slot request (from calling `initAdSlot` until the Promise resolves or rejects) can take before being terminated.  
Default is `4` seconds.

<a name="timeouts+contentrequest"></a>

#### contentRequest : <code>number</code>
The total number of seconds the video player can take to answer the `releaseContent` request to the player facade 
(see [FacadeBase.releaseContent()](FacadeBase.md#FacadeBase+releaseContent)). If the Promise is neither resolved nor rejected 
within the specified time, the AdSlot becomes terminated. The smartclientcore responds by sending a general error with code 11 
(`ERROR_CODE.SESSION.NOT_RESTORABLE`) and message _SessionError: Reset content timed out. Player did not respond_.  
Default is `3` seconds.

<a name="timeouts+nonlinearmaxduration"></a>

#### nonlinearMaxDuration : <code>number</code>
The maximum time in seconds a NonLinear ad is displayed (from triggering the impression) before being terminated.
**_Note_**_: The timer becomes paused for the time a creative has entered the linear state._   
Default is `10` seconds.

<a name="timeouts+videorequest"></a>

#### adSourceSelector : <code>Promise</code>
If no response is received within the specified timeout time of 250 ms, the adSourceFile object is emptied.

**Sample declaration**:

| Param | Type | description |
| ----- | ---- | ----------- |
| adSources | array | Array of available sources for the upcomimg ad. The list is cleaned up with `environmentVars.desiredVPAIDVendors` and `environmentVars.desiredMimeTypes`. |
| selectedSource | object | The source that fits the player and environment needs. |

```javascript
globalConfig = {
  
  ...
  adSourceSelector: (adSources) => {
    
	return new Promise((resolve) => {

		// TODO: Implement logic to find the best matching source for your needs.
		//  For illustration purpose we select the first source from the given list
		const selectedSource = adSources[0];
		
	        resolve(selectedSource);
        
        	// If none of the sources are good. `resolve(null)` or `resolve({})` 
        
        // don't reject!
    }
});
```

In order to decide what fits best to the player and environment needs, each element of the adSource array contains the
following properties:

**Linear**:
```javascript
{
    adParameter: 'XML-decoded data.',
    apiFramework: 'Identifies the API needed to execute the resource file if applicable.',
    bitrate: 'the bitrate value specifies the average bitrate for the media file',
    delivery: 'Either “progressive” for progressive download protocols or “streaming” for streaming protocols.',
    fileURL: 'contains url as string where source can be loaded',
    height: 'The native height of the video file, in pixels. (0 for audio ads)',
    linearity: 'linear or nonLinear ad type',
    mimeType: 'mimeType for the file container. Popular types are "video/mp4", "audio/mp3" for audio ads.',
    variableDuration: 'Boolean - true/false',
    width: 'The native width of the video file, in pixels. (0 for audio ads)'
}
```

**NonLinear**:
```javascript
{
  apiFramework: 'Identifies the API needed to execute the resource file if applicable.', 
  creativeType: 'Identifies the MIME type of the creative provided', // only StaticResource
  type: 'Node name of the resource', // HTML- / IFrame- / StaticResource
  resource: 'HTML textContent of the resource'
}
```

#### playerHandlesNonLinear : <code>boolean</code>
If `true` the own implementation with all NonLinear can be realized with other SDKs.
Default is `false`.

#### videoRequest : <code>number</code>
Representing the number of seconds a video creative can take to load before being terminated.  
Default is `3` seconds.

<a name="timeouts+vpaidreadiness"></a>

#### vpaidReadiness : <code>number</code>
Representing the number of seconds a VPAID creative can take to initialize and respond 
(from calling `VPAID.initAd()` until the creative triggers the `AdLoaded` event) before being terminated.  
Default is `3` seconds.

<a name="timeouts+vpaidrequest"></a>

#### vpaidRequest : <code>number</code>
Representing the number of seconds a VPAID creative (JavaScript resource) can take to load before being terminated.  
Default is `1` seconds.

<a name="trackimpressiononstart"></a>

### trackImpressionOnStart : <code>Boolean</code>
Defines whether the trackers **impression** and **start** are requested at the time a video ad is loaded or when the 
video player actually starts playing (_start_, 0%). The difference is most noticeable with video players or browsers 
that prevent autoplay without user interaction. The impression and creative view trackers are requested immediately,
while the **start** tracker is requested after a delay, depending on when playback starts.
Defaulting to `false` if omitted.

<a name="trackskippedquartiles"></a>

### trackSkippedQuartiles : <code>Boolean</code>
Defines whether to track all VAST progress trackers (**start**, **firstQuartile**, **midpoint**, **thirdQuartile**
and **complete**), regardless of whether some of them were somehow skipped or to just request VAST progress trackers
that were actually triggered by a matching playhead update. Possible "skip" use cases are the user seeks over one or
multiple progress points, or the timeupdate interval from the video player is too long.
Defaulting to `false` if omitted.

<a name="viewability"></a>

### viewability : <code>Object</code>
```javascript
let globalAdConfig = smartclientcore.SCHEMA.create(smartclientcore.SCHEMA.GLOBAL_CONFIG);
globalAdConfig.viewability = {
	area: 50,
	time: 2
};
```

The Media Ratings Council (MRC) has published the following as recommendations for video viewability.
How a video ad is counted when 50% of the ad's pixels are visible for at least two seconds.
Publishers should disclose their process for tracking viewable video impressions.

<a name="viewability+area"></a>

#### area : <code>number</code>
The percentage of how many pixels of an ad must be in the visible area for the visibility time measurement to begin.
Default is `50` percent of pixels.

<a name="viewability+time"></a>

#### time : <code>number</code>
The number of seconds a single ad must be visible before a viewable tracker can be triggered.   
Default is `2` seconds.

[IAB]: https://www.iab.com/omsdk
[OM SDK for Web Video]: https://interactiveadvertisingbureau.github.io/Open-Measurement-SDKJS/#3-create-the-context
