## Classes

<dl>
<dt><a href="#AdPlaylistAPI">AdPlaylistAPI</a></dt>
<dd></dd>
</dl>

## Typedefs

<dl>
<dt><a href="#AdPlaylistSetup">AdPlaylistSetup</a> : <code>Object</code></dt>
<dd><p>Ad configuration for the upcoming content video.</p>
</dd>
<dt><a href="#AdSlotSetup">AdSlotSetup</a> : <code>Object</code></dt>
<dd><p>Configuration for each of the four ad-slot types.</p>
</dd>
<dt><a href="#SeparationClip">SeparationClip</a> : <code>Object</code></dt>
<dd><p>A short video from the publisher that is played before (opener)
or after (closer) an ad-break. Also, a short video that is played between commercial and sponsored ads (bumper).</p>
</dd>
</dl>

<a name="AdPlaylistAPI"></a>

## AdPlaylistAPI
**Kind**: global class  

* [AdPlaylistAPI](#AdPlaylistAPI)
    * [new AdPlaylistAPI(playerProxy, adsAPI)](#new_AdPlaylistAPI_new)
    * [.error](#AdPlaylistAPI+error) ⇒ <code>PluginError</code>
    * [.rawVMAP](#AdPlaylistAPI+rawVMAP) ⇒ <code>XML</code>
    * [.initAdPlaylist(playlistSpecs, vastMacros)](#AdPlaylistAPI+initAdPlaylist) ⇒ <code>Promise</code>
    * [.startAdPlaylist()](#AdPlaylistAPI+startAdPlaylist) ⇒ <code>Promise</code>
    * [.stopAdPlaylist()](#AdPlaylistAPI+stopAdPlaylist) ⇒ <code>Promise</code>

<a name="new_AdPlaylistAPI_new"></a>

### new AdPlaylistAPI(playerProxy, adsAPI)

| Param | Type | Description |
| --- | --- | --- |
| playerProxy | <code>Object</code> | extended from [FacadeBase](FacadeBase) |
| adsAPI | <code>Object</code> | is a reference to the session AdSlotAPI |

<a name="AdPlaylistAPI+error"></a>

### adPlaylistAPI.error ⇒ <code>PluginError</code>
Requests details about the most recent error that has occurred.

**Kind**: instance property of <code>[AdPlaylistAPI](#AdPlaylistAPI)</code>  
**Returns**: <code>PluginError</code> - Description object of the most recent error or `null`.  
<a name="AdPlaylistAPI+rawVMAP"></a>

### adPlaylistAPI.rawVMAP ⇒ <code>XML</code>
Returns the VMAP that has been collected for the current (content) session

**Kind**: instance property of <code>[AdPlaylistAPI](#AdPlaylistAPI)</code>  
**Returns**: <code>XML</code> - XML as live parsable DOM representation, querySelector and similar work on this  
<a name="AdPlaylistAPI+initAdPlaylist"></a>

### adPlaylistAPI.initAdPlaylist(playlistSpecs, vastMacros) ⇒ <code>Promise</code>
Starts requesting a VMAP from the ad server

**Kind**: instance method of <code>[AdPlaylistAPI](#AdPlaylistAPI)</code>  
**Returns**: <code>Promise</code> - Resolves if loading the VMAP has been completed  

| Param | Type | Description |
| --- | --- | --- |
| playlistSpecs | <code>[AdPlaylistSetup](#AdPlaylistSetup)</code> | Ad configuration for the upcoming content video. |
| vastMacros | <code>Object</code> | VAST macros and their values as defined in  https://interactiveadvertisingbureau.github.io/vast/vast4macros/vast4-macros-latest.html |

<a name="AdPlaylistAPI+startAdPlaylist"></a>

### adPlaylistAPI.startAdPlaylist() ⇒ <code>Promise</code>
Starts playback and monitoring of the content and automatically inserts ad-slots
based on the `timeOffset` values of each VMAP AdBreak.
AdBreaks with a `timeOffset` equally to `0`, `"start"` or `"0%"` get requested immediately.

**Kind**: instance method of <code>[AdPlaylistAPI](#AdPlaylistAPI)</code>  
**Returns**: <code>Promise</code> - Resolves if the playback started  
<a name="AdPlaylistAPI+stopAdPlaylist"></a>

### adPlaylistAPI.stopAdPlaylist() ⇒ <code>Promise</code>
Immediately stops monitoring content playback.
AdBreaks that have already started remain until they complete. If necessary, they must be canceled
via the `AdSlotAPI.stopAdSlot()`.

**Kind**: instance method of <code>[AdPlaylistAPI](#AdPlaylistAPI)</code>  
**Returns**: <code>Promise</code> - - Whether the ad slot could be closed and cleaned up or not.  
<a name="AdPlaylistSetup"></a>

## AdPlaylistSetup : <code>Object</code>
Ad configuration for the upcoming content video.

**Kind**: global typedef  
**Properties**

| Name | Type | Description |
| --- | --- | --- |
| tag | <code>string</code> | VMAP request URL or... |
| response | <code>string</code> | direct VMAP XML |
| preroll | <code>[AdSlotSetup](#AdSlotSetup)</code> | Separation Clip and Prefetching setup for the adBreak |
| midroll | <code>[AdSlotSetup](#AdSlotSetup)</code> | Separation Clip and Prefetching setup |
| postroll | <code>[AdSlotSetup](#AdSlotSetup)</code> | Separation Clip and Prefetching setup |
| overlay | <code>[AdSlotSetup](#AdSlotSetup)</code> | Prefetching setup |
| strictOffsets | <code>boolean</code> | If `true` offsets are maintained accordingly when fast-forwarding, no overspooled ad is delivered. Defaulting to `false` if omitted and ignored. |

<a name="AdSlotSetup"></a>

## AdSlotSetup : <code>Object</code>
Configuration for each of the four ad-slot types.

**Kind**: global typedef  
**Properties**

| Name | Type | Description |
| --- | --- | --- |
| opener | <code>[SeparationClip](#SeparationClip)</code> | Setup for a short video to play before the commercial ads. |
| bumper | <code>[SeparationClip](#SeparationClip)</code> | Setup for a short video to play between commercial and sponsored ads. |
| closer | <code>[SeparationClip](#SeparationClip)</code> | Setup for a short video to play after the commercial ads. |
| prefetchOffset | <code>Number</code> | Time in seconds Defaulting to `0` seconds if omitted. The `preroll` ad-slot is always defaulting to `0`. |

<a name="SeparationClip"></a>

## SeparationClip : <code>Object</code>
A short video from the publisher that is played before (opener)
or after (closer) an ad-break. Also, a short video that is played between commercial and sponsored ads (bumper).

**Kind**: global typedef  
**Properties**

| Name | Type | Description |
| --- | --- | --- |
| progressive | <code>string</code> | Video asset URL |
| forcePlay | <code>Boolean</code> | Whether the clip needs to be played even if the ad-server does not return any ads. Defaulting to `false` if omitted and ignored if the clip is declared as a bumper. |

