## Classes

<dl>
<dt><a href="#AdSlotAPI">AdSlotAPI</a></dt>
<dd></dd>
</dl>

## Typedefs

<dl>
<dt><a href="#AdBreak">AdBreak</a> : <code>Object</code></dt>
<dd><p>Definition of the upcoming ad slot.</p>
</dd>
<dt><a href="#EnvironmentVars">EnvironmentVars</a> : <code>Object</code></dt>
<dd><p>Used for passing implementation-specific runtime variables.</p>
</dd>
<dt><a href="#Wrapper">Wrapper</a> : <code>Array</code></dt>
<dd><p>List of URLs that have been requested during a chain of ad server requests.</p>
</dd>
<dt><a href="#UniversalAdId">UniversalAdId</a> : <code>Object</code></dt>
<dd><p>A unique creative ID for the ad across multiple systems.</p>
</dd>
<dt><a href="#PublicAdSlot">PublicAdSlot</a> : <code>Object</code></dt>
<dd><p>Collection of data that describes the current ad slot.</p>
</dd>
<dt><a href="#PublicAd">PublicAd</a> : <code>Object</code></dt>
<dd><p>Collection of data for the current running ad</p>
</dd>
<dt><a href="#AdInfo">AdInfo</a> : <code>Object</code></dt>
<dd><p>Collection of data that describes the current video ad.</p>
</dd>
<dt><a href="#AdError">AdError</a> : <code>Object</code></dt>
<dd><p>Description object of the most recent ad error or <code>null</code>.</p>
</dd>
<dt><a href="#Wrapper">Wrapper</a> : <code>Object</code></dt>
<dd><p>Description object of a AdTag request.</p>
</dd>
<dt><a href="#CompanionAd">CompanionAd</a> : <code>Object</code></dt>
<dd><p>Secondary ads included in the VAST tag that accompany the video ad.</p>
</dd>
<dt><a href="#CreativeIds">CreativeIds</a> : <code>Object</code></dt>
<dd><p>An object containing the IDs of the creative node.</p>
</dd>
<dt><a href="#NonLinearAds">NonLinearAds</a> : <code>Object</code></dt>
<dd><p>Secondary ads included in the VAST tag that accompany the video ad.</p>
</dd>
<dt><a href="#Linear">Linear</a> : <code>Object</code></dt>
<dd><p>Linear Ads are the video or audio formatted ads that play linearly within the streaming
 content.</p>
</dd>
<dt><a href="#MediaFileResource">MediaFileResource</a> : <code>Object</code></dt>
<dd><p>contains all relevant data for the mediaFile</p>
</dd>
<dt><a href="#CompanionAdResource">CompanionAdResource</a> : <code>Object</code></dt>
<dd><p>Definition of a secondary ad by type.</p>
</dd>
<dt><a href="#Extension">Extension</a> : <code>Object</code></dt>
<dd><p>Custom XML element that extends the video ad.</p>
</dd>
<dt><a href="#ClosedCaption">ClosedCaption</a> : <code>Object</code></dt>
<dd><p>Subtitle files for the current creative in different languages</p>
</dd>
<dt><a href="#AdVerification">AdVerification</a> : <code>Object</code></dt>
<dd><p>Object contains the executable and bootstrapping data required to run the
    measurement code for a single verification vendor.</p>
</dd>
<dt><a href="#PluginError">PluginError</a> : <code>Object</code></dt>
<dd><p>Description object of the most recent error or <code>null</code>.</p>
</dd>
</dl>

<a name="AdSlotAPI"></a>

## AdSlotAPI
**Kind**: global class  

* [AdSlotAPI](#AdSlotAPI)
    * [new AdSlotAPI(playerProxy, config)](#new_AdSlotAPI_new)
    * [.ad](#AdSlotAPI+ad) ⇒ <code>[PublicAd](#PublicAd)</code> &#124; <code>null</code>
    * [.adSlot](#AdSlotAPI+adSlot) ⇒ <code>[PublicAdSlot](#PublicAdSlot)</code> &#124; <code>null</code>
    * [.error](#AdSlotAPI+error) ⇒ <code>[PluginError](#PluginError)</code>
    * [.rawXML](#AdSlotAPI+rawXML) ⇒ <code>XML</code>
    * [.dispose()](#AdSlotAPI+dispose) ⇒ <code>void</code>
    * [.initAdSlot(adBreak, environmentVars)](#AdSlotAPI+initAdSlot) ⇒ <code>Promise</code>
    * [.startAdSlot()](#AdSlotAPI+startAdSlot)
    * [.stopAdSlot()](#AdSlotAPI+stopAdSlot) ⇒ <code>Promise</code>
    * [.skipAd()](#AdSlotAPI+skipAd) ⇒ <code>void</code>
    * [.resize(boundingRectangle, viewMode)](#AdSlotAPI+resize) ⇒ <code>void</code>
    * [.clickThrough(playerHandles)](#AdSlotAPI+clickThrough) ⇒ <code>string</code>
    * [.iconClickThrough(iconProgram, playerHandles)](#AdSlotAPI+iconClickThrough) ⇒ <code>string</code>
    * [.iconView(iconProgram)](#AdSlotAPI+iconView) ⇒ <code>void</code>
    * [.verificationNotExecuted(vendor, reason)](#AdSlotAPI+verificationNotExecuted)
    * [.companionView(companionId)](#AdSlotAPI+companionView) ⇒ <code>void</code>
    * [.companionClickThrough(companionId, playerHandles)](#AdSlotAPI+companionClickThrough) ⇒ <code>string</code>
    * [.pauseAd()](#AdSlotAPI+pauseAd)
    * [.resumeAd()](#AdSlotAPI+resumeAd)

<a name="new_AdSlotAPI_new"></a>

### new AdSlotAPI(playerProxy, config)

| Param | Type | Description |
| --- | --- | --- |
| playerProxy | <code>Object</code> | extended from [FacadeBase](FacadeBase) |
| config | <code>Object</code> | Global configuration |

<a name="AdSlotAPI+ad"></a>

### adSlotAPI.ad ⇒ <code>[PublicAd](#PublicAd)</code> &#124; <code>null</code>
Returns information about the current ad, like companions, icons, variations, verifications and more.
The contents of variations depend on the advertising medium, the following things can be found there:

**Kind**: instance property of <code>[AdSlotAPI](#AdSlotAPI)</code>  
**Returns**: <code>[PublicAd](#PublicAd)</code> &#124; <code>null</code> - Represents static information about the current ad  
<a name="AdSlotAPI+adSlot"></a>

### adSlotAPI.adSlot ⇒ <code>[PublicAdSlot](#PublicAdSlot)</code> &#124; <code>null</code>
Returns information about the current ad-break, like times and more.

**Kind**: instance property of <code>[AdSlotAPI](#AdSlotAPI)</code>  
**Returns**: <code>[PublicAdSlot](#PublicAdSlot)</code> &#124; <code>null</code> - Represents static information about the current ad-break  
<a name="AdSlotAPI+error"></a>

### adSlotAPI.error ⇒ <code>[PluginError](#PluginError)</code>
Requests details about the most recent error that has occurred on the smartclientcore.

**Kind**: instance property of <code>[AdSlotAPI](#AdSlotAPI)</code>  
**Returns**: <code>[PluginError](#PluginError)</code> - Description object of the most recent error or `null`.  
<a name="AdSlotAPI+rawXML"></a>

### adSlotAPI.rawXML ⇒ <code>XML</code>
Returns all of the collected XML that has been collected for the whole slot

**Kind**: instance property of <code>[AdSlotAPI](#AdSlotAPI)</code>  
**Returns**: <code>XML</code> - XML as live parsable DOM representation, querySelector and similar work on this  
<a name="AdSlotAPI+dispose"></a>

### adSlotAPI.dispose() ⇒ <code>void</code>
Removes all event listeners that the SDK itself had previously added.

**Kind**: instance method of <code>[AdSlotAPI](#AdSlotAPI)</code>  
<a name="AdSlotAPI+initAdSlot"></a>

### adSlotAPI.initAdSlot(adBreak, environmentVars) ⇒ <code>Promise</code>
Invokes a commercial break by requesting the specified ad setup from the ad server.

**Kind**: instance method of <code>[AdSlotAPI](#AdSlotAPI)</code>  
**Returns**: <code>Promise</code> - Resolves if loading the ad manifests has been completed  

| Param | Type | Description |
| --- | --- | --- |
| adBreak | <code>[AdBreak](#AdBreak)</code> | Configuration for the upcoming ad break. |
| environmentVars | <code>[EnvironmentVars](#EnvironmentVars)</code> | Defines environment conditions for the upcoming ad break |

<a name="AdSlotAPI+startAdSlot"></a>

### adSlotAPI.startAdSlot()
Starts the ad break.
The add-on responds by sending an `ON_AD_SLOT_START` event notifying the video player the ad break is going
 to start.

**Kind**: instance method of <code>[AdSlotAPI](#AdSlotAPI)</code>  
<a name="AdSlotAPI+stopAdSlot"></a>

### adSlotAPI.stopAdSlot() ⇒ <code>Promise</code>
Stops a running ad break.
The add-on responds by sending an `ON_AD_SLOT_COMPLETE` event notifying the video player it has closed and
cleaned up ad resources. Also the content of the video player has been reset.

**Kind**: instance method of <code>[AdSlotAPI](#AdSlotAPI)</code>  
**Returns**: <code>Promise</code> - - Whether the ad slot could be closed and cleaned up or not.  
<a name="AdSlotAPI+skipAd"></a>

### adSlotAPI.skipAd() ⇒ <code>void</code>
Skips (stops) a running single ad
The add-on responds by sending the `ON_AD_SKIPPED` event notifying the video player it has closed and cleaned up
a single ad.

_Note:
The add-on does proceed with the next ad. Canceling the whole ad break requires calling `stopAdSlot()` instead.

**Kind**: instance method of <code>[AdSlotAPI](#AdSlotAPI)</code>  
<a name="AdSlotAPI+resize"></a>

### adSlotAPI.resize(boundingRectangle, viewMode) ⇒ <code>void</code>
Following a resize of the video player, the video player calls `resize()` to allow the add-on to scale
and reposition itself within the display area. The add-on responds by sending an `ON_AD_SIZE_CHANGED` event.

**Kind**: instance method of <code>[AdSlotAPI](#AdSlotAPI)</code>  

| Param | Type | Description |
| --- | --- | --- |
| boundingRectangle | <code>Rectangle</code> | The video content display as a Rectangle {width, height, top, left} |
| viewMode | <code>string</code> | Current viewing mode (normal, fullscreen, thumbnail, dynamic) |

<a name="AdSlotAPI+clickThrough"></a>

### adSlotAPI.clickThrough(playerHandles) ⇒ <code>string</code>
Following a click on the ad, the video player calls `clickThrough()` to allow the add-on
to request the advertisers landing page and call the ClickThru tracking requests.

**Kind**: instance method of <code>[AdSlotAPI](#AdSlotAPI)</code>  
**Returns**: <code>string</code> - The landing page URL.  

| Param | Type | Default | Description |
| --- | --- | --- | --- |
| playerHandles | <code>Boolean</code> | <code>false</code> | Whether the player takes responsibility for opening the landing page URL. Defaulting to `false` if omitted. |

<a name="AdSlotAPI+iconClickThrough"></a>

### adSlotAPI.iconClickThrough(iconProgram, playerHandles) ⇒ <code>string</code>
Following a click on an Industry Icon ad, the video player calls `iconClickThrough()` to allow the add-on
to request the advertisers landing page and call the ClickThru tracking requests.

**Kind**: instance method of <code>[AdSlotAPI](#AdSlotAPI)</code>  
**Returns**: <code>string</code> - The landing page URL.  

| Param | Type | Default | Description |
| --- | --- | --- | --- |
| iconProgram | <code>string</code> |  | The program represented in the icon |
| playerHandles | <code>Boolean</code> | <code>false</code> | Whether the player takes responsibility for opening the landing page URL. Defaulting to `false` if omitted. |

<a name="AdSlotAPI+iconView"></a>

### adSlotAPI.iconView(iconProgram) ⇒ <code>void</code>
The view tracking for icons is used to track when the icon creative is displayed.

**Kind**: instance method of <code>[AdSlotAPI](#AdSlotAPI)</code>  

| Param | Type | Description |
| --- | --- | --- |
| iconProgram | <code>string</code> | The program represented in the icon |

<a name="AdSlotAPI+verificationNotExecuted"></a>

### adSlotAPI.verificationNotExecuted(vendor, reason)
The player did not or was not able to execute the provided verification code.

**Kind**: instance method of <code>[AdSlotAPI](#AdSlotAPI)</code>  

| Param | Type | Description |
| --- | --- | --- |
| vendor | <code>string</code> | An identifier for the verification vendor. |
| reason | <code>number</code> | The reason code corresponding to the cause of the failure. |

<a name="AdSlotAPI+companionView"></a>

### adSlotAPI.companionView(companionId) ⇒ <code>void</code>
Requests the view trackers when a creative resource is displayed. The method should be called for each resource
 file of a `Companion Ad`.

**Kind**: instance method of <code>[AdSlotAPI](#AdSlotAPI)</code>  

| Param | Type | Description |
| --- | --- | --- |
| companionId | <code>string</code> | Value of the `id` attribute from the `CompanionAd` object. |

<a name="AdSlotAPI+companionClickThrough"></a>

### adSlotAPI.companionClickThrough(companionId, playerHandles) ⇒ <code>string</code>
Following a click on a Companion ad, the video player calls `companionClickThrough()` to allow the add-on
to call the ClickThru tracking requests and request the advertisers landing page (most likely with
`StaticResource` creative resource only).

**Kind**: instance method of <code>[AdSlotAPI](#AdSlotAPI)</code>  
**Returns**: <code>string</code> - The landing page URL.  

| Param | Type | Default | Description |
| --- | --- | --- | --- |
| companionId | <code>string</code> |  | Value of the `id` attribute from the `CompanionAd` object. |
| playerHandles | <code>Boolean</code> | <code>true</code> | Whether the player takes responsibility for opening the landing page URL. Defaulting to `true` since most companion creatives do handle clickthroughs by their own (`HTMLResource`,  `IFrameResource`). |

<a name="AdSlotAPI+pauseAd"></a>

### adSlotAPI.pauseAd()
Pauses the current ad break. The add-on responds by sending the `ON_AD_PAUSED` event.

**Kind**: instance method of <code>[AdSlotAPI](#AdSlotAPI)</code>  
<a name="AdSlotAPI+resumeAd"></a>

### adSlotAPI.resumeAd()
Resumes the current ad break. The add-on responds by sending the `ON_AD_PLAYING` event.

**Kind**: instance method of <code>[AdSlotAPI](#AdSlotAPI)</code>  
<a name="AdBreak"></a>

## AdBreak : <code>Object</code>
Definition of the upcoming ad slot.

**Kind**: global typedef  
**Properties**

| Name | Type | Description |
| --- | --- | --- |
| type | <code>string</code> | of the ad slot.  See [`AdBreak.type`](setup-sequential-config.md#adbreak+type) Defaulting to `linear`. |
| adBreakPosition | <code>number</code> | of the ad slot.  See [`AdBreak.adBreakPosition`](setup-sequential-config.md#adbreak+breakposition) |
| tag | <code>string</code> | AdRequest URL |
| response | <code>string</code> | direct VAST XML |
| opener | <code>string</code> |  |
| bumper | <code>string</code> |  |
| closer | <code>string</code> |  |

<a name="EnvironmentVars"></a>

## EnvironmentVars : <code>Object</code>
Used for passing implementation-specific runtime variables.

**Kind**: global typedef  
**Properties**

| Name | Type | Description |
| --- | --- | --- |
| desiredBitrate | <code>number</code> | Indicates the desired bitrate in kilobits per second (kbps). The player uses this  information to select Mediafiles with an appropriate bitrate. Defaulting to `null`. |
| desiredMimeTypes | <code>[ &#x27;Array&#x27; ].&lt;string&gt;</code> | Declaration of accepted media types. Defaulting to types that the  browser eventually is able to play. Types must be compliant with the  [IANA Media Type standard](https://www.iana.org/assignments/media-types/media-types.xhtml) |
| desiredVPAIDVendors | <code>[ &#x27;Array&#x27; ].&lt;string&gt;</code> | Declaration of accepted VPAID vendors (whitelist). Each specified  String has to represent an unique identifier that can be found within the creative media file URL, most likely the  domain name. If omitted, the plugin tries to deliver VPAID creatives from each vendor. |
| deviceType | <code>string</code> | Can be either `mobile`, `tablet`, `desktop` or `tv`. Defaulting to `null`. |
| deviceScreenSize | <code>Dimension</code> | Maximum size we can achieve when entering fullscreen. |
| networkReachability | <code>string</code> | Can be either `wan`, `wifi` or `unreachable`. Defaulting to `null`. |
| vastMacros | <code>Object</code> | VAST macros and their values as defined in  https://interactiveadvertisingbureau.github.io/vast/vast4macros/vast4-macros-latest.html |
| prefetchBuffetAds | <code>boolean</code> | In order to replace invalid ads in a pod instantly at runtime, buffet ads from  wrapper responses must be loaded up-front. `prefetchBuffetAds` determines whether stand-alone ads (buffet) will be  loaded together with the pod of ads or not. Defaulting to `false` if omitted. |
| adContainer | <code>HTMLElement</code> | The element that should be used to deliver non-video creative files. Defaulting to `null` if omitted. |

<a name="Wrapper"></a>

## Wrapper : <code>Array</code>
List of URLs that have been requested during a chain of ad server requests.

**Kind**: global typedef  
<a name="UniversalAdId"></a>

## UniversalAdId : <code>Object</code>
A unique creative ID for the ad across multiple systems.

**Kind**: global typedef  
**Properties**

| Name | Type | Description |
| --- | --- | --- |
| idRegistry | <code>string</code> | A string used to identify the URL for the registry website where the unique creative  ID is cataloged. Defaulting to `unknown`. |
| idValue | <code>string</code> | A string identifying the unique creative identifier. Defaulting to `unknown`. |

<a name="PublicAdSlot"></a>

## PublicAdSlot : <code>Object</code>
Collection of data that describes the current ad slot.

**Kind**: global typedef  
**Properties**

| Name | Type | Description |
| --- | --- | --- |
| currentClip | <code>number</code> | Index of the current ad, regardless of its variant. |
| currentCommercial | <code>number</code> | Index of the current ad of variant `COMMERCIAL`. Defaulting to -1 |
| totalClips | <code>number</code> | Total number of ads within the current ad break, regardless of variants. |
| totalCommercials | <code>number</code> | Total number of ads with variant `COMMERCIAL` within the current ad break |
| totalPlayableClips | <code>number</code> | Total number of playable ads within the current ad break, regardless of variants. |
| totalPlayableCommercials | <code>number</code> | Total number of ads with the 'COMMERCIAL' variant within the current ad  break that are playable. |
| totalCommercialsDuration | <code>number</code> | Total duration of ads with variant `COMMERCIAL` within the current  ad break. |
| totalCommercialsCurrentTime | <code>number</code> | Current time of all ads with variant `COMMERCIAL` within the current  ad break |

<a name="PublicAd"></a>

## PublicAd : <code>Object</code>
Collection of data for the current running ad

**Kind**: global typedef  
**Properties**

| Name | Type | Description |
| --- | --- | --- |
| adId | <code>string</code> &#124; <code>null</code> &#124; <code>Array&lt;string&#124;null&gt;</code> | Value of the `id` attribute from the `VAST > Ad` node. Array in  wrapper chain case. |
| adServingId | <code>string</code> &#124; <code>null</code> | A unique or pseudo-unique (long enough to be unique when combined with timestamp  data) GUID. |
| creativeIds | <code>[CreativeIds](#CreativeIds)</code> | Key value pair from all creative ids (adId/id). |
| isExpanded | <code>boolean</code> | Indicates if the ad is currently in an expanded state. |
| isInteractive | <code>boolean</code> | Returns whether the current ad is interactive (most likely by using __VPAID__)  or *  not. |
| isLinear | <code>boolean</code> | Indicates whether the ad’s current mode of operation is linear or non-linear. |
| isSkippable | <code>boolean</code> | If true, the ad can be skipped, based on AdTag skip delay and configurable skipp  offset. Changes of the state can be monitored by listening on `ON_AD_SKIPPABLE_STATE_CHANGE` |
| skipOffset | <code>number</code> | Time in seconds when ad will become skippable based on playback progress. Will return  -1 if ad won't become skippable. |
| hasClickThrough | <code>boolean</code> | Returns whether the current ad has a ClickThrough target (URL) or not. |
| width | <code>number</code> | Width of the ad in pixels, as given from AdTag |
| height | <code>number</code> | Height of the ad in pixels, as given from AdTag |
| currentTime | <code>number</code> | Current time of ad in decimal seconds. |
| remainingTime | <code>number</code> | Remaining time of ad in decimal seconds. |
| duration | <code>number</code> | Duration of current ad, given in decimal seconds. |
| volume | <code>number</code> | get and set volume of the current running ad |
| viewability | <code>Object</code> | get information about the visibility status, the corresponding threshold value and the  current visibility value. |
| companions | <code>[[ &#x27;Array&#x27; ].&lt;CompanionAd&gt;](#CompanionAd)</code> | The value of this property is an Array that provides ad companion details  for each `<Companion>` element. The video player should request this value whenever it receives the  [`ON_COMPANIONS_DETECTED`](events.md#event-list) event. |
| variations | <code>[[ &#x27;Array&#x27; ].&lt;NonLinearAds&gt;](#NonLinearAds)</code> | The value of this property is an Array that provides nonLinear creative details for each `<NonLinearAds>` element. |
| linear | <code>[[ &#x27;Array&#x27; ].&lt;Linear&gt;](#Linear)</code> | The value of this property is an Array that provides linear creative  details for each `<Linear>` element. |
| extensions | <code>[[ &#x27;Array&#x27; ].&lt;Extension&gt;](#Extension)</code> | The value of this property is an Array that provides ad extension details  for the `<Extensions>` element. The video player should request this value whenever it receives the  [`ON_EXTENSIONS_DETECTED`](events.md#event-list) add-on event. |
| icons | <code>[ &#x27;Array&#x27; ].&lt;Icon&gt;</code> | The value of this property is an Object that provides ad icon details for the  `<Icon>` element. The video player should request this value whenever it receives the  [`ON_ICONS_DETECTED`](events.md#event-list) add-on event. |
| closedCaptions | <code>[[ &#x27;Array&#x27; ].&lt;ClosedCaption&gt;](#ClosedCaption)</code> | The value of this property is an Array of caption details for the  `<ClosedCaption>` element. The video player should request this value whenever it receives the  [`ON_CLOSED_CAPTIONS_DETECTED`](events.md#event-list) add-on event. |
| verifications | <code>[[ &#x27;Array&#x27; ].&lt;AdVerification&gt;](#AdVerification)</code> | The value of this property is an Array that provides details for  each `<Verification>` element. The video player may request this value whenever it receives the  [`ON_VERIFICATIONS_DETECTED`](events.md#event-list) add-on event, depending on whether the player takes care of  the Open Measurement. |
| info | <code>[[ &#x27;Object&#x27; ].&lt;AdInfo&gt;](#AdInfo)</code> | Collection of data that describes the current video ad. |
| error | <code>[[ &#x27;Object&#x27; ].&lt;AdError&gt;](#AdError)</code> | Description object of the most recent ad error. |
| wrappers | <code>[[ &#x27;Array&#x27; ].&lt;Wrapper&gt;](#Wrapper)</code> | List of Wrapper objects, starting with the initial request up to the last  requested tag URI. |
| universalAdId | <code>[UniversalAdId](#UniversalAdId)</code> | A unique creative identifier that is maintained across different ad systems. |
| universalAdIds | <code>[[ &#x27;Array&#x27; ].&lt;UniversalAdId&gt;](#UniversalAdId)</code> | A list of multiple creative identifiers that are maintained across  different ad systems. |

<a name="AdInfo"></a>

## AdInfo : <code>Object</code>
Collection of data that describes the current video ad.

**Kind**: global typedef  
**Properties**

| Name | Type | Description |
| --- | --- | --- |
| adId | <code>string</code> | Value of the `id` attribute from the `VAST > Ad` node |
| currentClip | <code>number</code> | Index of the current ad, regardless of its variant. |
| currentCommercial | <code>number</code> | Index of the current ad of variant `COMMERCIAL`. Defaulting to -1 |
| currentTime | <code>number</code> | Current time of the current ad |
| duration | <code>number</code> | Total time of the current ad |
| idValue | <code>string</code> | A string identifying the unique creative identifier. Defaulting to `unknown`. |
| skippable | <code>Boolean</code> | The default value for this property is `false`. When the ad reaches a point where it  can be skipped, the ad unit updates this property to true and sends the `ON_AD_SKIPPABLE_STATE_CHANGE` event. The video player can check this property at any time, but should always check it when the  `ON_AD_SKIPPABLE_STATE_CHANGE` event is received. |
| totalClips | <code>number</code> | Total number of ads within the current ad break, regardless of variants. |
| totalCommercials | <code>number</code> | Total number of ads with variant `COMMERCIAL` within the current ad break |
| totalPlayableClips | <code>number</code> | Total number of playable ads within the current ad break, regardless of  variants. |
| totalPlayableCommercials | <code>number</code> | Total number of ads with the 'COMMERCIAL' variant within the current ad |
| title | <code>string</code> | Value of the `VAST > Ad > AdTitle` node |
| variant | <code>string</code> | Ad variant, depending on the current schedule and VAST manifest. |
| universalAdId | <code>[UniversalAdId](#UniversalAdId)</code> | A unique creative identifier that is maintained across different ad systems. |
| universalAdIds | <code>[[ &#x27;Array&#x27; ].&lt;UniversalAdId&gt;](#UniversalAdId)</code> | A list of multiple creative identifiers that are maintained across  different ad systems. |

<a name="AdError"></a>

## AdError : <code>Object</code>
Description object of the most recent ad error or `null`.

**Kind**: global typedef  
**Properties**

| Name | Type | Description |
| --- | --- | --- |
| code | <code>number</code> | Code according to [IAB VAST 4.0](https://www.iab.com/guidelines/digital-video-ad-serving-template-vast-4-0) Error Codes Table. |
| timestamp | <code>number</code> | Current client time `Date.now()` |
| description | <code>string</code> | A human-readable string which provides specific diagnostic information to help the reader understand the error condition which occurred. |

<a name="Wrapper"></a>

## Wrapper : <code>Object</code>
Description object of a AdTag request.

**Kind**: global typedef  
**Properties**

| Name | Type | Description |
| --- | --- | --- |
| url | <code>string</code> | Tag URI |
| loadStart | <code>string</code> | Current client ISO time when starting the request. |
| loadEnd | <code>string</code> | Current client ISO time after receiving the response. |
| loadTime | <code>number</code> | Time in milliseconds between loadStart and loadEnd |

<a name="CompanionAd"></a>

## CompanionAd : <code>Object</code>
Secondary ads included in the VAST tag that accompany the video ad.

**Kind**: global typedef  
**Properties**

| Name | Type | Description |
| --- | --- | --- |
| id | <code>string</code> | Value of the `id` attribute from the `Creative > CompanionAds > Companion` node |
| companionXML | <code>xml</code> | Full <Companion> node. |
| resources | <code>[[ &#x27;Array&#x27; ].&lt;CompanionAdResource&gt;](#CompanionAdResource)</code> | The companion ad may contain one or more resources to represent  different versions of the creative for use in different environments. The media player can choose which resource to  use when more than one resource file is provided. |

<a name="CreativeIds"></a>

## CreativeIds : <code>Object</code>
An object containing the IDs of the creative node.

**Kind**: global typedef  
**Properties**

| Name | Type | Description |
| --- | --- | --- |
| adId | <code>string</code> &#124; <code>null</code> | The unique ad server identifiers for the creative. |
| id | <code>string</code> &#124; <code>null</code> | The ad server-defined identifiers for the creative nodes. |

<a name="NonLinearAds"></a>

## NonLinearAds : <code>Object</code>
Secondary ads included in the VAST tag that accompany the video ad.

**Kind**: global typedef  
**Properties**

| Name | Type | Description |
| --- | --- | --- |
| apiFramework | <code>string</code> | A string that identifies an API that is needed to execute the creative. |
| adParameters | <code>Object</code> | Pass information from the VAST response into the SIMID/VPAID object |
| clickThroughURL | <code>string</code> | URIs for clickThrough |
| clickTracker | <code>array</code> | URIs for clickTracker |
| creativeTrackers | <code>Object</code> | URIs for creativeTracker |
| height | <code>number</code> | Height of the ad in pixels, as given from AdTag |
| id | <code>string</code> | An optional identifier for the creative |
| expandedHeight | <code>number</code> | The maximum pixel height of the creative in its expanded state. |
| expandedWidth | <code>number</code> | The maximum pixel width of the creative in its expanded state. |
| maintainAspectRation | <code>boolean</code> | Maintain the original canvas aspect ratio (width/height) when resizing. |
| minSuggestedDuration | <code>string</code> | Specified by advertiser. |
| resources | <code>array</code> | Array of resources with their attributes and contents parsed into properties. |
| scalable | <code>boolean</code> | Value that indicates whether the media file is meant to scale to larger dimensions. |
| width | <code>number</code> | Width of the ad in pixels, as given from AdTag |

<a name="Linear"></a>

## Linear : <code>Object</code>
Linear Ads are the video or audio formatted ads that play linearly within the streaming
 content.

**Kind**: global typedef  
**Properties**

| Name | Type | Description |
| --- | --- | --- |
| captions | <code>[[ &#x27;Array&#x27; ].&lt;ClosedCaption&gt;](#ClosedCaption)</code> | Subtitle files for the current creative in different languages |
| creativeTrackers | <code>Object</code> | Overview of all trackers that could be triggered. |
| icons | <code>Object</code> | The ad icon details for the `<Icon>` element. |
| mediaFiles | <code>[[ &#x27;Array&#x27; ].&lt;MediaFileResource&gt;](#MediaFileResource)</code> | from the parsed VAST response with various  sub-information like bitrate, mimType, URL etc. |
| selectedMediaFile | <code>[MediaFileResource](#MediaFileResource)</code> | is the selected media file and its information |

<a name="MediaFileResource"></a>

## MediaFileResource : <code>Object</code>
contains all relevant data for the mediaFile

**Kind**: global typedef  
**Properties**

| Name | Type | Description |
| --- | --- | --- |
| apiFramework | <code>string</code> | identifies the API needed to execute an interactive media file. |
| bitrate | <code>number</code> | value specifies the average bitrate for the media file. |
| height | <code>number</code> | The native height of the video file, in pixels. (0 for audio ads) |
| linearity | <code>string</code> | Type of linearity (linear/nonlinear) |
| mimeType | <code>string</code> | Type of media file. |
| variableDuration | <code>boolean</code> | Identifies whether the ad always drops when the duration is reached, or if  it can potentially extend the duration by pausing the underlying video or delaying the adStopped call after  adVideoComplete. |
| width | <code>number</code> | The native width of the video file, in pixels. (0 for audio ads). |

<a name="CompanionAdResource"></a>

## CompanionAdResource : <code>Object</code>
Definition of a secondary ad by type.

**Kind**: global typedef  
**Properties**

| Name | Type | Description |
| --- | --- | --- |
| type | <code>string</code> | Type of the companion creative resource. Can be either `StaticResource`, `IFrameResource` or `HTMLResource` |
| resource | <code>string</code> | The asset URL to be loaded. |

<a name="Extension"></a>

## Extension : <code>Object</code>
Custom XML element that extends the video ad.

**Kind**: global typedef  
**Properties**

| Name | Type | Description |
| --- | --- | --- |
| type | <code>string</code> | The MIME type of any code that might be included in the extension. Type should be compliant with the [IANA Media Type standard](https://www.iana.org/assignments/media-types/media-types.xhtml) |
| extensionXML | <code>xml</code> | Full <Extension> node. |

<a name="ClosedCaption"></a>

## ClosedCaption : <code>Object</code>
Subtitle files for the current creative in different languages

**Kind**: global typedef  
**Properties**

| Name | Type | Description |
| --- | --- | --- |
| fileURL | <code>string</code> | URL to the subtitle file |
| language | <code>string</code> | Language of the file that is provided |
| type | <code>string</code> | MIME type of the offered file |

<a name="AdVerification"></a>

## AdVerification : <code>Object</code>
Object contains the executable and bootstrapping data required to run the
	measurement code for a single verification vendor.

**Kind**: global typedef  
**Properties**

| Name | Type | Description |
| --- | --- | --- |
| vendor | <code>string</code> | An identifier for the verification vendor. |
| verificationParameters | <code>string</code> | Information intended for bootstrapping the verification code and providing metadata about the current impression. The format of the string is up to the individual vendor. |
| javascriptResource | <code>Object</code> | Object with `url`, `apiFramework` and `browserOptional` |
| tracking | <code>Object</code> | Array of single tracking elements, e.g. `verificationNotExecuted`. |

<a name="PluginError"></a>

## PluginError : <code>Object</code>
Description object of the most recent error or `null`.

**Kind**: global typedef  
**Properties**

| Name | Type | Description |
| --- | --- | --- |
| code | <code>number</code> | A number which represents the general type of error that occurred. |
| timestamp | <code>number</code> | Current client time `Date.now()` |
| message | <code>string</code> | A human-readable string which provides specific diagnostic information to help the reader understand the error condition which occurred. |

