## Classes

<dl>
<dt><a href="#FacadeBase">FacadeBase</a></dt>
<dd></dd>
</dl>

## Typedefs

<dl>
<dt><a href="#MediaError">MediaError</a> : <code>Object</code></dt>
<dd><p><a href="https://developer.mozilla.org/en-US/docs/Web/API/MediaError">https://developer.mozilla.org/en-US/docs/Web/API/MediaError</a></p>
</dd>
<dt><a href="#ElementSize">ElementSize</a> : <code>Object</code></dt>
<dd></dd>
<dt><a href="#EnvironmentVars">EnvironmentVars</a> : <code>Object</code></dt>
<dd><p>Used for passing implementation-specific runtime variables.</p>
</dd>
</dl>

<a name="FacadeBase"></a>

## FacadeBase
**Kind**: global class  

* [FacadeBase](#FacadeBase)
    * [new FacadeBase()](#new_FacadeBase_new)
    * [.PLAYER_EVENT_MAP](#FacadeBase+PLAYER_EVENT_MAP) ⇒ <code>Object</code>
    * [.handshakeVersion(apiFacadeVersion)](#FacadeBase+handshakeVersion) ⇒ <code>string</code>
    * [.load(url, autoPlay, disableSeeking)](#FacadeBase+load) ⇒ <code>Promise</code>
    * [.addEventListener(type, callback)](#FacadeBase+addEventListener)
    * [.removeEventListener(type, callback)](#FacadeBase+removeEventListener)
    * [.lockContent()](#FacadeBase+lockContent) ⇒ <code>Promise</code>
    * [.releaseContent()](#FacadeBase+releaseContent) ⇒ <code>Promise</code>
    * [.getCurrentContentSource()](#FacadeBase+getCurrentContentSource) ⇒ <code>SourceObject</code>
    * [.getCurrentTime()](#FacadeBase+getCurrentTime) ⇒ <code>Number</code>
    * [.getDuration()](#FacadeBase+getDuration) ⇒ <code>Number</code>
    * [.getEnvironmentVars(adBreakType)](#FacadeBase+getEnvironmentVars) ⇒ <code>[EnvironmentVars](#EnvironmentVars)</code>
    * [.getError()](#FacadeBase+getError) ⇒ <code>[MediaError](#MediaError)</code>
    * [.getPlayerSize()](#FacadeBase+getPlayerSize) ⇒ <code>[ElementSize](#ElementSize)</code>
    * [.getViewportSize()](#FacadeBase+getViewportSize) ⇒ <code>[ElementSize](#ElementSize)</code>
    * ~~[.getVideoElement()](#FacadeBase+getVideoElement) ⇒ <code>Element</code>~~
    * [.getPlayerElement()](#FacadeBase+getPlayerElement) ⇒ <code>Element</code>
    * [.setVolume(volume)](#FacadeBase+setVolume) ⇒ <code>Promise</code>
    * [.getVolume()](#FacadeBase+getVolume) ⇒ <code>Number</code>
    * [.isMuted()](#FacadeBase+isMuted) ⇒ <code>Boolean</code>
    * [.mute()](#FacadeBase+mute) ⇒ <code>Promise</code>
    * [.unmute()](#FacadeBase+unmute) ⇒ <code>Promise</code>
    * [.isPaused()](#FacadeBase+isPaused) ⇒ <code>Boolean</code>
    * [.pause()](#FacadeBase+pause) ⇒ <code>Promise</code>
    * [.play()](#FacadeBase+play) ⇒ <code>Promise</code>
    * [.seek(offset)](#FacadeBase+seek) ⇒ <code>Promise</code>

<a name="new_FacadeBase_new"></a>

### new FacadeBase()
A player proxy class
(last change 2026-01-26T09:47:44.709Z)

<a name="FacadeBase+PLAYER_EVENT_MAP"></a>

### facadeBase.PLAYER_EVENT_MAP ⇒ <code>Object</code>
Map player specific events to the corresponding HTML5 MediaEvent

**Kind**: instance property of <code>[FacadeBase](#FacadeBase)</code>  
<a name="FacadeBase+handshakeVersion"></a>

### facadeBase.handshakeVersion(apiFacadeVersion) ⇒ <code>string</code>
Requests the player facade version (API version) to ensure the particular versions of `smartclientcore` and player facade
are supported.

**Kind**: instance method of <code>[FacadeBase](#FacadeBase)</code>  
**Returns**: <code>string</code> - Supported API version  

| Param | Type | Description |
| --- | --- | --- |
| apiFacadeVersion | <code>string</code> | Required API version |

<a name="FacadeBase+load"></a>

### facadeBase.load(url, autoPlay, disableSeeking) ⇒ <code>Promise</code>
Requests the video player to load and play the specified media file.

**Kind**: instance method of <code>[FacadeBase](#FacadeBase)</code>  
**Returns**: <code>Promise</code> - Resolves if the player accepted the media file request  

| Param | Type | Default | Description |
| --- | --- | --- | --- |
| url | <code>string</code> |  | Media file URI |
| autoPlay | <code>Boolean</code> | <code>true</code> | Whether the requested media file starts playback immediately. |
| disableSeeking | <code>Boolean</code> | <code>false</code> | Whether the requested source can be seeked back and forth. |

<a name="FacadeBase+addEventListener"></a>

### facadeBase.addEventListener(type, callback)
Sets up a function that will be called whenever the specified event is delivered to the video player.

**Kind**: instance method of <code>[FacadeBase](#FacadeBase)</code>  

| Param | Type | Description |
| --- | --- | --- |
| type | <code>string</code> | A case-sensitive string representing the player event type to listen for. |
| callback | <code>function</code> | The function which receives a notification when an event of the specified type occurs. |

<a name="FacadeBase+removeEventListener"></a>

### facadeBase.removeEventListener(type, callback)
Removes an event listener from the video player that has been registered with `addEventListener()`
_*Note:* The event listener to be removed must match with the listener that has been added._

**Kind**: instance method of <code>[FacadeBase](#FacadeBase)</code>  

| Param | Type | Description |
| --- | --- | --- |
| type | <code>string</code> | A case-sensitive string representing the player event type to listen for. |
| callback | <code>function</code> | The function which receives a notification when an event of the specified type occurs. |

<a name="FacadeBase+lockContent"></a>

### facadeBase.lockContent() ⇒ <code>Promise</code>
Should freeze the current playback state (for later use with `releaseContent()`)
and respond to the AdSlotAPI once finished.

**Kind**: instance method of <code>[FacadeBase](#FacadeBase)</code>  
**Returns**: <code>Promise</code> - Current content source and playhead progress for VAST tracking enrichment  
<a name="FacadeBase+releaseContent"></a>

### facadeBase.releaseContent() ⇒ <code>Promise</code>
Should restore the last known playback state, resume playback
and respond to the AdSlotAPI once finished.

**Kind**: instance method of <code>[FacadeBase](#FacadeBase)</code>  
**Returns**: <code>Promise</code> - Either resolves if the player accepted the play request or not  
<a name="FacadeBase+getCurrentContentSource"></a>

### facadeBase.getCurrentContentSource() ⇒ <code>SourceObject</code>
**Kind**: instance method of <code>[FacadeBase](#FacadeBase)</code>  
**Returns**: <code>SourceObject</code> - Current content source and playhead progress  
<a name="FacadeBase+getCurrentTime"></a>

### facadeBase.getCurrentTime() ⇒ <code>Number</code>
Requests the current playhead position from the video player.

**Kind**: instance method of <code>[FacadeBase](#FacadeBase)</code>  
**Returns**: <code>Number</code> - Current time in seconds.  
<a name="FacadeBase+getDuration"></a>

### facadeBase.getDuration() ⇒ <code>Number</code>
Requests the content-duration from the video player.

**Kind**: instance method of <code>[FacadeBase](#FacadeBase)</code>  
**Returns**: <code>Number</code> - Total time in seconds.  
<a name="FacadeBase+getEnvironmentVars"></a>

### facadeBase.getEnvironmentVars(adBreakType) ⇒ <code>[EnvironmentVars](#EnvironmentVars)</code>
Requests the latest status of the video player, site, and other external factors.

**Kind**: instance method of <code>[FacadeBase](#FacadeBase)</code>  
**Returns**: <code>[EnvironmentVars](#EnvironmentVars)</code> - Description object of the most recent error or `null`.  

| Param | Type | Description |
| --- | --- | --- |
| adBreakType | <code>string</code> | Linearity of the upcoming ad slot. See [`AdBreak.type`](setup-sequential-config#adbreak+type) |

<a name="FacadeBase+getError"></a>

### facadeBase.getError() ⇒ <code>[MediaError](#MediaError)</code>
Requests details about the most recent error that has occurred on the video player.

**Kind**: instance method of <code>[FacadeBase](#FacadeBase)</code>  
**Returns**: <code>[MediaError](#MediaError)</code> - Description object of the most recent error or `null`.  
<a name="FacadeBase+getPlayerSize"></a>

### facadeBase.getPlayerSize() ⇒ <code>[ElementSize](#ElementSize)</code>
Requests the current size and viewMode from the video player.

**Kind**: instance method of <code>[FacadeBase](#FacadeBase)</code>  
**Returns**: <code>[ElementSize](#ElementSize)</code> - Current player dimension specs  
<a name="FacadeBase+getViewportSize"></a>

### facadeBase.getViewportSize() ⇒ <code>[ElementSize](#ElementSize)</code>
Requests the current size and viewMode from the viewport that surrounds the video player.

**Kind**: instance method of <code>[FacadeBase](#FacadeBase)</code>  
**Returns**: <code>[ElementSize](#ElementSize)</code> - The dimension specs of the element  
<a name="FacadeBase+getVideoElement"></a>

### ~~facadeBase.getVideoElement() ⇒ <code>Element</code>~~
***Deprecated***

Requests the video player element

**Kind**: instance method of <code>[FacadeBase](#FacadeBase)</code>  
**Returns**: <code>Element</code> - The video element  
<a name="FacadeBase+getPlayerElement"></a>

### facadeBase.getPlayerElement() ⇒ <code>Element</code>
Requests the player element

**Kind**: instance method of <code>[FacadeBase](#FacadeBase)</code>  
**Returns**: <code>Element</code> - The video or audio element  
<a name="FacadeBase+setVolume"></a>

### facadeBase.setVolume(volume) ⇒ <code>Promise</code>
Requests the video player to change the volume.

**Kind**: instance method of <code>[FacadeBase](#FacadeBase)</code>  
**Returns**: <code>Promise</code> - Resolves if the video player accepted the volume change request  

| Param | Type | Description |
| --- | --- | --- |
| volume | <code>Number</code> | Requested volume level between 0-1 |

<a name="FacadeBase+getVolume"></a>

### facadeBase.getVolume() ⇒ <code>Number</code>
Requests the current volume level from the video player.

**Kind**: instance method of <code>[FacadeBase](#FacadeBase)</code>  
**Returns**: <code>Number</code> - The current volume level between 0-1  
<a name="FacadeBase+isMuted"></a>

### facadeBase.isMuted() ⇒ <code>Boolean</code>
Requests the current muted state from the video player.

**Kind**: instance method of <code>[FacadeBase](#FacadeBase)</code>  
**Returns**: <code>Boolean</code> - Muted state  
<a name="FacadeBase+mute"></a>

### facadeBase.mute() ⇒ <code>Promise</code>
Requests the video player to mute playback.

**Kind**: instance method of <code>[FacadeBase](#FacadeBase)</code>  
**Returns**: <code>Promise</code> - Resolves if the video player has been muted  
<a name="FacadeBase+unmute"></a>

### facadeBase.unmute() ⇒ <code>Promise</code>
Requests the video player to unmute playback.

**Kind**: instance method of <code>[FacadeBase](#FacadeBase)</code>  
**Returns**: <code>Promise</code> - Resolves if the video player has been unmuted  
<a name="FacadeBase+isPaused"></a>

### facadeBase.isPaused() ⇒ <code>Boolean</code>
Requests the current play state from the video player.

**Kind**: instance method of <code>[FacadeBase](#FacadeBase)</code>  
**Returns**: <code>Boolean</code> - Playback state  
<a name="FacadeBase+pause"></a>

### facadeBase.pause() ⇒ <code>Promise</code>
Requests the video player to pause playback.

**Kind**: instance method of <code>[FacadeBase](#FacadeBase)</code>  
**Returns**: <code>Promise</code> - Resolves if the video player has been paused  
<a name="FacadeBase+play"></a>

### facadeBase.play() ⇒ <code>Promise</code>
Requests the video player to start (resume) playback.

**Kind**: instance method of <code>[FacadeBase](#FacadeBase)</code>  
**Returns**: <code>Promise</code> - Resolves if the video player has been resumed  
<a name="FacadeBase+seek"></a>

### facadeBase.seek(offset) ⇒ <code>Promise</code>
Requests the video player to change the playhead position to the specified time.

**Kind**: instance method of <code>[FacadeBase](#FacadeBase)</code>  
**Returns**: <code>Promise</code> - Resolves if the video player has finished seeking to the specified position  

| Param | Type | Description |
| --- | --- | --- |
| offset | <code>Number</code> | Requested playhead position |

<a name="MediaError"></a>

## MediaError : <code>Object</code>
https://developer.mozilla.org/en-US/docs/Web/API/MediaError

**Kind**: global typedef  
**Properties**

| Name | Type | Description |
| --- | --- | --- |
| code | <code>number</code> | A number which represents the general type of error that occurred. |
| message | <code>string</code> | A human-readable string which provides specific diagnostic information to help the reader understand the error condition which occurred. |

<a name="ElementSize"></a>

## ElementSize : <code>Object</code>
**Kind**: global typedef  
**Properties**

| Name | Type | Description |
| --- | --- | --- |
| boundingRect | <code>Object</code> | A rectangle that describes the size and position of the element (see HTML getBoundingClientRect) |
| viewMode | <code>string</code> | Either `normal` or `fullscreen` |

<a name="EnvironmentVars"></a>

## EnvironmentVars : <code>Object</code>
Used for passing implementation-specific runtime variables.

**Kind**: global typedef  
**Properties**

| Name | Type | Description |
| --- | --- | --- |
| desiredBitrate | <code>number</code> | Indicates the desired bitrate in kilobits per second (kbps). The player uses this  information to select Mediafiles with an appropriate bitrate. Defaulting to `null`. |
| desiredMimeTypes | <code>[ &#x27;Array&#x27; ].&lt;string&gt;</code> | Declaration of accepted media types. Defaulting to types that the  browser eventually is able to play. Types must be compliant with the  [IANA Media Type standard](https://www.iana.org/assignments/media-types/media-types.xhtml) |
| desiredVPAIDVendors | <code>[ &#x27;Array&#x27; ].&lt;string&gt;</code> | Declaration of accepted VPAID vendors (whitelist). Each specified  String has to represent an unique identifier that can be found within the creative media file URL, most likely the  domain name. If omitted, the plugin tries to deliver VPAID creatives from each vendor. |
| deviceType | <code>string</code> | Can be either `mobile`, `tablet`, `desktop` or `tv`. Defaulting to `null`. |
| deviceScreenSize | <code>Dimension</code> | Maximum size we can achieve when entering fullscreen. |
| networkReachability | <code>string</code> | Can be either `wan`, `wifi` or `unreachable`. Defaulting to `null`. |
| vastMacros | <code>Object</code> | VAST macros and their values as defined in  https://interactiveadvertisingbureau.github.io/vast/vast4macros/vast4-macros-latest.html |
| prefetchBuffetAds | <code>boolean</code> | In order to replace invalid ads in a pod instantly at runtime, buffet ads from  wrapper responses must be loaded up-front. `prefetchBuffetAds` determines whether stand-alone ads (buffet) will be  loaded together with the pod of ads or not. Defaulting to `false` if omitted. |
| adContainer | <code>HTMLElement</code> | The element that should be used to deliver non-video creative files. Defaulting to `null` if omitted. |

