"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FacadeBase = void 0;
var PLAYER_FACADE_VERSION = '4.0';
/**
 * A player proxy class
 * @module FacadeBase
 * @class
 *
 * @property {Object} PLAYER_EVENT_MAP The implementation can be found in the documentation.
 */
var FacadeBase = /** @class */ (function () {
    function FacadeBase() {
        this.currentContentSource = {
            // eslint-disable-next-line no-undefined
            currentTime: undefined,
            // eslint-disable-next-line no-undefined
            progressive: undefined
        };
        this.PLAYER_EVENT_MAP = {};
    }
    /**
     * Sets up a function that will be called whenever the specified event is delivered to the video player.
     * @param {string} type - A case-sensitive string representing the player event type to listen for.
     * @param {Function} callback - The function which receives a notification when an event of the specified type occurs.
     *
     * _*Note:*
     *
     * The PLAYER_EVENT_MAP should be defined within the Facade (constructor) to allow mapping and usage of equivalent
     * events for non-HTML5 video players. The key represents the event from the custom player, while the value
     * corresponds to the standard HTML5 event. It must also be set for HTML5 players as this is no longer part of the
     * FacadeBase!
     */
    FacadeBase.prototype.addEventListener = function (type, callback) { };
    /**
     * Requests the ad playhead position from the video player.
     * @returns {Number} Total time in seconds.
     */
    // @ts-ignore: method return implemented over playerReference
    FacadeBase.prototype.getAdCurrentTime = function () { };
    /**
     * Requests the ad-duration from the video player.
     * @returns {Number} Total time in seconds. _*Note:* The time can include milliseconds (3.1234)
     */
    // @ts-ignore: method return implemented over playerReference
    FacadeBase.prototype.getAdDuration = function () { };
    /**
     * Requests the current playhead position from the video player.
     * @returns {Number} Current time in seconds. _*Note:* The time can include milliseconds (3.1234)
     */
    // @ts-ignore: method return implemented over playerReference
    FacadeBase.prototype.getContentCurrentTime = function () { };
    /**
     * Requests the content-duration from the video player.
     * @returns {Number} Total time in seconds. _*Note:* The time can include milliseconds (3.1234)
     */
    // @ts-ignore: method return implemented over playerReference
    FacadeBase.prototype.getContentDuration = function () { };
    /**
     * @returns {CurrentContentSource} SourceObject - Current content source and playhead progress
     */
    // @ts-ignore: method return implemented over playerReference
    FacadeBase.prototype.getCurrentContentSource = function () { };
    /**
     * Requests the latest status of the video player, site, and other external factors.
     * @param {string} adBreakType - Linearity of the upcoming ad slot. See [`AdBreak.type`](setup-sequential-config#adbreak+type)
     * @returns {EnvironmentVars} Object describing surrounding conditions and the expected ad properties.
     */
    // @ts-ignore: method return implemented over playerReference
    FacadeBase.prototype.getEnvironmentVars = function (adBreakType) { };
    /**
     * Requests the player element.
     * @returns {HTMLAudioElement|HTMLVideoElement|null} The video or audio element or null.
     *
     * _*Note:* If the player takes care of the OM-SDK, config.adVerification.playerHandles = true ._
     */
    // @ts-ignore: method return implemented over playerReference
    FacadeBase.prototype.getPlayerElement = function () { };
    /**
     * Requests the current size and viewMode from the video player.
     * @returns {ElementSize} Current player dimension specs
     */
    // @ts-ignore: method return implemented over playerReference
    FacadeBase.prototype.getPlayerSize = function () { };
    /**
     * Requests the current size and viewMode from the viewport that surrounds the video player.
     * @returns {ElementSize} The dimension specs of the element
     */
    // @ts-ignore: method return implemented over playerReference
    FacadeBase.prototype.getViewportSize = function () { };
    /**
     * Requests the current volume level from the video player.
     * @returns {Number} The current volume level between 0-1
     */
    // @ts-ignore: method return implemented over playerReference
    FacadeBase.prototype.getVolume = function () { };
    /**
     * Requests the player facade version (API version) to ensure the particular versions of `smartclientcore` and player facade
     * are supported.
     * @param {string} apiFacadeVersion - Required API version
     * @returns {string} Supported API version
     */
    FacadeBase.prototype.handshakeVersion = function (apiFacadeVersion) {
        return PLAYER_FACADE_VERSION;
    };
    /**
     * Requests the video player to mute playback.
     * @returns {Promise} Resolves if the video player has been muted
     */
    // @ts-ignore: method return implemented over playerReference
    FacadeBase.prototype.mute = function () { };
    /**
     * Requests the video player to unmute playback.
     * @returns {Promise} Resolves if the video player has been unmuted
     */
    // @ts-ignore: method return implemented over playerReference
    FacadeBase.prototype.unmute = function () { };
    /**
     * Requests the current screen state from the video player.
     * @returns {Boolean} Fullscreen state
     */
    // @ts-ignore: method return implemented over playerReference
    FacadeBase.prototype.isFullscreen = function () { };
    /**
     * Requests the current muted state from the video player.
     * @returns {Boolean} Muted state
     */
    // @ts-ignore: method return implemented over playerReference
    FacadeBase.prototype.isMuted = function () { };
    /**
     * Requests the current pause state from the video player.
     * @returns {Boolean} Paused state
     */
    // @ts-ignore: method return implemented over playerReference
    FacadeBase.prototype.isPaused = function () { };
    /**
     * Requests the video player to load and play the specified media file.
     * @param {string} url - The URI of the media file to be played.
     * @param {Boolean} autoPlay - Whether the requested media file starts playback immediately.
     * @param {Boolean} disableSeeking - Whether the requested source can be seeked back and forth.
     * @returns {Promise<void|number>} That resolves if the player accepts the media file request. If an error occurs, the
     *  Promise may reject with an optional error code.
     */
    // @ts-ignore: method return implemented over playerReference
    FacadeBase.prototype.load = function (url, autoPlay, disableSeeking) {
        if (autoPlay === void 0) { autoPlay = true; }
        if (disableSeeking === void 0) { disableSeeking = false; }
    };
    /**
     * Requests the video player to pause playback.
     * @returns {Promise} Resolves if the video player has been paused
     */
    // @ts-ignore: method return implemented over playerReference
    FacadeBase.prototype.pause = function () { };
    /**
     * Requests the video player to start (resume) playback.
     * @returns {Promise} Resolves if the video player has been resumed
     */
    // @ts-ignore: method return implemented over playerReference
    FacadeBase.prototype.play = function () { };
    /**
     * Removes an event listener from the video player that has been registered with `addEventListener()`
     * _*Note:* The event listener to be removed must match with the listener that has been added._
     * @param {string} type - A case-sensitive string representing the player event type to listen for.
     * @param {Function} callback - The function which receives a notification when an event of the specified type occurs.
     */
    FacadeBase.prototype.removeEventListener = function (type, callback) { };
    /**
     * restoreContentState is called right after the ad playback has finished.
     * Resumes playback by restoring the last known playback state and communicates with the AdSlotAPI upon completion.
     *
     * _*Note:* Check whether the content was really replaced by an ad. Otherwise, there should be nothing to do.
     * @returns {Promise} Resolves if the player accepts the play request; otherwise, rejects.
     */
    // @ts-ignore: method return implemented over playerReference
    FacadeBase.prototype.restoreContentState = function () { };
    /**
     * saveContentState is called right before the ad playback should begin. Notes the current playback state for
     *  later use with `restoreContentState()` and communicates with the AdSlotAPI  upon completion.
     *
     * _*Note:* Promise.resolve() without the source and the current time of the content will not work.
     * @returns {Promise} Resolves with the current content source and playhead progress for VAST tracking enrichment.
     */
    // @ts-ignore: method return implemented over playerReference
    FacadeBase.prototype.saveContentState = function () { };
    /**
     * Requests the video player to change the playhead position to the specified time.
     * @param {Number} offset - Requested playhead position
     * @returns {Promise} Resolves if the video player has finished seeking to the specified position
     */
    // @ts-ignore: method return implemented over playerReference
    FacadeBase.prototype.seek = function (offset) { };
    /**
     * Requests the video player to change the volume.
     * @param {Number} volume - Requested volume level between 0-1
     * @returns {Promise} Resolves if the video player accepted the volume change request
     */
    // @ts-ignore: method return implemented over playerReference
    FacadeBase.prototype.setVolume = function (volume) { };
    return FacadeBase;
}());
exports.FacadeBase = FacadeBase;
