[**smartclientcore**](README.md) • **Docs**

***

[smartclientcore](modules.md) / [constants/interfaces](constants/interfaces/README.md) / EnvironmentVars

# Interface: EnvironmentVars

## Extended by

- [`ExtendedEnvironmentVars`](constants/interfaces/interfaces/ExtendedEnvironmentVars.md)

## Properties

<a id="adcontainer" name="adcontainer"></a>

### adContainer?

> `optional` **adContainer**: `null` \| `HTMLElement`

The element that should be used to deliver non-video creative files.
Defaulting to `null` if omitted.

***

<a id="desiredbitrate" name="desiredbitrate"></a>

### desiredBitrate?

> `optional` **desiredBitrate**: `number`

Indicates the desired bitrate in kilobits per second (kbps). The player uses this
 information to select Mediafiles with an appropriate bitrate. Defaulting to `null`.

***

<a id="desiredmimetypes" name="desiredmimetypes"></a>

### desiredMimeTypes?

> `optional` **desiredMimeTypes**: `string`[]

Declaration of accepted media types. Defaulting to types that the
 browser eventually is able to play if not set. Types must be compliant with the
 [IANA Media Type standard](https://www.iana.org/assignments/media-types/media-types.xhtml)

***

<a id="desiredvpaidvendors" name="desiredvpaidvendors"></a>

### desiredVPAIDVendors?

> `optional` **desiredVPAIDVendors**: `string`[]

Declaration of accepted VPAID vendors (whitelist). Each specified
 String has to represent a fully qualified domain name (FQDN), including both second-level (SLD) and top-level (TLD) domains.
 If omitted, the plugin tries to deliver VPAID creatives from each vendor.

***

<a id="devicescreensize" name="devicescreensize"></a>

### deviceScreenSize?

> `optional` **deviceScreenSize**: `null` \| `string`

Maximum size we can achieve when entering fullscreen.

***

<a id="devicetype" name="devicetype"></a>

### deviceType?

> `optional` **deviceType**: `null` \| `string`

Can be either `mobile`, `tablet`, `desktop` or `tv`. Defaulting to `null`.

***

<a id="networkreachability" name="networkreachability"></a>

### networkReachability?

> `optional` **networkReachability**: `null` \| `string`

Can be either `wan`, `wifi` or `unreachable`. Defaulting to `null`.

***

<a id="omidservicewindow" name="omidservicewindow"></a>

### omidServiceWindow?

> `optional` **omidServiceWindow**: `any`

***

<a id="prefetchbuffetads" name="prefetchbuffetads"></a>

### prefetchBuffetAds?

> `optional` **prefetchBuffetAds**: `boolean`

In order to replace invalid ads in a pod instantly at runtime, buffet ads from
 wrapper responses must be loaded up-front. `prefetchBuffetAds` determines whether stand-alone ads (buffet) will be
 loaded together with the pod of ads or not. Defaulting to `false` if omitted.

***

<a id="timeouts" name="timeouts"></a>

### timeouts?

> `optional` **timeouts**: `object`

<a id="adrequest" name="adrequest"></a>

#### adRequest?

> `optional` **adRequest**: `number`

<a id="adrequestchain" name="adrequestchain"></a>

#### adRequestChain?

> `optional` **adRequestChain**: `number`

<a id="adslotrequest" name="adslotrequest"></a>

#### adSlotRequest?

> `optional` **adSlotRequest**: `number`

<a id="contentrequest" name="contentrequest"></a>

#### contentRequest?

> `optional` **contentRequest**: `number`

<a id="nonlinearmaxduration" name="nonlinearmaxduration"></a>

#### nonlinearMaxDuration?

> `optional` **nonlinearMaxDuration**: `number`

<a id="videorequest" name="videorequest"></a>

#### videoRequest?

> `optional` **videoRequest**: `number`

<a id="vpaidreadiness" name="vpaidreadiness"></a>

#### vpaidReadiness?

> `optional` **vpaidReadiness**: `number`

<a id="vpaidrequest" name="vpaidrequest"></a>

#### vpaidRequest?

> `optional` **vpaidRequest**: `number`

***

<a id="vastmacros" name="vastmacros"></a>

### vastMacros?

> `optional` **vastMacros**: `object`

VAST macros and their values as defined in
 https://interactiveadvertisingbureau.github.io/vast/vast4macros/vast4-macros-latest.html

#### Index Signature

 \[`key`: `string`\]: `any`
