[**smartclientcore**](README.md) • **Docs**

***

[smartclientcore](modules.md) / [constants/interfaces](constants/interfaces/README.md) / ExtendedEnvironmentVars

# Interface: ExtendedEnvironmentVars

## Extends

- [`EnvironmentVars`](constants/interfaces/interfaces/EnvironmentVars.md)

## Properties

<a id="adcontainer" name="adcontainer"></a>

### adContainer?

> `optional` **adContainer**: `null` \| `HTMLElement`

The element that should be used to deliver non-video creative files.
Defaulting to `null` if omitted.

#### Inherited from

[`EnvironmentVars`](constants/interfaces/interfaces/EnvironmentVars.md).[`adContainer`](constants/interfaces/interfaces/EnvironmentVars.md#adcontainer)

***

<a id="desiredbitrate" name="desiredbitrate"></a>

### desiredBitrate?

> `optional` **desiredBitrate**: `number`

Indicates the desired bitrate in kilobits per second (kbps). The player uses this
 information to select Mediafiles with an appropriate bitrate. Defaulting to `null`.

#### Inherited from

[`EnvironmentVars`](constants/interfaces/interfaces/EnvironmentVars.md).[`desiredBitrate`](constants/interfaces/interfaces/EnvironmentVars.md#desiredbitrate)

***

<a id="desiredmimetypes" name="desiredmimetypes"></a>

### desiredMimeTypes?

> `optional` **desiredMimeTypes**: `string`[]

Declaration of accepted media types. Defaulting to types that the
 browser eventually is able to play if not set. Types must be compliant with the
 [IANA Media Type standard](https://www.iana.org/assignments/media-types/media-types.xhtml)

#### Inherited from

[`EnvironmentVars`](constants/interfaces/interfaces/EnvironmentVars.md).[`desiredMimeTypes`](constants/interfaces/interfaces/EnvironmentVars.md#desiredmimetypes)

***

<a id="desiredvpaidvendors" name="desiredvpaidvendors"></a>

### desiredVPAIDVendors?

> `optional` **desiredVPAIDVendors**: `string`[]

Declaration of accepted VPAID vendors (whitelist). Each specified
 String has to represent a fully qualified domain name (FQDN), including both second-level (SLD) and top-level (TLD) domains.
 If omitted, the plugin tries to deliver VPAID creatives from each vendor.

#### Inherited from

[`EnvironmentVars`](constants/interfaces/interfaces/EnvironmentVars.md).[`desiredVPAIDVendors`](constants/interfaces/interfaces/EnvironmentVars.md#desiredvpaidvendors)

***

<a id="devicescreensize" name="devicescreensize"></a>

### deviceScreenSize?

> `optional` **deviceScreenSize**: `null` \| `string`

Maximum size we can achieve when entering fullscreen.

#### Inherited from

[`EnvironmentVars`](constants/interfaces/interfaces/EnvironmentVars.md).[`deviceScreenSize`](constants/interfaces/interfaces/EnvironmentVars.md#devicescreensize)

***

<a id="devicetype" name="devicetype"></a>

### deviceType?

> `optional` **deviceType**: `null` \| `string`

Can be either `mobile`, `tablet`, `desktop` or `tv`. Defaulting to `null`.

#### Inherited from

[`EnvironmentVars`](constants/interfaces/interfaces/EnvironmentVars.md).[`deviceType`](constants/interfaces/interfaces/EnvironmentVars.md#devicetype)

***

<a id="networkreachability" name="networkreachability"></a>

### networkReachability?

> `optional` **networkReachability**: `null` \| `string`

Can be either `wan`, `wifi` or `unreachable`. Defaulting to `null`.

#### Inherited from

[`EnvironmentVars`](constants/interfaces/interfaces/EnvironmentVars.md).[`networkReachability`](constants/interfaces/interfaces/EnvironmentVars.md#networkreachability)

***

<a id="omidservicewindow" name="omidservicewindow"></a>

### omidServiceWindow?

> `optional` **omidServiceWindow**: `any`

#### Inherited from

[`EnvironmentVars`](constants/interfaces/interfaces/EnvironmentVars.md).[`omidServiceWindow`](constants/interfaces/interfaces/EnvironmentVars.md#omidservicewindow)

***

<a id="prefetchbuffetads" name="prefetchbuffetads"></a>

### prefetchBuffetAds?

> `optional` **prefetchBuffetAds**: `boolean`

In order to replace invalid ads in a pod instantly at runtime, buffet ads from
 wrapper responses must be loaded up-front. `prefetchBuffetAds` determines whether stand-alone ads (buffet) will be
 loaded together with the pod of ads or not. Defaulting to `false` if omitted.

#### Inherited from

[`EnvironmentVars`](constants/interfaces/interfaces/EnvironmentVars.md).[`prefetchBuffetAds`](constants/interfaces/interfaces/EnvironmentVars.md#prefetchbuffetads)

***

<a id="timeouts" name="timeouts"></a>

### timeouts

> **timeouts**: [`Timeouts`](constants/interfaces/interfaces/Timeouts.md)

#### Overrides

[`EnvironmentVars`](constants/interfaces/interfaces/EnvironmentVars.md).[`timeouts`](constants/interfaces/interfaces/EnvironmentVars.md#timeouts)

***

<a id="vastmacros" name="vastmacros"></a>

### vastMacros?

> `optional` **vastMacros**: `object`

VAST macros and their values as defined in
 https://interactiveadvertisingbureau.github.io/vast/vast4macros/vast4-macros-latest.html

#### Index Signature

 \[`key`: `string`\]: `any`

#### Inherited from

[`EnvironmentVars`](constants/interfaces/interfaces/EnvironmentVars.md).[`vastMacros`](constants/interfaces/interfaces/EnvironmentVars.md#vastmacros)
