[> Documentation-Index](index.md)

# smartclientcore
## Basic Usage

### Installing
The smartclientcore is provided as a JavaScript file `smartclientcore.min.js` that can be used in two ways:
- using ES6 import (_recommended_)
- directly loaded by the page that includes the video player

#### Using ES6 Import
The file must be copied to the video player project.

<span class="box box--dark-red-1">_We recommend using a place that already hosts third-party JS modules for your project.
But please do not use the folder `node_modules` because it is managed by **Node package manager (npm)**.
If not yet established, let's create a folder named `vendor_modules`._</span>

```javascript
import smartclientcore from './vendor_modules/smartclip/smartclientcore.min';
```

#### Directly loaded to the page
The file must be included once by putting the following HTML one-liner next to the Video Player source files.

```diff
 	<script src="js/videoplayer.js"></script>
+	<script src="js/smartclientcore.min.js"></script>
```
<sub>Sample code - step 1 :: Adding the smartclientcore to the page</sub>

### Player Prerequisites
Certainly your HTML page already includes a HTML5 Audio or Video Player. Otherwise you should take this step first.
Next steps assume that your content runs smoothly and the player fulfills the following preconditions:
- remove existing build-in ads setup
- the player can be controlled through an API
- the player is able to forward information about the current state and playback progress
	
```diff
 	advertising: {
-		schedule: {
-			'pre-roll-ad': {
-				offset: 'pre',
-				tag: 'https://adserver.com/tag?type=vast3xml'
-			}
-		}
 	}
```
<sub>Sample code - step 2 ::  Clean-up configuration Object</sub>


### Safeguarding the Video Player
In order to avoid unexpected calls to the player API, it is not only recommended but **mandatory to safeguard the player
API with your own facade** (proxy). The facade interface has to match with the **[Facade and Video Player Interface]**.

Using the facade has two main reasons:
- provide a generic player interface the smartclientcore can safely talk to
- capture and validate requests made by the smartclientcore towards the player API
- clean event pass-through

For your reference the smartclientcore package contains a file `FacadeBase.js` that can be extended by your custom player
facade.


```javascript
import { FacadeBase } from './FacadeBase';

const FACADE_VERSION = '4.0';

export class MyPlayerFacade extends FacadeBase {
	constructor(playerReference = {}) {
        
        this.PLAYER_EVENT_MAP = {

            // maybe different if no HTML5 player is used
            ended: 'ended',
            error: 'error',
            loadeddata: 'loadeddata',
            pause: 'pause',
            play: 'play',
            resize: 'resize',
            timeupdate: 'timeupdate',
            volumechange: 'volumechange'
        };
    };
}
```
<sub>Sample code - step 3 ::  Set up `MyPlayerFacade.js`</sub>


### Initialization

```javascript
import smartclientcore from './vendor_modules/smartclip/smartclientcore.min';
import { MyPlayerFacade } from './MyPlayerFacade';

// Let's assume the page uses a HTML5 VideoElement, though `myPlayer` can be any other Video Player
const myPlayer = document.querySelector('video#myplayer');
const myPlayerFacade = new MyPlayerFacade(myPlayer);

let config = smartclientcore.CONFIG;
let adSlotAPI = null;

let adCoreInstance = smartclientcore.init(myPlayerFacade, config);

if (adCoreInstance) {

	adCoreInstance.then(mainController => {
		
        adSlotAPI = mainController.AdSlotAPI;
		
		/**
		 * You are ready to request your first ads
		 * this is also a good point to subscribe to ad events
		 */
		smartclientcore.EVENTS.forEach(eventType => {
			adSlotAPI.addEventListener(eventType, (event) => { /* do something */ });
		});
	});
}
else {
    
    // Returns the error that occurred during initialization
    smartclientcore.initError;
}
```
<sub>Sample code - step 4 ::  Creation and setup of the smartclientcore</sub>

[Facade and Video Player Interface]:FacadeBase.md
