# smartclientcore - Advertisement Framework
## API Specification

<sub>_Applies to: Web-based Audio and Video Player_</sub>  
<sub>_Last Modified on 2026-01-14T09:56:47.747Z_</sub>

A JavaScript library (further referenced as **smartclientcore**) to extend web-based audio and video solutions with
advertisement capabilities. Aside of supporting the IAB video advertising standards (SIMID, VAST, VPAID, VMAP and
Open Measurement), it adds complex sequencing functionality (Opener, Closer, Divider, Sponsored Ads), helps 
bypassing ad-blockers through ad-reinsertion and is fully compliant with **smartclip's advertising eco-system** and
its connected vendor networks.


### Table of contents
- [Basic Usage](basic-usage.md)
- [Setup](setup.md)
  - [Global Configuration](setup-config.md)
  - [Sequential Configuration](setup-sequential-config.md)
- [FacadeBase](facade/FacadeBase/classes/FacadeBase.md)
- [Static API](plugin-static-api.md)
  - [Methods](plugin-static-api.md#methods)
  - [Properties](plugin-static-api.md#properties)
- [MainController](controllers/MainController/README.md)
- [Events](events.md)
  - [Ad and Ad-Slot Events](events.md#ad-events)
  - [Ad Playlist Events](events.md#ad-playlist-events)
  - [Event Cycle](events.md#event-cycle)
  - EVENT list
    - [Ad](events.md#event-list-ad)
    - [AdSlot](events.md#event-list-adslot)
    - [AdPlaylist](events.md#event-list-adplaylist)
- [Migration-Guide V6 to V7](migration-v6-v7.md)
- [Changelog](CHANGELOG.md)
- [Error Codes](errorcodes.md)
- [Glossar](glossar.md)

****
