**smartclientcore** • [**Docs**](modules.md)

***

[![coverage report](https://gitlab.burgeins.de/smartclip/smartclientcore/badges/develop/coverage.svg?style=flat-square)
](https://smartclip.pages.gitlab.burgeins.de/smartclientcore)
[![pipeline status](https://gitlab.burgeins.de/smartclip/smartclientcore/badges/develop/pipeline.svg?style=flat-square)
](https://gitlab.burgeins.de/smartclip/smartclientcore/pipelines/latest)

# smartclip smartclientcore - build guide
_Last Modified on 2026-01-12T08:36:42.815Z_  
_Current version 7.6.0-dev_

## Table of contents
- [NPM Scripts](#npm-scripts)
    - [build-core](#build-core)
    - [cucumber](#cucumber)
    - [omWebControl](#omWebControl)
    - [release](#release)
    - [setup](#setup)
    - [tests](#tests)
    - [update](#update)
    - [vite-dev](#vite-dev)
- [Documentation](#documentation)

## NPM Scripts
___
### _Tipp_
If you use **PHPStorm** right click on the file `package.json` in the root directory and select `Show npm scripts` at the
bottom of the context menu. This opens the npm tool window with the following list of npm scripts:

* build-omweb
* build-no-omweb
* cucumber
* cucumber
* omWebControl
* release
* setup
* tests
* update
* vite-dev

You can simply double click on a listed script to execute it.
___

### build-omweb (browser environment)
Builds the core application for production using vite with the following options:

-m production and the configuration file located in confs/vite.config.mjs. The script also runs the compile-es5.

### build-no omweb (non browser environment)
Builds the core application for production using vite with the following options:

-m production and the configuration file located in confs/vite.config.no.omweb.mjs. The script also runs the 
compile-es5.

### cucumber
The build task and the vite-dev task should be executed beforehand so that the acceptance test with Cucumber
is successful.

### cucumber-multiple-pass
Execute the cucumber several times. Checks that no time-related problems occur randomly.

### omWebControl
This checks whether the OMSDK version under utils and the package under vendor modules matches the version in
package.json.

### release
Creates a finished release zip package that contains changelog, docs, javascript, typescript and typescript definitions.

### setup
Installs the required dependencies for the project.

### setup-playwright
Installs the exact Playwright browser needed for cucumber etc.

### tests
Runs tests for the project using Playwright and the nyc code coverage tool, including files in the src directory.
The script generates text coverage reports.

### update
Updates the project's dependencies.

### vite-dev
Runs the development server using Vite with the following options: --host 0.0.0.0 --port 4444.

*_Note_*: Some of these scripts are dependent on other scripts, so be sure to check the script dependencies before
running them.

<a name="omupdate"></a>

## Documentation

[Add-On Setup Guideline](index.md)
