[**smartclientcore**](README.md) • **Docs**

***

[smartclientcore](modules.md) / [constants/interfaces](constants/interfaces/README.md) / FacadeBase

# Interface: FacadeBase

## Extended by

- [`PlayerFacade`](constants/interfaces/interfaces/PlayerFacade.md)

## Properties

<a id="currentcontentsource" name="currentcontentsource"></a>

### currentContentSource

> **currentContentSource**: [`CurrentContentSource`](constants/interfaces/interfaces/CurrentContentSource.md)

***

<a id="paused" name="paused"></a>

### paused

> **paused**: `boolean`

***

<a id="volume" name="volume"></a>

### volume

> **volume**: `number`

## Methods

<a id="addeventlistener" name="addeventlistener"></a>

### addEventListener()

> **addEventListener**(`type`, `callback`): `void`

#### Parameters

• **type**: `string`

• **callback**: `Function`

#### Returns

`void`

***

<a id="getadcurrenttime" name="getadcurrenttime"></a>

### getAdCurrentTime()

> **getAdCurrentTime**(): `number`

#### Returns

`number`

***

<a id="getadduration" name="getadduration"></a>

### getAdDuration()

> **getAdDuration**(): `number`

#### Returns

`number`

***

<a id="getcontentcurrenttime" name="getcontentcurrenttime"></a>

### getContentCurrentTime()

> **getContentCurrentTime**(): `number`

#### Returns

`number`

***

<a id="getcontentduration" name="getcontentduration"></a>

### getContentDuration()

> **getContentDuration**(): `number`

#### Returns

`number`

***

<a id="getcurrentcontentsource" name="getcurrentcontentsource"></a>

### getCurrentContentSource()

> **getCurrentContentSource**(): [`CurrentContentSource`](constants/interfaces/interfaces/CurrentContentSource.md)

#### Returns

[`CurrentContentSource`](constants/interfaces/interfaces/CurrentContentSource.md)

***

<a id="getenvironmentvars" name="getenvironmentvars"></a>

### getEnvironmentVars()

> **getEnvironmentVars**(`adBreakType`): [`EnvironmentVars`](constants/interfaces/interfaces/EnvironmentVars.md)

#### Parameters

• **adBreakType**: `string`

#### Returns

[`EnvironmentVars`](constants/interfaces/interfaces/EnvironmentVars.md)

***

<a id="getplayerelement" name="getplayerelement"></a>

### getPlayerElement()

> **getPlayerElement**(): `null` \| `HTMLAudioElement` \| `HTMLVideoElement`

#### Returns

`null` \| `HTMLAudioElement` \| `HTMLVideoElement`

***

<a id="getplayersize" name="getplayersize"></a>

### getPlayerSize()

> **getPlayerSize**(): [`ElementSize`](constants/interfaces/interfaces/ElementSize.md)

#### Returns

[`ElementSize`](constants/interfaces/interfaces/ElementSize.md)

***

<a id="getviewportsize" name="getviewportsize"></a>

### getViewportSize()

> **getViewportSize**(): [`ElementSize`](constants/interfaces/interfaces/ElementSize.md)

#### Returns

[`ElementSize`](constants/interfaces/interfaces/ElementSize.md)

***

<a id="getvolume" name="getvolume"></a>

### getVolume()

> **getVolume**(): `number`

#### Returns

`number`

***

<a id="handshakeversion" name="handshakeversion"></a>

### handshakeVersion()

> **handshakeVersion**(`apiFacadeVersion`): `string`

#### Parameters

• **apiFacadeVersion**: `string`

#### Returns

`string`

***

<a id="isfullscreen" name="isfullscreen"></a>

### isFullscreen()

> **isFullscreen**(): `boolean`

#### Returns

`boolean`

***

<a id="ismuted" name="ismuted"></a>

### isMuted()

> **isMuted**(): `boolean`

#### Returns

`boolean`

***

<a id="ispaused" name="ispaused"></a>

### isPaused()

> **isPaused**(): `boolean`

#### Returns

`boolean`

***

<a id="load" name="load"></a>

### load()

> **load**(`url`, `autoPlay`?, `disableSeeking`?): `Promise`\<`void`\>

#### Parameters

• **url**: `string`

• **autoPlay?**: `boolean`

• **disableSeeking?**: `boolean`

#### Returns

`Promise`\<`void`\>

***

<a id="mute" name="mute"></a>

### mute()

> **mute**(): `Promise`\<`void`\>

#### Returns

`Promise`\<`void`\>

***

<a id="pause" name="pause"></a>

### pause()

> **pause**(): `Promise`\<`void`\>

#### Returns

`Promise`\<`void`\>

***

<a id="play" name="play"></a>

### play()

> **play**(): `Promise`\<`void`\>

#### Returns

`Promise`\<`void`\>

***

<a id="removeeventlistener" name="removeeventlistener"></a>

### removeEventListener()

> **removeEventListener**(`type`, `callback`): `void`

#### Parameters

• **type**: `string`

• **callback**: `Function`

#### Returns

`void`

***

<a id="restorecontentstate" name="restorecontentstate"></a>

### restoreContentState()

> **restoreContentState**(): `Promise`\<`void`\>

#### Returns

`Promise`\<`void`\>

***

<a id="savecontentstate" name="savecontentstate"></a>

### saveContentState()

> **saveContentState**(): `Promise`\<[`CurrentContentSource`](constants/interfaces/interfaces/CurrentContentSource.md)\>

#### Returns

`Promise`\<[`CurrentContentSource`](constants/interfaces/interfaces/CurrentContentSource.md)\>

***

<a id="seek" name="seek"></a>

### seek()

> **seek**(`offset`): `Promise`\<`void`\>

#### Parameters

• **offset**: `number`

#### Returns

`Promise`\<`void`\>

***

<a id="setvolume" name="setvolume"></a>

### setVolume()

> **setVolume**(`volume`): `Promise`\<`void`\>

#### Parameters

• **volume**: `number`

#### Returns

`Promise`\<`void`\>

***

<a id="unmute" name="unmute"></a>

### unmute()

> **unmute**(): `Promise`\<`void`\>

#### Returns

`Promise`\<`void`\>
