# Migration Notes v6 to v7
_Last Modified on 2026-01-12T08:36:42.818Z_

## Table of contents
* [Introduction](#intro)
* [PlayerFacade](#facade)
    * [player event map](#facade+map)
    * [version](#facade+version)
    * [Comparison methods v6 : v7](#facade+methods)
    * [EnvironmentVars](#facade+environment)
    * [New load reject](#facade+load)
* [Initialization](#init)
    * [VAST-only](#vast)
        * [init](#vast+init)
        * [request](#vast+request)
    * [VMAP + VAST](#vmap)
        * [init](#vmap+init)
        * [request](#vmap+request)
    * [Comparison v6 : v7](#comparison)
* [From which event can be used compare - PublicAd & PublicAdSlot](#public)
* [Where can you get the extensions?](#public+extension)
* [Industry Icon Changes](#industryiconchanges)
* [Removed Event](#removedevent)
* [Custom Error Changes](#customerrorchanges)
* [AdReinsertion Code Changes](#adreinsertioncodechanges)
* [Start implementation with typescript](#typescript)
* [Start implementation with non-browser environments](#nonbrowser)

<a name="intro"></a>

## Introduction
With version 7 of the **smartclientcore** the complete initialization process has been simplified and there are still
two ways to deliver ads. As in previous versions, ads can be requested for a specific ad slot or ad playlists, which
contain a collection of ads for the entire underlying content.

The **smartclientcore** allows two getters after successful initialization in order to obtain the ad-specific 
delivery API. The VMAP `AdPlaylistAPI` to work with VMAP responses and the `AdSlotAPI` which continues to work with 
VAST responses.

Schema creation has been completely removed as type safety was introduced during development. The configuration now
contains all default values and can be adjusted.

An improved debugging system allows more granular controls over the type and amount of output logged. The new
debugging system is based on a defined logging level, which determines what kind of information should be logged. 
The available logging levels are `ERROR`, `NORMAL`, `SILENT` and `VERBOSE`.
Each level corresponds to a specific set of log types that determine what types of messages are logged.
The loglevel can be set via `smartclientcore.debugLevel = smartclientcore.LOGLEVEL.VERBOSE`
Default mode is `SILENT`.

<a name="debug"></a>

Output overview:

```javascript
smartclientcore.debugLevel = smartclientcore.LOGLEVEL.SILENT
```
No console output.

```javascript
smartclientcore.debugLevel = smartclientcore.LOGLEVEL.ERROR
```
Only console errors and critical states will be logged.

```javascript
smartclientcore.debugLevel = smartclientcore.LOGLEVEL.NORMAL
```

Console info, table, and warning states will be logged.

```javascript
smartclientcore.debugLevel = smartclientcore.LOGLEVEL.VERBOSE
```

All states including critical, error, info, table, and warning will be logged.

This enhancement makes debugging more flexible and efficient, allowing for better management of debug messages.

<a name="facade"></a>

## PlayerFacade

<a name="facade+map"></a>

### player event map

The PLAYER_EVENT_MAP should be defined within the Facade to allow mapping and usage of equivalent events for non-HTML5
video players. The key represents the event from the HTML5 player, while the value corresponds to the custom player
 event.

```javascript

this.PLAYER_EVENT_MAP = {
  ended: 'ended',
  error: 'error',
  loadeddata: 'loadeddata',
  play: 'play',
  resize: 'resize',
  pause: 'pause',
  timeupdate: 'timeupdate'
};
```

<a name="facade+version"></a>

### version

The **smartclientcore** version `7.0` requires facade version `4.0`.

```javascript es5 syntax
/**
 * Requests the player facade version (API version) to ensure the particular versions of `smartclientcore` and player
 *  facade are supported.
 * @param {string} apiFacadeVersion - Required API version
 * @returns {string} Supported API version
 */
PlayerFacade.prototype.handshakeVersion = function (apiFacadeVersion) {
	return '4.0';
};
```

<a name="facade+methods"></a>

### Methods comparison

| v6                                           | v7                                         |
|----------------------------------------------|--------------------------------------------|
| `playerFacade.handshakeVersion` return `3.2` | `playerFacade.handshakeVersion` return `4` |
| `playerFacade.lockContent`                   | `playerFacade.saveContentState`            |
| `playerFacade.releaseContent`                | `playerFacade.restoreContentState`         |
| `playerFacade.getCurrentTime`                | `playerFacade.getAdCurrentTime`            |
| `playerFacade.getDuration`                   | `playerFacade.getAdDuration`               |
| `playerFacade.getCurrentTime`                | `playerFacade.getContentCurrentTime`       |
| `playerFacade.getDuration`                   | `playerFacade.getContentDuration`          |
| `playerFacade.getError`                      | n/a                                        |
| n/a                                          | `playerFacade.isFullscreen`                |

`getCurrentTime` and `getDuration`
For better case differentiation, the facade has been extended and a distinction is made between the ad and the
content in relation to different time values.

`playerFacade.lockContent` and `playerFacade.releaseContent`
The old methods have been renamed for better understanding, as it was interpreted here that the content is frozen.
Here, however, the position of the content is recorded with the corresponding source.

`playerFacade.getError`
The publisher has all the important information in his player, so it is not necessary to pass it on.

`playerFacade.getPlayerElement`
An `HTMLAudioElement`, `HTMLVideoElement` or `null` may now be returned here.

If the PlayerElement is set to `null` by the publisher due to external circumstances (e.g. AdbBocker) and a 
`startAdSlot` is executed, the core automatically terminates this AdSlot.

It is therefore essential to transfer a PlayerElement, as otherwise no corresponding delivery can take place.

Having a PlayerElement, the **smartclientcore** is then ready to execute new `initAdSlot`s and deliver them with a
PlayerElement if available. This means that no new instance needs to be initialized.

### EnvironmentVars.desiredMimetypes

The publisher uses desiredMimeTypes to define what is playable, a check via canPlayType does not take place.
If it is not set, the standard MimeTypes are checked with the canPlayType method of the respective browser.

<a name="facade+load"></a>

### load reject accept error codes

```javascript
import { FacadeBase } from '../your/path/FacadeBase';

const FACADE_VERSION = '4.0';

export class Facade extends FacadeBase {

    constructor(playerReference = {}) {

        this.player = playerReference;
        this.currentContentSource = {};

        this.PLAYER_EVENT_MAP = {
            ended: 'ended',
            error: 'error',
            loadeddata: 'loadeddata',
            play: 'play',
            pause: 'pause',
            resize: 'resize',
            timeupdate: 'timeupdate'
        };
    }
    
    // ...
    
    load(url, autoPlay = true, disableSeeking = false) {
        
        // ... publisher logic ...
        
        this.player.addEventListener('error', (error) => {
            reject(401);        // permitted codes are listed in the table below the code example
        });
        
        // ... publisher logic ...
    }

    // ...
}
```

| Code | Message                                                                            |
|------|------------------------------------------------------------------------------------|
| 400  | General linear error. The video player is unable to display the linear ad.         |
| 401  | File not found. Unable to find linear/mediaFile from URI.                          |
| 402  | Unable to download or timeout of MediaFile URI.                                    |
| 403  | Could not find a media file that is supported by this video player, based ...      |
| 405  | Problem displaying a media file. Video player found a MediaFile with supported ... |

<a name="init"></a>

## Initialization

Follow the next two steps to use **smartclientcore** for requesting [VAST-AdTags](#vast)

See below for requesting and processing VMAP ads: [AdPlaylistAPI](#vmap).

<a name="vast"></a>

### VAST adSlot usage

Initialization is now done in one single step.

<a name="vast+init"></a>

#### init

Initialization could look like this.

```javascript es5 syntax
AdController.prototype.initSmartclientcore = function () {
	var that = this;
	
	window.smartclientcore
		.init(this.playerFacade, this.config)
		.then(function success(MainController) {
			that.adSlotAPI = MainController.adSlotAPI;
		})
        .catch(function failure() {
            console.warn('AdController::init error,', smartclientcore.initError);    
        });
};
```

<a name="vast+request"></a>

#### request

After connecting to the mainController, `AdSlotAPI` is used to call `initAdSlot` and then `startAdSlot`:

```javascript
that.adSlotAPI.initAdSlot(adBreak, that.environmentVars)
    .then(function () {
        that.adSlotAPI.startAdSlot();
    })
    .catch(function failure(error) {
        console.log('something went wrong while requesting VAST', error);
    });
```

<a name="vmap"></a>

### VMAP and VAST

Requesting a VMAP tag is just as simple.

<a name="vmap+init"></a>

#### init

VMAP processing is largely similar to VAST, but a different API needs to be used.

```javascript es5 syntax
AdController.prototype.initSmartclientcore = function () {
	var that = this;

    window.smartclientcore
        .init(this.playerFacade, this.config)
        .then(function success(MainController) {

            that.adPlaylistAPI = MainController.adPlaylistAPI;
            that.adSlotAPI = MainController.adSlotAPI;
        })
        .catch(function failure() {
            console.warn('AdController::init error,', smartclientcore.initError);
        });
};
```

<a name="vmap+request"></a>

#### request

Similar to VAST adSlot setups an ad server request (`initAdPlaylist()`) is initialized and the ad server
response (`startAdPlaylist()`) is processed.
Instead of setting the entire environmentVars beforehand, only the `vastMacros` property is needed.
The other environmentVars will be requested by the `PlayerFacade` at runtime (see [PlayerFacade](#facade)).

For detailed information on macros, see the [IAB online resource](
https://interactiveadvertisingbureau.github.io/vast/vast4macros/vast4-macros-latest.html).
Implementation is done as follows:

```javascript
var environmentVars = {};
environmentVars.vastMacros = {};

this.adPlaylistAPI.initAdPlaylist(adBreak, environmentVars)
    .then(function success() {
        this.adPlaylistAPI.startAdPlaylist();
    })
    .catch(function failure(error) {
        console.log('something went wrong while requesting VMAP', error);
    });
```

<a name="comparison"></a>

### Initialization comparison
| v6                                                                                                                                                                                                               | v7                                                                                                                                                              |
|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `smartclientcore.connect(PlayerFacade)`, `PlayerFacade` must match the `FacadeBase` interface version `3.2`                                                                                                      | `smartclientcore.init(PlayerFacade, config)`, `PlayerFacade` must match the `FacadeBase` interface version `4.0`                                                |
| `setup(GlobalConfig)`, but the API has been renamed to `AdSlotAPI`                                                                                                                                               | n/a                                                                                                                                                             |
| introduces `smartclientcore.vmap.connect(PlayerFacade)` to create an instance of the smartclientcore VMAP and VAST implementation for the given `PlayerFacade` (based upon `FacadeBase` interface version `3.2`) | n/a                                                                                                                                                             |
| `setup(GlobalConfig)` to instantiate the `AdPlaylistAPI` and `AdSlotAPI`                                                                                                                                         | `init(PlayerFacade, config)` to instantiate the `AdPlaylistAPI` and `AdSlotAPI` over MainController getter                                                      |
| `SCHEMA.create(smartclientcore.SCHEMA.GLOBAL_CONFIG)` to obtain the configuration for future processing                                                                                                          | The standard configuration is now accessible via the `smartclientcore.CONFIG` getter, after which the desired values can be changed to start an initialization  |

<a name="public"></a>

### PublicAd and PublicAdSlot comparison

| v6                                                        | v7                                                           |
|-----------------------------------------------------------|--------------------------------------------------------------|
| `PublicAd` available after `ON_AD_SLOT_STARTED` event     | `PublicAd` available after `ON_AD_MANIFEST_LOADED` event     |
| `PublicAdSlot` available after `ON_AD_SLOT_STARTED` event | `PublicAdSlot` available after `ON_AD_MANIFEST_LOADED` event |

<a name="public+extension"></a>

### Where can you get the extensions?

VAST ads can come with various custom extensions, which can be necessary for a specific execution of the ad or include
meta-data. The smartclip SDK supports many extensions such as "AdVerifications", all extensions of the current ad
can be accessed via PublicAd API.

The extensions of the first display become available with the ON_AD_LOADED event, all others can then be called up
after the respective ON_AD_START event.

```javascript

// first ad
adSlotAPI.addEventListener(smartclientcore.EVENT.ON_AD_LOADED, function(event) {
    
    const extensions = adSlotAPI.ad.extensions;
    
    extensions.forEach((extension, index) => {
        
        // do stuff
    });
})
```

<a name="industryiconchanges"></a>

### IndustryIcon comparison

| v6                                    | v7                   |
|---------------------------------------|----------------------|
| icon['iconClickThroughURLTemplate']   | icon.clickThroughURL |
| icon['iconClickTrackingURLTemplates'] | icon.clickTracking   |
| icon['iconViewTrackingURLTemplate']   | icon.viewTracking    |
| icon.offset `string`                  | icon.offset `number` |
| icon.[staticResource]                 | icon.resources       |

```javascript

icon.clickThroughURL = 'string';
icon.clickTracking = [{
    id: 'string | null',
    url: 'string'
}]
icon.viewTracking = [{
    url: 'string'
}]
icon.resources = [{
    creativeType: 'string | null',  // attribute from creativeResources node
    resource: 'string | null',      // creativeResources text content
    type: 'string'                  // creativeResources node name
}];
```

<a name="removedevent"></a>

### Event comparison

| v6                       | v7  |
|--------------------------|-----|
| EVENT.ON_AD_FINISHED     | n/a |

<a name="customerrorchanges"></a>

### Custom Error comparison

| Error V6                             | Error V7                              | Code V6 | Code v7 | 
|--------------------------------------|---------------------------------------|---------|---------|
| ERROR.SESSION.ALREADY_STARTED        | ERROR.SESSION.ALREADY_STARTED         | 10      | 200202  |
| ERROR.SESSION.NOT_RESTORABLE         | ERROR.SESSION.NOT_RESTORABLE          | 11      | 200206  |
| ERROR.SESSION.MANIFEST_SETUP_CORRUPT | ERROR.SESSION.MANIFEST_SETUP_CORRUPT  | 20      | 200201  |
| ERROR.SESSION.MANIFEST_LOAD_FAILED   | ERROR.SESSION.MANIFEST_LOAD_FAILED    | 21      | 200203  |
| ERROR.SESSION.TIMEOUT                | ERROR.SESSION.TIMEOUT                 | 22      | 200204  |
| n/a                                  | ERROR.SESSION.AD_REINSERTION_TIMEOUT  | n/a     | 200207  |
| ERROR.SESSION.AD_REINSERTION_PENALTY | ERROR.SESSION.AD_REINSERTION_PENALTY  | 23      | 200208  |
| ERROR.SETUP.CORRUPT                  | n/a                                   | 60      | n/a     |
| n/a                                  | ERROR.SETUP.NO_FACADE                 | n/a     | 200100  |
| n/a                                  | ERROR.SETUP.INCORRECT_FACADE          | n/a     | 200101  |
| ERROR.SETUP.NO_PLAYER                | n/a                                   | 61      | n/a     |
| n/a                                  | ERROR.SETUP.INVALID_HANDSHAKE         | n/a     | 200102  |
| ERROR.SETUP.AD_REINSERTION_PENALTY   | ERROR.SETUP.AD_REINSERTION_PENALTY    | 62      | 200103  |
| ERROR.SETUP.HOMAD_TIMEOUT            | n/a                                   | 63      | n/a     |
| ERROR.SETUP.AD_REINSERTION_DECLINED  | ERROR.SESSION.AD_REINSERTION_DECLINED | 64      | 200200  |
| ERROR.VMAP.NO_AD_BREAKS              | ERROR.VMAP.NO_AD_BREAKS               | 1009    | 202300  |
| ERROR.WARNING.TRACKER_LOAD_FAILED    | ERROR.WARNING.TRACKER_LOAD_FAILED     | 50      | 200400  |
| ERROR.WARNING.TRACKER_TIMEOUT        | ERROR.WARNING.TRACKER_TIMEOUT         | 51      | 200401  |
| ERROR.WRAPPER.MIXED_CONTENT          | ERROR.SESSION.MIXED_CONTENT           | 310     | 200205  |

<a name="adreinsertioncodechanges"></a>

### AdReinsertion code changes

| AdReinsertion Reason Codes | v6   | v7     | 
|----------------------------|------|--------|
| XHR_TIMEOUT                | 1000 | 201000 |
| XHR_UNEXPECTED_STATUS      | 1001 | 201001 |
| XHR_ERROR                  | 1002 | 201002 |
| XML_PARSING_ERROR          | 1003 | 201003 |
| WRAPPER_CHAIN_TIMEOUT      | 1004 | 201004 |
| AD_SLOT_TIMEOUT            | 1005 | 201005 |
| XHR_PROMISE_ERROR          | 1006 | 201006 |
| MEDIAFILE_TIMEOUT          | 1010 | 201010 |
| MEDIAFILE_LOAD_ERROR       | 1013 | 201013 |
| FORCE_ACTIVATION           | 1020 | 201020 |

<a name="typescript"></a>

### First steps towards working with Typescript and the smartclientcore

To begin development with TypeScript, ensure that the necessary dependencies are correctly configured.
Follow the steps below to set up and import the required packages.

#### 1.Update the Dependencies

In the project package.json file, modify or extend the dependencies section to include the local version of the
**smartclientcore** package:

```
{
  "dependencies": {
    "smartclientcore": "file:../7.1.0"
  }
}
```

#### 2. Install the Dependencies

Once the package.json is updated, run the following command to install all dependencies, including the
**smartclientcore** package:

```
npm install
```

This command will link all required packages into the project, ensuring that everything is set up for development.

#### 3. Importing the smartclientcore module

With the dependencies installed, it's possible to import the **smartclientcore** module into TypeScript files.

To import the default **smartclientcore** module, use the following line:

```
import smartclientcore from 'smartclientcore';
```

#### 4. Importing Types from smartclientcore

In addition to the **smartclientcore** functionality, specific types from the **smartclientcore** library may also be
needed. TypeScript enables strict typing for better code quality. To import types like AdBreakSetup, use the 
following syntax:

```
import { AdBreakSetup } from 'smartclientcore';
```

#### 5. Start Development

After completing the steps above, the **smartclientcore** library will be integrated into the project, allowing
development to proceed. The functionality and types provided by the **smartclientcore** library can now be utilized
within the TypeScript project to ensure type safety and efficient development.

<a name="nonbrowser"></a>

### First steps towards working with non browser environments and the smartclientcore

To begin development with non browser environments, ensure that the necessary dependencies are correctly configured.
Follow the steps below to set up and import the required packages.

#### 1.Update the Dependencies

In the project package.json file, modify or extend the dependencies section to include the local version of the
**smartclientcore** package:

```
{
  "dependencies": {
    "smartclientcore": "file:../7.2.0"
  }
}
```

#### 2. Install the Dependencies

Once the package.json is updated, run the following command to install all dependencies, including the
**smartclientcore** package:

```
npm install
```

This command will link all required packages into the project, ensuring that everything is set up for development.

#### 3. Importing the smartclientcore module

With the dependencies installed, it's possible to import the **smartclientcore** module into TypeScript files.

To import the default **smartclientcore** module, use the following line:

```
import smartclientcore from 'smartclientcore/no-omweb';
```

#### 4. Importing Types from smartclientcore

In addition to the **smartclientcore** functionality, specific types from the **smartclientcore** library may also be
needed. TypeScript enables strict typing for better code quality. To import types like AdBreakSetup, use the
following syntax:

```
import { AdBreakSetup } from 'smartclientcore/no-omweb';
```

#### 5. Start Development

After completing the steps above, the **smartclientcore** library will be integrated into the project, allowing
development to proceed. The functionality and types provided by the **smartclientcore** library can now be utilized
within the TypeScript project to ensure type safety and efficient development.
