[> Documentation-Index](index.md) [> Setup Guide](setup.md)

# smartClientCore

## Sequential Config
- [AdBreak](#adbreak)
  - [adBreakPosition](#adbreak+breakposition)
  - [type](#adbreak+type)
  - [tag](#adbreak+tag)
  - [response](#adbreak+response)
  - [limit](#adbreak+limit)
  - [opener](#adbreak+opener)
  - [closer](#adbreak+closer)
  - [divider](#adbreak+divider)
- [EnvironmentVars](#environmentvars)
  - [adContainer](#environmentvars+adcontainer)
  - [desiredBitrate](#environmentvars+desiredbitrate)
  - [desiredMimeTypes](#environmentvars+desiredmimetypes)
  - [desiredVPAIDVendors](#environmentvars+desiredvpaidvendors)
  - [deviceType](#environmentvars+devicetype)
  - [deviceScreenWidth](#environmentvars+devicescreenwidth)
  - [vastMacros](#environmentvars+vastmacros)
  - [networkReachability](#environmentvars+networkreachability)
  - [omidServiceWindow](#environmentvars+omidservicewindow)
  - [prefetchBuffetAds](#environmentvars+prefetchbuffetads)
  - [timeouts](#environmentvars+timeouts)

<a name="adbreak"></a>

### adBreak : <code>AdBreak</code>
Setup for an ad-break that defines the sequence of commercial ads, sponsored ads and separation clips.

Commercial and sponsored ads (variant NORMAL and SPONSORED) are defined by the ad-server VAST manifest.

Separation clips (variant OPENER, CLOSER, DIVIDER) are optional. They can be defined by the publisher. 
Most likely they depend on the upcoming TV show or editorial video.

<a name="adbreak+breakposition"></a>

#### adBreakPosition : <code>number</code>
_Optional_. Defines the position of the ad break within the timeline of the underlying content.
One of the values listed in the table below is expected. If omitted, the position of a linear ad break will be
calculated from the content progress. A non-linear ad break is by default `4` regardless of the content progress.

| Value | Description                                                                                        |
|-------|----------------------------------------------------------------------------------------------------|
| `1`   | for preroll, content currentTime = 0                                                               |
| `2`   | for midroll, content 0 < currentTime < duration                                                    |
| `3`   | for postroll content currentTime = duration                                                        |
| `4`   | for overlay/non-linear and standalone (Outstream), `AdBreak.type = smartclientcore.AD_TYPE.NON_LINEAR` |
| `0`   | for none of the above/other                                                                        |


<a name="adbreak+type"></a>

#### type : <code>string</code>
_Optional_. Specifies the desired linearity of the upcoming ad slot.
Possible values are `smartclientcore.AD_TYPE.LINEAR` (the default if omitted) and `smartclientcore.AD_TYPE.NON_LINEAR`.

<a name="adbreak+tag"></a>

#### tag : <code>[string, [ &#x27;Array&#x27; ].&lt;string&gt;]</code>
_Mandatory <sup>*</sup>_. Defines the ad-request URL(s) that return a VAST manifest. Allowed values are:
 - a single URL, ex. ad fill rate is ensured by the ad-server, a multiple ads ad-break is defined by the ad-server 
 - an Array of URLs, manual setup of an ad break for multiple ads

<a name="adbreak+response"></a>

#### response : <code>string.<XML></code>
_Mandatory <sup>*</sup>_. Defines a VAST manifest directly as a String.

> _<sup>*</sup> One of the **tag** or **response** property is required but both are not supported. 
> If both have been specified, **tag** will get preferred._

```javascript
adPlugin.initAdSlot(
	{
		tag: 'https://adserver.com/tag-pre?type=vast3xml'
	}
);
// or...
adPlugin.initAdSlot(
	{
		response: `<VAST version="4.0">
                   	<Ad id="example-inline-tag">
                   		<InLine>
                   			<!-- example code -->
                   		</InLine>
                   	</Ad>
                   </VAST>`
	}
);
```

<a name="adbreak+opener"></a>

#### opener : <code>Object</code>
_Optional_. Applies to NORMAL and SPONSORED ads.
Intro video for the upcoming ad break, played before all other ads.

- **progressive : <code>string</code>** - _Mandatory_. A video url used for progressive download.
 
- **forcePlay : <code>Boolean</code>** - _Optional_. Defines whether the separation clip must be delivered with ads or always. Defaulting to `false`.

Other source properties are currently not supported nor required by the smartclientcore. 
Future versions of the smartclientcore may include streaming resources.

<a name="adbreak+closer"></a>

#### closer : <code>Object</code>
_Optional_. Applies to NORMAL and SPONSORED ads.
Outro video, played after all other ads.

- **progressive : <code>string</code>** - _Mandatory_. A video url used for progressive download.

- **forcePlay : <code>Boolean</code>** - _Optional_. Defines whether the separation clip must be delivered with ads or always. Defaulting to `false`.

Other source properties are neither supported nor required by the smartclientcore.

<a name="adbreak+divider"></a>

#### divider : <code>Object</code>
_Optional_. Applies to NORMAL and SPONSORED ads.
Special intro video, played once when switching from commercial to sponsored ads or vice versa.
Not served if the ad-server response contains no ads of variant NORMAL or SPONSORED.

- **progressive : <code>string</code>** - _Mandatory_. A video url used for progressive download.

- **forcePlay : <code>Boolean</code>** - _Optional_. Defines whether the separation clip must be delivered with ads or always. Defaulting to `false`.

Other source properties are neither supported nor required by the smartclientcore.

```javascript
adPlugin.initAdSlot(
	{
		tag: 'https://adserver.com/tag-pre?type=vast3xml',
		opener: {
			progressive: 'https://yourpage.com/assets/opener-pre.mp4'
		},
		closer: {
			progressive: 'https://yourpage.com/assets/closer-pre.mp4'
		},
        divider: {
			progressive: 'https://yourpage.com/assets/divider-pre.mp4'
		}
	}
);
```

Example setup to play a static "Station Divider"
```javascript
adPlugin.initAdSlot(
	{
		opener: {
			progressive: 'https://yourpage.com/assets/station-divider.mp4',
			forcePlay: true
		}
	}
);
```

<a name="environmentvars"></a>

### environmentVars : <code>EnvironmentVars</code>

Used for passing implementation-specific runtime variables.

<a name="environmentvars+adcontainer"></a>

**adContainer : <code>HTMLElement</code>** - _Recommended with `AdBreak.type = smartclientcore.AD_TYPE.NON_LINEAR`_ 
The DOM element that can be used to deliver non-video creative files. The size and position should be aligned 
with the video player and should not prevent the user from interacting with the video playback controls.

If omitted, the plugin tries to add a blank DIV element in front of the video element as a fallback.

<a name="environmentvars+desiredbitrate"></a>

**desiredBitrate : <code>number</code>** - _Optional_. Indicates the desired bitrate in kilobits per second (kbps). 
The player uses this information to select media files with an appropriate bitrate. Defaulting to `1000`. 

If no media of the desiredBitrate is available, the next file of smaller bitrate will be selected.
If no media of smaller bitrate is available, the next file of higher bitrate will be selected.

<a name="environmentvars+desiredmimetypes"></a>

**desiredMimeTypes : <code>[ &#x27;Array&#x27; ].&lt;string&gt;</code>** - _Optional_. Declaration of accepted media types (whitelist). 
Defaulting to types that the browser eventually is able to play if not set. Types must be compliant with the [IANA 
Media Type standard]  
**_Note_**_: If set, this will override the plugin-internal media types._

<a name="environmentvars+desiredvpaidvendors"></a>

**desiredVPAIDVendors : <code>[ &#x27;Array&#x27; ].&lt;string&gt;</code>** - _Optional_. Declaration of accepted VPAID vendors (whitelist).
Each specified String has to represent an unique identifier that can be found within the creative media file URL, most likely the domain name.
If omitted, the plugin tries to deliver VPAID creatives from each vendor.  

<a name="environmentvars+devicetype"></a>

**deviceType : <code>string</code>** - _Optional_. Can be either `mobile`, `tablet`, `desktop` or `tv`. Defaulting to `null`.

<a name="environmentvars+devicescreenwidth"></a>

**deviceScreenSize : <code>Object</code>** - _Optional_. Maximum size we can achieve when entering fullscreen.
- **width : <code>number</code>** - Screen width in pixel.
- **height : <code>number</code>** - Screen height in pixel.

<a name="environmentvars+vastmacros"></a>

**vastMacros : <code>Object</code>** - _Recommended_. A list of VAST macros to provide details about how and where the upcoming ad-break is shown.
Macro names must be compliant with the [VAST 4.x Macros], though custom macro names (like future VAST macros too) are working already.

Example to provide additional data about the current environment
```javascript
adPlugin.initAdSlot(
	{
		tag: 'https://exampl.com?mph=[MEDIAPLAYHEAD]&bp=[BREAKPOSITION]&ref=[PAGEURL]&cb=[CACHEBUSTER]&foo=[CUSTOMMACRO]'
	},{
 		vastMacros: {
			'MEDIAPLAYHEAD': '00:05:21.123',
			'BREAKPOSITION': 2,
			'PAGEURL': 'https://www.mydomain.com/article/page',
			'CUSTOMMACRO': 'bar'
		}
 	}
);

// Results in the following URL request
// https://exampl.com?mph=00%3A05%3A21.123&bp=2&ref=https%3A%2F%2Fwww.mydomain.com%2Farticle%2Fpage&cb=1234567890&foo=bar
```

<a name="environmentvars+networkreachability"></a>

**networkReachability : <code>string</code>** - _Optional_. Can be either `wwan`, `wifi` or `unreachable`. Defaulting to `null`.

<a name="environmentvars+omidservicewindow"></a>

**omidServiceWindow : <code>Window</code>** - _Optional_. The DOM context into which the OM SDK Service Script was loaded.
The value becomes forwarded to the OM SDK Context `setServiceWindow` method as described in the [OM SDK for Web Video]
documentation. Defaulting to `window.top` if omitted.

Example: The video player is embedded into an `<iframe>` but the OM SDK Service Script is located in the parent window.
```javascript
adPlugin.initAdSlot(
	{
		// adBreak
	},{
 		omidServiceWindow: window.frameElement
 	}
 );
```

> _The OM SDK Service Script location can also be made known once by setting 
[Config.adVerification > serviceWindow](setup-config.md#adverification)_

<a name="environmentvars+prefetchbuffetads"></a>

**prefetchBuffetAds : <code>boolean</code>** - _Optional_. In order to replace invalid ads in a pod of ads instantly at runtime,
buffet ads from wrapper responses must be loaded up-front. `prefetchBuffetAds` determines whether stand-alone ads (buffet) from 
wrapper tags will be loaded together with the pod of ads or not. Defaulting to `false` if omitted.

<a name="environmentvars+timeouts"></a>

**timeouts : <code>Object</code>** - _Optional_. Definition of `timeouts` that replace global settings for the upcoming ad-break.
Take a look at section [Config timeouts](setup-config.md#timeouts) for relevant information.

Example with `desiredBitrate`. Other variables will be ignored.
```javascript
adPlugin.initAdSlot(
	{
		// adBreak
	},{
 		desiredBitrate: 1000,
 		deviceScreenSize: {
 			width: 1024,
 			height: 768
 		}
 	}
 );
```

Example with `deviceType` and `networkReachability`, utilized to calculate an appropriat bitrate.
```javascript
adPlugin.initAdSlot(
	{
		// adBreak
	},{
		deviceType: 'tablet',
		deviceScreenSize: {
			width: 1024,
			height: 768
		},
		networkReachability: 'wifi'
 	}
 );
```

[IANA Media Type standard]: https://www.iana.org/assignments/media-types/media-types.xhtml
[VAST 4.x Macros]: https://interactiveadvertisingbureau.github.io/vast/vast4macros/vast4-macros-latest.html
[OM SDK for Web Video]: https://interactiveadvertisingbureau.github.io/Open-Measurement-SDKJS/#3-create-the-context
