Object.entries || (Object.entries = function(e) {
  var i = [];
  for (k in e)
    typeof k == "string" && e.propertyIsEnumerable(k) && i.push([k, e[k]]);
  return i;
});
(function() {
  if (typeof navigator != "undefined" && navigator.userAgent) {
    var c = function(r, s) {
      s = s || {
        bubbles: !1,
        cancelable: !1,
        detail: void 0
      };
      var l = document.createEvent("CustomEvent");
      return l.initCustomEvent(r, s.bubbles, s.cancelable, s.detail), l;
    }, e = navigator.userAgent.match(/(opera|chrome|safari|firefox|msie|trident(?=\/))\/?\s*(\d+)/i) || [];
    /trident|msie/i.test(e[1]) && (c.prototype = window.Event.prototype, window.CustomEvent = c, window.Event = c);
  }
})();
(function(c) {
  c && c.prototype && c.prototype.firstElementChild === void 0 && Object.defineProperty(c.prototype, "firstElementChild", {
    get: function() {
      for (var i, r = this.childNodes, s = 0; i = r[s++]; )
        if (i.nodeType === 1)
          return i;
      return null;
    }
  });
})(typeof window != "undefined" ? window.Node || window.Element : null);
var lt = /* @__PURE__ */ ((c) => (c[c.SILENT = 0] = "SILENT", c[c.ERROR = 1] = "ERROR", c[c.NORMAL = 2] = "NORMAL", c[c.VERBOSE = 3] = "VERBOSE", c))(lt || {}), _e = /* @__PURE__ */ ((c) => (c[c.CRITICAL = 0] = "CRITICAL", c[c.ERROR = 1] = "ERROR", c[c.INFO = 2] = "INFO", c[c.TABLE = 3] = "TABLE", c[c.WARN = 4] = "WARN", c))(_e || {});
let Mt = lt.SILENT;
const wi = "[OIS_DEBUG]", ao = {
  [lt.ERROR]: [_e.CRITICAL, _e.ERROR],
  [lt.NORMAL]: [_e.INFO, _e.TABLE, _e.WARN],
  [lt.SILENT]: [],
  [lt.VERBOSE]: [_e.CRITICAL, _e.ERROR, _e.INFO, _e.TABLE, _e.WARN]
};
function ni() {
}
class p {
  /**
   * Sets the logging level for debug outputs.
   * @param {LOGLEVEL} level - The logging level, one of
   *  `LOGLEVEL.SILENT`, `LOGLEVEL.ERROR`, `LOGLEVEL.NORMAL`, or `LOGLEVEL.VERBOSE`.
   */
  static set logLevel(e) {
    Mt = e;
  }
  /**
   * Gets the current logging level.
   * @returns {number} - The current logging level.
   */
  static get logLevel() {
    return Mt;
  }
  static shouldLog(e, i) {
    return i !== lt.SILENT && ao[i].includes(e);
  }
  /**
   * Provides methods for logging debug outputs.
   */
  static get debug() {
    return {
      critical: (this.shouldLog(_e.CRITICAL, Mt) ? console.error : ni).bind(console, wi),
      info: (this.shouldLog(_e.INFO, Mt) ? console.info : ni).bind(console, wi),
      error: (this.shouldLog(_e.ERROR, Mt) ? console.error : ni).bind(console, wi),
      table: (this.shouldLog(_e.TABLE, Mt) ? console.table : ni).bind(console),
      warn: (this.shouldLog(_e.WARN, Mt) ? console.warn : ni).bind(console, wi)
    };
  }
}
const lo = "4.0";
class uo {
  constructor() {
    this.currentContentSource = {
      // eslint-disable-next-line no-undefined
      currentTime: void 0,
      // eslint-disable-next-line no-undefined
      progressive: void 0
    }, this.PLAYER_EVENT_MAP = {};
  }
  /**
   * Sets up a function that will be called whenever the specified event is delivered to the video player.
   * @param {string} type - A case-sensitive string representing the player event type to listen for.
   * @param {Function} callback - The function which receives a notification when an event of the specified type occurs.
   *
   * _*Note:*
   *
   * The PLAYER_EVENT_MAP should be defined within the Facade (constructor) to allow mapping and usage of equivalent
   * events for non-HTML5 video players. The key represents the event from the custom player, while the value
   * corresponds to the standard HTML5 event. It must also be set for HTML5 players as this is no longer part of the
   * FacadeBase!
   */
  addEventListener(e, i) {
  }
  /**
   * Requests the ad playhead position from the video player.
   * @returns {Number} Total time in seconds.
   */
  // @ts-ignore: method return implemented over playerReference
  getAdCurrentTime() {
  }
  /**
   * Requests the ad-duration from the video player.
   * @returns {Number} Total time in seconds. _*Note:* The time can include milliseconds (3.1234)
   */
  // @ts-ignore: method return implemented over playerReference
  getAdDuration() {
  }
  /**
   * Requests the current playhead position from the video player.
   * @returns {Number} Current time in seconds. _*Note:* The time can include milliseconds (3.1234)
   */
  // @ts-ignore: method return implemented over playerReference
  getContentCurrentTime() {
  }
  /**
   * Requests the content-duration from the video player.
   * @returns {Number} Total time in seconds. _*Note:* The time can include milliseconds (3.1234)
   */
  // @ts-ignore: method return implemented over playerReference
  getContentDuration() {
  }
  /**
   * @returns {CurrentContentSource} SourceObject - Current content source and playhead progress
   */
  // @ts-ignore: method return implemented over playerReference
  getCurrentContentSource() {
  }
  /**
   * Requests the latest status of the video player, site, and other external factors.
   * @param {string} adBreakType - Linearity of the upcoming ad slot. See [`AdBreak.type`](setup-sequential-config#adbreak+type)
   * @returns {EnvironmentVars} Object describing surrounding conditions and the expected ad properties.
   */
  // @ts-ignore: method return implemented over playerReference
  getEnvironmentVars(e) {
  }
  /**
   * Requests the player element.
   * @returns {HTMLAudioElement|HTMLVideoElement|null} The video or audio element or null.
   *
   * _*Note:* If the player takes care of the OM-SDK, config.adVerification.playerHandles = true ._
   */
  // @ts-ignore: method return implemented over playerReference
  getPlayerElement() {
  }
  /**
   * Requests the current size and viewMode from the video player.
   * @returns {ElementSize} Current player dimension specs
   */
  // @ts-ignore: method return implemented over playerReference
  getPlayerSize() {
  }
  /**
   * Requests the current size and viewMode from the viewport that surrounds the video player.
   * @returns {ElementSize} The dimension specs of the element
   */
  // @ts-ignore: method return implemented over playerReference
  getViewportSize() {
  }
  /**
   * Requests the current volume level from the video player.
   * @returns {Number} The current volume level between 0-1
   */
  // @ts-ignore: method return implemented over playerReference
  getVolume() {
  }
  /**
   * Requests the player facade version (API version) to ensure the particular versions of `smartclientcore` and player facade
   * are supported.
   * @param {string} apiFacadeVersion - Required API version
   * @returns {string} Supported API version
   */
  handshakeVersion(e) {
    return lo;
  }
  /**
   * Requests the video player to mute playback.
   * @returns {Promise} Resolves if the video player has been muted
   */
  // @ts-ignore: method return implemented over playerReference
  mute() {
  }
  /**
   * Requests the video player to unmute playback.
   * @returns {Promise} Resolves if the video player has been unmuted
   */
  // @ts-ignore: method return implemented over playerReference
  unmute() {
  }
  /**
   * Requests the current screen state from the video player.
   * @returns {Boolean} Fullscreen state
   */
  // @ts-ignore: method return implemented over playerReference
  isFullscreen() {
  }
  /**
   * Requests the current muted state from the video player.
   * @returns {Boolean} Muted state
   */
  // @ts-ignore: method return implemented over playerReference
  isMuted() {
  }
  /**
   * Requests the current pause state from the video player.
   * @returns {Boolean} Paused state
   */
  // @ts-ignore: method return implemented over playerReference
  isPaused() {
  }
  /**
   * Requests the video player to load and play the specified media file.
   * @param {string} url - The URI of the media file to be played.
   * @param {Boolean} autoPlay - Whether the requested media file starts playback immediately.
   * @param {Boolean} disableSeeking - Whether the requested source can be seeked back and forth.
   * @returns {Promise<void|number>} That resolves if the player accepts the media file request. If an error occurs, the
   *  Promise may reject with an optional error code.
   */
  // @ts-ignore: method return implemented over playerReference
  load(e, i = !0, r = !1) {
  }
  /**
   * Requests the video player to pause playback.
   * @returns {Promise} Resolves if the video player has been paused
   */
  // @ts-ignore: method return implemented over playerReference
  pause() {
  }
  /**
   * Requests the video player to start (resume) playback.
   * @returns {Promise} Resolves if the video player has been resumed
   */
  // @ts-ignore: method return implemented over playerReference
  play() {
  }
  /**
   * Removes an event listener from the video player that has been registered with `addEventListener()`
   * _*Note:* The event listener to be removed must match with the listener that has been added._
   * @param {string} type - A case-sensitive string representing the player event type to listen for.
   * @param {Function} callback - The function which receives a notification when an event of the specified type occurs.
   */
  removeEventListener(e, i) {
  }
  /**
   * restoreContentState is called right after the ad playback has finished.
   * Resumes playback by restoring the last known playback state and communicates with the AdSlotAPI upon completion.
   *
   * _*Note:* Check whether the content was really replaced by an ad. Otherwise, there should be nothing to do.
   * @returns {Promise} Resolves if the player accepts the play request; otherwise, rejects.
   */
  // @ts-ignore: method return implemented over playerReference
  restoreContentState() {
  }
  /**
   * saveContentState is called right before the ad playback should begin. Notes the current playback state for
   *  later use with `restoreContentState()` and communicates with the AdSlotAPI  upon completion.
   *
   * _*Note:* Promise.resolve() without the source and the current time of the content will not work.
   * @returns {Promise} Resolves with the current content source and playhead progress for VAST tracking enrichment.
   */
  // @ts-ignore: method return implemented over playerReference
  saveContentState() {
  }
  /**
   * Requests the video player to change the playhead position to the specified time.
   * @param {Number} offset - Requested playhead position
   * @returns {Promise} Resolves if the video player has finished seeking to the specified position
   */
  // @ts-ignore: method return implemented over playerReference
  seek(e) {
  }
  /**
   * Requests the video player to change the volume.
   * @param {Number} volume - Requested volume level between 0-1
   * @returns {Promise} Resolves if the video player accepted the volume change request
   */
  // @ts-ignore: method return implemented over playerReference
  setVolume(e) {
  }
}
var he = /* @__PURE__ */ ((c) => (c.LINEAR = "linear", c.NON_LINEAR = "nonlinear", c))(he || {});
function Vn(c, e = "") {
  return (Array.isArray(c) ? c : [c]).map((r) => e ? `${r} ${e}` : r).join(",");
}
class Qt {
  static cTSTS(e) {
    const i = (/* @__PURE__ */ new Date(`1970-01-01T${e}Z`)).getTime();
    return isNaN(i) ? null : i / 1e3;
  }
  static gMNE(e, i) {
    let r = -1, s = null;
    for (const l of te(e, i)) {
      let h = 0, m = l;
      for (; m.parentNode !== e; )
        h++, m = m.parentNode;
      h > r && (r = h, s = l);
    }
    return s;
  }
  static gU(e, i) {
    const r = e.map((l) => l[i]);
    return e.filter((l, h) => !r.includes(l[i], h + 1));
  }
  static t(e) {
    return e && e.trim().length !== 0 && e !== "null" ? e.trim() : null;
  }
  static f(e, i, r = "") {
    return e.querySelector(Vn(i, r));
  }
  static fA(e, i, r = "") {
    return e.querySelectorAll(Vn(i, r));
  }
}
const Tt = Qt.cTSTS, q = Qt.f, te = Qt.fA, ho = Qt.gU, ct = Qt.gMNE, ge = Qt.t;
class co {
  constructor(e) {
    this.adSourceXML = e, this.adSource = q(this.adSourceXML, "AdTagURI, VASTAdData, VASTData, CustomAdData");
  }
  get allowMultipleAds() {
    return this.adSourceXML.getAttribute("allowMultipleAds") === "true";
  }
  get followRedirects() {
    return this.adSourceXML.getAttribute("followRedirects") === "true";
  }
  get id() {
    return this.adSourceXML.getAttribute("id");
  }
  /**
   * @returns {*} An adTagURI or otherwise XML representing a VAST response or any custom XML
   */
  get source() {
    return this.adSource.nodeName.includes("AdTagURI") ? ge(this.adSource.textContent) : this.adSource.firstElementChild ? this.adSource.firstElementChild.outerHTML : ge(this.adSource.textContent);
  }
  get templateType() {
    return this.adSource.getAttribute("templateType");
  }
  // lowerCase for kepler and web
  get type() {
    return this.adSource.nodeName.toLowerCase();
  }
}
const wt = class wt {
  constructor(e, i = {}) {
    this.isRequested = !1, this.adBreakXML = e, this.publisherSpecs = i, this.hasBreakPosition = this.getBreakPosition(), this.extensionList = this.getExtensions(), this.multiMidroll = !1, this.separationClipsObj = this.getSeparationClips(), this.trackerList = this.getTrackers(), this.error = this.getError() || {
      // Use undefined since isNaN(null) in hasError would return true
      code: void 0,
      // eslint-disable-line no-undefined
      message: "",
      timestamp: null
    };
  }
  mapStringToAdType(e) {
    switch (e) {
      // Not supported for InStream
      // case 'display':
      // 	return AD_TYPE.DISPLAY;
      case "nonlinear":
        return he.NON_LINEAR;
      default:
        return he.LINEAR;
    }
  }
  queryElements(e) {
    return te(this.adBreakXML, e);
  }
  /**
   * @returns {AdSource} - Object representing the data or an URL to request the data or `null`
   */
  get adSource() {
    const e = q(this.adBreakXML, ":scope > AdSource");
    return e ? new co(e) : null;
  }
  /**
   * Optional attribute
   * @returns {string} the identifier for the AdBreak or an empty string
   */
  get breakId() {
    return this.adBreakXML.getAttribute("breakId") || null;
  }
  /**
   * Indicates the position of the ad break within the underlying video/audio content
   * that the ad is playing within.
   * @returns {number} the position
   */
  get breakPosition() {
    return this.hasBreakPosition;
  }
  get breakType() {
    var e;
    return (e = this.adBreakXML.getAttribute("breakType")) != null ? e : "";
  }
  get extensions() {
    return this.extensionList;
  }
  /**
   * Simple getter to check whether the adBreak can be delivered or not.
   * @returns {boolean} true if the adBreak is corrupted
   */
  get hasError() {
    return !isNaN(this.error.code);
  }
  get prefetchOffset() {
    return this.publisherSpecs[wt.POSITION[this.breakPosition]] && this.publisherSpecs[wt.POSITION[this.breakPosition]].prefetchOffset ? Math.abs(this.publisherSpecs[wt.POSITION[this.breakPosition]].prefetchOffset) : 0;
  }
  /**
   * @returns {Number} Time in seconds after the AdBreak should be repeated
   */
  get repeatAfter() {
    const e = Tt(
      this.adBreakXML.getAttribute("repeatAfter") || null
    ) || -1;
    return e !== -1 ? e : -1;
  }
  get requested() {
    return this.isRequested;
  }
  set requested(e) {
    this.isRequested = e;
  }
  get separationClips() {
    return this.separationClipsObj;
  }
  get timeOffset() {
    const e = this.adBreakXML.getAttribute("timeOffset");
    return e === "0%" ? "start" : e === "100%" ? "end" : e;
  }
  get trackingEvents() {
    return this.trackerList;
  }
  /**
   * AdBreak type property used by the core.
   * Note: We do not support mixed types as suggested by the VMAP standard (see VMAP 1.0.1 Chapter 2.4)
   * `
   * @returns {string} AdBreak type
   */
  get type() {
    const e = this.breakType.split(",")[0];
    return this.mapStringToAdType(e);
  }
  getBreakPosition() {
    return this.type === he.NON_LINEAR ? 4 : this.timeOffset === "start" || this.timeOffset === "0%" || Tt(this.timeOffset) === 0 ? 1 : this.timeOffset === "end" || this.timeOffset === "100%" ? 3 : 2;
  }
  getExtensions() {
    const e = this.queryElements(":scope > Extensions > Extension"), i = [];
    for (const r of e)
      i.push({
        extensionXML: r,
        type: r.getAttribute("type") || ""
      });
    return i;
  }
  getTrackers() {
    const e = this.queryElements(":scope > TrackingEvents > Tracking");
    let i = {};
    for (const r of e) {
      const s = r.getAttribute("event"), l = r.textContent.trim();
      l && (i[s] = i[s] || [], i[s].push({ url: l }));
    }
    return i;
  }
  getSeparationClips() {
    return this.publisherSpecs[wt.POSITION[this.breakPosition]] || {};
  }
  getError() {
    const e = q(this.adBreakXML, "ParserError");
    return e ? {
      code: parseInt(e.getAttribute("code"), 10),
      message: e.getAttribute("message"),
      timestamp: null
    } : null;
  }
};
wt.POSITION = [
  "unsupported",
  "preroll",
  "midroll",
  "postroll",
  "overlay"
];
let ui = wt;
class po {
  constructor(e, i) {
    this.adSlotList = [], this.midrollHasSameTimeOffset = !1, this.createAdSlotList(e, i);
  }
  createAdSlotList(e, i) {
    let r = e.documentElement || e, s = te(r, ":scope > *");
    const l = [];
    for (const z of s)
      l.push(new ui(z, i));
    this.adSlotList = l;
    let h = {}, m = [];
    const g = "Ad", y = "AdTagURI", L = "adtaguri", ie = "allowMultipleAds", ee = "sequence", Oe = "type", Q = "VAST";
    for (let z = 0; z < s.length; z++) {
      let S = l[z];
      S.breakPosition === 2 && S.timeOffset !== null && (h[S.timeOffset] = (h[S.timeOffset] || 0) + 1, h[S.timeOffset] > 1 && (S.multiMidroll = !0, m.length === 0 && (this.adSlotList[z - 1].multiMidroll = !0, this.adSlotList[z - 1].adBreakXML.setAttribute(
        Oe,
        this.adSlotList[z - 1].adSource.type
      ), this.adSlotList[z - 1].adBreakXML.setAttributeNS(
        null,
        ie,
        this.adSlotList[z].adSource.allowMultipleAds.toString()
      ), m.push(this.adSlotList[z - 1].adBreakXML.cloneNode(!0)), this.midrollHasSameTimeOffset = !0), this.adSlotList[z].multiMidroll = !0, S.adBreakXML.setAttribute(Oe, this.adSlotList[z].adSource.type), S.adBreakXML.setAttributeNS(
        null,
        ie,
        this.adSlotList[z].adSource.allowMultipleAds.toString()
      ), m.push(S.adBreakXML.cloneNode(!0))));
    }
    if (this.midrollHasSameTimeOffset) {
      let z = [];
      for (let I = 0; I < m.length; I++)
        if (m[I].getAttribute(Oe).includes(L)) {
          let x = document.createElementNS(null, g);
          x.setAttribute(ee, (I + 1).toString());
          let Y = document.createElementNS(null, "Wrapper");
          Y.setAttributeNS(
            null,
            "fallbackOnNoAd",
            m[I].getAttribute(ie)
          );
          let W = document.createElementNS(null, Q + y);
          W.textContent = q(m[I], y).textContent.trim(), Y.appendChild(W), x.appendChild(Y), z.push(x);
        } else
          q(m[I], g).setAttribute(ee, (I + 1).toString()), z.push(q(m[I], g));
      let S = null;
      for (let I = 0; I < this.adSlotList.length; I++) {
        if (!this.adSlotList[I].multiMidroll)
          continue;
        if (this.adSlotList[I].adBreakXML.hasAttribute(Oe) && this.adSlotList[I].adBreakXML.getAttribute(Oe).includes(L) && (S = document.createElementNS(null, Q + "AdData")), q(this.adSlotList[I].adBreakXML, "Ad") || S) {
          if (S) {
            q(this.adSlotList[I].adBreakXML, "AdTagURI").remove();
            let Y = q(this.adSlotList[I].adBreakXML, "AdSource");
            const W = document.createElementNS(null, "VAST");
            for (const J of z)
              W.appendChild(J);
            S.appendChild(W), Y.appendChild(S);
          } else {
            q(this.adSlotList[I].adBreakXML, "Ad").remove();
            const Y = q(this.adSlotList[I].adBreakXML, "VAST");
            for (const W of z)
              Y.appendChild(W);
          }
          this.adSlotList[I].multiMidroll = !1, this.adSlotList[I] = new ui(this.adSlotList[I].adBreakXML, this.adSlotList[I].publisherSpecs);
          break;
        }
      }
      this.adSlotList = this.adSlotList.filter((I) => {
        if (!I.multiMidroll)
          return I;
      });
    }
  }
  getAdPlaylist() {
    return this.adSlotList;
  }
  get hasPlayableAdBreaks() {
    return !!this.adSlotList.filter((i) => !i.hasError && i.adSource).shift();
  }
}
class Rt {
  constructor() {
    this.listeners = {};
  }
  /**
   * Adds an event listener for the given type.
   * @param {string} type - The type of the event to listen for.
   * @param {Function} listener - The function to call when the event is dispatched.
   * @returns {Function} A function that can be called to remove the listener.
   */
  addEventListener(e, i) {
    const r = this.listeners[e] || (this.listeners[e] = []);
    return r.includes(i) || r.push(i), () => {
      this.removeEventListener(e, i);
    };
  }
  /**
   * Dispatches an event of the given type with the given data.
   * @param {string} type - The type of the event to dispatch.
   */
  dispatchEvent(e) {
    const i = this.listeners[e];
    if (!i)
      return;
    const r = {
      type: e,
      timestamp: Date.now(),
      issuer: "smartclip"
    };
    for (let s = 0; s < i.length; s++)
      i[s].call(this, r);
  }
  /**
   * Checks whether an event listener has been added for the given type and listener function.
   * @param {string} type - The type of the event to check for the listener.
   * @param {Function} listener - The listener function to check for.
   * @returns {boolean} True if the listener has been added for the given type, false otherwise.
   */
  hasEventListener(e, i) {
    const r = this.listeners[e];
    return r && r.indexOf(i) !== -1;
  }
  /**
   * Removes an event listener for the given type.
   * @param {string} type - The type of the event to remove the listener for.
   * @param {Function} listener - The listener function to remove.
   */
  removeEventListener(e, i) {
    const r = this.listeners[e];
    if (r) {
      const s = r.indexOf(i);
      s !== -1 && r.splice(s, 1);
    }
  }
}
const w = {
  // == IAB Errors with Creative
  CREATIVE: {
    // The video player received an ad type that it was not expecting and/or cannot display.
    EXPECTED_DIFFERENT_ADTYPE: {
      code: 200,
      message: "Trafficking error. Video player received an ad type that it was not expecting and/or cannot display"
    },
    EXPECTED_DIFFERENT_LINEARITY: {
      code: 201,
      message: "Video player expecting different linearity"
    }
  },
  // == smartclip Errors with the current ad-break session
  SESSION: {
    AD_REINSERTION_DECLINED: {
      code: 200200,
      message: "AdReinsertion usage declined by the vendor"
    },
    // Invalid AdBreak definition.
    MANIFEST_SETUP_CORRUPT: {
      code: 200201,
      message: "Invalid AdBreak definition"
    },
    // An ad-break has already been started. Shut down the current ad-break by calling `stopAdSlot`.
    ALREADY_STARTED: {
      code: 200202,
      message: "An ad-break has already been started"
    },
    // Unknown Manifest Loading Error.
    MANIFEST_LOAD_FAILED: {
      code: 200203,
      message: "Unknown Manifest Loading Error"
    },
    // The manifest couldn't be loaded in time.
    TIMEOUT: {
      code: 200204,
      message: "The manifest couldn't be loaded in time"
    },
    MIXED_CONTENT: {
      code: 200205,
      message: "Mixed Content = The request has been blocked and must be served over HTTPS"
    },
    // Restoring the content after an ad-break failed.
    NOT_RESTORABLE: {
      code: 200206,
      message: "Restoring the content after an ad-break failed"
    },
    // AdReinsertion timeout - not included for the moment!
    AD_REINSERTION_TIMEOUT: {
      code: 200207,
      message: "AdReinsertion failed at runtime"
    },
    // AdReinsertion failed at runtime
    AD_REINSERTION_PENALTY: {
      code: 200208,
      message: "AdReinsertion failed at runtime"
    }
  },
  // == smartclip Errors with the setup initialization
  SETUP: {
    NO_FACADE: {
      code: 200100,
      message: "No facade was handed over"
    },
    INCORRECT_FACADE: {
      code: 200101,
      message: "The facade implementation is incorrect"
    },
    INVALID_HANDSHAKE: {
      code: 200102,
      message: "Handshake validation failed"
    },
    AD_REINSERTION_PENALTY: {
      code: 200103,
      message: "AdReinsertion initialization failed"
    }
  },
  // == IAB Errors with SIMID creative
  SIMID: {
    GENERAL_ERROR: {
      code: 902,
      message: "General InteractiveCreativeFile error code"
    }
  },
  // == IAB Errors with linear VAST tag
  VAST: {
    GENERAL_ERROR: {
      code: 400,
      message: "General Linear error. Video player is unable to display the Linear Ad"
    },
    FILE_NOT_FOUND: {
      code: 401,
      message: "File not found. Unable to find Linear/MediaFile from URI"
    },
    TIMEOUT: {
      code: 402,
      message: "Timeout of MediaFile URI"
    },
    UNSUPPORTED_MIMETYPE: {
      code: 403,
      message: "Couldn't find MediaFile that is supported by this video player based on the attributes of the MediaFile element"
    },
    MEDIAFILE_DISPLAY_ERROR: {
      code: 405,
      message: "Problem displaying MediaFile"
    }
  },
  // == IAB Errors with non-linear VAST tag
  VAST_NONLINEAR: {
    GENERAL_ERROR: {
      code: 500,
      message: "General NonLinearAds error"
    },
    DISPLAY_ERROR: {
      code: 501,
      message: "Unable to display NonLinear Ad because creative dimensions do not align with creative display area (i.e., creative dimension too large)"
    },
    FILE_NOT_FOUND: {
      code: 502,
      message: "Unable to fetch NonLinearAds/NonLinear resource"
    },
    UNSUPPORTED_MIMETYPE: {
      code: 503,
      message: "Could not find NonLinearresource with supported type."
    },
    // == custom descriptions
    TIMEOUT: {
      // FILE_NOT_FOUND in time
      code: 502,
      message: "Timeout of Resource URI"
    }
  },
  /**
   * Please group error codes by type, and provide a short text as comment above the code
   *
   * Overview of error codes:
   * - https://wiki.iabtechlab.com/?title=VAST_Error_Code_Troubleshooting_Matrix
   * - https://support.google.com/dfp_premium/answer/4442429
   * - https://www.jwplayer.com/blog/vast-errors/ (grouped)
   */
  VMAP: {
    UNDEFINED: {
      code: 900,
      message: "Undefined error"
    },
    INVALID_SCHEMA: {
      code: 1e3,
      message: "VMAP schema validation error"
    },
    UNSUPPORTED_RESPONSE: {
      code: 1001,
      message: "Version of response not supported"
    },
    PARSE_ERROR: {
      code: 1002,
      message: "Parsing error"
    },
    UNSUPPORTED_TYPE: {
      code: 1003,
      message: "AdBreak type not supported"
    },
    DOCUMENT_ERROR: {
      code: 1004,
      message: "General ad response document error"
    },
    UNSUPPORTED_TEMPLATE: {
      code: 1005,
      message: "Ad response template type not supported"
    },
    EXTRACTION_ERROR: {
      code: 1006,
      message: "Ad response document extraction or parsing error"
    },
    TIMEOUT: {
      code: 1007,
      message: "Ad response document retrieval timeout"
    },
    RESPONSE: {
      code: 1008,
      message: "Ad response document retrieval error (e.g., HTTP server)"
    },
    /* Non-standard codes (also used by the IMA) */
    NO_ADBREAKS: {
      code: 200300,
      message: "The response does not contain any valid ads"
    }
  },
  // == IAB Errors with linear VPAID creative
  // General VPAID error. Creative doesn't initialize.
  VPAID: {
    GENERAL_ERROR: {
      code: 901,
      message: "General VPAID error"
    }
  },
  // == smartclip Warnings with the current ad-break session
  WARNING: {
    // Unknown Tracker Loading Error
    TRACKER_LOAD_FAILED: {
      code: 200400,
      message: "Unknown tracker loading error"
    },
    // The tracker couldn't be loaded in time.
    TRACKER_TIMEOUT: {
      code: 200401,
      message: "The tracker couldn't be loaded in time"
    }
  },
  // == IAB Errors with Wrapper
  WRAPPER: {
    // Same error code as TIMEOUT, but related to the whole request chain for a single branch of Wrappers
    CHAIN_TIMEOUT: {
      code: 301,
      message: "Wrapper chain timeout reached"
    },
    // Timeout of VAST URI provided in Wrapper element, or of VAST URI provided in a subsequent Wrapper element
    TIMEOUT: {
      code: 301,
      message: "Timeout of VAST URI provided in Wrapper element, or of VAST URI provided in a subsequent Wrapper element. Includes request errors such as invalid URI, unreachable or request timeout for URI, and security or other exceptions related to requesting a VAST URI"
    },
    // Wrapper limit reached, as defined by the video player
    LIMIT_REACHED: {
      code: 302,
      message: "Wrapper limit reached, as defined by the video player. Too many Wrapper responses have been received with no InLine response"
    },
    // No Ads VAST response after one or more Wrappers. When working with third-party networks,
    //  the fill-rate can be less than 100%. If so, this is an expected error
    NO_RESPONSE: {
      code: 303,
      message: "No ads VAST response after one or more Wrappers. Also includes number of empty VAST responses from fallback"
    }
  },
  // == IAB Errors with the Tag
  XML: {
    INVALID_XML: {
      code: 100,
      message: "XML parsing error"
    },
    INVALID_SCHEMA: {
      code: 101,
      message: "VAST schema validation error"
    }
  }
};
let hr = null, cr = null, qt = 0, kn = null, pr = null;
const Ge = class Ge {
  constructor(e, i) {
    this.enrichment = i, this.reasonData = null, e && e.homad && (kn = e), this.enrichment.set("BLOCKED", qt, "blocked");
  }
  get isActive() {
    return qt === 1;
  }
  get vendorAPI() {
    return pr;
  }
  setVendorAPI(e) {
    !pr && e && (pr = e);
  }
  get reinsertionReason() {
    return this.reasonData;
  }
  setReinsertionReason(e) {
    this.reasonData = e;
  }
  /**
   * @param {function} callback that HOMAD may use to decide whether they take responsibility
   * @returns {void}
   */
  setCorroborationCallback(e) {
    cr = e;
  }
  /**
   * @param {function} callback that publishers may use to accept or decline activating the ad reinsertion
   * @returns {void}
   */
  setActivationCallback(e) {
    hr = e;
  }
  /**
   * @param {Function} success There are reason why ad-reinsertion should be enabled. See `AdReinsertionModel.REASON`
   * @param {Function} failure Data that might help understanding the error, e.g. `xhr` status
   * @returns {void}
   */
  enable(e, i) {
    if (p.debug.warn("AdReinsertionModel: Trying to activate AdReinsertion."), !kn.homad.enabled) {
      let l = new Error("AdReinsertionModel: HOMAD not enabled by the publisher.");
      i(l);
      return;
    }
    if (!this.vendorAPI) {
      p.debug.warn("AdReinsertionModel: HOMAD enabled but not loaded."), requestAnimationFrame(() => {
        this.enable(e, i);
      });
      return;
    }
    if (!this.vendorAPI.isEnabled || !this.vendorAPI.isActive) {
      let l = new Error("AdReinsertionModel: Fallback not activated.");
      l = w.SESSION.AD_REINSERTION_DECLINED, i(l);
      return;
    }
    if (!cr) {
      i("HOMAD corroboration callback not set.");
      return;
    }
    let r = this.reasonData.reason, s = this.reasonData;
    cr(r, s).then(() => {
      qt !== Ge.STATUS.IS_BLOCKED ? hr ? hr(r).then((l) => {
        p.debug.info(
          ">> AdReinsertion success: Activation has been approved by the publisher."
        ), this.enrichment.set(
          "BLOCKED",
          Ge.STATUS.IS_BLOCKED,
          "blocked"
        ), qt = Ge.STATUS.IS_BLOCKED, e();
      }).catch((l) => {
        p.debug.info(
          ">> AdReinsertion error: Activation has been declined by the publisher."
        ), this.disable(), i("AdReinsertion request declined by publisher.", l);
      }) : (p.debug.warn(
        ">> AdReinsertion warning: Activation callback not set. Activation will be approved by default."
      ), this.enrichment.set(
        "BLOCKED",
        Ge.STATUS.IS_BLOCKED,
        "blocked"
      ), qt = Ge.STATUS.IS_BLOCKED, e()) : (p.debug.info(">> AdReinsertion has been enabled already. success."), e());
    }, (l) => {
      this.disable(), i("AdReinsertion request declined by HOMAD.", l);
    });
  }
  disable() {
    qt = 0, this.enrichment.set("BLOCKED", Ge.STATUS.IS_OPEN, "blocked");
  }
};
Ge.REASON = {
  XHR_TIMEOUT: 201e3,
  XHR_UNEXPECTED_STATUS: 201001,
  XHR_ERROR: 201002,
  XML_PARSING_ERROR: 201003,
  WRAPPER_CHAIN_TIMEOUT: 201004,
  AD_SLOT_TIMEOUT: 201005,
  XHR_PROMISE_ERROR: 201006,
  MEDIAFILE_TIMEOUT: 201010,
  MEDIAFILE_LOAD_ERROR: 201013,
  FORCE_ACTIVATION: 201020
}, Ge.STATUS = {
  IS_BLOCKED: 1,
  IS_OPEN: 0
}, Ge.TIMEOUT = {
  ACTIVATION_CALLBACK_RESPONSE: 250
}, Ge.EventDispatcher = new Rt();
let ce = Ge;
class ke {
  /*
  	 Returns current OS as String
  	 Used in EnrichmentModel
  
  	 based on https://stackoverflow.com/a/19883965
  	 */
  static operatingSystem() {
    return navigator.platform;
  }
  static userAgent() {
    return navigator.userAgent;
  }
  static screenResolution() {
    return {
      height: ke.screenHeight(),
      width: ke.screenWidth()
    };
  }
  static screenWidth() {
    return window.screen.width;
  }
  static screenHeight() {
    return window.screen.height;
  }
  static domain() {
    return window.location.href.split("/")[2];
  }
  /**
   * returns true if we are inside an IFrame
   *
   * @return {boolean} inside an IFrame
   */
  static isIF() {
    return window !== top;
  }
  /**
   * returns true if we are inside an friendly iframe
   *
   * @return {boolean} inside an friendly iframe
   */
  static isFIF() {
    return ke.isIF() && window.frameElement !== null;
  }
  /**
   * returns true if were in a friendly IFrame, or in no frame at all
   * used by the URLEnrichment flag AllowInSwipe
   *
   * @returns {boolean} inside friendly IFrame, or no IFrame at all
   */
  static isFriendlyIFrameOrNoFrame() {
    return !ke.isIF() || ke.isFIF();
  }
}
function fo() {
  return Math.round(Math.random() * 89999999) + 1e7;
}
function Vi(c) {
  return encodeURIComponent(c).replace(/[!'()*]/g, (e) => "%" + e.charCodeAt(0).toString(16));
}
function Ao() {
  const c = /* @__PURE__ */ new Date(), e = c.toISOString();
  let i = c.getTimezoneOffset() / 60, r = i < 0 ? "-" : "+" + ("0" + Math.abs(i)).slice(-2);
  return e.replace("Z", r);
}
function mo(c, e, i) {
  if (c.indexOf(e) === -1)
    return c;
  {
    const r = new RegExp(`\\[${e}+(\\|\\d+){0,1}\\]`, "ig");
    let s = /\d+/.test(c) ? parseInt(c.match(/\|(\d+)]/)[1], 10) : 0;
    return c.replace(
      r,
      s === 0 ? Vi(i) : Vi(i).substring(0, s)
    );
  }
}
function ki(c) {
  let e = !Number.isFinite(c) || c < 0 ? 0 : c;
  const i = /* @__PURE__ */ new Date(0);
  return i.setSeconds(e), i.toISOString().substring(11, 19) + ".000";
}
function zn() {
  return "xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g, (c) => {
    let e = Math.random() * 16 | 0;
    return (c === "x" ? e : e & 3 | 8).toString(16);
  });
}
class Ot {
  constructor() {
    this.macroMap = /* @__PURE__ */ new Map(), this.setDefaultMacros();
  }
  // macro iab overview
  // https://interactiveadvertisingbureau.github.io/vast/vast4macros/vast4-macros-latest.html
  // APIFRAMEWORKS - if a new API is supported, changes are required here
  // https://github.com/InteractiveAdvertisingBureau/AdCOM/blob/master/AdCOM%20v1.0%20FINAL.md#list_apiframeworks
  // required
  // CACHEBUSTER, ERRORCODE, REASON, LIMITADTRACKING, TIMESTAMP
  // required (if OM is supported) + for App/Web is supported, otherwise Optional.
  // OMIDPARTNER + APPBUNDLE, PAGEURL
  setDefaultMacros() {
    this.set("ADCATEGORIES", -1, "adcategories"), this.set("ADCOUNT", -1, "adcount"), this.set("ADPLAYHEAD", -1, "adplayhead"), this.set("ADSERVINGID", -1, "adservingid"), this.set("ADTYPE", -1, "adtype"), this.set("ALLOWINSWIPE", -1, ["allowinswipe"], ke.isFriendlyIFrameOrNoFrame), this.set("APIFRAMEWORKS", [2, 7, 8, 9], "apiframeworks"), this.set("APPBUNDLE", -1, "appbundle"), this.set("ASSETURI", -1, "asseturi"), this.set("BLOCKED", 0, "blocked"), this.set("BLOCKEDADCATEGORIES", -1, "blockedadcategories"), this.set("BREAKPOSITION", -1, "breakposition"), this.set("CACHEBUSTER", -1, ["cachebusting", "cachebuster", "rand(om|num)"], fo), this.set("CLICKPOS", -1, "clickpos"), this.set("CLICKTYPE", -1, "clicktype"), this.set("CLIENTUA", -1, "clientua"), this.set("CONTENTID", -1, "contentid"), this.set("CONTENTURI", -1, "contenturi"), this.set("CONTENTPLAYHEAD", -1, "contentplayhead", ki), this.set("DEVICEIP", -1, "deviceip"), this.set("DEVICEUA", ke.userAgent(), "deviceua"), this.set("DOMAIN", ke.domain(), "domain"), this.set("ERRORCODE", 0, "errorcode"), this.set("EXTENSIONS", -1, "extensions"), this.set("FIF", -1, "fif", ke.isFIF), this.set("GDPRCONSENT", -1, "gdprconsent"), this.set("IFA", -1, "ifa"), this.set("IDFAID", -1, "idfaid", () => this.macroMap.get("IFA")), this.set("IFATYPE", -1, "ifatype"), this.set("INVENTORYSTATE", -1, "inventoryState"), this.set("LATLONG", -1, "latlong"), this.set("LIMITADTRACKING", -1, "limitadtracking"), this.set("MEDIAMIME", -1, "mediamime"), this.set("MEDIAPLAYHEAD", 0, "mediaplayhead", ki), this.set("OS", ke.operatingSystem(), "os"), this.set("OMIDPARTNER", "Smartcliptv/7.6.0-dev", "omidpartner"), this.set("PAGETITLE", document.title, "pagetitle"), this.set("PAGEURL", document.URL, "pageurl"), this.set("PLACEMENTTYPE", -1, "placementtype"), this.set("PLAYERCAPABILITIES", -1, "playercapabilities"), this.set("PLAYERSIZE", {}, ["playersize"], this.getResolution), this.set("PLAYERWIDTH", -1, ["player_width", "playerwidth"], () => this.getPlayerDimension("width")), this.set("PLAYERHEIGHT", -1, ["player_height", "playerheight"], () => this.getPlayerDimension("height")), this.set("PLAYERSTATE", -1, "playerstate"), this.set("PODSEQUENCE", -1, "podsequence"), this.set("REASON", -1, "reason"), this.set("REGULATIONS", -1, "regulations"), this.set(
      "SCREENRES",
      ke.screenResolution(),
      ["screen_res", "screenres"],
      this.getResolution
    ), this.set("SCREENHEIGHT", ke.screenHeight(), "screenheight"), this.set("SCREENWIDTH", ke.screenWidth(), "screenwidth"), this.set("SERVERSIDE", 0, "serverside"), this.set("SERVERUA", -1, "serverua"), this.set("TIMESTAMP", -1, "timestamp", Ao), this.set("TRANSACTIONID", zn(), "transactionid"), this.set(
      "UNIVERSALADID",
      -1,
      "universaladid",
      (e) => Array.isArray(e) ? e.map((i) => i.idRegistry + " " + i.idValue) : e
    ), this.set("VASTVERSIONS", [2, 3, 5, 6, 7, 8, 11, 12, 13, 14], "vastversions"), this.set("VERIFICATIONVENDORS", -1, "verificationvendors");
  }
  getPlayerDimension(e) {
    var r;
    return ((r = this.macroMap.get("PLAYERSIZE").value) == null ? void 0 : r[e]) || 0;
  }
  getResolution(e) {
    const i = parseInt((e == null ? void 0 : e.width) || "0", 10), r = parseInt((e == null ? void 0 : e.height) || "0", 10);
    return `${i},${r}`;
  }
  getMacros(e = !1) {
    let i = {};
    if (e)
      for (const [r] of this.macroMap)
        i[`[${r}]`] = this.get(r, !0);
    else
      for (const [r] of this.macroMap)
        i[r] = this.get(r, !0);
    return i;
  }
  /**
   * Returns all macros as defined by the IAB and its encoded values.
   * @returns {Object} list of macro value pairs
   */
  getMacroList() {
    return this.getMacros();
  }
  /**
   * Returns all macros as defined by the IAB, but surrounded by square brackets,
   *  and its encoded values.
   * @returns {Object} list of macro value pairs
   */
  getIABMacroList() {
    return this.getMacros(!0);
  }
  /**
   * Key and Value have to be set everytime,
   * macroToReplace needs to be set at least once
   * transformFunction is a function to be called each time the macro is replaced,
   * so you can set a value like this
   *      set('size', {width:w, height:h}, ['WxH'], function(obj){return obj.width+'x'+obj.height;}
   * while on updating the value only
   *      set('size', {width:w, height:h});
   * is needed
   *
   * @param {String} key reference key
   * @param {*} value usually a string, however transformFunction can make this a string
   * @param {(String|String[])} [macroToReplace] the macro to replace
   * @param {Function} [transformFunction] value will sent through this function on each apply call
   * @return {EnrichmentModel} to set() functions can be chained
   */
  set(e, i, r, s) {
    let l = this.macroMap.get(e) || {}, h = r || l.macroList;
    return l.value = i, h ? Array.isArray(h) ? l.macroList = h : l.macroList = [h] : l.macroList = [e.toLowerCase()], s && (l.transform = s), this.macroMap.set(e, l), this;
  }
  get(e, i = !1) {
    if (!e)
      return null;
    let r = this.macroMap.get(e + "");
    if (!r)
      return null;
    let s = r.value;
    return r.transform && (s = r.transform(s)), i ? Array.isArray(s) ? s.map((l) => Vi(String(l))).join(",") : Vi(String(s)) : s;
  }
  setFromObject(e) {
    if (e)
      for (const i in e) {
        if (!Object.prototype.hasOwnProperty.call(e, i))
          continue;
        const r = e[i], s = typeof r == "string" && r.length === 0 || Array.isArray(r) && r.length === 0 ? "-1" : r;
        this.set(i.toUpperCase(), s, "");
      }
  }
  /**
   * Does replace all occurrences of macro replacement strings with values.
   * @param {string} inputString - This is most likely a URL
   * @returns {string|*} - Enriched URL
   */
  apply(e) {
    let i = e === null ? "" : String(e);
    for (const [r, s] of this.macroMap) {
      const l = String(this.get(r, !0));
      for (const h of s.macroList)
        i = this.replaceMacroWithValue(i, h, l);
    }
    return i;
  }
  replaceMacroWithValue(e, i, r) {
    let s = e.replace(this.getRegExp(i), r);
    return mo(s, "[" + i, r);
  }
  getRegExp(e) {
    let i = "[\\[](" + e + ")[\\]]";
    return new RegExp(i, "gi");
  }
}
class Ui {
  xdrRequest() {
    return typeof window != "undefined" && window.XDomainRequest ? window.XDomainRequest : null;
  }
  static supported() {
    return !!new Ui().xdrRequest();
  }
  get(e, i, r) {
    if (this.xdrRequest()) {
      let s = new XMLHttpRequest();
      s.open("GET", e), s.timeout = i.timeout || 0, s.withCredentials = i.withCredentials !== !1, s.onload = () => {
        let l = new DOMParser().parseFromString(s.responseText, "text/xml");
        r(null, l);
      }, s.onerror = () => {
        r(new Error("Error loading the XML document"));
      }, s.send();
    } else
      r(new Error("XDomainRequest is not supported"));
  }
}
class Eo {
  /**
   * Fetches an image from the specified URL.
   * @param {string} url - URL of the image to be fetched.
   * @param {object} options - Timeout options from the configuration.
   * @param {number} options.timeouts.adRequest - Timeout duration for the image request in seconds.
   * @param {Function} callback - A callback function that expects one parameter `xhrError` to handle errors.
   */
  static getAsImage(e, i, r) {
    let s = !1;
    const l = i.timeouts.adRequest * 1e3, h = setTimeout(() => {
      s = !0;
      let L = new Error("ImageURLHandler: Tracking request timeout.");
      L.code = w.WARNING.TRACKER_TIMEOUT.code, L.description = w.WARNING.TRACKER_TIMEOUT.message, L.type = "AdWarning", r(L);
    }, l);
    let m = new Image();
    m.src = "";
    const g = () => {
      clearTimeout(h), !s && r(null);
    }, y = (L) => {
      g();
    };
    return m.onerror = y, m.onload = g, m.src = e, m;
  }
}
function Mr(c) {
  if (typeof c != "string")
    return c;
  let e = null;
  if (DOMParser)
    e = new DOMParser().parseFromString(c, "text/xml");
  else if (ActiveXObject) {
    let i = new ActiveXObject("Microsoft.XMLDOM");
    i.loadXML(c), e = i;
  }
  return e;
}
const fr = " Response contains neither 'responseXML' nor 'responseText'", Ce = class Ce {
  /**
   * Creates and returns a new XMLHttpRequest object with CORS support.
   *
   * @returns {XMLHttpRequest | null} A new XMLHttpRequest object with CORS support, or null if the browser doesn't
   *  support CORS.
   */
  xhrRequest() {
    let e = new XMLHttpRequest();
    return "withCredentials" in e ? e : null;
  }
  static supported() {
    return !!new Ce().xhrRequest();
  }
  /**
   * Performs an asynchronous HTTP GET request using XMLHttpRequest.
   *
   * @param {string} url - URL to make the GET request to.
   * @param {XHROptions} options - Additional options for the request. (timeout etc.)
   * @param {Function} callback - The callback function to handle the response.
   * @returns {void}
   */
  getAsXHR(e, i, r) {
    let s, l = r.timeouts.adRequest * 1e3, m = setTimeout(() => {
      s.onreadystatechange = s.onerror = () => {
        p.debug.info(Ce.NAME + ": Ignoring XHR state changes after timeout error", e);
      };
      let g = new Error(Ce.NAME + ": Request timeout");
      g.code = w.WRAPPER.TIMEOUT.code;
      let y = r.timeouts ? r.timeouts.errorMessage : null;
      g.message = y || w.WRAPPER.TIMEOUT.message, r.adReinsertion.setReinsertionReason({
        reason: r.isWrapper ? ce.REASON.WRAPPER_CHAIN_TIMEOUT : ce.REASON.XHR_TIMEOUT,
        xhr: s,
        xhrError: g
      }), i(g, null);
    }, l);
    try {
      s = this.xhrRequest(), s.withCredentials = r.withCredentials !== !1, s.overrideMimeType && s.overrideMimeType("text/xml"), s.onreadystatechange = () => {
        if (s.readyState === 1) {
          s.send();
          return;
        }
        if (s.readyState === 4)
          if (clearTimeout(m), s.status === 200) {
            let g = s.responseXML;
            if (!g && s.responseText && (g = Mr(s.responseText)), !g) {
              p.debug.info(Ce.NAME + fr);
              let y = new Error(Ce.NAME + fr);
              y.code = r.isWrapper ? w.WRAPPER.NO_RESPONSE.code : w.XML.INVALID_XML.code, y.message = "XHR Response Error:" + fr, r.adReinsertion.setReinsertionReason({
                reason: ce.REASON.XHR_ERROR,
                xhr: s,
                xhrError: y
              }), i(y, null);
              return;
            }
            i(null, g);
          } else {
            s.onreadystatechange = s.onerror = () => {
              p.debug.info(Ce.NAME + "Ignoring XHR state changes after status error", s.readyState, s.status, e);
            };
            let g = new Error(Ce.NAME + s.statusText);
            g.code = r.isWrapper ? w.WRAPPER.TIMEOUT.code : w.XML.INVALID_XML.code, g.message = `XHR Status Error (${s.status}): ${s.statusText}`, r.adReinsertion.setReinsertionReason({
              reason: ce.REASON.XHR_UNEXPECTED_STATUS,
              xhr: s,
              xhrError: g
            }), i(g, null);
          }
      }, s.open("GET", e), s.onerror = () => {
        clearTimeout(m), p.debug.info(Ce.NAME + ": XHR Error.", s.readyState, s.status, e);
        let g = new Error(Ce.NAME + s.statusText);
        g.code = w.WRAPPER.TIMEOUT.code, g.message = `XHR Error (${s.status}): ${s.statusText}`, r.adReinsertion.setReinsertionReason({
          reason: ce.REASON.XHR_UNEXPECTED_STATUS,
          xhr: s,
          xhrError: g
        }), i(g, null);
      };
    } catch (g) {
      clearTimeout(m);
      let y = new Error(`${Ce.NAME}: Request error.`);
      y.code = w.WRAPPER.TIMEOUT.code, y.message = `XHR Request Error: ${g}`, r.adReinsertion.setReinsertionReason({
        reason: ce.REASON.XHR_ERROR,
        xhr: null,
        xhrError: y
      }), i(y, null);
    }
  }
  get(e, i, r) {
    p.debug.info(`${Ce.NAME}: XHR get with timeout ${r.timeouts.adRequest} sec: ${e}`), r.issuer && r.issuer === Ce.ISSUER.TRACKING ? Eo.getAsImage(e, r, i) : this.getAsXHR(e, i, r);
  }
};
Ce.ISSUER = {
  TRACKING: "TrackingURLHandler",
  TAG: "URLHandler"
}, Ce.NAME = "XHRURLHandler";
let pt = Ce;
pt.DEFAULT_TIMEOUT = 4;
function Fi(c, e) {
  if (c.indexOf("//") === 0) {
    let i = location.protocol;
    return (i === "about:" || i === "file:") && (i = "https:"), i + c;
  }
  return c.indexOf("://") === -1 ? e.slice(0, e.lastIndexOf("/")) + "/" + c : c;
}
const hi = {
  adRequestMethod: "xhr",
  adVerification: {
    accessMode: "full",
    disabled: !1,
    omidServiceWindow: null,
    playerHandles: !1,
    serviceWindow: window.top,
    sessionCleanupDelay: 3,
    timeoutScriptLoad: 1,
    vendorWhitelist: []
  },
  adReinsertion: {
    homad: {
      enabled: !1,
      setup: {
        globalConfig: "",
        clientConfig: "",
        activationCallback: () => {
        },
        enableSessionCoverage: !1,
        forceActivation: !1
      }
    }
  },
  adSourceSelector: null,
  blockInsecureURL: !0,
  maxWrapperDepth: 10,
  playerHandlesNonLinear: !1,
  shareVideoElementWithVPAID: !0,
  skipOffset: -1,
  timeouts: {
    adRequest: 1,
    adRequestChain: 2,
    adSlotRequest: 4,
    contentRequest: 3,
    nonlinearMaxDuration: 10,
    videoRequest: 3,
    vpaidReadiness: 3,
    vpaidRequest: 1
  },
  trackImpressionOnStart: !1,
  trackSkippedQuartiles: !1,
  viewability: {
    area: 50,
    time: 2
  }
};
class Pr {
  constructor() {
    this.issuer = pt.ISSUER.TAG;
  }
  get(e, i, r) {
    if (!i)
      return null;
    let s = r, l = e;
    s || (s = hi, s.enrichment = new Ot()), s.issuer = this.issuer, s.enrichment = s.enrichment || new Ot(), l = s.enrichment.apply(l), l && l.indexOf("//") === 0 && (l = Fi(l, ""));
    let h = s.urlhandler;
    if (s.response) {
      let m = s.response;
      i(null, Mr(m));
    } else return h && h.supported() ? new h().get(l, i, s) : pt.supported() ? new pt().get(l, i, s) : Ui.supported() ? new Ui().get(l, i, s) : i();
    return null;
  }
}
const ai = class ai extends Pr {
  constructor() {
    super(), this.issuer = pt.ISSUER.TRACKING;
  }
  track(e, i, r) {
    e && e.length > 0 && Array.isArray(e) ? this.getMultiple(e, i, r) : p.debug.info(ai.NAME + "track - without trackers:", e);
  }
  getMultiple(e, i, r) {
    for (const s of e)
      s.requested = !0, s.url && super.get(s.url, (i || this.onResponse).bind(this, s), r);
  }
  // Error declaration in lib.es5.d.ts
  onResponse(e, i) {
    i && p.debug.warn(ai.NAME + "onResponse failed:", i.name, i, e);
  }
};
ai.NAME = "TrackingUrlHandler::";
let $i = ai;
const f = {
  // Single Ad Events
  ON_AD_CLICKED: "AdClickThru",
  // clickThroughUrl
  ON_AD_CREATIVE_VIEW: "AdCreativeView",
  ON_AD_ERROR: "AdError",
  ON_AD_FIRST_QUARTILE: "AdVideoFirstQuartile",
  ON_AD_IMPRESSION: "AdImpression",
  ON_AD_LINEARITY_CHANGE: "AdLinearChange",
  // isLinear
  ON_AD_LOADED: "AdLoaded",
  // numAds
  ON_AD_MANIFEST_LOADED: "AdTagParsed",
  ON_AD_MANIFEST_LOAD_ERROR: "AdTagLoadFailed",
  ON_AD_MID_POINT: "AdVideoMidpoint",
  ON_AD_MUTED: "AdMuted",
  ON_AD_PAUSED: "AdPaused",
  ON_AD_PLAYBACK_START: "AdVideoStart",
  ON_AD_PLAYBACK_FINISHED: "AdVideoComplete",
  ON_AD_PLAYING: "AdPlaying",
  ON_AD_PROGRESS: "AdProgress",
  ON_AD_REWIND: "AdRewind",
  ON_AD_SIZE_CHANGED: "AdSizeChanged",
  ON_AD_SKIPPABLE_STATE_CHANGE: "AdSkippableStateChange",
  ON_AD_SKIPPED: "AdSkipped",
  ON_AD_START: "AdStart",
  ON_AD_STARTED: "AdStarted",
  ON_AD_STOPPED: "AdStopped",
  ON_AD_THIRD_QUARTILE: "AdVideoThirdQuartile",
  ON_AD_UNMUTED: "AdUnmuted",
  ON_AD_VOLUME_CHANGED: "AdVolumeChanged",
  ON_ENTER_FULLSCREEN: "EnterFullscreen",
  // replaced by playerExpand since VAST 4.1
  ON_EXIT_FULLSCREEN: "LeaveFullscreen",
  // replaced by playerCollapse since VAST 4.1
  ON_PLAYER_EXPAND: "PlayerExpand",
  ON_PLAYER_COLLAPSE: "PlayerCollapse",
  ON_CLOSED_CAPTIONS_DETECTED: "ClosedCaptionsDetected",
  ON_COMPANIONS_DETECTED: "CompanionsDetected",
  ON_EXTENSIONS_DETECTED: "ExtensionsDetected",
  ON_ICONS_DETECTED: "IconsDetected",
  ON_NONLINEAR_DETECTED: "NonLinearDetected",
  ON_VERIFICATION_DETECTED: "AdVerificationDetected",
  ON_COMPANION_CREATIVE_VIEW: "CompanionCreativeView",
  ON_COMPANION_CLICKED: "CompanionClickThru",
  ON_ICON_CLICKED: "IconClickThru",
  // NonLinear Ad Metrics
  ON_AD_NONLINEAR_FINISHED: "AdOverlayViewFinished",
  ON_AD_NONLINEAR_STOPPED: "AdOverlayViewStopped",
  // Single VMAP Events
  ON_AD_PLAYLIST_LOADED: "AdPlaylistLoaded",
  ON_AD_PLAYLIST_LOAD_ERROR: "AdPlaylistLoadError",
  ON_AD_PLAYLIST_START: "AdPlaylistStart",
  ON_AD_PLAYLIST_STARTED: "AdPlaylistStarted",
  ON_AD_PLAYLIST_STOPPED: "AdPlaylistStopped",
  ON_AD_PLAYLIST_COMPLETE: "AdPlaylistComplete",
  // Multiple Ads Events
  ON_AD_SLOT_START: "AdSlotStart",
  ON_AD_SLOT_STARTED: "AdSlotStarted",
  ON_AD_SLOT_STOPPED: "AdSlotStopped",
  ON_AD_SLOT_COMPLETE: "AdSlotComplete",
  ON_AD_SLOT_DURATION_CHANGE: "AdSlotDurationChange",
  // viewableImpressionEvents
  ON_AD_VIEWABLE: "AdViewable",
  ON_AD_NOT_VIEWABLE: "AdNotViewable",
  ON_AD_VIEWABLE_STATE_CHANGE: "AdViewStateChange",
  ON_AD_VIEWABLE_UNDETERMINED: "AdViewUndetermined",
  // Custom Events
  ON_AD_WARNING: "AdWarning",
  ON_AD_REINSERTION_ACTIVATION: "AdReinsertionActivation",
  ON_AD_REINSERTION_PENALTY: "AdReinsertionPenalty",
  ON_GENERAL_ERROR: "GeneralError",
  ON_PLAYBACK_FINISHED: "PlaybackFinished",
  ON_SIMID_ERROR: "SIMIDError",
  ON_VPAID_CLEANUP: "VPAIDCleanup",
  // HOMAD
  ON_HOMAD_PENALTY: "HOMADPenalty"
}, Yt = {
  ON_AD_CLICKED: "clickTracking",
  // clickThroughUrl
  ON_AD_ERROR: "error",
  ON_AD_STOPPED: "AdStopped",
  ON_AD_LINEARITY_CHANGE: "AdLinearChange",
  // isLinear
  ON_AD_MANIFEST_LOADED: "AdTagParsed",
  ON_AD_LOADED: "AdLoaded",
  // numAds
  ON_AD_SKIPPED: "skip",
  ON_AD_PLAYBACK_START: "start",
  ON_AD_FIRST_QUARTILE: "firstQuartile",
  ON_AD_MID_POINT: "midpoint",
  ON_AD_THIRD_QUARTILE: "thirdQuartile",
  ON_AD_PLAYBACK_FINISHED: "complete",
  ON_AD_PROGRESS: "progress",
  ON_AD_REWIND: "rewind",
  ON_AD_MUTED: "mute",
  ON_AD_UNMUTED: "unmute",
  ON_ENTER_FULLSCREEN: "fullscreen",
  ON_EXIT_FULLSCREEN: "exitFullscreen",
  ON_PLAYER_EXPAND: "playerExpand",
  ON_PLAYER_COLLAPSE: "playerCollapse",
  ON_AD_IMPRESSION: "impression",
  ON_AD_CREATIVE_VIEW: "creativeView",
  ON_AD_PAUSED: "pause",
  ON_AD_PLAYING: "resume",
  // viewableImpressionEvents
  ON_AD_VIEWABLE: "viewable",
  ON_AD_NOT_VIEWABLE: "notViewable",
  ON_AD_VIEWABLE_UNDETERMINED: "viewUndetermined",
  // NonLinear Ad Metrics
  ON_AD_NONLINEAR_STOPPED: "overlayViewDuration",
  // VMAP
  ON_AD_BREAK_START: "breakStart",
  ON_AD_BREAK_END: "breakEnd",
  ON_AD_BREAK_ERROR: "error"
}, xt = class xt {
  constructor(e, i, r) {
    this.player = i, this.config = r, this.adSlotAPI = e, this.eventHandlers = [], this.currentAdBreak = null, this.environmentVars = null, xt.ERROR_CODE_MAP[w.SESSION.MANIFEST_LOAD_FAILED.code] = 1008, xt.ERROR_CODE_MAP[w.SESSION.TIMEOUT.code] = 1007;
  }
  initAdSlot(e, i = {}) {
    e.requested = !0, p.debug.info(
      Te.NAME + "initAdSlot - Request core to init AdBreak",
      e.breakId,
      e.breakType,
      e.type
    ), this.currentAdBreak = e, this.environmentVars = i;
    const r = e.adSource.type.indexOf("adtaguri") > -1 ? "tag" : "response";
    let s = {};
    return s.adBreakPosition = e.breakPosition, s.type = e.type, s[r] = e.adSource.source, s = Object.assign(s, e.separationClips), this.currentAdBreak.enrichment = new Ot(), this.currentAdBreak.enrichment.setFromObject(this.environmentVars.vastMacros), this.currentAdBreak.enrichment.set("BREAKPOSITION", e.breakPosition), this.currentAdBreak.adReinsertion = new ce(
      this.config.adReinsertion,
      this.currentAdBreak.enrichment
    ), this.on(), new Promise((l, h) => {
      this.adSlotAPI.initAdSlot(s, i).then(() => {
        p.debug.info(
          Te.NAME + "initAdSlot - Initialized ad slot with adBreak",
          e.breakId
        ), l(e);
      }).catch((m) => {
        p.debug.warn(Te.NAME + "initAdSlot - Could not init ad slot", m), h(m);
      });
    });
  }
  startAdSlot() {
    let e = this.currentAdBreak;
    p.debug.info(
      Te.NAME + "startAdSlot",
      e.breakId,
      e.timeOffset,
      e.prefetchOffset,
      this.player.getContentCurrentTime()
    ), this.adSlotAPI.startAdSlot();
  }
  /**
   * Activates player and ad event listeners.
   */
  on() {
    this.off();
    const e = [
      this.adSlotAPI.addEventListener(f.ON_AD_SLOT_START, () => {
        this.trackEvent(Yt.ON_AD_BREAK_START);
      }),
      this.adSlotAPI.addEventListener(f.ON_AD_SLOT_STOPPED, () => {
        this.trackEvent(Yt.ON_AD_BREAK_END);
      }),
      // Remove listeners. The AdPlaylistController creates a separate instance with each AdBreak
      this.adSlotAPI.addEventListener(f.ON_AD_SLOT_STOPPED, () => {
        this.off();
      }),
      /** Error Handling */
      this.adSlotAPI.addEventListener(f.ON_AD_MANIFEST_LOAD_ERROR, () => {
        this.currentAdBreak.enrichment.set(
          "ERRORCODE",
          xt.ERROR_CODE_MAP[this.adSlotAPI.error.code] || this.adSlotAPI.error.code
        ), this.trackEvent(Yt.ON_AD_BREAK_ERROR);
      }),
      // Ad execution errors should report the same error code in VMAP that was reported for the VAST ad
      this.adSlotAPI.addEventListener(f.ON_AD_ERROR, () => {
        this.currentAdBreak.enrichment.set(
          "ERRORCODE",
          Object.keys(this.adSlotAPI.ad).length > 0 ? this.adSlotAPI.ad.error.code : this.adSlotAPI.error.code
        ), this.trackEvent(Yt.ON_AD_BREAK_ERROR);
      })
    ];
    this.eventHandlers = this.eventHandlers.concat(e), p.debug.info(
      Te.NAME + "on - Subscribed to ad slot events. Current list",
      this.eventHandlers
    );
  }
  off() {
    p.debug.info(
      Te.NAME + "off - Unsubscribe event listeners. Current list",
      this.eventHandlers
    );
    for (const e of this.eventHandlers)
      e();
    this.eventHandlers = [];
  }
  trackEvent(e) {
    let i = this.currentAdBreak.trackingEvents[e];
    this.callTrackers(i);
  }
  callTrackers(e) {
    if (!e || e.length < 1) {
      p.debug.info(
        Te.NAME + "callTrackers - Request without URIs",
        e
      );
      return;
    }
    this.currentAdBreak.enrichment.set("PLAYERSIZE", this.player.getPlayerSize().boundingRect);
    const i = {
      adReinsertion: this.currentAdBreak.adReinsertion,
      enrichment: this.currentAdBreak.enrichment,
      // @ts-expect-error: No values will be assigned if environmentVars is undefined or null!
      timeouts: Object.assign(this.config.timeouts, this.environmentVars.timeouts),
      urlhandler: this.config.urlhandler
    };
    new $i().track(e, (r, s) => {
      s && p.debug.warn(Te.NAME + "callTrackers - failed:", s, r);
    }, i);
  }
};
xt.ERROR_CODE_MAP = {}, xt.NAME = "AdBreakCtrl::";
let gr = xt;
const Be = {
  ON_ENDED: "ended",
  ON_LOADED_DATA: "loadeddata",
  ON_TIME_UPDATED: "timeupdate",
  ON_PLAY: "playerPlay",
  ON_PAUSED: "playerPause",
  ON_VOLUME_CHANGED: "volumeChanged",
  ON_ERROR: "error"
}, Ar = "Content - Scan for AdBreaks to play", pe = class pe extends Rt {
  /**
   *
   * @param {AdPlaylist} playlist
   * @param {Object} config - smartclientcore.SCHEME.GLOBAL_CONFIG
   */
  constructor(e, i) {
    super(), this.adBreakController = null, this.adPlaylist = e.getAdPlaylist(), this.adSlotAPI = null, this.contentDuration = 1 / 0, this.contentFinished = !1, this.playlistComplete = !1, this.eventHandlers = [], this.config = i, this.player = null, this.playableAdBreaks = [], this.postroll = this.adPlaylist.filter((r) => {
      if (r.timeOffset === "end")
        return r;
    }), this.isSeeking = void 0;
  }
  setAdsAPI(e) {
    this.adSlotAPI = e;
  }
  setPlayer(e) {
    this.player = e;
  }
  dispatchFinishedEvents() {
    super.dispatchEvent(f.ON_AD_PLAYLIST_STOPPED), super.dispatchEvent(f.ON_AD_PLAYLIST_COMPLETE);
  }
  waitForAdSlotComplete() {
    this.adSlotAPI.addEventListener(f.ON_AD_SLOT_COMPLETE, () => {
      this.dispatchFinishedEvents();
    });
  }
  /**
   * This triggers all AdSlots that have an AdBreak with `timeOffset` equally to `0`, `"start"`, `"0%"`.
   *
   * Note: Most likely we do not know any times from the content at this point in time.
   * @returns {Promise<void>}
   */
  beforeContent() {
    return this.contentFinished = !1, p.debug.info(
      pe.NAME + "before" + Ar + "."
    ), super.dispatchEvent(f.ON_AD_PLAYLIST_STARTED), this.requestAdBreak(0).then(() => {
      this.deliverAdBreak(), this.startContent();
    }).catch((e) => {
      p.debug.info(
        pe.NAME + "requestAdBreak - Found no matching AdBreak.",
        e
      ), this.startContent();
    });
  }
  startContent() {
    this.adSlotAPI.addEventListener(f.ON_AD_SLOT_COMPLETE, () => {
      this.on();
    }), this.contentFinished = !1, this.contentDuration = this.player.getContentDuration(), p.debug.info(
      pe.NAME + "start" + Ar + " during content playback."
    ), this.on();
  }
  /**
   * This triggers all AdSlots that have an AdBreak with `timeOffset` equally to `this.player.getContentDuration()`,
   * `"end"`, `"100%"`.
   * @returns {Promise<void>}
   */
  afterContent() {
    return this.contentFinished = !0, p.debug.info(
      pe.NAME + "after" + Ar + "."
    ), this.playlistComplete ? Promise.resolve() : this.playableAdBreaks.length > 0 ? (this.playlistComplete = !0, this.waitForAdSlotComplete(), this.deliverAdBreak(), Promise.resolve()) : (this.postroll && (this.playlistComplete = !0, this.dispatchFinishedEvents()), Promise.resolve());
  }
  stop() {
    this.off(), this.dispatchFinishedEvents();
  }
  /**
   * Walks through the adPlaylist and requests the AdBreak that matches the current playback progress
   *  with the given current offset and initializes the ad slot controller for it.
   *
   * @param {number} currentOffset - The current offset for which to request the AdBreak.
   * @returns {Promise<void>} A Promise that resolves when the AdBreak has been successfully initialized and added to
   *  the list of playable AdBreaks.
   * @throws {string} If no AdBreak can be found for the given current offset or if initialization of the AdBreak fails.
   */
  requestAdBreak(e) {
    if (this.player && this.isSeeking && this.postroll.length > 0 && e >= this.contentDuration - this.postroll[0].prefetchOffset) {
      this.isSeeking = !1, this.postroll = null;
      for (const s of this.adPlaylist)
        s.timeOffset !== "end" && (s.requested = !0);
      this.requestAdBreak(e);
    }
    if (this.player && this.isSeeking || this.playlistComplete)
      return Promise.resolve();
    let i = this.find(e), r = i.shift();
    for (const s of i)
      s.requested = !0;
    return r && this.playableAdBreaks.length && (r.requested = !0), new Promise((s, l) => {
      r && !r.requested ? (this.adBreakController = new gr(this.adSlotAPI, this.player, this.config), this.adBreakController.initAdSlot(r, this.player.getEnvironmentVars(r.type)).then((h) => {
        p.debug.info(
          pe.NAME + "requestAdBreak - Initialized AdBreak",
          h.timeOffset
        ), this.contentFinished ? (this.playlistComplete = !0, this.waitForAdSlotComplete(), this.adBreakController.startAdSlot()) : this.playableAdBreaks.push(h), s();
      }).catch((h) => {
        p.debug.warn(
          pe.NAME + "requestAdBreak - Failed to initialize ",
          r.timeOffset,
          h
        ), l(h);
      })) : l(
        pe.NAME + "requestAdBreak - Could not find an AdBreak with timeOffset " + e
      );
    });
  }
  deliverAdBreak() {
    if (this.playableAdBreaks.length !== 0 && this.isExecutableAdBreak(
      this.playableAdBreaks[0],
      this.player.getContentCurrentTime(),
      pe.PROCESS.DELIVERY
    )) {
      let e = this.playableAdBreaks.shift();
      this.duplicateAdBreak(e), p.debug.info(pe.NAME + "deliverAdBreak - Start AdBreak", e.timeOffset), this.adBreakController.startAdSlot();
    }
  }
  find(e) {
    const i = e;
    return this.adPlaylist.filter((r) => {
      if (r.requested)
        return !1;
      let s = i;
      return r.prefetchOffset > 0 && (s += r.prefetchOffset), this.isExecutableAdBreak(r, s);
    });
  }
  /**
   * Checks if an ad break is executable based on the current time and process type.
   * @param {Object} adBreak - The adBreak to check.
   * @param {number} currentTime - The current playback time in seconds.
   * @param {string} [process=AdPlaylistController.PROCESS.TYPE] - The process type DELIVERY/REQUEST.
   * @returns {boolean} Returns true if the ad break is executable, false otherwise.
   */
  isExecutableAdBreak(e, i, r = pe.PROCESS.REQUEST) {
    function s(h, m) {
      var y;
      const g = h - m;
      return (y = e.publisherSpecs) != null && y.strictOffsets ? g >= 0 && g <= pe.STRICT_OFFSET_THRESHOLD : g >= 0;
    }
    if (e.timeOffset.indexOf("%") > -1) {
      const h = this.contentDuration * parseFloat(e.timeOffset) / 100;
      return s(i, h);
    }
    if (e.timeOffset === "start" || this.contentFinished && e.timeOffset === "end" && r === pe.PROCESS.DELIVERY)
      return !0;
    if (e.timeOffset === "end" && !e.requested && r === pe.PROCESS.REQUEST)
      return i - this.contentDuration >= 0;
    const l = Tt(e.timeOffset);
    return l !== null && s(i, l);
  }
  /**
   * Duplicates the specified ad break and adds it to the ad playlist at a specified time offset.
   * @param {Object} adBreak - The ad break to duplicate.
   * @returns {void}
   */
  duplicateAdBreak(e) {
    if (e.repeatAfter <= 0)
      return;
    const r = this.player.getContentCurrentTime() + e.repeatAfter;
    let s = e.adBreakXML.cloneNode(!0);
    s.setAttribute("timeOffset", ki(r)), this.adPlaylist.push(new ui(s, e.publisherSpecs)), p.debug.info(
      pe.NAME + "duplicateAdBreak - Updated adPlaylist",
      this.adPlaylist.slice(0)
    );
  }
  /**
   * Activates player and ad event listeners.
   */
  on() {
    this.off();
    let e = Date.now(), i = 0, r = 0;
    this.addPlayerEventListener(Be.ON_TIME_UPDATED, () => {
      if (this.adSlotAPI.slot && this.adSlotAPI.ad.isLinear)
        return;
      const s = this.player.getContentCurrentTime(), l = s - i, h = (Date.now() - e) / 1e3;
      l > h + 0.075 || l > 2 ? (this.isSeeking = !0, r = 0) : r >= pe.NOF_REQUIRED_UPDATES_TO_UNSEEK && (this.isSeeking = !1), r = Math.min(
        r + 1,
        pe.NOF_REQUIRED_UPDATES_TO_UNSEEK
      ), i = s, e = Date.now(), this.requestAdBreak(this.player.getContentCurrentTime()).catch(() => {
      }), this.deliverAdBreak();
    }), this.addPlayerEventListener(Be.ON_ENDED, () => {
      this.adSlotAPI.slot && this.adSlotAPI.ad.isLinear || this.afterContent();
    }), p.debug.info(
      pe.NAME + "on - Subscribed to player and core events.",
      this.eventHandlers
    );
  }
  off() {
    p.debug.info(
      pe.NAME + "off - Unsubscribe event listeners. Current list",
      this.eventHandlers
    );
    for (const e of this.eventHandlers)
      e();
    this.eventHandlers = [];
  }
  // eslint-disable-next-line @typescript-eslint/no-unsafe-function-type
  addPlayerEventListener(e, i) {
    this.player.addEventListener(e, i);
    const r = () => this.removePlayerEventListener(e, i);
    return this.eventHandlers.push(r), r;
  }
  // eslint-disable-next-line @typescript-eslint/no-unsafe-function-type
  removePlayerEventListener(e, i) {
    this.player.removeEventListener(e, i);
  }
};
pe.NAME = "AdPlaylistCtrl::", pe.PROCESS = {
  REQUEST: "AdPlaylistController::request",
  DELIVERY: "AdPlaylistController::delivery"
}, pe.STRICT_OFFSET_THRESHOLD = 2, pe.NOF_REQUIRED_UPDATES_TO_UNSEEK = 4;
let Te = pe;
const go = "HomadXHRUrlHandler", Un = ": Response contains neither 'responseXML' nor 'responseText'", Gt = class Gt {
  /**
   * Creates an XMLHttpRequest object.
   * @returns {XMLHttpRequest|null} An XMLHttpRequest object if the browser supports it, or null if it does not.
   */
  xhrRequest() {
    let e = new XMLHttpRequest();
    return "withCredentials" in e ? e : null;
  }
  static supported() {
    return !!new Gt().xhrRequest();
  }
  getAsXHR(e, i, r) {
    function s(g) {
      i(g, null);
    }
    function l(g) {
      if (r.issuer && r.issuer === pt.ISSUER.TRACKING) {
        i(null, null);
        return;
      }
      let y = g.responseXML;
      if (!y && g.responseText && (y = Mr(g.responseText)), !y) {
        let L = new Error(go + Un);
        L.code = w.XML.INVALID_XML.code, L.description = "HOMAD Response Error" + Un, i(L, null);
        return;
      }
      i(null, y);
    }
    if (!r.adReinsertion) {
      let g = new Error("AdReinsertion setup omitted. HomadXHRURLHandler not activated.");
      g.code = w.WRAPPER.TIMEOUT.code, g.description = "HOMAD Activation Error: AdReinsertion setup omitted (publisher-side).", s(g);
      return;
    }
    const h = r.adReinsertion.vendorAPI.stuffAdTag(e);
    let m = r.adReinsertion.vendorAPI.getUrlRequest(h);
    m.data.homad_macros = JSON.stringify(r.enrichment.getIABMacroList()), p.debug.info(
      Gt.NAME + "getAsXHR - Provide VAST Macro List" + m.data.homad_macros
    ), r.adReinsertion.vendorAPI.loadFile(m, (g) => {
      l(g);
    }, (g) => {
      let y, L = "HOMADUtils XHR";
      g.timedOut ? (y = new Error("HomadUtilsURLHandler: Request timeout."), y.code = w.WRAPPER.TIMEOUT.code, y.description = `${L} Timeout Error ${r.timeouts.errorMessage || w.WRAPPER.TIMEOUT.message}`) : (y = new Error("HomadUtilsURLHandler: " + g.statusText), y.code = w.XML.INVALID_XML.code, y.description = `${L} Status Error (${g.status}): ${g.statusText}`), s(y);
    }, !1, !1, !1, r.timeouts.adRequest * 1e3);
  }
  get(e, i, r = {}) {
    r.timeouts || (r.timeouts = hi.timeouts), p.debug.info(`${Gt.NAME}: Get with timeout ${r.timeouts.adRequest} sec: ${e}`), this.getAsXHR(e, i, r);
  }
};
Gt.NAME = "HomadUrlHandler::";
let ji = Gt;
function Qn(c) {
  return window.location.protocol === "https:" && !c.startsWith("http://") || window.location.protocol !== "https:";
}
function Ke(c, e) {
  let i = document.createElement("ParserError");
  i.setAttribute("code", e.code.toString()), i.setAttribute("message", e.message), c.appendChild(i);
}
const li = class li {
  constructor(e) {
    e.urlRequestObserver.requestTime = Date.now(), this.adSlotTimeout = e.timeouts.adSlotRequest * 1e3, this.blockInsecureURL = e.blockInsecureURL || !1, this.callbackLoadingDone = null, this.maxWrapperDept = e.maxWrapperDepth | 10, this.urlHandlerOptions = e, this.wrapperChainTimeout = e.timeouts.adRequestChain * 1e3;
  }
  /**
   * Takes XML document and immediately returns it
   * This is just a loop through function that might touch the XML if needed
   * @param vmapDoc
   * @param callbackOnDoneLoading
   * @returns {Promise<void>}
   */
  requestXML(e, i) {
    this.callbackLoadingDone = i, this.returnVMAP(e);
  }
  /**
   * Takes URL and loads it
   * On resolve the final XMLDoc of the aggregated files will be returned
   * @param url
   * @param callbackOnDoneLoading
   * @returns {void|Promise<void>}
   */
  requestURL(e, i) {
    if (p.debug.info(li.NAME + "requestURL", e), this.callbackLoadingDone = i, this.isInsecureURL(e)) {
      let r = document.createDocumentFragment();
      return Ke(r, w.SESSION.MIXED_CONTENT), this.returnVMAP(r);
    }
    return this.loadURL(e).then((r) => {
      this.returnVMAP(r);
    });
  }
  returnVMAP(e) {
    let i = e, r = document.createDocumentFragment();
    te(e, "VMAP").length > 0 && te(e, "AdBreak").length === 0 && (Ke(r, w.VMAP.NO_ADBREAKS), i = r), te(e, "VMAP").length === 0 && te(e, "ParserError").length === 0 && (Ke(r, w.VMAP.DOCUMENT_ERROR), i = r), this.callbackLoadingDone(i);
  }
  loadURL(e) {
    return this.urlHandlerOptions.response = null, new Promise((i) => {
      new Pr().get(e, (r, s) => {
        if (!r && s && q(s, "parsererror")) {
          let l = document.createDocumentFragment();
          Ke(l, w.VMAP.EXTRACTION_ERROR), i(l);
        }
        if (r && !s) {
          let l = document.createDocumentFragment();
          p.debug.warn(li.NAME + "loadURL - XHR Request Error", r), Ke(l, r), i(l);
        } else
          i(s);
      }, this.urlHandlerOptions);
    });
  }
  isInsecureURL(e) {
    return this.blockInsecureURL && !Qn(e);
  }
};
li.NAME = "VMAPReqService::";
let vr = li;
function Jn(c) {
  if (!c || typeof c != "object")
    return !1;
  try {
    return c.self === c;
  } catch (e) {
    return !0;
  }
}
function zt(c, ...e) {
  for (const i of e)
    if (i)
      for (const r in i)
        Object.prototype.hasOwnProperty.call(i, r) && i[r] !== null && (Jn(i[r]) ? c[r] = i[r] : typeof c[r] == "object" && typeof i[r] == "object" ? c[r] = zt(c[r], i[r]) : c[r] = i[r]);
  return c;
}
function Zn() {
  return this.error || null;
}
function ot(c) {
  this.error = {
    code: c.code,
    message: c.message,
    timestamp: Date.now()
  };
}
let Fn = null;
const Vr = class Vr extends Rt {
  /**
   * @param {Object} playerFacade extended from FacadeBase
   * @param {Object} adsAPI is a reference to the session AdSlotAPI
   */
  constructor(e, i) {
    super(), this.player = e, this.config = i.config, p.debug.info(Te.NAME + "Create AdPlaylistAPI with", i.config), this.environmentVars = i.environmentVars, this.vmapSetup = null, this.adPlaylist = null, this.adPlaylistController = null, this.adSlotAPI = i, this.rawVMAPXML = null, this.error = null, this.timeouts = this.config.timeouts;
  }
  /**
   * Starts requesting a VMAP from the ad server
   *
   * @param {AdPlaylistSetup} playlistSpecs - Ad configuration for the upcoming content video.
   * @param {EnvironmentVars} environmentVars - Defines environment conditions for the upcoming ad break.
   *  https://interactiveadvertisingbureau.github.io/vast/vast4macros/vast4-macros-latest.html
   * @returns {Promise<String|Error>} Resolves if loading the VMAP has been completed
   */
  initAdPlaylist(e, i = {}) {
    this.environmentVars = Object.assign(this.environmentVars, i), p.debug.info(Te.NAME + "initAdPlaylist - with", e, this.environmentVars), this.vmapSetup = e, this.timeouts = zt(this.timeouts, this.environmentVars.timeouts), this.error = null, e.response && e.response.length > 0 && (this.vmapSetup.responseXML = new DOMParser().parseFromString(
      e.response,
      "text/xml"
    ));
    let r = null;
    this.adSlotAPI.environmentVars = this.environmentVars;
    const s = this.adSlotAPI.setupEnrichmentAndTCF();
    Fn = new ce(this.config.adReinsertion, s);
    const l = {
      adReinsertion: Fn,
      blockInsecureURL: this.config.blockInsecureURL,
      enrichment: s,
      response: this.vmapSetup.responseXML,
      timeouts: this.timeouts,
      urlhandler: this.config.urlhandler,
      withCredentials: !0,
      urlRequestObserver: {
        originTimeouts: zt({}, this.timeouts),
        initialTime: Date.now(),
        requestTime: 0,
        responseTime: 0
      }
    };
    return new Promise((h, m) => {
      r = this.addEventListener(f.ON_AD_PLAYLIST_LOAD_ERROR, () => m(this.errorAPI)), this.addEventListener(f.ON_AD_PLAYLIST_LOADED, () => (r(), this.adPlaylistController = new Te(this.adPlaylist, this.config), this.adPlaylistController.setPlayer(this.player), this.adPlaylistController.setAdsAPI(this.adSlotAPI), h("ok")));
      let g = new vr(
        l
      );
      e.tag ? g.requestURL(e.tag, this.onXMLLoadDone.bind(this, l)) : g.requestXML(l.response, this.onXMLLoadDone.bind(this, l));
    });
  }
  // any - options.adReinsertion get overwritten with AdReinsertionModel, was before a setup object
  onXMLLoadDone(e, i) {
    this.rawVMAPXML = i, this.adPlaylist = new po(i, this.vmapSetup);
    let r = this.adPlaylist.getAdPlaylist();
    p.debug.info(Te.NAME + "onXMLLoadDone and vmap parsed.", i), p.debug.table(r);
    const s = () => {
      if (!this.adPlaylist.hasPlayableAdBreaks) {
        const l = q(i, "ParserError"), h = l ? {
          code: parseInt(l.getAttribute("code"), 10),
          message: l.getAttribute("message")
        } : this.error = w.VMAP.NO_ADBREAKS;
        ot.call(this, h), super.dispatchEvent(f.ON_AD_PLAYLIST_LOAD_ERROR);
        return;
      }
      super.dispatchEvent(f.ON_AD_PLAYLIST_LOADED);
    };
    if (e.adReinsertion.reinsertionReason) {
      p.debug.info(
        Te.NAME + "onXMLLoadDone - Found reason to enable AdReinsertion",
        e.adReinsertion.reinsertionReason
      ), e.adReinsertion.enable(
        () => {
          e.adReinsertion.setReinsertionReason(null), p.debug.info(
            Te.NAME + "enable - Override default URLHandler with HOMADURLHandler."
          ), this.config.urlhandler = ji, this.initAdPlaylist(this.vmapSetup, this.environmentVars.vastMacros).catch(() => {
            s();
          });
        },
        // ERROR.SESSION.AD_REINSERTION_DECLINED
        (l) => {
          p.debug.info(Te.NAME + "enable - AdReinsertion remains disabled.", l), ot.call(this, l), s();
        }
      );
      return;
    }
    s();
  }
  /**
   * Starts playback and monitoring of the content and automatically inserts ad-slots
   * based on the `timeOffset` values of each VMAP AdBreak.
   * AdBreaks with a `timeOffset` equally to `0`, `"start"` or `"0%"` get requested immediately.
   *
   * @returns {Promise} Resolves if the playback started
   */
  startAdPlaylist() {
    super.dispatchEvent(f.ON_AD_PLAYLIST_START);
    for (const e of Object.values(f))
      this.adPlaylistController.addEventListener(e, (i) => {
        super.dispatchEvent(i.type);
      });
    return new Promise((e, i) => {
      this.adPlaylistController.beforeContent().then(() => {
        e();
      }).catch(
        /* c8 ignore start: The method beforeContent always resolves and must not prevent
        	the start of the content. It only catches runtime errors that might occur. */
        (r) => {
          i(r);
        }
        /* c8 ignore stop */
      );
    });
  }
  /**
   * Immediately stops monitoring content playback.
   * AdBreaks that have already started remain until they complete. If necessary, they must be canceled
   * via the `AdSlotAPI.stopAdSlot()`.
   *
   * @returns {Promise<void>} - Whether the ad slot could be closed and cleaned up or not.
   */
  stopAdPlaylist() {
    return this.adPlaylistController.stop(), Promise.resolve();
  }
  dispose() {
    return this.stopAdPlaylist(), Promise.resolve();
  }
  /**
   * Requests details about the most recent error that has occurred on the AdPlaylistAPI.
   *
   * @returns {error} Description object of the most recent error or `null`.
   */
  get errorAPI() {
    return Zn.call(this);
  }
  /**
   * Returns the VMAP that has been collected for the current (content) session
   *
   * @returns {XML} XML as live parsable DOM representation, querySelector and similar work on this
   */
  get rawVMAP() {
    return this.rawVMAPXML;
  }
};
Vr.NAME = "AdPlaylAPI::";
let Sr = Vr;
var fe = /* @__PURE__ */ ((c) => (c.CLOSER = "closer", c.DIVIDER = "divider", c.OPENER = "opener", c.COMMERCIAL = "commercial", c.SPONSORED = "sponsored", c))(fe || {});
class vo {
  constructor(e) {
    this.totalCommercialsDurationArray = [-1], this.totalCommercialsCurrentTimeNumber = -1, this.currentTimeOffsetNumber = 0, e && this.setManifest(e);
  }
  setManifest(e) {
    e && (this.adSlotManifest = e, this.collectCommercialsDuration());
  }
  collectCommercialsDuration() {
    this.totalCommercialsDurationArray = [0];
    for (let e = 0; e < this.adSlotManifest.length; e++) {
      let i = this.adSlotManifest[e];
      !i.isLinear || i.variant !== fe.COMMERCIAL || this.totalCommercialsDurationArray.push(i.duration);
    }
    this.totalCommercialsDurationArray.reduce((e, i) => e + i) === 0 && (this.totalCommercialsDurationArray = [-1]), console.log(
      "AdSloDel::AdSlotTimes.totalCommercialsDuration initial",
      this.totalCommercialsDurationArray.reduce((e, i) => e + i)
    );
  }
  get totalCommercialsDuration() {
    return this.totalCommercialsDurationArray.reduce((e, i) => e + i);
  }
  // Note: `set...` means we "add" these seconds to the existing duration
  setTotalCommercialsDuration(e) {
    this.totalCommercialsDurationArray[0] === -1 ? this.totalCommercialsDurationArray[0] = e : this.totalCommercialsDurationArray.push(e);
  }
  get totalCommercialsCurrentTime() {
    return this.totalCommercialsCurrentTimeNumber;
  }
  setCommercialsCurrentTime(e) {
    this.totalCommercialsCurrentTimeNumber = e;
  }
  get currentTimeOffset() {
    return this.currentTimeOffsetNumber;
  }
  setCurrentTimeOffset(e) {
    this.currentTimeOffsetNumber = e;
  }
}
const de = {
  CLICK_THRU: "Creative:clickThru",
  COLLAPSE_NONLINEAR: "Creative:collapseNonlinear",
  EXPAND_NONLINEAR: "Creative:expandNonlinear",
  FATAL_ERROR: "Creative:fatalError",
  GET_MEDIA_STATE: "Creative:getMediaState",
  LOG: "Creative:log",
  READY: "Creative:ready",
  REPORT_TRACKING: "Creative:reportTracking",
  REQUEST_CHANGE_AD_DURATION: "Creative:requestChangeAdDuration",
  REQUEST_FULL_SCREEN: "Creative:requestFullScreen",
  REQUEST_PAUSE: "Creative:requestPause",
  REQUEST_PLAY: "Creative:requestPlay",
  REQUEST_RESIZE: "Creative:requestResize",
  REQUEST_SKIP: "Creative:requestSkip",
  REQUEST_STOP: "Creative:requestStop",
  REQUEST_VIDEO_LOCATION: "Creative:requestVideoLocation",
  REQUEST_VOLUME: "Creative:requestVolume"
}, st = {
  DURATION_CHANGE: "Media:durationchange",
  ENDED: "Media:ended",
  ERROR: "Media:error",
  PAUSE: "Media:pause",
  PLAY: "Media:play",
  PLAYING: "Media:playing",
  SEEKED: "Media:seeked",
  SEEKING: "Media:seeking",
  TIME_UPDATE: "Media:timeupdate",
  VOLUME_CHANGE: "Media:volumechange"
}, at = {
  AD_SKIPPED: "Player:adSkipped",
  AD_STOPPED: "Player:adStopped",
  FATAL_ERROR: "Player:fatalError",
  INIT: "Player:init",
  LOG: "Player:log",
  START_CREATIVE: "Player:startCreative"
}, Ye = {
  CREATE_SESSION: "createSession",
  REJECT: "reject",
  RESOLVE: "resolve"
}, di = class di extends p {
  /** playerElement is needed for multiple instances support
   * @param {Element} playerElement where the simid ad get played
   */
  constructor(e) {
    super(), this.listeners = {}, this.resolutionListeners = {}, this.eventsThatRequireResponse = [
      de.CLICK_THRU,
      de.GET_MEDIA_STATE,
      de.READY,
      de.REPORT_TRACKING,
      de.REQUEST_CHANGE_AD_DURATION,
      de.REQUEST_FULL_SCREEN,
      de.REQUEST_PAUSE,
      de.REQUEST_PLAY,
      de.REQUEST_RESIZE,
      de.REQUEST_SKIP,
      de.REQUEST_STOP,
      de.REQUEST_VIDEO_LOCATION,
      de.REQUEST_VOLUME,
      at.AD_SKIPPED,
      at.AD_STOPPED,
      at.FATAL_ERROR,
      at.INIT,
      at.START_CREATIVE,
      Ye.CREATE_SESSION
    ], this.listeners = {}, this.sessionId = "", this.nextMessageId = 1, this.target = e.ownerDocument.defaultView, this.target.addEventListener(
      "message",
      this.receiveMessage.bind(this),
      !1
    ), this.resolutionListeners = {};
  }
  /* Reverts this protocol to its original state */
  reset() {
    this.listeners = {}, this.sessionId = "", this.nextMessageId = 1, this.resolutionListeners = {};
  }
  /**
   * Sends a message using post message.
   * Returns a promise that will resolve or reject after the message receives a response.
   * @param {string} messageType The name of the message
   * @param {?Object} messageArgs The arguments for the message, may be null.
   * @return {!Promise} Promise that will be fulfilled when client resolves or rejects.
   */
  sendMessage(e, i) {
    const r = this.nextMessageId++, s = e === Ye.CREATE_SESSION ? e : "SIMID:" + e, l = {
      sessionId: this.sessionId,
      messageId: r,
      type: s,
      timestamp: Date.now(),
      args: i
    };
    return this.eventsThatRequireResponse.includes(e) ? new Promise((h, m) => {
      this.addResolveRejectListener(r, h, m), this.target.postMessage(JSON.stringify(l), "*");
    }) : new Promise((h) => {
      this.target.postMessage(JSON.stringify(l), "*"), h();
    });
  }
  /**
   * Adds a listener for a given message.
   */
  addListener(e, i) {
    this.listeners[e] ? this.listeners[e].push(i) : this.listeners[e] = [i];
  }
  isResolve(e) {
    return e.type === Ye.RESOLVE;
  }
  addResolveRejectListener(e, i, r) {
    const s = (l) => {
      this.isResolve(l) ? i(l.args.value) : r(l.args.value);
    };
    this.resolutionListeners[e] = s.bind(this);
  }
  parseData(e) {
    try {
      return JSON.parse(e);
    } catch (i) {
      return null;
    }
  }
  callListeners(e, i) {
    const r = this.listeners[e];
    if (r)
      for (let s = 0; s < r.length; s++)
        r[s](i);
  }
  // eslint-disable-next-line complexity
  isValidSession(e) {
    const i = e.sessionId, r = e.type, s = this.sessionId === "" && r === Ye.CREATE_SESSION, l = this.sessionId === i;
    if (!(!(s || l) || r === null)) {
      if (Object.values(Ye).includes(r))
        this.handleProtocolMessage(e);
      else if (r.startsWith("SIMID:")) {
        const m = r.substring(6);
        this.callListeners(m, e);
      }
    }
  }
  /**
   * Receives messages from either the player or creative.
   */
  receiveMessage(e) {
    if (!e || !e.data)
      return;
    let i = this.parseData(e.data);
    i && this.isValidSession(i);
  }
  handleProtocolMessage(e) {
    const i = e.type;
    switch (i) {
      case Ye.CREATE_SESSION:
        this.sessionId = e.sessionId, this.resolve(e, {}), this.callListeners(i, e);
        break;
      case Ye.RESOLVE:
      // intentional fallthrough
      case Ye.REJECT:
        const s = e.args.messageId, l = this.resolutionListeners[s];
        l && (l(e), delete this.resolutionListeners[s]);
        break;
    }
  }
  /**
   * Resolves an incoming message.
   * @param {!Object} incomingMessage the message that is being resolved.
   * @param {!Object} outgoingArgs Any arguments that are part of the resolution.
   */
  resolve(e, i) {
    const r = this.nextMessageId++, s = {
      messageId: e.messageId,
      value: i
    }, l = {
      sessionId: this.sessionId,
      messageId: r,
      type: Ye.RESOLVE,
      timestamp: Date.now(),
      args: s
    };
    this.target.postMessage(JSON.stringify(l), "*");
  }
  /**
   * Rejects an incoming message.
   * @param {!Object} incomingMessage the message that is being resolved.
   * @param {!Object} outgoingArgs Any arguments that are part of the resolution.
   */
  reject(e, i) {
    const r = this.nextMessageId++, s = {
      messageId: e.messageId,
      value: i
    }, l = {
      sessionId: this.sessionId,
      messageId: r,
      type: Ye.REJECT,
      timestamp: Date.now(),
      args: s
    };
    this.target.postMessage(JSON.stringify(l), "*");
  }
  /**
   * Creates a new session.
   * @return {!Promise} The promise from the create session message.
   */
  createSession() {
    const e = () => {
      p.debug.info(di.NAME + "createSession resolve");
    }, i = () => {
      p.debug.info(di.NAME + "createSession reject");
    };
    this.generateSessionId(), this.sendMessage(Ye.CREATE_SESSION, {}).then(
      e,
      i
    );
  }
  generateSessionId() {
    const e = new Uint8Array(16);
    window.crypto.getRandomValues(e), e[6] = e[6] & 15 | 64, e[8] = e[8] & 63 | 128;
    let i = "", r;
    for (r = 0; r < 16; r++)
      i += (r === 4 || r === 6 || r === 8 || r === 10 ? "-" : "") + e[r].toString(16);
    this.sessionId = i;
  }
  setMessageTarget(e) {
    this.target = e;
  }
};
di.NAME = "SIMIDPtl::";
let yr = di;
function It(c, e) {
  let i = document.createElement(c);
  if (e)
    for (const r in e)
      Object.prototype.hasOwnProperty.call(e, r) && i.setAttribute(r, e[r]);
  return i;
}
const xi = {
  PLAYBACK_AREA_UNUSABLE: 1102,
  EXPAND_NOT_POSSIBLE: 1105
}, $n = {
  UNSUPPORTED_TIME: 1202,
  VIDEO_COULD_NOT_LOAD: 1206
}, Pt = {
  MEDIA_PLAYBACK_COMPLETE: 2,
  PLAYER_INITATED: 3,
  CREATIVE_INITIATED: 4,
  NON_LINEAR_DURATION_COMPLETE: 5
}, si = 0, mr = -2, So = !0, Ve = class Ve {
  /**
   * Sets up the creative iframe and starts listening for messages
   * from the creative.
   * @param {Object} adSlotController. - contains all current ad information.
   */
  constructor(e) {
    this.adSlotController = e, this.currentAd = e.currentAd, this.creativeAsset = e.currentAd.properCreative.selectedCreativeFile, this.mediaAsset = e.currentAd.properCreative.selectedMediaFile, this.playerFacade = e.player, this.loadedSource = null, this.simidProtocol = new yr(this.playerFacade.getPlayerElement()), this.addListeners(), this.initializationPromise = null, this.videoTrackingEvents = /* @__PURE__ */ new Map(), this.isLinearAd = this.mediaAsset.linearity === "linear", this.nonLinearStartTime = null, this.requestedDuration = si, this.resolveSessionCreatedPromise = null, this.sessionCreatedPromise = new Promise((i) => {
      this.resolveSessionCreatedPromise = i;
    }), this.resolveInitializationPromise = null, this.rejectInitializationPromise = null, this.requestedDuration = si, this.nonLinearDimensions = null, this.initializationPromise = new Promise((i, r) => {
      this.resolveInitializationPromise = i, this.rejectInitializationPromise = r;
    }), this.IFrame = null, this.trackEventsOnAdVideoElement();
  }
  /**
   * Initializes an ad. This should be called before an ad plays.
   * Creates an iframe with the creative in it, then uses a promise
   * to call init on the creative as soon as the creative initializes
   * a session.
   */
  initializeAd() {
    if (!this.isLinearAd && !this.isValidDimensions(this.getNonlinearDimensions())) {
      p.debug.info(
        Ve.NAME + "initializeAd - nonLinear ad with bigger dimensions than the player."
      );
      return;
    }
    this.IFrame = this.createIFrame(), this.isLinearAd || this.displayNonlinearCreative(), this.initializationPromise.catch((e) => {
      this.onAdInitializedFailed(e);
    }), this.sessionCreatedPromise.then(() => {
      this.sendInitMessage(), this.initializationPromise.then(() => {
        this.startCreativePlayback();
      });
    });
  }
  addContainer(e) {
    this.container = It("div", {
      id: "container--simid"
    }), e.parentNode && e.parentNode.insertBefore(this.container, e.nextSibling);
  }
  createIFrame() {
    this.addContainer(this.playerFacade.getPlayerElement());
    const e = document.createElement("iframe");
    if (p.debug.info(Ve.NAME + "createSimidIframe with", this.creativeAsset), e.style.display = "none", this.container.appendChild(e), this.creativeAsset.resource) {
      const i = new Blob([this.creativeAsset.resource], { type: "text/html" });
      e.src = URL.createObjectURL(i);
    } else
      e.src = this.creativeAsset.fileURL;
    return this.simidProtocol.setMessageTarget(e.contentWindow), e;
  }
  addListeners() {
    this.simidProtocol.addListener(Ye.CREATE_SESSION, this.onSessionCreated.bind(this)), this.simidProtocol.addListener(de.CLICK_THRU, this.onReqClickThu.bind(this)), this.simidProtocol.addListener(de.REQUEST_FULL_SCREEN, this.onReqFullScreen.bind(this)), this.simidProtocol.addListener(de.REQUEST_PLAY, this.onReqPlay.bind(this)), this.simidProtocol.addListener(de.REQUEST_PAUSE, this.onReqPause.bind(this)), this.simidProtocol.addListener(de.FATAL_ERROR, this.onCreativeFatalError.bind(this)), this.simidProtocol.addListener(de.REQUEST_SKIP, this.onReqSkip.bind(this)), this.simidProtocol.addListener(de.REQUEST_STOP, this.onReqStop.bind(this)), this.simidProtocol.addListener(
      de.REQUEST_CHANGE_AD_DURATION,
      this.onReqChangeAdDuration.bind(this)
    ), this.simidProtocol.addListener(de.GET_MEDIA_STATE, this.onGetMediaState.bind(this)), this.simidProtocol.addListener(de.LOG, this.onReceiveCreativeLog.bind(this)), this.simidProtocol.addListener(de.EXPAND_NONLINEAR, this.onExpandResize.bind(this)), this.simidProtocol.addListener(de.COLLAPSE_NONLINEAR, this.onCollapse.bind(this)), this.simidProtocol.addListener(de.REQUEST_RESIZE, this.onReqResize.bind(this));
  }
  onSessionCreated() {
    this.resolveSessionCreatedPromise();
  }
  destroyIFrame() {
    this.IFrame && (this.IFrame.parentNode.remove(), this.IFrame = null, this.simidProtocol.reset());
    for (let [e, i] of this.videoTrackingEvents)
      this.playerFacade.removeEventListener(e, i);
    this.videoTrackingEvents.clear();
  }
  getFullDimensions() {
    const e = this.playerFacade.getPlayerSize().boundingRect;
    return {
      x: 0,
      y: 0,
      width: e.width,
      height: e.height
    };
  }
  isValidDimensions(e) {
    const i = this.playerFacade.getPlayerSize().boundingRect, r = e.y + e.height <= i.height, s = e.x + e.width <= i.width;
    return r && s;
  }
  getNonlinearDimensions() {
    return this.nonLinearDimensions ? this.nonLinearDimensions : {
      // nonLinear ad-container is over playerControls!
      height: this.currentAd.properCreative.selectedMediaFile.height,
      width: this.currentAd.properCreative.selectedMediaFile.width,
      x: this.playerFacade.getPlayerSize().boundingRect.x + 100,
      y: this.playerFacade.getPlayerSize().boundingRect.y
    };
  }
  pause() {
    this.playerFacade.pause();
  }
  play() {
    this.playerFacade.play();
  }
  displayNonlinearCreative() {
    const e = this.getNonlinearDimensions();
    if (!this.isValidDimensions(e)) {
      p.debug.info("Unable to play a non-linear ad with dimensions bigger than the player. Please modify dimensions to a smaller size.");
      return;
    }
    this.setIFrameDimensions(e), this.IFrame.style.position = "absolute", this.play(), this.requestedDuration = this.currentAd.duration;
  }
  setIFrameDimensions(e) {
    p.debug.info(Ve.NAME + "resize", e), this.IFrame.style.height = e.height.toString(), this.IFrame.style.width = e.width.toString(), this.IFrame.style.left = `${e.x}px`, this.IFrame.style.top = `${e.y}px`, this.adSlotController.dispatchEvent(f.ON_AD_SIZE_CHANGED);
  }
  resolve(e) {
    this.simidProtocol.resolve(e);
  }
  reject(e, i) {
    this.simidProtocol.reject(e, i);
  }
  /**
   * The creative wants to expand the ad.
   * @param {!Object} incomingMessage Message sent from the creative to the player
   */
  onExpandResize(e) {
    if (this.isLinearAd) {
      const i = {
        errorCode: xi.EXPAND_NOT_POSSIBLE,
        message: "Linear resize not yet supported."
      };
      this.reject(e, i), p.debug.info(i.message);
    } else {
      const i = this.getFullDimensions();
      this.setIFrameDimensions(i), this.pause(), this.resolve(e);
    }
  }
  /**
   * The creative wants to collapse the ad.
   * @param {!Object} incomingMessage Message sent from the creative to the player
   */
  onCollapse(e) {
    const i = this.getNonlinearDimensions();
    if (this.isLinearAd) {
      const r = {
        message: "Cannot collapse linear ads."
      };
      this.reject(e, r), p.debug.info(r.message);
    } else if (this.isValidDimensions(i))
      this.setIFrameDimensions(i), this.IFrame.style.position = "absolute", this.play(), this.resolve(e);
    else {
      const r = {
        message: "Unable to collapse to dimensions bigger than the player. Please modify dimensions to a smaller size."
      };
      this.reject(e, r), p.debug.info(r.message);
    }
  }
  /**
   * The creative wants to resize the ad.
   * @param {!Object} incomingMessage Message sent from the creative to the player.
   */
  onReqResize(e) {
    let i = "onRequestResize - error:";
    if (this.isLinearAd) {
      const r = {
        errorCode: xi.EXPAND_NOT_POSSIBLE,
        message: "Linear resize not yet supported."
      };
      this.reject(e, r), p.debug.error(Ve.NAME + i, r.message);
    } else if (this.isValidDimensions(e.args.creativeDimensions))
      this.nonLinearDimensions = e.args.creativeDimensions, this.setIFrameDimensions(e.args.creativeDimensions), this.resolve(e);
    else {
      const r = {
        errorCode: xi.EXPAND_NOT_POSSIBLE,
        message: "Unable to resize a non-linear ad with dimensions bigger than the player. Please modify dimensions to a smaller size."
      };
      this.reject(e, r), p.debug.error(Ve.NAME + i, r.message);
    }
  }
  sendInitMessage() {
    const e = this.getFullDimensions(), i = this.isLinearAd ? this.getFullDimensions() : this.getNonlinearDimensions(), r = {
      videoDimensions: e,
      creativeDimensions: i,
      fullscreen: !1,
      fullscreenAllowed: !0,
      variableDurationAllowed: !0,
      skippableState: "adHandles",
      // This player does not render a skip button.
      siteUrl: document.location.host,
      appId: "",
      // This is not relevant on desktop
      useragent: "",
      // This should be filled in for sdks and players
      deviceId: "",
      // This should be filled in on mobile
      muted: this.playerFacade.isMuted(),
      volume: this.playerFacade.volume
    }, s = {
      adParameters: this.creativeAsset.adParameters,
      // These values should be populated from the VAST response.
      adId: this.currentAd.id,
      creativeId: "",
      adServingId: "",
      clickThroughUrl: this.currentAd.clickThroughURL,
      duration: 0
    };
    this.isLinearAd || (s.duration = this.currentAd.duration);
    const l = {
      environmentData: r,
      creativeData: s
    };
    this.simidProtocol.sendMessage(at.INIT, l).then(() => {
      this.resolveInitializationPromise(), p.debug.info(Ve.NAME + "session created");
    }).catch((m) => {
      this.rejectInitializationPromise(m);
    });
  }
  startCreativePlayback() {
    this.showIFrame(), this.isLinearAd ? this.adSlotController.dispatchEvent(f.ON_AD_STARTED) : (this.nonLinearStartTime = this.playerFacade.getContentCurrentTime(), this.play()), p.debug.info(Ve.NAME + "startCreativePlayback"), this.simidProtocol.sendMessage(at.START_CREATIVE);
  }
  onAdInitializedFailed(e) {
    this.setError(w.SESSION.MANIFEST_LOAD_FAILED), this.adSlotController.dispatchEvent(f.ON_SIMID_ERROR), this.adSlotController.cancelAdWithError(), p.debug.error(Ve.NAME + "onAdInitializedFailed", JSON.stringify(e)), this.destroyIframeAndResumeContent();
  }
  hideIFrame() {
    this.IFrame.style.display = "none";
  }
  showIFrame() {
    this.IFrame.style.bottom = "0", this.IFrame.style.display = "block", this.IFrame.style.height = "100%", this.IFrame.style.left = "0", this.IFrame.style.position = "absolute", this.IFrame.style.width = "100%";
  }
  setCreativeControlsState(e) {
    let i = te(document, ".ad_request");
    if (i)
      for (let r of i)
        r.disabled = e;
  }
  trackEventsOnAdVideoElement() {
    this.videoTrackingEvents.set("ended", this.videoComplete.bind(this)), this.videoTrackingEvents.set("error", () => {
      this.simidProtocol.sendMessage(
        st.ERROR,
        {
          error: w.SIMID.GENERAL_ERROR.code,
          message: w.SIMID.GENERAL_ERROR.message
        }
      ), this.currentAd.error = w.SIMID.GENERAL_ERROR, this.adSlotController.cancelAdWithError();
    }), this.videoTrackingEvents.set("pause", () => {
      this.simidProtocol.sendMessage(st.PAUSE);
    }), this.videoTrackingEvents.set("play", () => {
      this.simidProtocol.sendMessage(st.PLAY);
    }), this.videoTrackingEvents.set("playing", () => {
      this.simidProtocol.sendMessage(st.PLAYING);
    }), this.videoTrackingEvents.set("seeked", () => {
      this.simidProtocol.sendMessage(st.SEEKED);
    }), this.videoTrackingEvents.set("seeking", () => {
      this.simidProtocol.sendMessage(st.SEEKING);
    }), this.videoTrackingEvents.set(Be.ON_TIME_UPDATED, () => {
      this.simidProtocol.sendMessage(
        st.TIME_UPDATE,
        { currentTime: this.playerFacade.getAdCurrentTime() }
      ), this.compareAdAndReqDurations(), this.simidProtocol.sendMessage(
        st.DURATION_CHANGE,
        { duration: this.playerFacade.getAdDuration() }
      ), this.nonLinearStartTime !== null && this.playerFacade.getContentCurrentTime() - this.nonLinearStartTime > this.requestedDuration && this.stopAd(Pt.NON_LINEAR_DURATION_COMPLETE);
    }), this.videoTrackingEvents.set("volumechange", () => {
      this.simidProtocol.sendMessage(
        st.VOLUME_CHANGE,
        { volume: this.playerFacade.getVolume() }
      );
    });
    for (let [e, i] of this.videoTrackingEvents)
      this.playerFacade.addEventListener(e, i);
  }
  /**
   * Stops the ad and destroys the ad iframe.
   * @param {number} reason The reason the ad will stop.
   */
  stopAd(e = Pt.PLAYER_INITATED) {
    this.IFrame && (this.hideIFrame(), this.loadedSource = null, this.simidProtocol.sendMessage(at.AD_STOPPED).then(() => {
      p.debug.info(Ve.NAME + "stopAd-destroy reason", e), this.destroyIframeAndResumeContent();
    }));
  }
  /**
   * Skips the ad and destroys the ad iframe.
   */
  skipAd() {
    this.hideIFrame(), this.simidProtocol.sendMessage(at.AD_SKIPPED).then(() => this.destroyIframeAndResumeContent()), this.adSlotController.dispatchEvent(f.ON_AD_SKIPPED), this.loadedSource = null;
  }
  destroyIframeAndResumeContent() {
    this.destroyIFrame(), this.setCreativeControlsState(So), this.adSlotController.dispatchEvent(f.ON_AD_STOPPED);
  }
  /** The creative wants to go full screen. */
  onReqFullScreen(e) {
    p.debug.info(Ve.NAME + "onReqFullScreen", e);
    let i;
    this.IFrame && (i = this.IFrame.requestFullscreen);
    let r = i == null ? void 0 : i();
    r ? r.then(() => this.resolve(e)) : this.resolve(e);
  }
  onReqClickThu(e) {
    e.args && e.args.playerHandles && this.pause(), this.adSlotController.onClickThrough(!1);
  }
  /** The creative wants to play video. */
  onReqPlay(e) {
    if (this.isLinearAd) {
      if (this.loadedSource === this.mediaAsset.fileURL)
        return this.play(), this.simidProtocol.resolve(e, {});
      this.playerFacade.load(this.mediaAsset.fileURL).then(() => (this.loadedSource = this.mediaAsset.fileURL, this.simidProtocol.resolve(e, {}))).catch(() => {
        const i = {
          errorCode: $n.VIDEO_COULD_NOT_LOAD,
          message: "The SIMID media could not be loaded."
        };
        this.reject(e, i);
      });
    } else {
      const i = {
        errorCode: xi.PLAYBACK_AREA_UNUSABLE,
        message: "Non linear ads do not play video."
      };
      this.reject(e, i);
    }
  }
  /** The creative wants to pause video. */
  onReqPause(e) {
    this.pause(), this.resolve(e);
  }
  /** The creative wants to stop with a fatal error. */
  onCreativeFatalError(e) {
    this.resolve(e), this.stopAd(Pt.CREATIVE_INITIATED);
  }
  /** The creative wants to skip this ad. */
  onReqSkip(e) {
    this.resolve(e), this.skipAd();
  }
  /** The creative wants to stop the ad early. */
  onReqStop(e) {
    this.resolve(e), this.stopAd(Pt.CREATIVE_INITIATED);
  }
  /**
   * The player must implement sending tracking pixels from the creative.
   * This sample implementation does not show how to send tracking pixels or
   * replace macros. That should be done using the players standard workflow.
   */
  onReportTracking(e) {
    const i = e.args.trackingUrls;
    p.debug.info(Ve.NAME + "onReportTracking -  Creative has asked the player to send a ping."), p.debug.table(i);
  }
  videoComplete() {
    if (this.simidProtocol.sendMessage(st.ENDED), this.requestedDuration === si && this.stopAd(Pt.MEDIA_PLAYBACK_COMPLETE), this.requestedDuration !== si && this.requestedDuration !== mr) {
      const e = (this.requestedDuration - this.playerFacade.getAdDuration()) * 1e3;
      setTimeout(() => {
        this.stopAd(Pt.CREATIVE_INITIATED);
      }, e);
    }
  }
  onReqChangeAdDuration(e) {
    const i = e.args.duration;
    if (i !== mr && i < 0) {
      const r = {
        errorCode: $n.UNSUPPORTED_TIME,
        message: "A negative duration is not valid."
      };
      this.simidProtocol.reject(e, r);
    } else
      this.requestedDuration = i, this.compareAdAndReqDurations(), this.resolve(e);
  }
  compareAdAndReqDurations() {
    this.requestedDuration === si || this.requestedDuration === mr || this.playerFacade.getAdCurrentTime() >= this.requestedDuration && (p.debug.info("Creative requested a duration shorter than the ad", this.requestedDuration), this.stopAd(Pt.CREATIVE_INITIATED));
  }
  /**
   * Sets the error of the ad that can occur during the player process.
   * @param errorObject contains VAST error code and message.
   */
  setError(e) {
    this.currentAd.error = {
      code: e.code,
      message: e.message,
      timestamp: Date.now()
    };
  }
  onGetMediaState(e) {
    const i = {
      currentSrc: this.playerFacade.getCurrentContentSource(),
      currentTime: this.playerFacade.getContentCurrentTime(),
      duration: this.playerFacade.getContentDuration(),
      ended: this.playerFacade.getContentCurrentTime() >= this.playerFacade.getContentDuration(),
      muted: this.playerFacade.isMuted(),
      paused: this.playerFacade.paused,
      volume: this.playerFacade.getVolume(),
      fullscreen: this.playerFacade.isFullscreen()
    };
    this.simidProtocol.resolve(e, i);
  }
  onReceiveCreativeLog(e) {
    e.args.message;
  }
  sendLog(e) {
    const i = {
      message: e
    };
    this.simidProtocol.sendMessage(at.LOG, i);
  }
};
Ve.NAME = "SIMIDPly::";
let Ir = Ve;
function jn(c) {
  return c.height >= 0 ? c.y + c.height : c.y;
}
function Bn(c) {
  return c.width >= 0 ? c.x : c.x + c.width;
}
function Hn(c) {
  return c.width >= 0 ? c.x + c.width : c.x;
}
function Wn(c) {
  return c.height >= 0 ? c.y : c.y + c.height;
}
function yo(c, e) {
  let i = 0, r = {
    bottom: Math.min(jn(c), jn(e)),
    height: 0,
    left: Math.max(Bn(c), Bn(e)),
    right: Math.min(Hn(c), Hn(e)),
    top: Math.max(Wn(c), Wn(e)),
    width: 0
  };
  r.width = r.right - r.left, r.height = r.bottom - r.top;
  let s = c.width * c.height, l = r.width * r.height;
  return l > 0 && (i = l / s), i;
}
class Io {
  /**
   * @param {Object} adSlotController to get adSlotEvents and control the viewability process with them and
   *  currentAd.config includes area and time as setup
   * area - how many pixels in percent of the ad should be visible from the viewer
   * time - how long the viewer must have seen the ad
   */
  constructor(e) {
    this.adSlotController = e, this.interval = null, this.notViewableDispatched = !1, this.removeEventHandlers = [], this.startAdTime = null, this.viewabilityConfig = this.adSlotController.currentAd.config.viewability, this.viewabilityFinished = !1, this.addEventListeners();
  }
  addEventListeners() {
    this.removeEventListeners();
    for (const e of Object.values(f)) {
      let i = this.adSlotController.addEventListener(
        e,
        this.handleAdEvent.bind(this)
      );
      this.removeEventHandlers.push(i);
    }
  }
  removeEventListeners() {
    for (const e of this.removeEventHandlers)
      e();
    this.removeEventHandlers = [];
  }
  handleAdEvent(e) {
    switch (e.type) {
      case f.ON_AD_PAUSED:
        clearInterval(this.interval);
        break;
      case f.ON_AD_PLAYBACK_START:
      case f.ON_AD_PLAYING:
        this.startAdTime = null, this.notViewableDispatched = !1, this.adVisibilityControl(), clearInterval(this.interval), this.interval = setInterval(() => {
          this.adVisibilityControl();
        }, 250);
        break;
      case f.ON_AD_PLAYBACK_FINISHED:
      case f.ON_AD_SKIPPED:
      case f.ON_AD_STOPPED:
        clearInterval(this.interval), !this.viewabilityFinished && !this.notViewableDispatched && (this.notViewableDispatched = !0, this.adSlotController.dispatchEvent(f.ON_AD_NOT_VIEWABLE)), this.removeEventListeners(), this.adSlotController.viewability = null;
        break;
    }
  }
  adVisibilityControl() {
    let e = this.adSlotController.player.getPlayerSize(), i = this.adSlotController.player.getViewportSize();
    if (e.boundingRect.height === 0 && e.boundingRect.width === 0 || i.boundingRect.height === 0 && i.boundingRect.width === 0) {
      this.removeEventListeners(), this.adSlotController.dispatchEvent(f.ON_AD_VIEWABLE_UNDETERMINED);
      return;
    }
    let r = yo(e.boundingRect, i.boundingRect) * 100;
    r > this.viewabilityConfig.area ? this.startAdTime === null && this.adSlotController.currentAd ? (this.startAdTime = Date.now(), this.adSlotController.currentAd.viewability = {
      state: !0,
      threshold: this.viewabilityConfig.area,
      value: r
    }, this.adSlotController.dispatchEvent(f.ON_AD_VIEWABLE_STATE_CHANGE)) : Date.now() - this.startAdTime > this.viewabilityConfig.time * 1e3 && !this.viewabilityFinished && (p.debug.info("[Viewability] tracker time reached", Date.now()), this.viewabilityFinished = !0, this.adSlotController.dispatchEvent(f.ON_AD_VIEWABLE)) : (this.startAdTime !== null && (this.adSlotController.currentAd.viewability = {
      state: !1,
      threshold: this.viewabilityConfig.area,
      value: r
    }, this.adSlotController.dispatchEvent(f.ON_AD_VIEWABLE_STATE_CHANGE)), this.startAdTime = null);
  }
}
function Oo(c, e, i) {
  return new Promise((r) => {
    let s = It("iframe", {
      id: c,
      style: e
    });
    s.onload = () => {
      let l = It("script", {
        type: "text/javascript"
      });
      l.innerHTML = "var inDapIF = true;", s.contentDocument.body.appendChild(l);
      let h = It("style", {});
      h.innerHTML = "html,body{margin:0;}", s.contentDocument.body.appendChild(h), r(s);
    }, i.insertBefore(s, i.firstChild);
  });
}
const K = class K extends Rt {
  // ms
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  constructor(e, i) {
    super(), this.callbacks = null, this.currentAd = i, this.config = i.config, this.container = null, this.durationTime = 0, this.debugTiming = [], this.debugTiming.push({
      event: "constructor",
      time: Date.now()
    }), this.defaultElementStyle = "position:absolute;top:0;left:0;width:100%;height:100%;", this.defaultIFrameStyle = "position:absolute;top:0;left:0;width:0;height:0;overflow:hidden;border:none;visibility:hidden;", this.friendlyIFrame = null, this.height = e.getBoundingClientRect().height, this.log = p.logLevel === lt.NORMAL || p.logLevel === lt.VERBOSE, this.progressInterval = 0, this.remaining = 0, this.resource = i.isLinear ? i.properCreative.selectedMediaFile : i.properCreative.variations[0], this.slot = It("div", {
      id: "container--vpaid__slot",
      style: this.defaultElementStyle + "overflow:hidden;"
    }), this.timeoutAdLoadedTimer = null, this.timeoutScriptLoadTimer = null, this.videoElement = e, this.videoSlot = null, this.width = e.getBoundingClientRect().width, this.vpaidAd = null, this.vpaidScript = null, this.width = e.getBoundingClientRect().width, this.addContainer(e), Oo(
      "container--vpaid__iframe",
      this.defaultIFrameStyle,
      this.container
    ).then((r) => {
      this.friendlyIFrame = r, this.debugTiming.push({
        event: "addFriendlyIFrame.done",
        time: Date.now()
      }), this.addSlots(), this.load();
    });
  }
  addContainer(e) {
    this.container = It("div", {
      id: "container--vpaid",
      style: this.defaultElementStyle + "z-index:100;"
    }), e.parentNode.insertBefore(this.container, e.nextSibling);
  }
  addSlots() {
    this.debugTiming.push({
      event: "addSlots.start",
      time: Date.now()
    }), this.config.shareVideoElementWithVPAID || (this.videoSlot = It("video", {
      id: "container--vpaid__videoslot",
      style: this.defaultElementStyle
    }), this.videoSlot.muted = !0, this.friendlyIFrame.contentDocument.body.appendChild(this.videoSlot)), this.friendlyIFrame.contentDocument.body.appendChild(this.slot), this.debugTiming.push({
      event: "addSlots.done",
      time: Date.now()
    });
  }
  load() {
    this.debugTiming.push({
      event: "vpaidScriptLoad.start",
      time: Date.now()
    }), this.vpaidScript = It("script", {
      type: "text/javascript",
      src: this.currentAd.isLinear ? this.resource.fileURL : this.resource.selectedResource.resource
    }), this.timeoutScriptLoadTimer = setTimeout(() => {
      this.guardScriptLoadFail();
    }, this.config.timeouts.vpaidRequest * 1e3), this.vpaidScript.onload = () => {
      clearTimeout(this.timeoutScriptLoadTimer), this.debugTiming.push({
        event: "vpaidScriptLoad.done -- maxTime:" + this.config.timeouts.vpaidRequest,
        time: Date.now()
      }), this.getVPAIDAd() && this.isValidHandshake() && (this.subscribeToVPAIDAd(), this.initAd());
    }, this.vpaidScript.onerror = (e) => {
      p.debug.warn(K.NAME + "load - Creative loading error.", e), clearTimeout(this.timeoutScriptLoadTimer), this.debugTiming.push({
        event: "vpaidScriptLoad.failed -- maxTime:" + this.config.timeouts.vpaidRequest,
        time: Date.now()
      }), this.currentAd.error = w.VAST.FILE_NOT_FOUND, this.currentAd.enrichment.set("ERRORCODE", this.currentAd.error.code), this.onAdError("vpaidRequest failed", this.config.timeouts.vpaidRequest);
    }, this.friendlyIFrame.contentDocument.body.appendChild(this.vpaidScript);
  }
  getVPAIDAd() {
    let e = this.friendlyIFrame.contentWindow.getVPAIDAd;
    return e && typeof e == "function" ? (this.vpaidAd = e(), p.debug.info(
      K.NAME + "getVPAIDAd - available properties - preHandshake:",
      Object.keys(this.vpaidAd)
    ), !0) : (p.debug.info(K.NAME + "getVPAIDAd - not implemented - not a valid VPAID creative"), !1);
  }
  isValidHandshake() {
    if (this.functionExistsOnVPAIDAd("handshakeVersion")) {
      let e = this.vpaidAd.handshakeVersion("2.0") + "", i = parseInt(e.split(".")[0], 10);
      return p.debug.info(
        K.NAME + "isValidHandshake -- handshakeVersion:",
        e,
        "majorVersion:",
        i
      ), p.debug.info(
        K.NAME + "getVPAIDAd - available properties - afterHandshake:",
        Object.keys(this.vpaidAd)
      ), i <= 2;
    }
    return !1;
  }
  getCreativeData() {
    return { AdParameters: this.resource.adParameters };
  }
  getEnvironmentVars() {
    return {
      slot: this.slot,
      videoSlot: this.config.shareVideoElementWithVPAID ? this.videoElement : this.videoSlot
    };
  }
  initAd() {
    this.debugTiming.push({
      event: "initAd.start",
      time: Date.now()
    }), p.debug.info(
      K.NAME + "initAd -- this.config.shareVideoElementWithVPAID",
      this.config.shareVideoElementWithVPAID
    ), this.functionExistsOnVPAIDAd("initAd") && (this.timeoutAdLoadedTimer = setTimeout(() => {
      this.guardAdLoadedFail();
    }, this.config.timeouts.vpaidReadiness * 1e3), p.debug.info(
      K.NAME + "initAd",
      "WxH:",
      this.width + "x" + this.height,
      "viewMode:",
      this.config.viewMode,
      "bitrate:",
      this.config.bitrate,
      "creativeData:",
      this.getCreativeData(),
      "environmentVars:",
      this.getEnvironmentVars()
    ), this.vpaidAd.initAd(
      this.width,
      this.height,
      this.config.viewMode,
      this.config.bitrate,
      this.getCreativeData(),
      this.getEnvironmentVars()
    ));
  }
  functionExistsOnVPAIDAd(e) {
    return this.vpaidAd && this.vpaidAd[e] && typeof this.vpaidAd[e] == "function";
  }
  subscribeToVPAIDAd() {
    this.callbacks = {
      AdStarted: this.onStartAd,
      AdStopped: this.onStopAd,
      AdSkipped: this.onSkipAd,
      AdLoaded: this.onAdLoaded,
      AdLinearChange: this.onAdLinearChange,
      AdSizeChange: this.onAdSizeChange,
      AdExpandedChange: this.onAdExpandedChange,
      AdSkippableStateChange: this.onAdSkippableStateChange,
      AdDurationChange: this.onAdDurationChange,
      AdRemainingTimeChange: this.onAdRemainingTimeChange,
      // VPAID 1.1
      AdVolumeChange: this.onAdVolumeChange,
      AdImpression: this.onAdImpression,
      AdClickThru: this.onAdClickThru,
      AdInteraction: this.onAdInteraction,
      AdVideoStart: this.onAdVideoStart,
      AdVideoFirstQuartile: this.onAdVideoFirstQuartile,
      AdVideoMidpoint: this.onAdVideoMidpoint,
      AdVideoThirdQuartile: this.onAdVideoThirdQuartile,
      AdVideoComplete: this.onAdVideoComplete,
      AdUserAcceptInvitation: this.onAdUserAcceptInvitation,
      AdUserMinimize: this.onAdUserMinimize,
      AdUserClose: this.onAdUserClose,
      AdPaused: this.onAdPaused,
      AdPlaying: this.onAdPlaying,
      AdError: this.onAdError,
      AdLog: this.onAdLog
    };
    for (let e in this.callbacks)
      this.callbacks.hasOwnProperty(e) && this.vpaidAd.subscribe(this.callbacks[e], e, this);
  }
  unsubscribeFromVPAIDAd() {
    for (let e in this.callbacks)
      this.callbacks.hasOwnProperty(e) && this.functionExistsOnVPAIDAd("unsubscribe") && this.vpaidAd.unsubscribe(this.callbacks[e], e, this);
  }
  // time between loading $vpaidScript and getting server response
  guardScriptLoadFail() {
    p.debug.info(K.NAME + "guardScriptLoadFail - script didn't load"), clearTimeout(this.timeoutScriptLoadTimer), this.vpaidScript.onload = null, this.vpaidScript.onerror = null, this.currentAd.error = w.VAST.TIMEOUT, this.currentAd.error.message = "Timeout of VPAID resource URI.", this.currentAd.enrichment.set("ERRORCODE", this.currentAd.error.code), this.onAdError("vpaidRequest timeout", this.config.timeouts.vpaidRequest);
  }
  // guards time between initAd and receiving adLoaded
  guardAdLoadedFail() {
    p.debug.info(K.NAME + "guardAdLoadedFail"), clearTimeout(this.timeoutAdLoadedTimer), this.currentAd.error = w.VPAID.GENERAL_ERROR, this.currentAd.enrichment.set("ERRORCODE", this.currentAd.error.code), this.onAdError("vpaidReadiness timeout", this.config.timeouts.vpaidReadiness);
  }
  cleanUp() {
    clearInterval(this.progressInterval), this.progressInterval = 0, p.debug.info(K.NAME + "cleanup"), this.dispatchEvent(f.ON_VPAID_CLEANUP), this.unsubscribeFromVPAIDAd(), this.removeContainer();
  }
  removeContainer() {
    this.container.parentNode && this.container.parentNode.removeChild(this.container);
  }
  onAdLoaded() {
    p.debug.info(K.NAME + "onAdLoaded"), this.debugTiming.push({
      event: "initAd.done - in onAdLoaded() -- maxTime:" + this.config.timeouts.vpaidReadiness,
      time: Date.now()
    }), clearTimeout(this.timeoutAdLoadedTimer), this.dispatchEvent(f.ON_AD_LOADED), this.functionExistsOnVPAIDAd("startAd") && (this.friendlyIFrame.setAttribute("style", "position:absolute;top:0;left:0;width:100%;height:100%;overflow:hidden;border:none;"), this.vpaidAd.startAd());
  }
  //called from outside, to make the vpaid pause
  pause() {
    p.debug.info(K.NAME + "pause"), this.functionExistsOnVPAIDAd("pauseAd") && this.vpaidAd.pauseAd();
  }
  //called from outside, to make the vpaid play
  play() {
    p.debug.info(K.NAME + "pause"), this.functionExistsOnVPAIDAd("resumeAd") && this.vpaidAd.resumeAd();
  }
  //called from outside, to make the vpaid change volume
  setVolume(e) {
    p.debug.info(K.NAME + "setVolume", e), this.functionExistsOnVPAIDAd("setAdVolume") && this.vpaidAd.setAdVolume(e);
  }
  //called from outside, to make the vpaid adjust its size
  resizeAd(e, i, r) {
    p.debug.info(K.NAME + "resizeAd", e, i, r), this.functionExistsOnVPAIDAd("resizeAd") && this.vpaidAd.resizeAd(e, i, r);
  }
  onStartAd() {
    p.debug.info(K.NAME + "onStartAd"), this.dispatchEvent(f.ON_AD_STARTED), this.debugTiming.push({
      event: "onStartAd",
      time: Date.now()
    }), this.logTimings();
  }
  onAdImpression() {
    p.debug.info(K.NAME + "onAdImpression"), this.dispatchEvent(f.ON_AD_IMPRESSION);
  }
  onAdVideoStart() {
    p.debug.info(K.NAME + "onAdVideoStart"), this.dispatchEvent(f.ON_AD_PLAYBACK_START), this.onAdRemainingTimeChange(), this.progressInterval = setInterval(this.onAdRemainingTimeChange.bind(this), K.TIMEUPDATE_INTERVAL), setTimeout(() => {
      this.remaining <= 0 && (p.debug.warn(K.NAME + "onAdRemainingTimeChange - Ad didn't update times after 10 tries.Stop monitoring ad progress."), clearInterval(this.progressInterval), this.progressInterval = 0);
    }, K.TIMEUPDATE_INTERVAL * 10);
  }
  onAdVideoFirstQuartile() {
    p.debug.info(K.NAME + "onAdVideoFirstQuartile"), this.dispatchEvent(f.ON_AD_FIRST_QUARTILE);
  }
  onAdVideoMidpoint() {
    p.debug.info(K.NAME + "onAdVideoMidpoint"), this.dispatchEvent(f.ON_AD_MID_POINT);
  }
  onAdVideoThirdQuartile() {
    p.debug.info(K.NAME + "onAdVideoThirdQuartile"), this.dispatchEvent(f.ON_AD_THIRD_QUARTILE);
  }
  onAdVideoComplete() {
    p.debug.info(K.NAME + "onAdVideoComplete"), clearInterval(this.progressInterval), this.onAdRemainingTimeChange(), this.dispatchEvent(f.ON_AD_PLAYBACK_FINISHED);
  }
  onAdDurationChange() {
    p.debug.info(K.NAME + "onAdDurationChange"), this.getAllProperties();
  }
  onStopAd() {
    p.debug.info(K.NAME + "onStopAd"), this.dispatchEvent(f.ON_AD_STOPPED), this.cleanUp();
  }
  onAdError(e, i) {
    p.debug.info(K.NAME + "onAdError", e, i), this.currentAd.error = this.currentAd.error === null ? w.VPAID.GENERAL_ERROR : this.currentAd.error, this.currentAd.enrichment.set("ERRORCODE", this.currentAd.error.code), this.dispatchEvent(f.ON_AD_ERROR), this.cleanUp();
  }
  onSkipAd() {
    this.dispatchEvent(f.ON_AD_SKIPPED), p.debug.info(K.NAME + "onSkipAd"), this.cleanUp();
  }
  onAdLinearChange() {
    this.dispatchEvent(f.ON_AD_LINEARITY_CHANGE);
  }
  onAdSizeChange() {
    this.functionExistsOnVPAIDAd("getAdWidth") && this.functionExistsOnVPAIDAd("getAdHeight") && p.debug.info(
      K.NAME + "onAdSizeChange",
      this.vpaidAd.getAdWidth(),
      this.vpaidAd.getAdHeight()
    ), this.dispatchEvent(f.ON_AD_SIZE_CHANGED);
  }
  onAdExpandedChange() {
    p.debug.info(K.NAME + "onAdExpandedChange");
  }
  onAdSkippableStateChange() {
    p.debug.info(K.NAME + "onAdSkippableStateChange"), this.dispatchEvent(f.ON_AD_SKIPPABLE_STATE_CHANGE);
  }
  /**
   * Deprecated with VPAID 2.0. Players have to use internal logic to update the progress UI.
   * @returns {void}
   * @deprecated
   */
  onAdRemainingTimeChange() {
    this.functionExistsOnVPAIDAd("getAdDuration") && (this.durationTime = this.vpaidAd.getAdDuration()), this.functionExistsOnVPAIDAd("getAdRemainingTime") && (this.remaining = this.vpaidAd.getAdRemainingTime()), this.dispatchEvent(f.ON_AD_PROGRESS);
  }
  onAdVolumeChange() {
    p.debug.info(K.NAME + "onAdVolumeChange");
  }
  /**
   * See VPAID 2.0 specs: How to handle click throughs
   *
   * @param {string} url - Optional. The landing page URI.
   * @param {string} id - Optional. Unused.
   * @param {Boolean} playerHandles - Optional. Whether the core should open the landing page or not.
   *   defaulting to false.
   * @returns {void}
   */
  onAdClickThru(e = null, i = null, r = !1) {
    p.debug.info(K.NAME + "onAdClickThru - creative handles click", !r), r === !0 && (p.debug.info(K.NAME + "onAdClickThru - open landing page", e, i), this.currentAd.clickThroughURL = e || this.currentAd.clickThroughURL, this.currentAd.handleClickThrough = r), this.dispatchEvent(f.ON_AD_CLICKED);
  }
  onAdInteraction(e) {
    p.debug.info(K.NAME + "onAdInteraction", e);
  }
  onAdUserAcceptInvitation() {
    p.debug.info(K.NAME + "onAdUserAcceptInvitation");
  }
  onAdUserMinimize() {
    p.debug.info(K.NAME + "onAdUserMinimize");
  }
  onAdUserClose() {
    p.debug.info(K.NAME + "onAdUserClose");
  }
  onAdPaused() {
    p.debug.info(K.NAME + "onAdPaused");
  }
  onAdPlaying() {
    p.debug.info(K.NAME + "onAdPlaying"), this.dispatchEvent(f.ON_AD_PLAYING);
  }
  onAdLog(e) {
    p.debug.info(K.NAME + "onAdLog", e);
  }
  get duration() {
    return this.durationTime || 0;
  }
  get remainingTime() {
    return this.remaining || 0;
  }
  //Debug -- Start
  /* istanbul ignore next */
  getAllProperties() {
    if (!this.log)
      return;
    let e = Object.keys(this.vpaidAd);
    for (let i in e)
      e.hasOwnProperty(i) && e[i].indexOf("getAd") === 0 && p.debug.info(
        K.NAME + "--vpaidAd." + e[i] + "()",
        this.vpaidAd[e[i]]()
      );
  }
  /* istanbul ignore next */
  logTimings() {
    this.log && (this.debugTiming.map((e, i, r) => {
      i === 0 ? e.delta = 0 : e.delta = r[i].time - r[i - 1].time;
    }), p.debug.table(this.debugTiming));
  }
  //Debug -- End
};
K.NAME = "VPAIDBridge::", K.TIMEUPDATE_INTERVAL = 250;
let Or = K;
const ci = {
  // these MimeTypes will be used if desireMimeTypes remains unset from publisher side - don't change sequence!
  //  and it's used in canPlayType, text/html can't be played it's only used for interactive actions.
  VPAID: "application/javascript",
  MP4: "video/mp4",
  WEBM: "video/webm",
  OGG: "video/ogg",
  MP3: "audio/mpeg"
}, je = class je extends Rt {
  /**
   * @param {adPod} adPod - AdSlotManifest Defines the adSlot.
   * @param {adBuffet} adBuffet - AdSlotManifest Defines the adSlot buffet ads.
   * @param {EnvironmentVars} envVars Used for passing implementation-specific runtime variables.
   * @param {FacadePlayer} player - Facade interface for the player.
   */
  constructor(e, i, r, s) {
    super(), this.adCount = 0, this.adDuration = 1 / 0, this.currentViewMode = je.VIEW_MODE.NORMAL, this.environmentVars = r, this.eventCallbacks = [], this.eventKeys = Object.keys(f), this.eventTypes = Object.values(f), this.nonLinearView = null, this.player = s, this.progressTracker = null, this.properCreative = null, this.replacedCounter = 0, this.requestedTrackingEvents = [], this.simidPlayer = null, this.viewability = null, this.vpaidPlayer = null, this.prepare(e, i);
  }
  hasOffsetReached(e, i, r) {
    let s = r.offset;
    return typeof s == "string" && s.indexOf("%") > -1 && (s = parseInt(s, 10) / 100 * i), e >= parseInt(s, 10) && !r.requested;
  }
  prepare(e, i) {
    this.manifest = e.slice(0), this.buffet = (i || []).slice(0), this.adSlotTimes = new vo(this.manifest), this.currentAd = null, this.environmentVars.vastMacros = Object.assign(this.environmentVars.vastMacros || {}, {
      CONTENTPLAYHEAD: this.player.getContentCurrentTime(),
      MEDIAPLAYHEAD: this.player.getContentCurrentTime()
    });
  }
  updateAdSettings() {
    this.properCreative = this.currentAd.isLinear ? this.currentAd.properCreative.selectedMediaFile : this.currentAd.properCreative.variations[0], this.currentAd.isExpanded = !1, this.currentAd.isSkippable = !1, this.currentAd.isVPAID = this.properCreative.isVPAID, this.currentAd.isSIMID = !!this.currentAd.properCreative.selectedCreativeFile, this.currentAd.isInteractive = this.currentAd.isVPAID || this.currentAd.isSIMID, this.currentAd.isVPAID && (this.currentAd.config.bitrate = this.environmentVars.desiredBitrate || 500, this.currentAd.config.viewMode = "dynamic"), this.currentAd.isLinear && (this.currentAd.skipOffsetValue = this.currentAd.skipOffset === -1 ? this.currentAd.config.skipOffset : this.currentAd.skipOffsetValue), this.currentAd.isLinear ? (this.currentAd.enrichment.setFromObject(this.environmentVars.vastMacros), this.currentAd.enrichment.set("ADTYPE", this.currentAd.adType), this.currentAd.enrichment.set("ASSETURI", this.properCreative.fileURL)) : (this.currentAd.enrichment.set("ADTYPE", "hybrid"), this.currentAd.enrichment.set("ASSETURI", this.properCreative.selectedResource.resource), this.currentAd.enrichment.set(
      "MEDIAMIME",
      this.environmentVars.desiredMimeTypes || Object.values(ci)
    ), this.currentAd.properCreative.variations[0].displayDuration = this.getMinimalDurationTime()), [fe.COMMERCIAL, fe.SPONSORED].includes(this.currentAd.variant) ? this.currentAd.enrichment.set("ADCOUNT", this.adCount += 1) : this.currentAd.enrichment.set("ADCOUNT", -1), this.currentAd.enrichment.set("ADSERVINGID", this.currentAd.adServingId), this.currentAd.enrichment.set("BLOCKED", this.currentAd.adReinsertion.isActive ? 1 : 0), this.currentAd.enrichment.set("ERRORCODE", 0), isNaN(this.currentAd.sequence) || this.currentAd.enrichment.set("PODSEQUENCE", this.currentAd.currentPodSequencing + this.replacedCounter), this.currentAd.enrichment.set("UNIVERSALADID", this.currentAd.universalAdIds);
  }
  startViewability() {
    this.viewability = null, this.currentAd.adTrackers.viewable && (this.viewability = new Io(this));
  }
  getAd() {
    if (this.progressTracker = null, this.currentAd = this.manifest.length > 0 ? this.manifest.shift() : null, !this.currentAd)
      return null;
    for (const i of this.eventCallbacks)
      i();
    this.eventCallbacks = [];
    for (const i of Object.values(f)) {
      const r = this.addEventListener(i, (s) => {
        this.trackEvent(s.type);
      });
      this.eventCallbacks.push(r);
    }
    if (this.currentAd.hasError)
      return this.currentAd.trackingEvents = this.currentAd.adTrackers, this.currentAd;
    if (this.currentAd.config.adSourceSelector) {
      let i = null;
      const r = new Promise((l) => {
        i = setTimeout(l, 250, null);
      }), s = this.currentAd.isLinear ? "mediaFiles" : "variations";
      if (this.currentAd.properCreative && this.currentAd.properCreative[s].length) {
        let l = this.currentAd.isLinear ? this.currentAd.properCreative[s] : this.currentAd.properCreative[s][0].resources;
        const h = this.currentAd.config.adSourceSelector(
          l
        ).then((m) => m === null || Object.keys(m).length === 0 ? null : m);
        Promise.race([r, h]).then((m) => {
          m === null && this.cancelAd(), this.currentAd.isLinear ? this.currentAd.properCreative.selectedMediaFile = m : this.currentAd.properCreative.selectedResource = m, this.updateAdSettings();
        }).catch(() => {
          this.cancelAd();
        });
      } else
        clearTimeout(i), this.cancelAd();
    } else {
      this.updateAdSettings();
      const i = this.currentAd.isLinear ? this.currentAd.properCreative.creativeTrackers : this.currentAd.properCreative.variations[0].creativeTrackers;
      this.currentAd.trackingEvents = Object.assign({}, this.currentAd.adTrackers, i);
    }
    const e = this.addEventListener(f.ON_AD_ERROR, this.setTotalCommercialsDuration);
    return this.eventCallbacks.push(e), this.currentAd;
  }
  applyBuffetAd() {
    if (!this.currentAd.replaced && this.currentAd.fallbackOnNoAd && this.buffet.length > 0) {
      let e = this.buffet.shift();
      if (e.adCount = this.adCount + 1, this.replacedCounter += 1, e.currentClip = this.currentAd.currentClip, e.currentCommercial = this.currentAd.currentCommercial, p.debug.info(je.NAME + "applyBuffetAd - Insert at runtime", e), this.currentAd.replaced = !0, this.manifest.replaced = 1, this.manifest.unshift(e), e.variant === fe.COMMERCIAL) {
        let i = e.duration;
        this.currentAd.isLinear || (i += this.currentAd.duration), p.debug.info(
          je.NAME + "applyBuffetAd - adjust totalCommercialsDuration after replace",
          i
        ), this.adSlotTimes.setTotalCommercialsDuration(i), this.setTotalCommercialsDuration(), p.debug.info(je.NAME + "deliver buffetAd", this.manifest);
      }
    }
  }
  callTrackers(e) {
    if (!e || e.length < 1) {
      p.debug.info(je.NAME + "callTrackers - Request without URIs", e);
      return;
    }
    const i = {
      adReinsertion: this.currentAd.adReinsertion,
      enrichment: this.currentAd.enrichment,
      timeouts: this.currentAd.config.timeouts,
      urlhandler: this.currentAd.config.urlhandler
    };
    this.currentAd.enrichment.set("PLAYERSIZE", this.player.getPlayerSize().boundingRect);
    let r = this.currentAd;
    new $i().track(e, (s, l) => {
      l && (p.debug.warn(je.NAME + "callTrackers failed:", l, s), r.error = l.code ? l : w.WARNING.TRACKER_LOAD_FAILED, r.error.message = `${r.error.message}: ${JSON.stringify(s)}`, this.dispatchEvent(f.ON_AD_WARNING));
    }, i);
  }
  // async canceling ad (adSourceSelector way)
  cancelAd() {
    if (this.currentAd.isLinear && this.currentAd.type === he.NON_LINEAR) {
      this.currentAd.error = w.CREATIVE.EXPECTED_DIFFERENT_ADTYPE, this.dispatchEvent(f.ON_AD_ERROR);
      return;
    }
    this.cancelAdWithError();
  }
  cancelAdWithError() {
    this.currentAd.error || (this.currentAd.error = {}, this.currentAd.error = w.VAST.UNSUPPORTED_MIMETYPE), p.debug.info(je.NAME + "Canceling ad with error", this.currentAd), this.currentAd.enrichment.set("ERRORCODE", this.currentAd.error.code), this.dispatchEvent(f.ON_AD_ERROR), this.applyBuffetAd();
  }
  // only called in nonlinear cases
  getMinimalDurationTime() {
    return this.currentAd.minSuggestedDuration > 0 ? Math.min(this.currentAd.minSuggestedDuration, this.currentAd.config.timeouts.nonlinearMaxDuration) : this.currentAd.config.timeouts.nonlinearMaxDuration;
  }
  onClickThrough(e) {
    this.dispatchEvent(f.ON_AD_CLICKED);
    let i = this.currentAd.enrichment.apply(this.currentAd.clickThroughURL);
    if (i && i.indexOf("//") === 0 && (i = Fi(i, "")), !e) {
      const r = this.currentAd.adReinsertion.isActive === !0 ? "_self" : "_blank";
      window.open(i, r);
    }
    return i;
  }
  onIconView(e) {
    if (this.currentAd && this.currentAd.icons[e]) {
      let i = this.currentAd.icons[e].creativeViewTracker;
      this.callTrackers(i);
    }
  }
  /**
   * Called by the AdSlotAPI for each ad that is going to start for another time
   */
  onRewind() {
    this.dispatchEvent(f.ON_AD_REWIND);
  }
  onVerificationNotExecuted(e, i) {
    if (this.currentAd && this.currentAd.adVerifications) {
      let r = this.currentAd.adVerifications.filter((h) => h.vendor === e)[0];
      if (!r || !r.tracking.verificationNotExecuted)
        return;
      let s = r.tracking.verificationNotExecuted, l = parseInt(i, 10);
      i && isFinite(l) && l >= 1 && l <= 3 && this.currentAd.enrichment.set("REASON", l), s && s.length > 0 && this.callTrackers(s);
    }
  }
  setTotalCommercialsDuration() {
    if (this.currentAd.variant === fe.COMMERCIAL) {
      const e = this.currentAd.duration * -1;
      p.debug.info(je.NAME + "setTotalCommercialsDuration - decrease", e), this.adSlotTimes.setTotalCommercialsDuration(e), this.dispatchEvent(f.ON_AD_SLOT_DURATION_CHANGE);
      return;
    }
    this.currentAd.replaced === !0 && this.dispatchEvent(f.ON_AD_SLOT_DURATION_CHANGE);
  }
  onAdSkippableStateChange() {
    this.currentAd.adSkippableStateChangeSent || (this.currentAd.adSkippableStateChangeSent = !0, this.currentAd.isSkippable = !0, this.dispatchEvent(f.ON_AD_SKIPPABLE_STATE_CHANGE));
  }
  onIconClickThrough(e, i) {
    if (!this.currentAd.icons[e])
      return null;
    let r = this.currentAd.icons[e].clickTracker;
    this.callTrackers(r);
    let s = this.currentAd.enrichment.apply(this.currentAd.icons[e].clickThroughURL);
    if (!i) {
      const l = this.currentAd.adReinsertion.isActive === !0 ? "_self" : "_blank";
      window.open(s, l);
    }
    return s;
  }
  onResizeAd(e, i) {
    this.currentAd && (i !== this.currentViewMode && (this.currentViewMode = i, i === je.VIEW_MODE.FULLSCREEN ? (this.dispatchEvent(f.ON_ENTER_FULLSCREEN), this.dispatchEvent(f.ON_PLAYER_EXPAND)) : (this.dispatchEvent(f.ON_EXIT_FULLSCREEN), this.dispatchEvent(f.ON_PLAYER_COLLAPSE))), this.currentAd.isVPAID ? this.vpaidPlayer.resizeAd(e.width, e.height, i) : this.dispatchEvent(f.ON_AD_SIZE_CHANGED));
  }
  onSkip() {
    this.currentAd.variant === fe.COMMERCIAL && (this.adSlotTimes.setCommercialsCurrentTime(this.adSlotTimes.currentTimeOffset + this.currentAd.duration), this.adSlotTimes.setCurrentTimeOffset(this.adSlotTimes.totalCommercialsCurrentTime)), this.adDuration = 1 / 0, this.dispatchEvent(f.ON_AD_SKIPPED);
  }
  // called on VPAID ON_AD_SKIPPABLE_STATE_CHANGE
  timeupdate() {
    if (!this.currentAd)
      return;
    let e = this.currentAd.isVPAID ? this.vpaidPlayer.duration - this.vpaidPlayer.remainingTime : this.player.getAdCurrentTime();
    if (this.adDuration = this.currentAd.isVPAID ? this.vpaidPlayer.duration : this.player.getAdDuration(), !(!this.currentAd || isNaN(this.adDuration) || !isNaN(this.adDuration) && this.adDuration <= 0 || Object.keys(this.currentAd).length < 1)) {
      if (this.currentAd.enrichment.set("ADPLAYHEAD", ki(e)), this.currentAd.variant === fe.COMMERCIAL) {
        const i = this.adDuration - this.currentAd.duration;
        if (i && Number.isFinite(i)) {
          let r = i;
          this.currentAd.isLinear || (r = this.currentAd.isVPAID ? this.vpaidPlayer.duration : this.getMinimalDurationTime()), this.adSlotTimes.setTotalCommercialsDuration(r);
        }
        e >= this.adDuration ? (this.adSlotTimes.setCurrentTimeOffset(this.adSlotTimes.totalCommercialsCurrentTime), this.adSlotTimes.setCommercialsCurrentTime(this.adSlotTimes.currentTimeOffset)) : this.adSlotTimes.setCommercialsCurrentTime(this.adSlotTimes.currentTimeOffset + e);
      }
      if (this.currentAd.duration = this.adDuration, this.currentAd.currentTime = e, this.currentAd.remainingTime = this.adDuration - e, [fe.COMMERCIAL, fe.SPONSORED].includes(this.currentAd.variant) && Number.isFinite(this.currentAd.skipOffset) && this.currentAd.skipOffset > -1 && e >= this.currentAd.skipOffset && this.onAdSkippableStateChange(), this.currentAd) {
        if (!this.progressTracker && this.currentAd.properCreative && this.currentAd.properCreative.creativeTrackers && this.currentAd.properCreative.creativeTrackers.progress && (this.progressTracker = this.currentAd.properCreative.creativeTrackers.progress), this.progressTracker && this.progressTracker.forEach((s) => {
          this.hasOffsetReached(e, this.adDuration, s) && this.dispatchEvent(f.ON_AD_PROGRESS);
        }), this.currentAd.isVPAID || !this.currentAd.isLinear)
          return;
        let i = [], r = [];
        e >= this.adDuration && i.push(f.ON_AD_PLAYBACK_FINISHED), e >= this.adDuration / (4 / 3) && i.push(f.ON_AD_THIRD_QUARTILE), e >= this.adDuration / 2 && i.push(f.ON_AD_MID_POINT), e >= this.adDuration / 4 && i.push(f.ON_AD_FIRST_QUARTILE), e && i.push(f.ON_AD_PLAYBACK_START), r.push(i[0]), this.currentAd.config.trackSkippedQuartiles && (r = i);
        for (let s = r.length - 1; s >= 0; s--)
          this.requestedTrackingEvents.filter((h) => h === r[s]).shift() || (this.dispatchEvent(r[s]), this.currentAd.isSIMID && this.requestedTrackingEvents.push(r[s]));
      }
    }
  }
  trackEvent(e) {
    const i = this.eventKeys[this.eventTypes.indexOf(e)], r = Yt[i], s = this.player.getAdCurrentTime(), l = this.player.getAdDuration();
    if (this.requestedTrackingEvents.push(e), this.currentAd && this.currentAd.trackingEvents && this.currentAd.trackingEvents[r]) {
      let h = this.currentAd.trackingEvents[r];
      e === f.ON_AD_PROGRESS && (h = h.filter((m) => this.hasOffsetReached(s, l, m))), this.callTrackers(h);
    }
  }
  loadAdSIMID() {
    this.currentAd.properCreative.selectedCreativeFile.fileURL === "" && this.currentAd.properCreative.selectedCreativeFile.resource === null ? (this.currentAd.error = w.SIMID.GENERAL_ERROR, this.cancelAdWithError()) : (this.simidPlayer = new Ir(this), this.simidPlayer.initializeAd());
  }
  loadAdVPAID() {
    this.vpaidPlayer = new Or(this.player.getPlayerElement(), this.currentAd), this.currentAd.isLinear ? [
      f.ON_AD_CLICKED,
      f.ON_AD_LOADED,
      f.ON_AD_STARTED,
      f.ON_AD_IMPRESSION,
      f.ON_AD_PLAYING,
      f.ON_AD_PLAYBACK_START,
      f.ON_AD_FIRST_QUARTILE,
      f.ON_AD_MID_POINT,
      f.ON_AD_THIRD_QUARTILE,
      f.ON_AD_PLAYBACK_FINISHED,
      f.ON_AD_STOPPED,
      f.ON_AD_SKIPPED,
      f.ON_AD_ERROR,
      f.ON_AD_PROGRESS,
      f.ON_AD_SIZE_CHANGED,
      f.ON_AD_SKIPPABLE_STATE_CHANGE,
      f.ON_VPAID_CLEANUP
    ].map(
      (e) => {
        this.vpaidPlayer.addEventListener(e, (i) => this.vpaidEventHandler(i));
      }
    ) : [
      f.ON_AD_LINEARITY_CHANGE,
      f.ON_AD_SKIPPED,
      f.ON_AD_STOPPED
    ].map(
      (e) => {
        this.vpaidPlayer.addEventListener(e, (i) => this.nonLinearVpaidEventHandler(i));
      }
    );
  }
  nonLinearVpaidEventHandler(e) {
    if (this.vpaidPlayer.functionExistsOnVPAIDAd("getAdLinear"))
      switch (e.type) {
        case f.ON_AD_LINEARITY_CHANGE:
          this.vpaidPlayer.vpaidAd.getAdLinear() ? (p.debug.info("::NonLinearHandler - Ad change linear mode"), this.player.saveContentState()) : this.player.restoreContentState();
          break;
        case f.ON_AD_SKIPPED:
        case f.ON_AD_STOPPED:
          this.vpaidPlayer.vpaidAd.getAdLinear() && this.player.restoreContentState();
          break;
      }
  }
  vpaidEventHandler(e) {
    let i;
    switch (e.type) {
      // there's no creative view event in vpaid, so we send it when impression is triggered
      case f.ON_AD_LOADED:
      //onStartAd
      case f.ON_AD_STARTED:
      //onStartAd
      case f.ON_AD_IMPRESSION:
      case f.ON_AD_PLAYING:
      //onAdPlaying()
      case f.ON_AD_PLAYBACK_START:
      //onVideoStart()
      case f.ON_AD_FIRST_QUARTILE:
      case f.ON_AD_MID_POINT:
      case f.ON_AD_THIRD_QUARTILE:
      case f.ON_AD_PLAYBACK_FINISHED:
        this.requestedTrackingEvents.push(e.type), this.dispatchEvent(e.type);
        break;
      case f.ON_AD_CLICKED:
        i = !this.currentAd.handleClickThrough, this.onClickThrough(i);
        break;
      case f.ON_AD_SKIPPABLE_STATE_CHANGE:
        this.onAdSkippableStateChange();
        break;
      case f.ON_AD_PROGRESS:
        this.timeupdate();
        break;
      case f.ON_AD_SIZE_CHANGED:
        this.dispatchEvent(e.type);
        break;
      case f.ON_AD_SKIPPED:
        this.requestedTrackingEvents.push(e.type), this.onSkip();
        break;
      case f.ON_AD_ERROR:
        this.requestedTrackingEvents.push(e.type), this.dispatchEvent(e.type);
        break;
      case f.ON_AD_STOPPED:
        this.dispatchEvent(e.type);
        break;
      case f.ON_VPAID_CLEANUP:
        this.dispatchEvent(e.type);
        break;
    }
  }
  // nonLinear part
  stop() {
    p.debug.info("[NonLinearAdSlotDelivery] Stop AdSlot."), this.nonLinearView.stop(), this.nonLinearView = null;
  }
};
je.NAME = "AdSloCtrl::", je.VIEW_MODE = {
  FULLSCREEN: "fullscreen",
  NORMAL: "normal"
};
let Tr = je;
var oi = /* @__PURE__ */ ((c) => (c[c.ERROR_RESOURCE_REJECTED = 1] = "ERROR_RESOURCE_REJECTED", c[c.ERROR_VERIFICATION_NOT_SUPPORTED = 2] = "ERROR_VERIFICATION_NOT_SUPPORTED", c[c.ERROR_ON_RESOURCE_LOAD = 3] = "ERROR_ON_RESOURCE_LOAD", c))(oi || {});
function Ie() {
  return Ie = Object.assign ? Object.assign.bind() : function(c) {
    for (var e = 1; e < arguments.length; e++) {
      var i = arguments[e];
      for (var r in i) ({}).hasOwnProperty.call(i, r) && (c[r] = i[r]);
    }
    return c;
  }, Ie.apply(null, arguments);
}
function Z(c) {
  "@babel/helpers - typeof";
  return Z = typeof Symbol == "function" && typeof Symbol.iterator == "symbol" ? function(e) {
    return typeof e;
  } : function(e) {
    return e && typeof Symbol == "function" && e.constructor === Symbol && e !== Symbol.prototype ? "symbol" : typeof e;
  }, Z(c);
}
var St = typeof globalThis != "undefined" ? globalThis : typeof window != "undefined" ? window : typeof global != "undefined" ? global : typeof self != "undefined" ? self : {};
function To(c) {
  return c && c.__esModule && Object.prototype.hasOwnProperty.call(c, "default") ? c.default : c;
}
var es = {};
(function(c) {
  (function(e, i, r) {
    if (Z(r) === "object" && typeof r.nodeName != "string")
      i(e, r);
    else {
      var s = function(L) {
        for (var ie in L)
          L.hasOwnProperty(ie) && (L[ie] = s(L[ie]));
        return Object.freeze(L);
      }, r = {}, l = ["1.5.6-iab144"], h = "default";
      h && l.push(h), i(e, r);
      for (var m in r)
        r.hasOwnProperty(m) && (Object.getOwnPropertyDescriptor(e, m) == null && Object.defineProperty(e, m, {
          value: {}
        }), l.forEach(function(y) {
          if (Object.getOwnPropertyDescriptor(e[m], y) == null) {
            var L = s(r[m]);
            Object.defineProperty(e[m], y, {
              get: function() {
                return L;
              },
              enumerable: !0
            });
          }
        }));
    }
  })(St, function(e, i) {
    var r = r || {};
    r.scope = {}, r.createTemplateTagFirstArg = function(a) {
      return a.raw = a;
    }, r.createTemplateTagFirstArgWithRaw = function(a, u) {
      return a.raw = u, a;
    }, r.arrayIteratorImpl = function(a) {
      var u = 0;
      return function() {
        return u < a.length ? {
          done: !1,
          value: a[u++]
        } : {
          done: !0
        };
      };
    }, r.arrayIterator = function(a) {
      return {
        next: r.arrayIteratorImpl(a)
      };
    }, r.makeIterator = function(a) {
      var u = typeof Symbol != "undefined" && Symbol.iterator && a[Symbol.iterator];
      if (u)
        return u.call(a);
      if (typeof a.length == "number")
        return r.arrayIterator(a);
      throw Error(String(a) + " is not an iterable or ArrayLike");
    }, r.arrayFromIterator = function(a) {
      for (var u, E = []; !(u = a.next()).done; )
        E.push(u.value);
      return E;
    }, r.arrayFromIterable = function(a) {
      return a instanceof Array ? a : r.arrayFromIterator(r.makeIterator(a));
    }, r.ASSUME_ES5 = !1, r.ASSUME_NO_NATIVE_MAP = !1, r.ASSUME_NO_NATIVE_SET = !1, r.SIMPLE_FROUND_POLYFILL = !1, r.ISOLATE_POLYFILLS = !1, r.FORCE_POLYFILL_PROMISE = !1, r.FORCE_POLYFILL_PROMISE_WHEN_NO_UNHANDLED_REJECTION = !1, r.objectCreate = r.ASSUME_ES5 || typeof Object.create == "function" ? Object.create : function(a) {
      var u = function() {
      };
      return u.prototype = a, new u();
    }, r.defineProperty = r.ASSUME_ES5 || typeof Object.defineProperties == "function" ? Object.defineProperty : function(a, u, E) {
      return a == Array.prototype || a == Object.prototype || (a[u] = E.value), a;
    }, r.getGlobal = function(a) {
      a = [(typeof globalThis == "undefined" ? "undefined" : Z(globalThis)) == "object" && globalThis, a, (typeof window == "undefined" ? "undefined" : Z(window)) == "object" && window, (typeof self == "undefined" ? "undefined" : Z(self)) == "object" && self, Z(St) == "object" && St];
      for (var u = 0; u < a.length; ++u) {
        var E = a[u];
        if (E && E.Math == Math)
          return E;
      }
      throw Error("Cannot find global object");
    }, r.global = r.getGlobal(this), r.IS_SYMBOL_NATIVE = typeof Symbol == "function" && Z(Symbol("x")) === "symbol", r.TRUST_ES6_POLYFILLS = !r.ISOLATE_POLYFILLS || r.IS_SYMBOL_NATIVE, r.polyfills = {}, r.propertyToPolyfillSymbol = {}, r.POLYFILL_PREFIX = "$jscp$", r.polyfill = function(a, u, E, O) {
      u && (r.ISOLATE_POLYFILLS ? r.polyfillIsolated(a, u, E, O) : r.polyfillUnisolated(a, u, E, O));
    }, r.polyfillUnisolated = function(a, u, E, O) {
      for (E = r.global, a = a.split("."), O = 0; O < a.length - 1; O++) {
        var C = a[O];
        if (!(C in E))
          return;
        E = E[C];
      }
      a = a[a.length - 1], O = E[a], u = u(O), u != O && u != null && r.defineProperty(E, a, {
        configurable: !0,
        writable: !0,
        value: u
      });
    }, r.polyfillIsolated = function(a, u, E, O) {
      var C = a.split(".");
      a = C.length === 1, O = C[0], O = !a && O in r.polyfills ? r.polyfills : r.global;
      for (var se = 0; se < C.length - 1; se++) {
        var oe = C[se];
        if (!(oe in O))
          return;
        O = O[oe];
      }
      C = C[C.length - 1], E = r.IS_SYMBOL_NATIVE && E === "es6" ? O[C] : null, u = u(E), u != null && (a ? r.defineProperty(r.polyfills, C, {
        configurable: !0,
        writable: !0,
        value: u
      }) : u !== E && (r.propertyToPolyfillSymbol[C] === void 0 && (E = 1e9 * Math.random() >>> 0, r.propertyToPolyfillSymbol[C] = r.IS_SYMBOL_NATIVE ? r.global.Symbol(C) : r.POLYFILL_PREFIX + E + "$" + C), r.defineProperty(O, r.propertyToPolyfillSymbol[C], {
        configurable: !0,
        writable: !0,
        value: u
      })));
    }, r.getConstructImplementation = function() {
      function a() {
        function E() {
        }
        return Reflect.construct(E, [], function() {
        }), new E() instanceof E;
      }
      if (r.TRUST_ES6_POLYFILLS && typeof Reflect != "undefined" && Reflect.construct) {
        if (a())
          return Reflect.construct;
        var u = Reflect.construct;
        return function(E, O, C) {
          return E = u(E, O), C && Reflect.setPrototypeOf(E, C.prototype), E;
        };
      }
      return function(E, O, C) {
        return C === void 0 && (C = E), C = r.objectCreate(C.prototype || Object.prototype), Function.prototype.apply.call(E, C, O) || C;
      };
    }, r.construct = {
      valueOf: r.getConstructImplementation
    }.valueOf(), r.underscoreProtoCanBeSet = function() {
      var a = {
        a: !0
      }, u = {};
      try {
        return u.__proto__ = a, u.a;
      } catch (E) {
      }
      return !1;
    }, r.setPrototypeOf = r.TRUST_ES6_POLYFILLS && typeof Object.setPrototypeOf == "function" ? Object.setPrototypeOf : r.underscoreProtoCanBeSet() ? function(a, u) {
      if (a.__proto__ = u, a.__proto__ !== u)
        throw new TypeError(a + " is not extensible");
      return a;
    } : null, r.inherits = function(a, u) {
      if (a.prototype = r.objectCreate(u.prototype), a.prototype.constructor = a, r.setPrototypeOf) {
        var E = r.setPrototypeOf;
        E(a, u);
      } else
        for (E in u)
          if (E != "prototype")
            if (Object.defineProperties) {
              var O = Object.getOwnPropertyDescriptor(u, E);
              O && Object.defineProperty(a, E, O);
            } else
              a[E] = u[E];
      a.superClass_ = u.prototype;
    }, r.getRestArguments = function() {
      for (var a = Number(this), u = [], E = a; E < arguments.length; E++)
        u[E - a] = arguments[E];
      return u;
    }, r.polyfill("Reflect", function(a) {
      return a || {};
    }, "es6", "es3"), r.polyfill("Reflect.construct", function(a) {
      return r.construct;
    }, "es6", "es3"), r.polyfill("Reflect.setPrototypeOf", function(a) {
      if (a)
        return a;
      if (r.setPrototypeOf) {
        var u = r.setPrototypeOf;
        return function(E, O) {
          try {
            return u(E, O), !0;
          } catch (C) {
            return !1;
          }
        };
      }
      return null;
    }, "es6", "es5"), r.initSymbol = function() {
    }, r.polyfill("Symbol", function(a) {
      if (a)
        return a;
      var u = function(oe, tt) {
        this.$jscomp$symbol$id_ = oe, r.defineProperty(this, "description", {
          configurable: !0,
          writable: !0,
          value: tt
        });
      };
      u.prototype.toString = function() {
        return this.$jscomp$symbol$id_;
      };
      var E = "jscomp_symbol_" + (1e9 * Math.random() >>> 0) + "_", O = 0, C = function(oe) {
        if (this instanceof C)
          throw new TypeError("Symbol is not a constructor");
        return new u(E + (oe || "") + "_" + O++, oe);
      };
      return C;
    }, "es6", "es3"), r.polyfill("Symbol.iterator", function(a) {
      if (a)
        return a;
      a = Symbol("Symbol.iterator");
      for (var u = "Array Int8Array Uint8Array Uint8ClampedArray Int16Array Uint16Array Int32Array Uint32Array Float32Array Float64Array".split(" "), E = 0; E < u.length; E++) {
        var O = r.global[u[E]];
        typeof O == "function" && typeof O.prototype[a] != "function" && r.defineProperty(O.prototype, a, {
          configurable: !0,
          writable: !0,
          value: function() {
            return r.iteratorPrototype(r.arrayIteratorImpl(this));
          }
        });
      }
      return a;
    }, "es6", "es3"), r.iteratorPrototype = function(a) {
      return a = {
        next: a
      }, a[Symbol.iterator] = function() {
        return this;
      }, a;
    }, r.iteratorFromArray = function(a, u) {
      a instanceof String && (a += "");
      var E = 0, O = !1, C = {
        next: function() {
          if (!O && E < a.length) {
            var oe = E++;
            return {
              value: u(oe, a[oe]),
              done: !1
            };
          }
          return O = !0, {
            done: !0,
            value: void 0
          };
        }
      };
      return C[Symbol.iterator] = function() {
        return C;
      }, C;
    }, r.polyfill("Array.prototype.keys", function(a) {
      return a || function() {
        return r.iteratorFromArray(this, function(u) {
          return u;
        });
      };
    }, "es6", "es3"), r.owns = function(a, u) {
      return Object.prototype.hasOwnProperty.call(a, u);
    }, r.polyfill("Object.values", function(a) {
      return a || function(u) {
        var E = [], O;
        for (O in u)
          r.owns(u, O) && E.push(u[O]);
        return E;
      };
    }, "es8", "es3"), r.checkEs6ConformanceViaProxy = function() {
      try {
        var a = {}, u = Object.create(new r.global.Proxy(a, {
          get: function(O, C, se) {
            return O == a && C == "q" && se == u;
          }
        }));
        return u.q === !0;
      } catch (E) {
        return !1;
      }
    }, r.USE_PROXY_FOR_ES6_CONFORMANCE_CHECKS = !1, r.ES6_CONFORMANCE = r.USE_PROXY_FOR_ES6_CONFORMANCE_CHECKS && r.checkEs6ConformanceViaProxy(), r.polyfill("WeakMap", function(a) {
      function u() {
        if (!a || !Object.seal)
          return !1;
        try {
          var b = Object.seal({}), F = Object.seal({}), j = new a([[b, 2], [F, 3]]);
          return j.get(b) != 2 || j.get(F) != 3 ? !1 : (j.delete(b), j.set(F, 4), !j.has(b) && j.get(F) == 4);
        } catch (it) {
          return !1;
        }
      }
      function E() {
      }
      function O(b) {
        var F = Z(b);
        return F === "object" && b !== null || F === "function";
      }
      function C(b) {
        if (!r.owns(b, oe)) {
          var F = new E();
          r.defineProperty(b, oe, {
            value: F
          });
        }
      }
      function se(b) {
        if (!r.ISOLATE_POLYFILLS) {
          var F = Object[b];
          F && (Object[b] = function(j) {
            return j instanceof E ? j : (Object.isExtensible(j) && C(j), F(j));
          });
        }
      }
      if (r.USE_PROXY_FOR_ES6_CONFORMANCE_CHECKS) {
        if (a && r.ES6_CONFORMANCE)
          return a;
      } else if (u())
        return a;
      var oe = "$jscomp_hidden_" + Math.random();
      se("freeze"), se("preventExtensions"), se("seal");
      var tt = 0, X = function(F) {
        if (this.id_ = (tt += Math.random() + 1).toString(), F) {
          F = r.makeIterator(F);
          for (var j; !(j = F.next()).done; )
            j = j.value, this.set(j[0], j[1]);
        }
      };
      return X.prototype.set = function(b, F) {
        if (!O(b))
          throw Error("Invalid WeakMap key");
        if (C(b), !r.owns(b, oe))
          throw Error("WeakMap key fail: " + b);
        return b[oe][this.id_] = F, this;
      }, X.prototype.get = function(b) {
        return O(b) && r.owns(b, oe) ? b[oe][this.id_] : void 0;
      }, X.prototype.has = function(b) {
        return O(b) && r.owns(b, oe) && r.owns(b[oe], this.id_);
      }, X.prototype.delete = function(b) {
        return O(b) && r.owns(b, oe) && r.owns(b[oe], this.id_) ? delete b[oe][this.id_] : !1;
      }, X;
    }, "es6", "es3"), r.MapEntry = function() {
    }, r.polyfill("Map", function(a) {
      function u() {
        if (r.ASSUME_NO_NATIVE_MAP || !a || typeof a != "function" || !a.prototype.entries || typeof Object.seal != "function")
          return !1;
        try {
          var X = Object.seal({
            x: 4
          }), b = new a(r.makeIterator([[X, "s"]]));
          if (b.get(X) != "s" || b.size != 1 || b.get({
            x: 4
          }) || b.set({
            x: 4
          }, "t") != b || b.size != 2)
            return !1;
          var F = b.entries(), j = F.next();
          return j.done || j.value[0] != X || j.value[1] != "s" ? !1 : (j = F.next(), !(j.done || j.value[0].x != 4 || j.value[1] != "t" || !F.next().done));
        } catch (it) {
          return !1;
        }
      }
      if (r.USE_PROXY_FOR_ES6_CONFORMANCE_CHECKS) {
        if (a && r.ES6_CONFORMANCE)
          return a;
      } else if (u())
        return a;
      var E = /* @__PURE__ */ new WeakMap(), O = function(b) {
        if (this.data_ = {}, this.head_ = oe(), this.size = 0, b) {
          b = r.makeIterator(b);
          for (var F; !(F = b.next()).done; )
            F = F.value, this.set(F[0], F[1]);
        }
      };
      O.prototype.set = function(X, b) {
        X = X === 0 ? 0 : X;
        var F = C(this, X);
        return F.list || (F.list = this.data_[F.id] = []), F.entry ? F.entry.value = b : (F.entry = {
          next: this.head_,
          previous: this.head_.previous,
          head: this.head_,
          key: X,
          value: b
        }, F.list.push(F.entry), this.head_.previous.next = F.entry, this.head_.previous = F.entry, this.size++), this;
      }, O.prototype.delete = function(X) {
        return X = C(this, X), X.entry && X.list ? (X.list.splice(X.index, 1), X.list.length || delete this.data_[X.id], X.entry.previous.next = X.entry.next, X.entry.next.previous = X.entry.previous, X.entry.head = null, this.size--, !0) : !1;
      }, O.prototype.clear = function() {
        this.data_ = {}, this.head_ = this.head_.previous = oe(), this.size = 0;
      }, O.prototype.has = function(X) {
        return !!C(this, X).entry;
      }, O.prototype.get = function(X) {
        return (X = C(this, X).entry) && X.value;
      }, O.prototype.entries = function() {
        return se(this, function(X) {
          return [X.key, X.value];
        });
      }, O.prototype.keys = function() {
        return se(this, function(X) {
          return X.key;
        });
      }, O.prototype.values = function() {
        return se(this, function(X) {
          return X.value;
        });
      }, O.prototype.forEach = function(X, b) {
        for (var F = this.entries(), j; !(j = F.next()).done; )
          j = j.value, X.call(b, j[1], j[0], this);
      }, O.prototype[Symbol.iterator] = O.prototype.entries;
      var C = function(b, F) {
        var j = F && Z(F);
        j == "object" || j == "function" ? E.has(F) ? j = E.get(F) : (j = "" + ++tt, E.set(F, j)) : j = "p_" + F;
        var it = b.data_[j];
        if (it && r.owns(b.data_, j))
          for (b = 0; b < it.length; b++) {
            var _t = it[b];
            if (F !== F && _t.key !== _t.key || F === _t.key)
              return {
                id: j,
                list: it,
                index: b,
                entry: _t
              };
          }
        return {
          id: j,
          list: it,
          index: -1,
          entry: void 0
        };
      }, se = function(b, F) {
        var j = b.head_;
        return r.iteratorPrototype(function() {
          if (j) {
            for (; j.head != b.head_; )
              j = j.previous;
            for (; j.next != j.head; )
              return j = j.next, {
                done: !1,
                value: F(j)
              };
            j = null;
          }
          return {
            done: !0,
            value: void 0
          };
        });
      }, oe = function() {
        var b = {};
        return b.previous = b.next = b.head = b;
      }, tt = 0;
      return O;
    }, "es6", "es3");
    var s = "omid_message_guid", l = "omid_message_method", h = "omid_message_version", m = "omid_message_args", g = function(u, E, O, C) {
      this.guid = u, this.method = E, this.version = O, this.args = C;
    };
    g.isValidSerializedMessage = function(a) {
      return !!a && a[s] !== void 0 && a[l] !== void 0 && a[h] !== void 0 && typeof a[s] == "string" && typeof a[l] == "string" && typeof a[h] == "string" && (a[m] === void 0 || a[m] !== void 0);
    }, g.deserialize = function(a) {
      return new g(a[s], a[l], a[h], a[m]);
    }, g.prototype.serialize = function() {
      var a = {};
      return a = (a[s] = this.guid, a[l] = this.method, a[h] = this.version, a), this.args !== void 0 && (a[m] = this.args), a;
    };
    var y = {
      AdEventType: {
        SESSION_START: "sessionStart",
        SESSION_FINISH: "sessionFinish"
      },
      MediaEventType: {
        LOADED: "loaded",
        START: "start",
        FIRST_QUARTILE: "firstQuartile",
        MIDPOINT: "midpoint",
        THIRD_QUARTILE: "thirdQuartile",
        COMPLETE: "complete",
        PAUSE: "pause",
        RESUME: "resume",
        BUFFER_START: "bufferStart",
        BUFFER_FINISH: "bufferFinish",
        SKIPPED: "skipped",
        VOLUME_CHANGE: "volumeChange",
        PLAYER_STATE_CHANGE: "playerStateChange",
        AD_USER_INTERACTION: "adUserInteraction"
      },
      ImpressionType: {
        DEFINED_BY_JAVASCRIPT: "definedByJavaScript"
      },
      ErrorType: {
        GENERIC: "generic"
      },
      AccessMode: {
        FULL: "full"
      },
      Environment: {
        APP: "app",
        WEB: "web"
      },
      CreativeType: {
        DEFINED_BY_JAVASCRIPT: "definedByJavaScript"
      },
      CommunicationType: {
        NONE: "NONE",
        DIRECT: "DIRECT",
        POST_MESSAGE: "POST_MESSAGE"
      },
      MessageMethod: {
        IDENTIFY_SERVICE_WINDOW: "identifyServiceWindow"
      }
    }, L = function(u) {
      this.to = u, this.communicationType_ = y.CommunicationType.NONE;
    };
    L.prototype.sendMessage = function(a, u) {
    }, L.prototype.handleMessage = function(a, u) {
      this.onMessage && this.onMessage(a, u);
    }, L.prototype.serialize = function(a) {
      return JSON.stringify(a);
    }, L.prototype.deserialize = function(a) {
      return JSON.parse(a);
    }, L.prototype.isDirectCommunication = function() {
      return this.communicationType_ === y.CommunicationType.DIRECT;
    }, L.prototype.isCrossOrigin = function() {
    };
    function ie(a, u) {
      if (!u)
        throw Error("Value for " + a + " is undefined, null or blank.");
      if (typeof u != "string" && !(u instanceof String))
        throw Error("Value for " + a + " is not a string.");
      if (u.trim() === "")
        throw Error("Value for " + a + " is empty string.");
    }
    function ee(a, u) {
      if (u == null)
        throw Error("Value for " + a + " is undefined or null");
    }
    function Oe(a, u) {
      if (u == null)
        throw Error(a + " must not be null or undefined.");
      if (typeof u != "number" || isNaN(u))
        throw Error("Value for " + a + " is not a number");
    }
    function Q(a, u, E, O) {
      if (Oe(a, u), u < E || u > O)
        throw Error("Value for " + a + " is outside the range [" + E + "," + O + "]");
    }
    function z() {
      return typeof i == "undefined" ? null : i;
    }
    function S(a, u) {
      return a && (a[u] || (a[u] = {}));
    }
    function I(a, u, E) {
      (E = E === void 0 ? z() : E) && (a = a.split("."), a.slice(0, a.length - 1).reduce(S, E)[a[a.length - 1]] = u);
    }
    var x = function(u, E) {
      ie("Partner.name", u), ie("Partner.version", E), this.name = u, this.version = E;
    };
    I("OmidSessionClient.Partner", x);
    var Y = function(u, E, O, C) {
      C = C === void 0 ? y.AccessMode.FULL : C, ie("VerificationScriptResource.resourceUrl", u), this.resourceUrl = u, this.vendorKey = E, this.verificationParameters = O, this.accessMode = C;
    };
    Y.prototype.toJSON = function() {
      return {
        accessMode: this.accessMode,
        resourceUrl: this.resourceUrl,
        vendorKey: this.vendorKey,
        verificationParameters: this.verificationParameters
      };
    }, I("OmidSessionClient.VerificationScriptResource", Y);
    var W = function(u, E) {
      ie("UniversalAdId.value", u), ie("UniversalAdId.idRegistry", E), this.value = u, this.idRegistry = E;
    };
    W.prototype.toSerialisedValue = function() {
      return this.value + "; " + this.idRegistry;
    }, I("OmidSessionClient.UniversalAdId", W);
    var J = function(u, E, O, C, se) {
      O = O === void 0 ? null : O, C = C === void 0 ? null : C, se = se === void 0 ? null : se, ee("Context.partner", u), this.partner = u, this.verificationScriptResources = E, this.videoElement = this.slotElement = null, this.contentUrl = O, this.customReferenceData = C, this.underEvaluation = !1, this.serviceWindow = null, this.universalAdId = se;
    };
    J.prototype.setVideoElement = function(a) {
      ee("Context.videoElement", a), this.videoElement = a;
    }, J.prototype.setSlotElement = function(a) {
      ee("Context.slotElement", a), this.slotElement = a;
    }, J.prototype.setServiceWindow = function(a) {
      ee("Context.serviceWindow", a), this.serviceWindow = a;
    }, I("OmidSessionClient.Context", J);
    var U = {};
    function D() {
      if (typeof e != "undefined" && e)
        return e;
      if (typeof St != "undefined" && St)
        return St;
      if (typeof window != "undefined" && window)
        return window;
      if (typeof globalThis != "undefined" && globalThis)
        return globalThis;
      var a = Function("return this")();
      if (a)
        return a;
      throw Error("Could not determine global object context.");
    }
    U.omidGlobal = D();
    var N = {
      ROOT: "omidSessionInterface",
      AD_EVENTS: "adEvents",
      MEDIA_EVENTS: "mediaEvents"
    }, P = {
      sessionError: "reportError"
    }, $ = Object.keys(y.MediaEventType).map(function(a) {
      return y.MediaEventType[a];
    }), re = ["impressionOccurred"], De = function(u) {
      u = u === void 0 ? U.omidGlobal : u, this.interfaceRoot_ = u[N.ROOT];
    };
    De.prototype.isSupported = function() {
      return this.interfaceRoot_ != null;
    }, De.prototype.sendMessage = function(a, u, E) {
      if (a == "registerSessionObserver" && (E = [u]), P[a] && (a = P[a]), u = this.interfaceRoot_, 0 <= re.indexOf(a) && (u = u[N.AD_EVENTS]), 0 <= $.indexOf(a) && (u = u[N.MEDIA_EVENTS]), u = u[a], !u)
        throw Error("Unrecognized method name: " + a + ".");
      u.apply(null, r.arrayFromIterable(E));
    };
    function Le() {
      return "xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g, function(a) {
        var u = 16 * Math.random() | 0;
        return a = a === "y" ? (u & 3 | 8).toString(16) : u.toString(16), a;
      });
    }
    function ft() {
      var a = r.getRestArguments.apply(0, arguments);
      kt(function() {
        throw new (Function.prototype.bind.apply(Error, [null, "Could not complete the test successfully - "].concat(r.arrayFromIterable(a))))();
      }, function() {
        return console.error.apply(console, r.arrayFromIterable(a));
      });
    }
    function kt(a, u) {
      typeof jasmine != "undefined" && jasmine ? a() : typeof console != "undefined" && console && console.error && u();
    }
    var ze = {
      Version: "1.5.6-iab144"
    }, dt = 3;
    function He(a) {
      return /\d+\.\d+\.\d+(-.*)?/.test(a);
    }
    function Nt(a, u) {
      a = a.split("-")[0].split("."), u = u.split("-")[0].split(".");
      for (var E = 0; E < dt; E++) {
        var O = parseInt(a[E], 10), C = parseInt(u[E], 10);
        if (O > C)
          break;
        if (O < C)
          return !1;
      }
      return !0;
    }
    var et = "1.0.3";
    function At(a, u) {
      return He(a) && Nt(a, et) ? u : JSON.stringify(u);
    }
    function ut(a, u) {
      return He(a) && Nt(a, et) ? u || [] : u && typeof u == "string" ? JSON.parse(u) : [];
    }
    var We = {
      SESSION_SERVICE: "SessionService."
    };
    function Ut(a) {
      return Se(a, We.SESSION_SERVICE);
    }
    function Se(a, u) {
      return u + a;
    }
    function mt(a) {
      return a != null && typeof a.top != "undefined" && a.top != null;
    }
    function Ue(a) {
      if (a === U.omidGlobal)
        return !1;
      try {
        if (typeof a.location.hostname == "undefined")
          return !0;
        Re(a);
      } catch (u) {
        return !0;
      }
      return !1;
    }
    function Re(a) {
      return a.x === "" || a.x !== "";
    }
    function be(a) {
      return typeof a == "undefined" && typeof window != "undefined" && window && (a = window), mt(a) ? a : U.omidGlobal;
    }
    function Xe(a) {
      return mt(a) ? a.top : U.omidGlobal;
    }
    var V = function(u) {
      L.call(this, u), this.communicationType_ = y.CommunicationType.DIRECT, this.handleExportedMessage = V.prototype.handleExportedMessage.bind(this);
    };
    r.inherits(V, L), V.prototype.sendMessage = function(a, u) {
      if (u = u === void 0 ? this.to : u, !u)
        throw Error("Message destination must be defined at construction time or when sending the message.");
      u.handleExportedMessage(a.serialize(), this);
    }, V.prototype.handleExportedMessage = function(a, u) {
      g.isValidSerializedMessage(a) && this.handleMessage(g.deserialize(a), u);
    }, V.prototype.isCrossOrigin = function() {
      return !1;
    };
    var B = function(u, E) {
      E = E === void 0 ? U.omidGlobal : E, L.call(this, E);
      var O = this;
      this.communicationType_ = y.CommunicationType.POST_MESSAGE, u.addEventListener("message", function(C) {
        if (Z(C.data) === "object") {
          var se = C.data;
          g.isValidSerializedMessage(se) && (se = g.deserialize(se), C.source && O.handleMessage(se, C.source));
        }
      });
    };
    r.inherits(B, L), B.isCompatibleContext = function(a) {
      return !!(a && a.addEventListener && a.postMessage);
    }, B.prototype.sendMessage = function(a, u) {
      if (u = u === void 0 ? this.to : u, !u)
        throw Error("Message destination must be defined at construction time or when sending the message.");
      u.postMessage(a.serialize(), "*");
    }, B.prototype.isCrossOrigin = function() {
      return this.to ? Ue(this.to) : !0;
    };
    var G = {
      OMID_PRESENT_FRAME_NAME: "omid_v1_present",
      OMID_PRESENT_FRAME_NAME_WEB: "omid_v1_present_web",
      OMID_PRESENT_FRAME_NAME_APP: "omid_v1_present_app",
      getEnvironmentIframeName: function(u) {
        var E = {};
        return (E[y.Environment.APP] = G.OMID_PRESENT_FRAME_NAME_APP, E[y.Environment.WEB] = G.OMID_PRESENT_FRAME_NAME_WEB, E)[u];
      }
    };
    function Ae(a, u) {
      try {
        return a.frames && !!a.frames[u];
      } catch (E) {
        return !1;
      }
    }
    G.isOmidPresent = function(a) {
      return [G.OMID_PRESENT_FRAME_NAME, G.OMID_PRESENT_FRAME_NAME_WEB, G.OMID_PRESENT_FRAME_NAME_APP].some(function(u) {
        return Ae(a, u);
      });
    }, G.getOmidEnvironment = function(a) {
      for (var u = r.makeIterator(Object.values(y.Environment)), E = u.next(); !E.done; E = u.next()) {
        E = E.value;
        var O = G.getEnvironmentIframeName(E);
        if (Ae(a, O))
          return E;
      }
      return null;
    };
    function le(a, u) {
      a.document.write('<iframe style="display:none" id="' + (u + '" name="' + u + '" sandbox></iframe>'));
    }
    G.declareOmidPresence = function(a, u) {
      a.frames && a.document && ![G.OMID_PRESENT_FRAME_NAME, G.OMID_PRESENT_FRAME_NAME_WEB, G.OMID_PRESENT_FRAME_NAME_APP].some(function(E) {
        return !!a.frames[E];
      }) && (a.document.body == null && G.isMutationObserverAvailable_(a) ? G.registerMutationObserver_(a, u) : (u = G.getEnvironmentIframeName(u), a.document.body ? (G.appendPresenceIframe_(a, G.OMID_PRESENT_FRAME_NAME), G.appendPresenceIframe_(a, u)) : (le(a, G.OMID_PRESENT_FRAME_NAME), le(a, u))));
    }, G.appendPresenceIframe_ = function(a, u) {
      var E = a.document.createElement("iframe");
      E.id = u, E.name = u, E.style.display = "none", E.sandbox = "", a.document.body.appendChild(E);
    }, G.isMutationObserverAvailable_ = function(a) {
      return "MutationObserver" in a;
    }, G.registerMutationObserver_ = function(a, u) {
      var E = new MutationObserver(function(O) {
        O.forEach(function(C) {
          C.addedNodes[0].nodeName === "BODY" && (C = G.getEnvironmentIframeName(u), G.appendPresenceIframe_(a, G.OMID_PRESENT_FRAME_NAME), G.appendPresenceIframe_(a, C), E.disconnect());
        });
      });
      E.observe(a.document.documentElement, {
        childList: !0
      });
    };
    var Et = ["omid", "v1_SessionServiceCommunication"];
    function Ct(a, u) {
      return u.reduce(function(E, O) {
        return E && E[O];
      }, a);
    }
    function fi(a, u, E, O) {
      if (!Ue(u))
        try {
          var C = Ct(u, E);
          if (C)
            return new V(C);
        } catch (se) {
        }
      return O(u) ? new B(a, u) : null;
    }
    function qe(a, u, E, O) {
      u = r.makeIterator(u);
      for (var C = u.next(); !C.done; C = u.next())
        if (C = fi(a, C.value, E, O))
          return C;
      return null;
    }
    function Ai(a, u, E) {
      E = E === void 0 ? G.isOmidPresent : E;
      var O = [a, Xe(a)];
      return u && O.unshift(u), qe(a, O, Et, E);
    }
    var ne = function(u, E, O) {
      ee("AdSession.context", u), this.adSessionId_ = Le(), this.context_ = u, this.impressionOccurred_ = !1;
      var C = this.context_.serviceWindow || void 0;
      this.communication_ = E || Ai(be(), C), this.sessionInterface_ = O || new De(), this.isSessionRunning_ = this.hasMediaEvents_ = this.hasAdEvents_ = !1, this.impressionType_ = this.creativeType_ = null, this.creativeLoaded_ = !1, this.callbackMap_ = {}, this.communication_ && (this.communication_.onMessage = this.handleInternalMessage_.bind(this)), this.setClientInfo_(), this.injectVerificationScripts_(u.verificationScriptResources), this.sendSlotElement_(u.slotElement), this.sendVideoElement_(u.videoElement), this.sendContentUrl_(u.contentUrl), this.watchSessionEvents_();
    };
    ne.prototype.getAdSessionId = function() {
      return this.adSessionId_;
    }, ne.prototype.setCreativeType = function(a) {
      if (a === y.CreativeType.DEFINED_BY_JAVASCRIPT)
        throw Error("Creative type cannot be redefined with value " + y.CreativeType.DEFINED_BY_JAVASCRIPT);
      if (this.impressionOccurred_)
        throw Error("Impression has already occurred");
      if (this.creativeLoaded_)
        throw Error("Creative has already loaded");
      if (this.creativeType_ && this.creativeType_ !== y.CreativeType.DEFINED_BY_JAVASCRIPT)
        throw Error("Creative type cannot be redefined");
      if (this.creativeType_ === void 0)
        throw Error("Native integration is using OMID 1.2 or earlier");
      this.sendOneWayMessage("setCreativeType", a, this.adSessionId_), this.creativeType_ = a;
    }, ne.prototype.setImpressionType = function(a) {
      if (a === y.ImpressionType.DEFINED_BY_JAVASCRIPT)
        throw Error("Impression type cannot be redefined with value " + y.ImpressionType.DEFINED_BY_JAVASCRIPT);
      if (this.impressionOccurred_)
        throw Error("Impression has already occurred");
      if (this.creativeLoaded_)
        throw Error("Creative has already loaded");
      if (this.impressionType_ && this.impressionType_ !== y.ImpressionType.DEFINED_BY_JAVASCRIPT)
        throw Error("Impression type cannot be redefined");
      if (this.impressionType_ === void 0)
        throw Error("Native integration is using OMID 1.2 or earlier");
      this.sendOneWayMessage("setImpressionType", a, this.adSessionId_), this.impressionType_ = a;
    }, ne.prototype.isSupported = function() {
      return !!this.communication_ || this.sessionInterface_.isSupported();
    }, ne.prototype.isSendingElementsSupported_ = function() {
      return this.communication_ ? this.communication_.isDirectCommunication() : this.sessionInterface_.isSupported();
    }, ne.prototype.registerSessionObserver = function(a) {
      this.sendMessage("registerSessionObserver", a, this.adSessionId_);
    }, ne.prototype.start = function() {
      var a = {
        customReferenceData: this.context_.customReferenceData,
        underEvaluation: this.context_.underEvaluation
      };
      this.context_.universalAdId && (a.universalAdId = this.context_.universalAdId.toSerialisedValue()), this.sendOneWayMessage("startSession", a, this.adSessionId_);
    }, ne.prototype.finish = function() {
      this.sendOneWayMessage("finishSession", this.adSessionId_);
    }, ne.prototype.error = function(a, u) {
      this.sendOneWayMessage("sessionError", a, u, this.adSessionId_);
    }, ne.prototype.registerAdEvents = function() {
      if (this.hasAdEvents_)
        throw Error("AdEvents already registered.");
      this.hasAdEvents_ = !0, this.sendOneWayMessage("registerAdEvents", this.adSessionId_);
    }, ne.prototype.registerMediaEvents = function() {
      if (this.hasMediaEvents_)
        throw Error("MediaEvents already registered.");
      this.hasMediaEvents_ = !0, this.sendOneWayMessage("registerMediaEvents", this.adSessionId_);
    }, ne.prototype.sendOneWayMessage = function(a) {
      var u = r.getRestArguments.apply(1, arguments);
      this.sendMessage.apply(this, [a, null].concat(r.arrayFromIterable(u)));
    }, ne.prototype.sendMessage = function(a, u) {
      var E = r.getRestArguments.apply(2, arguments);
      this.communication_ ? this.sendInternalMessage_(a, u, E) : this.sessionInterface_.isSupported() && this.sendInterfaceMessage_(a, u, E);
    }, ne.prototype.sendInternalMessage_ = function(a, u, E) {
      var O = Le();
      u && (this.callbackMap_[O] = u), a = new g(O, Ut(a), ze.Version, At(ze.Version, E)), this.communication_.sendMessage(a);
    }, ne.prototype.handleInternalMessage_ = function(a, u) {
      u = a.method;
      var E = a.guid;
      if (a = a.args, u === "response" && this.callbackMap_[E]) {
        var O = ut(ze.Version, a);
        this.callbackMap_[E].apply(this, O);
      }
      u === "error" && window.console && ft(a);
    }, ne.prototype.sendInterfaceMessage_ = function(a, u, E) {
      try {
        this.sessionInterface_.sendMessage(a, u, E);
      } catch (O) {
        ft("Failed to communicate with SessionInterface with error:"), ft(O);
      }
    }, ne.prototype.assertSessionRunning = function() {
      if (!this.isSessionRunning_)
        throw Error("Session not started.");
    }, ne.prototype.impressionOccurred = function() {
      if (this.creativeType_ === y.CreativeType.DEFINED_BY_JAVASCRIPT)
        throw Error("Creative type has not been redefined");
      if (this.impressionType_ === y.ImpressionType.DEFINED_BY_JAVASCRIPT)
        throw Error("Impression type has not been redefined");
      this.impressionOccurred_ = !0;
    }, ne.prototype.creativeLoaded = function() {
      if (this.creativeType_ === y.CreativeType.DEFINED_BY_JAVASCRIPT)
        throw Error("Creative type has not been redefined");
      if (this.impressionType_ === y.ImpressionType.DEFINED_BY_JAVASCRIPT)
        throw Error("Impression type has not been redefined");
      this.creativeLoaded_ = !0;
    }, ne.prototype.setClientInfo_ = function() {
      this.sendOneWayMessage("setClientInfo", ze.Version, this.context_.partner.name, this.context_.partner.version, this.adSessionId_);
    }, ne.prototype.injectVerificationScripts_ = function(a) {
      a && (a = a.map(function(u) {
        return u.toJSON();
      }), this.sendOneWayMessage("injectVerificationScriptResources", a, this.adSessionId_));
    }, ne.prototype.sendSlotElement_ = function(a) {
      this.sendElement_(a, "setSlotElement");
    }, ne.prototype.sendVideoElement_ = function(a) {
      this.sendElement_(a, "setVideoElement");
    }, ne.prototype.sendElement_ = function(a, u) {
      a && (this.isSendingElementsSupported_() ? this.sendOneWayMessage(u, a, this.adSessionId_) : this.error(y.ErrorType.GENERIC, "Session Client " + u + " called when communication is cross-origin"));
    }, ne.prototype.sendContentUrl_ = function(a) {
      a && this.sendOneWayMessage("setContentUrl", a, this.adSessionId_);
    }, ne.prototype.setElementBounds = function(a) {
      ee("AdSession.elementBounds", a), this.sendOneWayMessage("setElementBounds", a, this.adSessionId_);
    }, ne.prototype.watchSessionEvents_ = function() {
      var a = this;
      this.registerSessionObserver(function(u) {
        u.type === y.AdEventType.SESSION_START && (a.isSessionRunning_ = !0, a.creativeType_ = u.data.creativeType, a.impressionType_ = u.data.impressionType), u.type === y.AdEventType.SESSION_FINISH && (a.isSessionRunning_ = !1);
      });
    }, I("OmidSessionClient.AdSession", ne);
    var Jt = function(u, E, O, C) {
      this.isSkippable = u, this.skipOffset = E, this.isAutoPlay = O, this.position = C;
    };
    Jt.prototype.toJSON = function() {
      return {
        isSkippable: this.isSkippable,
        skipOffset: this.skipOffset,
        isAutoPlay: this.isAutoPlay,
        position: this.position
      };
    };
    var Zt = function(u) {
      ee("AdEvents.adSession", u), this.adSessionId_ = u.getAdSessionId();
      try {
        u.registerAdEvents(), this.adSession = u;
      } catch (E) {
        throw Error("AdSession already has an ad events instance registered");
      }
    };
    Zt.prototype.impressionOccurred = function() {
      this.adSession.assertSessionRunning(), this.adSession.impressionOccurred(), this.adSession.sendOneWayMessage("impressionOccurred", this.adSessionId_);
    }, Zt.prototype.loaded = function(a) {
      a = a === void 0 ? null : a, this.adSession.creativeLoaded(), a = a ? a.toJSON() : null, this.adSession.sendOneWayMessage("loaded", a, this.adSessionId_);
    }, I("OmidSessionClient.AdEvents", Zt);
    var ye = function(u) {
      ee("MediaEvents.adSession", u), this.adSessionId_ = u.getAdSessionId();
      try {
        u.registerMediaEvents(), this.adSession = u;
      } catch (E) {
        throw Error("AdSession already has a media events instance registered");
      }
    };
    ye.prototype.start = function(a, u) {
      Oe("MediaEvents.start.duration", a), Q("MediaEvents.start.mediaPlayerVolume", u, 0, 1), this.adSession.sendOneWayMessage("start", a, u, this.adSessionId_);
    }, ye.prototype.firstQuartile = function() {
      this.adSession.sendOneWayMessage("firstQuartile", this.adSessionId_);
    }, ye.prototype.midpoint = function() {
      this.adSession.sendOneWayMessage("midpoint", this.adSessionId_);
    }, ye.prototype.thirdQuartile = function() {
      this.adSession.sendOneWayMessage("thirdQuartile", this.adSessionId_);
    }, ye.prototype.complete = function() {
      this.adSession.sendOneWayMessage("complete", this.adSessionId_);
    }, ye.prototype.pause = function() {
      this.adSession.sendOneWayMessage("pause", this.adSessionId_);
    }, ye.prototype.resume = function() {
      this.adSession.sendOneWayMessage("resume", this.adSessionId_);
    }, ye.prototype.bufferStart = function() {
      this.adSession.sendOneWayMessage("bufferStart", this.adSessionId_);
    }, ye.prototype.bufferFinish = function() {
      this.adSession.sendOneWayMessage("bufferFinish", this.adSessionId_);
    }, ye.prototype.skipped = function() {
      this.adSession.sendOneWayMessage("skipped", this.adSessionId_);
    }, ye.prototype.volumeChange = function(a) {
      Q("MediaEvents.volumeChange.mediaPlayerVolume", a, 0, 1), this.adSession.sendOneWayMessage("volumeChange", a, this.adSessionId_);
    }, ye.prototype.playerStateChange = function(a) {
      ee("MediaEvents.playerStateChange.playerState", a), this.adSession.sendOneWayMessage("playerStateChange", a, this.adSessionId_);
    }, ye.prototype.adUserInteraction = function(a) {
      ee("MediaEvents.adUserInteraction.interactionType", a), this.adSession.sendOneWayMessage("adUserInteraction", a, this.adSessionId_);
    }, I("OmidSessionClient.MediaEvents", ye);
    var mi = function(u, E) {
      ie("OmidVersion.semanticVersion", u), ie("OmidVersion.apiLevel", E);
    };
    I("OmidSessionClient.OmidVersion", mi);
    function Ei(a) {
      var u = be();
      new B(u).onMessage = function(E, O) {
        E.method === y.MessageMethod.IDENTIFY_SERVICE_WINDOW && a(O);
      };
    }
    I("OmidSessionClient.listenForServiceWindow", Ei), I("OmidSessionClient.VastProperties", Jt);
    var Fe = {
      VerificationVendorId: {
        OTHER: 1,
        MOAT: 2,
        DOUBLEVERIFY: 3,
        INTEGRAL_AD_SCIENCE: 4,
        PIXELATE: 5,
        NIELSEN: 6,
        COMSCORE: 7,
        MEETRICS: 8,
        GOOGLE: 9,
        HUMAN: 10
      }
    };
    function gi(a) {
      for (var u = r.makeIterator(Ft.keys()), E = u.next(); !E.done; E = u.next()) {
        E = E.value;
        for (var O = r.makeIterator(Ft.get(E)), C = O.next(); !C.done; C = O.next())
          if (C.value.test(a))
            return E;
      }
      return Fe.VerificationVendorId.OTHER;
    }
    var Ft = /* @__PURE__ */ new Map([[Fe.VerificationVendorId.DOUBLEVERIFY, [/^(https?:\/\/|\/\/)?[-a-zA-Z0-9.]+\.doubleverify\.com\/.*$/, /^(https?:\/\/|\/\/)?c\.[\w\-]+\.com\/vfw\/dv\/.*$/, /^(https?:\/\/|\/\/)?(www\.)?[\w]+\.tv\/r\/s\/d\/.*$/, /^(https?:\/\/|\/\/)?(\w\.?)+\.dv\.tech\/.*$/]], [Fe.VerificationVendorId.INTEGRAL_AD_SCIENCE, [/^(https?:\/\/|\/\/)?[-a-zA-Z0-9.]+\.adsafeprotected\.com\/.*$/]], [Fe.VerificationVendorId.PIXELATE, [/^https?:\/\/(q|cdn)\.adrta\.com\/s\/.*\/(aa|aanf)\.js.*$/, /^https:\/\/cdn\.rta247\.com\/s\/.*\/(aa|aanf)\.js.*$/]], [Fe.VerificationVendorId.NIELSEN, []], [Fe.VerificationVendorId.COMSCORE, [/^(https?:\/\/|\/\/)?[-a-zA-Z0-9.]+\.voicefive\.com\/.*$/, /^(https?:\/\/|\/\/)?[-a-zA-Z0-9.]+\.measuread\.com\/.*$/, /^(https?:\/\/|\/\/)?[-a-zA-Z0-9.]+\.scorecardresearch\.com\/.*$/]], [Fe.VerificationVendorId.MEETRICS, [/^(https?:\/\/|\/\/)?s418\.mxcdn\.net\/bb-serve\/omid-meetrics.*\.js$/]], [Fe.VerificationVendorId.GOOGLE, [/^(https?:\/\/|\/\/)?pagead2\.googlesyndication\.com\/.*$/, /^(https?:\/\/|\/\/)?www\.googletagservices\.com\/.*$/]], [Fe.VerificationVendorId.HUMAN, [/^(https?:\/\/|\/\/)?[-a-zA-Z0-9.]+\.script\.ac\/.*$/, /^(https?:\/\/|\/\/)?[-a-zA-Z0-9.]+\/(2|ag|static)\/[a-zA-Z0-9.]*\/analytics.js.*$/]]]);
    I("OmidSessionClient.verificationVendorIdForScriptUrl", gi), I("OmidSessionClient.VerificationVendorId", Fe.VerificationVendorId), Fe.verificationVendorIdForScriptUrl = gi;
  }, c);
})(es);
const Ro = /* @__PURE__ */ To(es), me = class me {
  constructor(e, i) {
    if (this.ad = e, this.adSlotDelivery = i, this.sessionClient = Ro.OmidSessionClient, this.removeEventHandlers = [], this.video = i.player.getPlayerElement(), !this.sessionClient) {
      p.debug.warn(me.NAME + "const. - no sessionClient available!");
      return;
    }
    if (this.CONTENT_URL = i.player.getCurrentContentSource(), this.OMSDK_SERVICE_WINDOW = e.config.adVerification.serviceWindow, this.internalOmidConfig = e.config.adVerification, this.verifications = this.filterVerifications(
      e.adVerifications,
      this.internalOmidConfig.vendorWhitelist
    ), !this.verifications || this.verifications.length === 0) {
      p.debug.info(
        me.NAME + "verification(s) found after application of the allow-list is/are 0"
      );
      return;
    }
    if (p.debug.info(
      me.NAME,
      this.verifications.length,
      "verification(s) found after initial"
    ), p.debug.table(this.verifications), e.isVPAID && !e.config.shareVideoElementWithVPAID) {
      p.debug.info(
        me.NAME + " VPAID ad with shareVideoElementWithVPAID set to false is not supported!"
      );
      return;
    }
    this.initOMIDJS() && this.addEventListeners();
  }
  createVastProperties() {
    return new this.sessionClient.VastProperties(
      this.ad.skipOffset > -1,
      // skippable
      this.ad.skipOffset,
      !0,
      // autoplay
      me.POSITION_MAP[this.ad.adBreakPosition]
    );
  }
  filterVerifications(e, i) {
    return !e || e.length === 0 ? e : e.filter((r) => {
      const s = !i || i.length === 0 || i.includes(r.vendor);
      if (!s)
        return this.trackError(r.tracking.verificationNotExecuted, oi.ERROR_RESOURCE_REJECTED), !1;
      if (i)
        return !0;
      const l = r.javascriptResource ? r.javascriptResource.apiFramework.toLowerCase() === "omid" : !1;
      return !i && !l ? (s && this.trackError(
        r.tracking.verificationNotExecuted,
        oi.ERROR_VERIFICATION_NOT_SUPPORTED
      ), !1) : !0;
    });
  }
  initOMIDJS() {
    if (this.adSession = this.createAdSession(), this.adSession.impressionType_ || this.adSession.setImpressionType(this.ad.config.trackImpressionOnStart ? me.IMPRESSION_TYPE.RENDER : me.IMPRESSION_TYPE.LOADED), this.adSession.creativeType_ || this.adSession.setCreativeType(this.ad.adType), p.debug.info(me.NAME + "initOMIDJS", this.adSession), !this.adSession.isSupported())
      return p.debug.error(me.NAME + "isSupported - session not supported, call all error trackers and tear down"), this.verifications.map((i) => {
        this.trackError(
          i.tracking.verificationNotExecuted,
          oi.ERROR_VERIFICATION_NOT_SUPPORTED
        );
      }), !1;
    this.adEvents = new this.sessionClient.AdEvents(this.adSession);
    const e = () => {
      const i = this.createVastProperties();
      this.adEvents.loaded(i), this.video.removeEventListener("canplaythrough", e);
    };
    return this.video.addEventListener("canplaythrough", e), this.mediaEvents = new this.sessionClient.MediaEvents(this.adSession), this.adSession.start(), !0;
  }
  createAdSession() {
    let e = new this.sessionClient.Partner(me.PARTNER_NAME, me.PARTNER_VERSION), i = this.verifications.map((s) => (p.debug.info(
      me.NAME + "VerificationScriptResource",
      "omidScriptURL:",
      Fi(s.javascriptResource.url, s.javascriptResource.url),
      "vendor:",
      s.vendor,
      "verification params:",
      s.verificationParameters,
      "accessMode:",
      this.internalOmidConfig.accessMode
    ), new this.sessionClient.VerificationScriptResource(
      Fi(s.javascriptResource.url, s.javascriptResource.url),
      s.vendor,
      s.verificationParameters,
      this.internalOmidConfig.accessMode
    ))), r = new this.sessionClient.Context(e, i, this.CONTENT_URL);
    return r.underEvaluation = !0, r.setVideoElement(this.video), r.setServiceWindow(this.OMSDK_SERVICE_WINDOW), r.supportsLoadedEvent = !0, new this.sessionClient.AdSession(r);
  }
  addEventListeners() {
    this.removeEventListeners();
    for (const e of Object.values(f)) {
      let i = this.adSlotDelivery.adSlotController.addEventListener(
        e,
        this.handleAdEvent.bind(this)
      );
      this.removeEventHandlers.push(i);
    }
  }
  removeEventListeners() {
    for (const e of this.removeEventHandlers)
      e();
    this.removeEventHandlers = [];
  }
  handleAdEvent(e) {
    switch (this.forwardEventToOMSDK(e.type), e.type) {
      case f.ON_AD_ERROR:
        this.adSession.error("generic", this.ad.error.code), this.removeEventListeners(), p.debug.info(me.NAME + "handleAdEvent AdError -- call adSession.error"), setTimeout(() => {
          this.adSession.finish();
        }, this.ad.config.adVerification.sessionCleanupDelay * 1e3);
        break;
      case f.ON_AD_SKIPPED:
      case f.ON_AD_STOPPED:
        this.removeEventListeners(), setTimeout(() => {
          p.debug.info(me.NAME + "handleAdEvent " + e.type + " -- call adSession.finish"), this.adSession.finish();
        }, this.ad.config.adVerification.sessionCleanupDelay * 1e3);
        break;
    }
  }
  forwardEventToOMSDK(e) {
    let i = "forwardEventToOMSDK";
    if (p.debug.info(me.NAME + i, e), !this.adEvents) {
      p.debug.warn(me.NAME + i + " - adEvents not set, happens when adSession is not supported");
      return;
    }
    let r;
    switch (e) {
      case f.ON_AD_STARTED:
        r = this.createVastProperties(), this.adEvents.start(r);
        break;
      case f.ON_AD_PLAYBACK_START:
        this.mediaEvents.start(
          this.ad.duration,
          this.ad.volume,
          // mediaPlayerVolume
          this.ad.volume,
          // videoPlayerVolume
          1
          // deviceVolume not detectable, assuming 1
        );
        break;
      case f.ON_AD_IMPRESSION:
        this.adEvents.impressionOccurred();
        break;
      // general video progression events
      case f.ON_AD_FIRST_QUARTILE:
        this.mediaEvents.firstQuartile();
        break;
      case f.ON_AD_MID_POINT:
        this.mediaEvents.midpoint();
        break;
      case f.ON_AD_THIRD_QUARTILE:
        this.mediaEvents.thirdQuartile();
        break;
      case f.ON_AD_PLAYBACK_FINISHED:
        this.mediaEvents.complete();
        break;
      // -- playback controls --
      case f.ON_AD_PAUSED:
        this.mediaEvents.pause();
        break;
      case f.ON_AD_PLAYING:
        this.mediaEvents.resume();
        break;
      case f.ON_AD_VOLUME_CHANGED:
        this.mediaEvents.volumeChange(
          this.ad.volume,
          // mediaPlayerVolume
          this.ad.volume,
          // videoPlayerVolume
          1
          // deviceVolume not detectable, assuming 1
        );
        break;
      case f.ON_AD_SKIPPED:
        this.mediaEvents.skipped();
        break;
      case f.ON_AD_CLICKED:
        this.mediaEvents.adUserInteraction("click");
        break;
      case f.ON_ENTER_FULLSCREEN:
        this.mediaEvents.playerStateChange("fullscreen");
        break;
      case f.ON_EXIT_FULLSCREEN:
        this.mediaEvents.playerStateChange("normal");
        break;
      case f.ON_PLAYER_EXPAND:
        this.mediaEvents.playerStateChange("expanded");
        break;
      case f.ON_PLAYER_COLLAPSE:
        this.mediaEvents.playerStateChange("collapsed");
        break;
    }
  }
  trackError(e, i) {
    this.ad.enrichment.set("REASON", i, "reason"), this.adSlotDelivery.adSlotController.callTrackers(e);
  }
};
me.IMPRESSION_TYPE = {
  AUDIBLE: "audible",
  LOADED: "loaded",
  OTHER: "other",
  PIXEL: "onePixel",
  RENDER: "beginToRender",
  UNSPECIFIED: "unspecified",
  VIEWABLE: "viewable"
}, me.PARTNER_NAME = "Smartcliptv", me.PARTNER_VERSION = "7.6.0-dev", me.POSITION_MAP = [
  "standalone",
  "preroll",
  "midroll",
  "postroll",
  "standalone"
  // equals breakPosition 'overlay' in VAST
], me.NAME = "OMID::";
let Rr = me;
const Er = "Resource", Bi = {
  STATIC: `Static${Er}`,
  HTML: `HTML${Er}`,
  IFRAME: `IFrame${Er}`
}, yt = class yt extends Rt {
  constructor(e, i) {
    super(), this.adSlotController = e.adSlotController, this.adSlotDelivery = e, this.publisherAdContainer = i, this.adContainer = null, this.ad = null, this.asset = null, this.adDisplayTime = {
      currentTime: 0,
      duration: 0,
      offset: 0
    }, this.cleanupTimer = [];
  }
  /**
   * @param {asset} asset VASTNonLinear - contains parameters and a list of VASTCreativeResources
   * @returns {Promise<void>} Resolves if the asset has been loaded and shown to the audience.
   */
  init(e) {
    return this.asset = e, this.adDisplayTime.duration = e.displayDuration, this.createAdContainer(), this.createNonLinearElement(), new Promise((i) => {
      this.render(), i();
    });
  }
  createAdContainer() {
    const e = "display:none; pointer-events:none; position:absolute; width:100%; height:100%; top:0; left:0;";
    this.adContainer = document.createElement("div"), this.adContainer.setAttribute("style", e);
  }
  createNonLinearElement() {
    let e = {
      attributes: {},
      style: {}
    };
    this.asset.scalable ? (e.style.width = "100%", e.style.height = "100%", e.style["object-fit"] = "contain", e.style["object-position"] = "bottom") : (e.style.width = parseInt(this.asset.width, 10) + "px", e.style.height = parseInt(this.asset.height, 10) + "px"), e.style.position = "absolute", e.style.bottom = "0", e.style.right = "50%", e.style.transform = "translateX(50%)", e.attributes.style = JSON.stringify(e.style), e.attributes.style = e.attributes.style.substring(1, JSON.stringify(e.style).length - 1), e.attributes.style = e.attributes.style.replace(/\"/ig, "").replace(/\,/ig, ";") + ";", e.attributes.src = this.asset.selectedResource.resource, this.ad = e;
  }
  render() {
    let e;
    switch (this.asset.selectedResource.type) {
      case Bi.STATIC:
        e = "img";
        break;
      default:
        e = "iframe";
        break;
    }
    let i = document.createElement(e);
    for (let r in this.ad.attributes)
      this.ad.attributes[r] && i.setAttribute(r, this.ad.attributes[r]);
    i.style.pointerEvents = "auto", i.onload = this.onStartAd.bind(this), e === "iframe" ? (i.style.border = "0", i.setAttribute("scrolling", "no"), i.setAttribute("margin", "0"), i.setAttribute("allowtransparency", "true")) : (i.style.cursor = "pointer", i.addEventListener("click", this.onClick.bind(this))), this.adContainer.appendChild(i), this.publisherAdContainer.appendChild(this.adContainer);
  }
  stop() {
    for (const e of this.cleanupTimer)
      clearTimeout(e);
    this.adContainer && this.adContainer.parentNode === this.publisherAdContainer && this.publisherAdContainer.removeChild(this.adContainer);
  }
  pause() {
    p.debug.info(yt.NAME + "pause");
    for (const e of this.cleanupTimer)
      clearTimeout(e);
    this.adDisplayTime.currentTime += (Date.now() - this.adDisplayTime.offset) / 1e3;
  }
  play() {
    p.debug.info(yt.NAME + "play - start or resume"), this.adDisplayTime.offset = Date.now();
    const e = this.adDisplayTime.duration - this.adDisplayTime.currentTime;
    p.debug.info(yt.NAME + "play - remove ad in", e, "seconds.");
    const i = setTimeout(this.onStopAd.bind(this), e * 1e3);
    this.cleanupTimer.push(i);
  }
  onStartAd() {
    p.debug.info(yt.NAME + "onStartAd"), this.adContainer.style.display = "block", this.dispatchEvent(f.ON_AD_LOADED), this.dispatchEvent(f.ON_AD_STARTED), this.dispatchEvent(f.ON_AD_IMPRESSION), this.dispatchEvent(f.ON_AD_CREATIVE_VIEW), this.play();
  }
  onStopAd() {
    p.debug.info(yt.NAME + "onStopAd"), this.dispatchEvent(f.ON_AD_NONLINEAR_STOPPED), this.dispatchEvent(f.ON_AD_STOPPED), this.stop();
  }
  onClick() {
    this.adSlotController.onClickThrough(this.asset);
  }
};
yt.NAME = "NonLinear::";
let Nr = yt;
const Ze = class Ze extends Rt {
  // TODO: jsDoc, (BaseAd + extend)
  constructor(e, i) {
    super(), this.adSlotController = i, this.adSlotHasStarted = !1, this.currentAd = e, this.eventCallbacks = [], this.player = i.player;
  }
  getRemoveHandlerForAdSlotControllerEvent(e, i) {
    return this.adSlotController.addEventListener(e, i);
  }
  addPlayerEventListener(e, i) {
    this.player.addEventListener(e, i);
    const r = () => this.removePlayerEventListener(e, i);
    return this.eventCallbacks.push(r), () => this.player.removeEventListener(e, i);
  }
  removePlayerEventListener(e, i) {
    this.player.removeEventListener(e, i);
  }
  cleanAndDeliveryNextAd() {
    this.currentAd = null, this.deliverNextAd();
  }
  addVpaidListeners() {
    const e = () => {
      if (this.currentAd.isVPAID) {
        p.debug.info(
          Ze.NAME + "Wait for a finished event from the VPAID player.",
          this.currentAd
        );
        const r = () => {
          this.currentAd.replaced ? (i(), this.deliverNextAd()) : (y(), this.cleanAndDeliveryNextAd());
        }, s = () => {
          this.saveStartVolumeVPAID();
        }, l = () => {
          this.adSlotController.applyBuffetAd();
        }, h = this.getRemoveHandlerForAdSlotControllerEvent(
          f.ON_AD_STARTED,
          s
        ), m = this.getRemoveHandlerForAdSlotControllerEvent(
          f.ON_AD_ERROR,
          l
        ), g = this.getRemoveHandlerForAdSlotControllerEvent(
          f.ON_VPAID_CLEANUP,
          r
        ), y = () => {
          h(), m(), g();
        };
      }
    }, i = this.getRemoveHandlerForAdSlotControllerEvent(
      f.ON_AD_START,
      e
    );
  }
  controlPlayback(e) {
    this.currentAd && (this.currentAd.isVPAID ? e(this.adSlotController.vpaidPlayer) : this.currentAd.isLinear ? e(this.player) : e(this.adSlotController.nonLinearView));
  }
  deliverOrHOMAD(e, i) {
    this.currentAd.adReinsertion.isActive === !1 ? this.deliverNextAd() : this.activateHOMAD(e, i);
  }
  pause() {
    this.controlPlayback((e) => e.pause());
  }
  play() {
    this.controlPlayback((e) => e.play());
  }
  /**
   * Activates player and ad event listeners.
   */
  on() {
    this.addPlayerEventListener(Be.ON_TIME_UPDATED, () => {
      this.adSlotController.timeupdate();
    }), this.addPlayerEventListener(Be.ON_PAUSED, () => {
      this.currentAd.isPaused = !0, this.player.getAdCurrentTime() > 0 && this.player.getAdCurrentTime() < this.player.getAdDuration() && this.adSlotController.dispatchEvent(f.ON_AD_PAUSED);
    }), this.addPlayerEventListener(Be.ON_PLAY, () => {
      this.currentAd.isPaused = !1, this.player.getAdCurrentTime() > 0 && this.adSlotController.dispatchEvent(f.ON_AD_PLAYING);
    }), this.addPlayerEventListener(Be.ON_VOLUME_CHANGED, () => {
      this.currentAd && (isNaN(this.currentAd.volume) || (this.currentAd.volume === 0 && this.player.getVolume() > 0 ? this.adSlotController.dispatchEvent(f.ON_AD_UNMUTED) : this.currentAd.volume > 0 && this.player.getVolume() === 0 && this.adSlotController.dispatchEvent(f.ON_AD_MUTED)), this.currentAd.volume = this.player.getVolume(), this.adSlotController.dispatchEvent(f.ON_AD_VOLUME_CHANGED));
    }), this.getRemoveHandlerForAdSlotControllerEvent(f.ON_AD_START, this.saveStartVolume), super.addEventListener(f.ON_AD_STARTED, () => {
      this.removeDeliverNextAdEventHandler = this.addPlayerEventListener(Be.ON_ENDED, () => {
        this.adSlotController.timeupdate(), this.adSlotController.dispatchEvent(f.ON_AD_STOPPED), p.debug.info(Ze.NAME + "Received ended event from the video player.", this.currentAd), this.cleanAndDeliveryNextAd();
      });
    }), this.addVpaidListeners(), this.addPlayerEventListener(Be.ON_ERROR, () => {
      p.debug.info(
        Ze.NAME + "on - Player sent error event"
      );
    });
  }
  saveStartVolume() {
    this.currentAd && this.player && (this.currentAd.volume = this.player.getVolume());
  }
  saveStartVolumeVPAID() {
    this.adSlotController.vpaidPlayer.setVolume(this.player.getVolume());
  }
  stop() {
    return new Promise((e) => {
      if (!this.adSlotHasStarted)
        return e();
      this.removeDeliverNextAdEventHandler && this.removeDeliverNextAdEventHandler(), this.adSlotHasStarted && (this.adSlotHasStarted = !1, this.dispatchEvent(f.ON_AD_SLOT_STOPPED));
      for (const i of this.eventCallbacks)
        i();
      return this.eventCallbacks = [], e();
    });
  }
  deliverNextAd() {
    var r;
    const e = this;
    (e.currentAd === null || e.currentAd.replaced) && (e.currentAd = e.adSlotController.getAd()), p.debug.info(Ze.NAME + "deliver ad:", e.currentAd), clearTimeout(e.loadPendingTimeout);
    function i() {
      if (e.adSlotController.requestedTrackingEvents = [], e.adSlotController.startViewability(), e.adSlotController.dispatchEvent(f.ON_AD_START), e.deployConcurrentAssets(), e.removeDeliverNextAdEventHandler && e.removeDeliverNextAdEventHandler(), e.removeImpressionOnStartHandler && e.removeImpressionOnStartHandler(), e.currentAd.isSIMID && e.adSlotController.loadAdSIMID(), e.currentAd.isVPAID)
        e.adSlotController.loadAdVPAID();
      else {
        const s = e.currentAd.config.trackImpressionOnStart ? f.ON_AD_PLAYBACK_START : f.ON_AD_STARTED;
        e.removeImpressionOnStartHandler = e.addEventListener(s, () => {
          e.adSlotController.dispatchEvent(f.ON_AD_IMPRESSION), e.adSlotController.dispatchEvent(f.ON_AD_CREATIVE_VIEW);
        });
        let l = e.currentAd.isLinear ? e.currentAd.properCreative.selectedMediaFile : e.currentAd.properCreative.variations[0];
        e.loadAd(l);
      }
    }
    if (e.adSlotHasStarted || (e.dispatchEvent(f.ON_AD_SLOT_STARTED), e.adSlotHasStarted = !0, e.on()), (r = e.currentAd) != null && r.hasError) {
      e.cancelAdWithError();
      return;
    }
    e.currentAd === null ? e.stop() : i();
  }
  cancelAdWithError() {
    this.adSlotController.cancelAd(), this.currentAd = null, this.deliverNextAd();
  }
  deployConcurrentAssets() {
    const e = this.currentAd.creatives.filter((i) => i.type === "companion" && i.hasCompanionResources);
    if (e && e.length > 0 && this.dispatchEvent(f.ON_COMPANIONS_DETECTED), this.currentAd.extensions && this.currentAd.extensions.length > 0 && this.dispatchEvent(f.ON_EXTENSIONS_DETECTED), this.currentAd.icons && Object.keys(this.currentAd.icons).length > 0 && this.dispatchEvent(f.ON_ICONS_DETECTED), this.currentAd.closedCaptions && this.currentAd.closedCaptions.length > 0 && this.dispatchEvent(f.ON_CLOSED_CAPTIONS_DETECTED), this.currentAd.adVerifications && this.currentAd.adVerifications.length > 0) {
      if (!this.currentAd.config.adVerification.disabled)
        this.currentAd.config.adVerification.playerHandles || new Rr(this.currentAd, this);
      else {
        p.debug.warn(
          Ze.NAME + "adVerification - disabled by publisher (config.adVerification.disabled)."
        );
        for (const i of this.currentAd.adVerifications)
          this.currentAd.enrichment.set("REASON", oi.ERROR_RESOURCE_REJECTED, "reason"), this.adSlotController.callTrackers(i.tracking.verificationNotExecuted);
      }
      this.dispatchEvent(f.ON_VERIFICATION_DETECTED);
    }
  }
  activateHOMAD(e, i) {
    this.currentAd.adReinsertion.setReinsertionReason({
      reason: e,
      source: i,
      error: this.currentAd.error
    }), this.currentAd.adReinsertion.enable(
      () => {
        this.currentAd.isLinear && (this.currentAd.enrichment.set("ERRORCODE", this.currentAd.error.code), this.dispatchEvent(f.ON_AD_ERROR)), ce.EventDispatcher.dispatchEvent(f.ON_AD_REINSERTION_ACTIVATION);
      },
      () => {
        this.deliverNextAd();
      }
    );
  }
  loadAd(e) {
    if (this.currentAd.isLinear) {
      let i = "Load MediaFile ", r = e.fileURL, s = !1;
      clearTimeout(this.loadPendingTimeout);
      let l = (h) => {
        s = !0, p.debug.error("VideoProxy load timeout.", h), this.currentAd.error = w.VAST.TIMEOUT, this.deliverOrHOMAD(ce.REASON.MEDIAFILE_TIMEOUT, r);
      };
      this.loadPendingTimeout = setTimeout(
        l.bind(this),
        this.currentAd.config.timeouts.videoRequest * 1e3
      ), p.debug.info(Ze.NAME + i + "from URI", r), this.player.load(r, !0).then(() => {
        clearTimeout(this.loadPendingTimeout), !s && (p.debug.info(Ze.NAME + i + "success."), this.adSlotController.dispatchEvent(f.ON_AD_LOADED), this.dispatchEvent(f.ON_AD_STARTED));
      }, (h) => {
        if (clearTimeout(this.loadPendingTimeout), s)
          return;
        p.debug.error(Ze.NAME + i + "failed", h);
        const m = {
          [w.VAST.GENERAL_ERROR.code]: w.VAST.GENERAL_ERROR,
          [w.VAST.FILE_NOT_FOUND.code]: w.VAST.FILE_NOT_FOUND,
          [w.VAST.UNSUPPORTED_MIMETYPE.code]: w.VAST.UNSUPPORTED_MIMETYPE
        };
        this.currentAd.error = m[h] || w.VAST.MEDIAFILE_DISPLAY_ERROR, this.deliverOrHOMAD(ce.REASON.MEDIAFILE_LOAD_ERROR, r);
      });
    } else {
      let i, r = !1, s = "loadAd - NonLinear ";
      if (clearTimeout(this.loadPendingTimeout), this.currentAd.config.playerHandlesNonLinear) {
        this.addPlayerEventListener(Be.ON_LOADED_DATA, () => {
          this.dispatchEvent(f.ON_AD_STARTED), this.dispatchEvent(f.ON_AD_IMPRESSION), this.dispatchEvent(f.ON_AD_CREATIVE_VIEW);
        }), this.addPlayerEventListener(Be.ON_ENDED, () => {
          this.dispatchEvent(f.ON_AD_NONLINEAR_STOPPED), this.dispatchEvent(f.ON_AD_STOPPED);
        });
        return;
      }
      this.loadPendingTimeout = setTimeout((l) => {
        r = !0, p.debug.error(s + " timeout.", l), this.currentAd.error = w.VAST_NONLINEAR.TIMEOUT, this.currentAd.enrichment.set("ERRORCODE", this.currentAd.error.code), this.dispatchEvent(f.ON_AD_ERROR), this.deliverOrHOMAD(ce.REASON.MEDIAFILE_TIMEOUT, e);
      }, this.currentAd.config.timeouts.videoRequest * 1e3), this.adSlotController.environmentVars.adContainer ? (p.debug.info(
        s + "- Using publisher adContainer",
        this.adSlotController.environmentVars.adContainer
      ), i = this.adSlotController.environmentVars.adContainer) : (p.debug.warn(s + "- Publisher adContainer not specified. Using the video elements parent element as a fallback."), i = this.player.getPlayerElement().parentNode), this.adSlotController.nonLinearView = new Nr(this, i), [
        f.ON_AD_STARTED,
        f.ON_AD_IMPRESSION,
        f.ON_AD_CREATIVE_VIEW,
        f.ON_AD_NONLINEAR_STOPPED,
        f.ON_AD_STOPPED
      ].map((l) => {
        const h = this.adSlotController.nonLinearView.addEventListener(
          l,
          (m) => {
            this.dispatchEvent(m.type), m.type === f.ON_AD_STOPPED && this.cleanAndDeliveryNextAd();
          }
        );
        this.eventCallbacks.push(h);
      }), this.addPlayerEventListener(Be.ON_PLAY, this.play.bind(this)), this.addPlayerEventListener(Be.ON_PAUSED, this.pause.bind(this)), this.adSlotController.nonLinearView.init(e).then(() => {
        clearTimeout(this.loadPendingTimeout), !r && p.debug.info(s + "Request complete");
      }, (l) => {
        clearTimeout(this.loadPendingTimeout), !r && (p.debug.error("loadAd - VideoProxy load failed", l), this.currentAd.error = w.VAST_NONLINEAR.GENERAL_ERROR, this.currentAd.enrichment.set("ERRORCODE", this.currentAd.error.code), this.dispatchEvent(f.ON_AD_ERROR), this.deliverOrHOMAD(ce.REASON.MEDIAFILE_LOAD_ERROR, e));
      });
    }
  }
  getCurrentAd() {
    return this.currentAd;
  }
  onSkip() {
    this.adSlotController.onSkip(), this.cleanAndDeliveryNextAd();
  }
};
Ze.NAME = "AdSloDel::";
let Cr = Ze;
class wr {
  getResources() {
    return this.resources;
  }
  constructor(e, i) {
    var r, s, l, h;
    this.adParameters = ((s = (r = q(i, "AdParameters")) == null ? void 0 : r.textContent) == null ? void 0 : s.trim()) || null, this.apiFramework = i.getAttribute("apiFramework") || null, this.clickThroughURL = ((h = (l = q(i, e + "ClickThrough")) == null ? void 0 : l.textContent) == null ? void 0 : h.trim()) || null, this.clickTracker = this.getClickTracker(e, i), this.resources = this.parseResources(i);
  }
  /**
   * Parse StaticResource, HTMLResource and IFrameResource into array of resources
   * @param {Element} container (parent element) of the resource file nodes
   * @returns {Array} Array of resources with their attributes and contents parsed into properties
   */
  parseResources(e) {
    let i = [];
    const r = Object.values(Bi).join(", ");
    let s = te(e, r);
    for (let l = 0; l < s.length; l++)
      i.push({
        creativeType: s[l].getAttribute("creativeType"),
        resource: ge(s[l].textContent || ""),
        type: s[l].nodeName
      });
    return i;
  }
  getClickTracker(e, i) {
    let r = [];
    const s = te(i, e + "ClickTracking");
    for (const l of s)
      r.push({
        url: ge(l.textContent),
        id: l.getAttribute("id")
      });
    return r;
  }
}
class No extends wr {
  constructor(e, i, r) {
    var s;
    super(e, r), this.adSlotId = r.getAttribute("adSlotId") || "", this.altText = ge(((s = q(r, "AltText")) == null ? void 0 : s.textContent) || ""), this.assetHeight = r.getAttribute("assetHeight") || "", this.assetWidth = r.getAttribute("assetWidth") || "", this.companionXML = r, this.creativeViewTracker = i, this.expandedHeight = r.getAttribute("expandedHeight") || "", this.expandedWidth = r.getAttribute("expandedWidth") || "", this.hasCreative = super.getResources().length > 0, this.height = r.getAttribute("height"), this.id = r.getAttribute("id") || zn(), this.pxratio = r.getAttribute("pxratio") || "1", this.renderingMode = r.getAttribute("renderingMode") || "default", this.width = r.getAttribute("width");
  }
}
function ve(c, e) {
  const i = (c == null ? void 0 : c.getAttribute(e)) || -1;
  let r = -1;
  return typeof i == "string" && (r = parseInt(i, 10)), isNaN(i) ? -1 : r;
}
class Co extends wr {
  constructor(e, i, r) {
    var s;
    super(e, r), this.altText = ge(((s = q(r, "AltText")) == null ? void 0 : s.textContent) || ""), this.creativeViewTracker = i, this.duration = ve(r, "duration"), this.hasCreative = super.getResources().length > 0, this.height = ge(r.getAttribute("height")), this.hoverText = r.getAttribute("hoverText") || null, this.offset = Tt(r.getAttribute("offset")), this.program = r.getAttribute("program") || "unknown", this.pxratio = ve(r, "pxratio"), this.width = r.getAttribute("width"), this.xPosition = r.getAttribute("xPosition"), this.yPosition = r.getAttribute("yPosition");
  }
}
class _o extends wr {
  constructor(e, i, r) {
    const s = ve(r, "expandedHeight"), l = ve(r, "expandedWidth"), h = ve(r, "height"), m = r.getAttribute("id"), g = r.getAttribute("maintainAspectRatio") !== "false", y = Tt(
      r.getAttribute("minSuggestedDuration")
    ), L = r.getAttribute("scalable") !== "false", ie = ve(r, "width");
    super(e, r), this.creativeTrackers = i, this.displayDuration = null, this.expandedHeight = s, this.expandedWidth = l, this.height = h, this.id = m, this.maintainAspectRatio = g, this.minSuggestedDuration = y != null ? y : -1, this.scalable = L, this.selectedResource = {
      creativeType: null,
      resource: null,
      type: ""
    }, this.width = ie;
  }
}
var pi = ((c) => (c.COMPANION = "companion", c[c.LINEAR = he.LINEAR] = "LINEAR", c[c.NON_LINEAR = he.NON_LINEAR] = "NON_LINEAR", c))(pi || {});
class Do {
  constructor(e) {
    this.adXML = e, this.VASTVersion = this.adXML.parentElement && typeof this.adXML.parentElement.getAttribute == "function" ? parseInt(this.adXML.parentElement.getAttribute("version"), 10) : null, this.linearObject = this.getLinear(), this.nonLinearCreative = this.getNonLinear();
  }
  // collects all types of linear, nonLinear and companions - so ad.creatives.length can be checked
  get allTypesAsArray() {
    let e = this.linear, i = this.companion, r = e.mediaFiles.interactive, s = this.nonLinearCreative, l = e.mediaFiles.streaming, h = e.mediaFiles.vpaid, m = [];
    return m = m.concat(
      ...h,
      ...l,
      ...r,
      ...s,
      ...i
    ), m;
  }
  //CreativeSourceSelector expects mediafiles to be an array of creatives
  //FIXME it'd be more clean to rewrite CreateSourceSelector however that'd break all tests currently
  // to use vpaid, streaming and so on instead of "reparsing"/filter them for vpaid and others again
  get linearAsArray() {
    let e = this.linear;
    return [{
      captions: e.captions,
      creativeTrackers: e.creativeTrackers,
      icons: e.icons,
      mediaFiles: [].concat(
        e.mediaFiles.interactive,
        e.mediaFiles.streaming,
        e.mediaFiles.vpaid
      )
    }];
  }
  get linear() {
    return this.linearObject;
  }
  createEmptyElement(e) {
    return document.createElement(e);
  }
  getLinear() {
    let e = q(this.adXML, "InLine > Creatives > Creative > Linear") || this.createEmptyElement("Inline"), i = q(e, "MediaFiles") || this.createEmptyElement("MediaFiles");
    return {
      captions: this.getClosedCaptionCreatives(e),
      creativeTrackers: this.getTrackers("Linear Tracking"),
      icons: this.getIndustryIcons(),
      mediaFiles: {
        interactive: this.getInteractiveCreatives(e),
        streaming: this.getStreamingCreatives(i),
        vpaid: this.getVPAIDCreatives(e)
      }
    };
  }
  getBaseForVersion(e, i) {
    if (i === null)
      return e;
    const s = {
      2: 3,
      3: 1,
      4: 0
    }[i];
    let l = e;
    for (let h = 0; h < s && l.parentElement; h++)
      l = l.parentElement;
    return l;
  }
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  extractInteractiveCreativeUrl(e) {
    for (const i of e.childNodes)
      if (i.wholeText)
        return i.wholeText.trim();
    return "";
  }
  getVPAIDCreatives(e) {
    var l;
    let i = [], r = te(e, 'MediaFile[apiFramework="VPAID"]'), s = q(e, "AdParameters");
    for (let h = 0; h < r.length; h++)
      i.push({
        adParameters: ((l = s == null ? void 0 : s.textContent) == null ? void 0 : l.trim()) || null,
        apiFramework: "VPAID",
        bitrate: ve(r[h], "bitrate"),
        fileURL: ge(r[h].textContent),
        height: ve(r[h], "height"),
        linearity: he.LINEAR,
        mimeType: r[h].getAttribute("type"),
        width: ve(r[h], "width")
      });
    return i;
  }
  getStreamingCreatives(e) {
    let i = [], r = te(e, 'MediaFile:not([apiFramework="VPAID"])');
    for (let s = 0; s < r.length; s++)
      i.push({
        apiFramework: r[s].getAttribute("apiFramework"),
        bitrate: ve(r[s], "bitrate"),
        fileURL: ge(r[s].textContent),
        height: ve(r[s], "height"),
        linearity: he.LINEAR,
        mimeType: r[s].getAttribute("type"),
        width: ve(r[s], "width")
      });
    return i;
  }
  getInteractiveCreatives(e) {
    var m;
    const i = [], r = this.getBaseForVersion(e, this.VASTVersion), s = te(r, "InteractiveCreativeFile"), l = q(r, "AdParameters"), h = q(r, "HTMLResource");
    for (let g = 0; g < s.length; g++) {
      let y = "", L = null;
      this.VASTVersion && this.VASTVersion < 4 ? (y = this.extractInteractiveCreativeUrl(s[g]), L = y === "" && h ? h.textContent.trim() : null) : y = s[g].textContent.trim(), i.push({
        adParameters: ((m = l == null ? void 0 : l.textContent) == null ? void 0 : m.trim()) || null,
        apiFramework: s[g].getAttribute("apiFramework"),
        delivery: s[g].getAttribute("delivery"),
        fileURL: y,
        linearity: he.LINEAR,
        mimeType: s[g].getAttribute("type"),
        resource: L,
        variableDuration: s[g].getAttribute("variableDuration") === "true"
      });
    }
    return i;
  }
  getClosedCaptionCreatives(e) {
    let i = [], r = q(e, "ClosedCaptionFiles");
    if (r) {
      let s = te(r, "ClosedCaptionFile");
      for (let l = 0; l < s.length; l++)
        i.push({
          fileURL: s[l].textContent,
          // en, en-US, zh-TW
          language: s[l].getAttribute("language"),
          linearity: he.LINEAR,
          // text/srt, text/vtt, application/ttml+xml
          type: s[l].getAttribute("type")
        });
    }
    return i;
  }
  getCreativeViewTrackers(e, i) {
    const r = [], s = te(e, i);
    for (const l of s)
      r.push({
        url: ge(l.textContent) || ""
      });
    return r;
  }
  getIndustryIcons() {
    const e = {};
    let i = te(this.adXML, "Creatives > Creative > Linear", "Icon");
    for (let r = 0; r < i.length; r++) {
      const s = i[r].getAttribute("program") || "unknown", l = this.getCreativeViewTrackers(i[r], "IconViewTracking"), h = new Co("Icon", l, i[r]);
      e[s] = h;
    }
    return e;
  }
  get nonLinear() {
    return this.nonLinearCreative;
  }
  getNonLinear() {
    let e = te(this.adXML, "InLine > Creatives > Creative > NonLinearAds");
    return this.getNonLinearCreatives(e[0]);
  }
  getNonLinearCreatives(e) {
    if (!e || e.children.length === 0)
      return [];
    p.debug.info("[VASTAdCreatives] Get NonLinear Creatives from.", e);
    let i = te(e, "NonLinear"), r = [{
      type: pi.NON_LINEAR,
      universalAdId: {},
      variations: []
    }];
    for (let s = 0; s < i.length; s++) {
      const l = new _o(
        "NonLinear",
        this.getTrackers("NonLinearAds Tracking"),
        i[s]
      );
      r[s].variations.push(l);
    }
    return r;
  }
  get companion() {
    const e = te(this.adXML, "Creatives > Creative > CompanionAds");
    let i = [];
    for (let r = 0; r < e.length; r++) {
      i[r] = {
        hasCompanionResources: !1,
        required: null,
        type: pi.COMPANION,
        variations: []
      };
      const s = te(e[r], "Companion");
      for (let l = 0; l < s.length; l++)
        if (s[l].hasChildNodes()) {
          const h = this.getCreativeViewTrackers(
            s[l],
            "Tracking[event=creativeView]"
          );
          let m = new No(
            "Companion",
            h,
            s[l]
          );
          i[r].hasCompanionResources = m.resources.length > 0, i[r].required = e[r].getAttribute("required"), i[r].variations.push(m);
        }
    }
    return i.reverse();
  }
  getTrackers(e) {
    const i = {}, r = Array.from(te(this.adXML, "ClickTracking, " + e));
    for (let s = 0; s < r.length; s++) {
      const l = r[s], h = l.nodeName.charAt(0).toLowerCase() + l.nodeName.slice(1), m = l.getAttribute("event") || h, g = l.getAttribute("offset"), y = {
        offset: "",
        url: ge(l.textContent)
      };
      if (m === Yt.ON_AD_PROGRESS && g) {
        const L = Tt(g);
        y.offset = typeof L == "number" ? L.toString() : g;
      }
      i[m] = i[m] || [], i[m].push(y);
    }
    return i;
  }
}
class Lo extends p {
  /**
   * This model represents the Object-notation of a single <Ad> node.
   *
   * @param {Element} adTag a single root Ad node from the VAST response
   * @param {Document} xmlDoc the full VAST response
   */
  constructor(e, i) {
    super(), this.adXML = e, this.rawXML = i instanceof Document ? i.documentElement : i, this.adTrackerList = this.getRootTracker(), this.error = {
      // eslint-disable-next-line no-undefined
      code: void 0,
      message: "",
      timestamp: null
    }, this.extensionsArray = this.getExtensions();
  }
  /**
  * @private
  */
  getElementsSortedByDepth(e) {
    return e.sort((i, r) => {
      const s = Number(Object.keys(i));
      return Number(Object.keys(r)) - s;
    }).map((i) => Object.values(i)[0]);
  }
  /**
   * @private
   */
  getNodeDepth(e) {
    let i = 0, r = e.parentElement;
    for (; r; )
      i++, r = r.parentElement;
    return { [i]: e };
  }
  /**
   * @private
   */
  getWrapperAndInLineCreative() {
    const e = " > Creatives > Creative";
    let i = [];
    const r = te(this.adXML, "Ad > Wrapper");
    let s = [];
    for (const h of r) {
      let m = te(h, "Wrapper" + e);
      if (m.length > 0)
        for (const g of m)
          s.push(g);
      else
        i.push(h);
    }
    if (s.length > 0)
      for (const h of s)
        i.push(h);
    let l = te(this.adXML, "InLine" + e);
    for (const h of l)
      i.push(h);
    return i;
  }
  /**
   * Used to provide the ad server’s unique identifier for the creative.
   * @returns {Array<string|null>} adId(s) of the ad creative node(s) in the creatives node.
   */
  get adIds() {
    let e = [];
    if (this.wrappers.length > 0)
      e = this.getWrapperAndInLineCreative();
    else {
      let l = te(this.adXML, "Creative");
      for (let h of l)
        e.push(h);
    }
    let i = [];
    for (const l of e)
      i.push(this.getNodeDepth(l));
    const r = this.getElementsSortedByDepth(i);
    let s = [];
    for (const l of r) {
      const h = l.getAttributeNames().find((m) => m.toLowerCase() === "adid");
      s.push(l.getAttribute(h) || null);
    }
    return s;
  }
  /**
   * @returns {string} The type of ad as specified by the ad-server (since VAST 4.1)
   */
  get adType() {
    return (ct(this.adXML, "Ad") || this.adXML).getAttribute("adType") || "video";
  }
  /**
   * @returns {string|null} The name of the advertiser.
   */
  get advertiser() {
    const e = q(this.adXML, "InLine", "Advertiser");
    return ge((e == null ? void 0 : e.textContent) || "");
  }
  /**
   * @returns {array|null} AdVerification
   *
   * The element is used to contain one or more <Verification> elements,
   *  which are used to initiate a controlled container where code can be
   *  executed for collecting data to verify ad viewability details.
   */
  get adVerifications() {
    const e = te(this.adXML, "AdVerifications > Verification");
    let i = [];
    for (let r = 0; r < e.length; r++) {
      const s = e[r], l = s.getAttribute("vendor") || "", h = q(s, "JavaScriptResource"), m = this.getNodeContentsAsText(
        q(s, "VerificationParameters") || document.createElement("div")
      ), g = this.getTrackerNodesAsURLArray(
        q(s, "TrackingEvents") || document.createElement("div")
      );
      if (l && l.length > 0 && h) {
        const y = {
          javascriptResource: {
            url: ge(this.getNodeContentsAsText(h)),
            apiFramework: h.getAttribute("apiFramework") || "",
            browserOptional: h.getAttribute("browserOptional") === "true" || !1
          },
          tracking: g,
          vendor: l,
          verificationParameters: m
        };
        i.push(y);
      }
    }
    return i.length > 0 ? ho(i, "vendor") : [];
  }
  /**
   * @returns {Boolean} True if the current ad wrapper has been specified as allowMultipleAds
   */
  get allowMultipleAds() {
    let e = ct(this.adXML, "Wrapper");
    return e && e.hasAttribute("allowMultipleAds") ? e.getAttribute("allowMultipleAds") === "true" : !1;
  }
  /**
   * @returns {Array} <Creatives>
   *
   * The <Creatives>(plural) element is a container for one or more <Creative>(singular) element used
   *  to provide creative files for the ad. For an InLine ad, the <Creatives>element nests all the files
   *  necessary for executing and tracking the ad.
   */
  get creatives() {
    return this.creativeClass.allTypesAsArray;
  }
  get creativeClass() {
    return this.creativesArray ? this.creativesArray : (this.creativesArray = new Do(this.adXML), this.creativesArray);
  }
  /**
   * @returns {string|null} A brief description of the campaign or placement,
   *  defined by the ad serving party.
   */
  get description() {
    const e = q(this.adXML, "InLine", "Description");
    return ge((e == null ? void 0 : e.textContent) || "");
  }
  /**
   * The list of all found <Extension> nodes
   * @returns {Array<Extension>} list
   */
  get extensions() {
    return this.extensionsArray;
  }
  /**
   * @returns {Boolean} false if the current ad wrapper has been specified as fallbackOnNoAd is false default true
   */
  get fallbackOnNoAd() {
    let e = ct(this.adXML, "Wrapper");
    return e && e.hasAttribute("fallbackOnNoAd") ? e.getAttribute("fallbackOnNoAd") !== "false" : !0;
  }
  /**
   * @returns {string} from attribute of fallbackType, defaulting to the IAB standard BuffetAd replacement method
   */
  get fallbackType() {
    let e = ct(this.adXML, "Wrapper");
    return e && e.hasAttribute("fallbackType") ? e.getAttribute("fallbackType") : "replace";
  }
  /**
   * @returns {string|null|Array<string|null>} Used to identify the ad server that provides the creative.
   */
  get id() {
    let e = [];
    if (this.wrappers.length > 0) {
      let s = te(this.adXML, "Ad > Wrapper");
      for (const l of s) {
        const h = l.parentElement.getAttribute("id");
        e.push(h);
      }
    }
    let i = null, r = ct(this.adXML, "Ad");
    return r && r.hasAttribute("id") && (i = r.id), e.length > 0 ? (e.push(i), e.reverse()) : this.adXML.getAttribute("id") || null;
  }
  /**
   * Ad server’s unique identifier for the creative.
   *
   * @returns {Array<string|null>} A string used to identify the ad server that provides the creative.
   */
  get ids() {
    let e = [];
    if (this.wrappers.length > 0)
      e = this.getWrapperAndInLineCreative();
    else {
      let l = te(this.adXML, "Creative");
      for (const h of l)
        e.push(h);
    }
    let i = [];
    for (const l of e)
      i.push(this.getNodeDepth(l));
    let r = [];
    const s = this.getElementsSortedByDepth(i);
    for (const l of s)
      r.push(l.getAttribute("id") || null);
    return r;
  }
  /**
   * @returns {string|null} The purpose of this id is to greatly reduce the amount of work required
   *  to compare impression-level data across multiple systems.
   */
  get adServingId() {
    const e = q(this.adXML, "InLine", "AdServingId");
    return ge((e == null ? void 0 : e.textContent) || "");
  }
  /**
   * @returns {Object|null} Real-time bidding (RTB) pricing data including model and currency.
   *  The core doesn't handle RTB, so this is for informational purposes only.
   */
  get pricing() {
    let e = q(this.adXML, "InLine", "Pricing") || ct(this.adXML, "Wrapper Pricing");
    return e && e !== this.adXML ? {
      value: this.getNodeContentsAsText(e),
      model: e.getAttribute("model"),
      currency: e.getAttribute("currency")
    } : null;
  }
  /**
   * @returns {string|null} URI to any resource file having to do with collecting survey data.
   */
  get survey() {
    const e = q(this.adXML, "InLine", "Survey");
    return ge((e == null ? void 0 : e.textContent) || "");
  }
  /**
   * @returns {string|null} Descriptive name for the ad serving system.
   */
  get system() {
    const e = q(this.adXML, "InLine", "AdSystem");
    return ge((e == null ? void 0 : e.textContent) || "");
  }
  /**
   * @returns {string|null} Title for the ad, defined by the ad serving party.
   */
  get title() {
    const e = q(this.adXML, "InLine", "AdTitle");
    return ge((e == null ? void 0 : e.textContent) || "");
  }
  /**
   * @returns {Object} Object with tracker arrays for impression and error
   */
  get adTrackers() {
    return this.adTrackerList;
  }
  /**
   * @returns {Array} List of Wrapper objects, starting with the first Wrapper up to the Inline tag.
   */
  get wrappers() {
    const e = [];
    this.rawXML.hasAttribute && this.rawXML.hasAttribute("_initialURL") && e.push({
      loadStart: new Date(ve(this.rawXML, "_loadStart")).toISOString(),
      loadEnd: new Date(ve(this.rawXML, "_loadEnd")).toISOString(),
      loadTime: ve(this.rawXML, "_loadEnd") - ve(this.rawXML, "_loadStart"),
      url: this.rawXML.getAttribute("_initialURL")
    });
    const i = te(this.adXML, "VASTAdTagURI");
    for (let r = 0; r < i.length; r++)
      e.push({
        loadStart: new Date(ve(i[r], "_loadStart")).toISOString(),
        loadEnd: new Date(ve(i[r], "_loadEnd")).toISOString(),
        loadTime: ve(i[r], "_loadEnd") - ve(i[r], "_loadStart"),
        url: ge(i[r].textContent)
      });
    return e;
  }
  /**
   * Note: VAST 4.0 had an attribute “idValue” that was a duplicate of the node value and so was removed as of 4.1.
   * Media players should not fail if this attribute is present, but should always use the Content
   *  as the source of truth for the creative ID value
   *
   * Content/"idValue" A string identifying the unique creative identifier.
   * Default value is “unknown” idRegistry A string used to identify the URL for the registry website
   *  where the unique creative ID is cataloged. Default value is “unknown.
   *
   * @returns {Object} UniversalAdId
   */
  get universalAdId() {
    const e = te(this.adXML, ["Creative", "CreativeExtension", "Extension"], "UniversalAdId"), i = e[e.length - 1];
    return i ? this.extractUniversalAdIdInfo(i) : { idRegistry: "unknown", idValue: "unknown" };
  }
  /**
   * VAST 4.2 allows multiple UniversalAdId nodes to be provided
   *
   * @returns {Array} List of all Universal Ad IDs
   */
  get universalAdIds() {
    let e = [];
    const i = te(this.adXML, ["Creative", "CreativeExtension", "Extension"], "UniversalAdId");
    for (let r = 0; r < i.length; r++)
      e.push(this.extractUniversalAdIdInfo(i[r]));
    return e;
  }
  getExtensions() {
    let e = [];
    if (this.adXML) {
      const i = te(this.adXML, "Extensions > Extension");
      for (let r = 0; r < i.length; r++)
        e.push({
          extensionXML: i[r],
          type: i[r].getAttribute("type")
        });
    }
    return e;
  }
  getNodeContentsAsText(e) {
    var i;
    return ((i = e == null ? void 0 : e.textContent) == null ? void 0 : i.trim()) || "";
  }
  extractUniversalAdIdInfo(e) {
    return {
      idRegistry: e.getAttribute("idRegistry") || null,
      idValue: this.getNodeContentsAsText(e) || ge(e.getAttribute("idValue") || "unknown")
    };
  }
  getRootTracker() {
    const e = {};
    if (this.adXML) {
      const i = [...this.adXML.querySelectorAll(
        "Error, Impression, NotViewable, Viewable, ViewUndetermined"
      )];
      this.adXML.nodeName === "Error" && i.push(this.adXML);
      for (const r of i) {
        const s = r.nodeName.charAt(0).toLowerCase() + r.nodeName.slice(1), l = this.getNodeContentsAsText(r);
        l && l.length > 0 && (e[s] = e[s] || [], e[s].push({
          url: l
        }));
      }
    }
    return e;
  }
  /**
   * Extracts tracking event nodes from a provided DOM element and returns them as an array of objects with URLs.
   *
   * @param {Element} trackingEventsNode - DOM element containing tracking event nodes.
   * @returns {Object} - Tracking events as keys, each containing an array of objects with URL properties.
   */
  getTrackerNodesAsURLArray(e) {
    const i = {};
    if (!e)
      return i;
    for (const r of te(e, "Tracking")) {
      const s = this.getNodeContentsAsText(r);
      if (s.length === 0)
        continue;
      const l = r.getAttribute("event");
      l && (i[l] || (i[l] = []), i[l].push(
        { url: s }
      ));
    }
    return i;
  }
}
class Vt extends Lo {
  /**
   * This model represents the Object-notation of a single <Ad> node.
   *
   * @param {Element} adTag a single root Ad node from the VAST response
   * @param {Document} xmlDoc the full VAST response
   */
  constructor(e, i) {
    super(e, i), this.adXML = e, this.adSkippableStateChange = !1, this.isLinearBoolean = te(this.adXML, "Creative", "Linear").length >= 1 || !1, this.isSkippableBoolean = !1, this.sequencePosition = this.adXML.getAttribute("sequence") || NaN, this.skipOffsetValue = this.parseSkipOffsetToNumber(), this.deepestClickThroughURL = this.getClickThroughURL(), this.linearDuration = this.getDuration(), this.variantExtensionType = this.getVariant(
      ct(
        this.adXML,
        'Extension[type="sxp"] variant, Extension[name="SXP"] AdInfo'
      )
    ), this.replaced = !1, this.error = this.getError();
  }
  mapStringToVariant(e) {
    switch (e.toUpperCase()) {
      // only vast specific variants!
      case "BUMPER":
      case "SPONSORED":
        return fe.SPONSORED;
      default:
        return fe.COMMERCIAL;
    }
  }
  parseSkipOffsetToNumber() {
    var i;
    const e = Tt(
      ((i = q(this.adXML, "InLine Linear")) == null ? void 0 : i.getAttribute("skipoffset")) || "0"
    );
    return typeof e == "number" ? e : -1;
  }
  /**
   * @returns {boolean} state whether the ON_AD_SKIPPABLE_STATE_CHANGE has been sent or not
   */
  get adSkippableStateChangeSent() {
    return this.adSkippableStateChange;
  }
  /**
   * @param {boolean} state whether the ON_AD_SKIPPABLE_STATE_CHANGE has been sent or not
   * @returns {void}
   */
  set adSkippableStateChangeSent(e) {
    this.adSkippableStateChange = e;
  }
  /**
   * Simple getter to check whether the ad can be delivered or not.
   * @returns {boolean} true if the ad is corrupted
   */
  get hasError() {
    return this.error !== null;
  }
  /**
   * The landing page URL
   * @returns {string} url
   */
  get clickThroughURL() {
    return this.deepestClickThroughURL;
  }
  /**
   * The url might be updated at runtime from VPAID creatives
   * @param {string} url The landing page URL
   * @returns {void}
   */
  set clickThroughURL(e) {
    this.deepestClickThroughURL = e;
  }
  /**
   * Time value for the duration of the Linear ad
   * @returns {number} in seconds
   */
  get duration() {
    return this.linearDuration;
  }
  /**
   * The duration might be updated at runtime after receiving the video's metadata.
   * @param {number} time Video duration in seconds
   * @returns {void}
   */
  set duration(e) {
    this.linearDuration = e;
  }
  /**
   @returns {Boolean} True if the current ad is linear
   */
  get isLinear() {
    return this.isLinearBoolean;
  }
  /**
   * @param value {Boolean}
   */
  set isLinear(e) {
    this.isLinearBoolean = e;
  }
  /**
   * Note: Up to version 4.x the `isSkippable` flag was used to check whether the ad can be skipped, depending on the
   * current progress. The following conditions must have been met:
   *  - the ad has specified a `skipoffset`
   *  - the parsed time of `skipoffset` is equal or greater than 0 seconds
   *  - the current playhead time is equal or greater than the `skipoffset`
   *
   * @returns {Boolean} True if the current Linear has attribute skipoffset.
   */
  get isSkippable() {
    return this.isSkippableBoolean;
  }
  /**
   * @param value {Boolean}
   */
  set isSkippable(e) {
    this.isSkippableBoolean = e;
  }
  /**
   * @returns {number} Representing the numerical order in which each sequenced creative within an ad should play
   */
  get sequence() {
    return parseFloat(this.sequencePosition);
  }
  set sequence(e) {
    this.sequencePosition = e;
  }
  /**
   * @returns {number} Representing the playback time after a linear ad can be skipped. Defaulting to -1, not
   *     skippable.
   */
  get skipOffset() {
    return this.skipOffsetValue;
  }
  /**
   * @param {number} seconds The playback time after an ad can be skipped. The value might be updated with publisher
   *     settings.
   */
  set skipOffset(e) {
    this.skipOffsetValue = e;
  }
  /**
   * The ad variant, based on data we get from the SXP VAST Extension.
   * If omitted, the variant defaults to AD_VARIANT.COMMERCIAL
   *
   * @returns {string} variant of the ad
   */
  get variant() {
    return this.variantExtensionType;
  }
  /**
   * @param value {string}
   */
  set variant(e) {
    this.variantExtensionType = e;
  }
  getVariant(e) {
    if (e === null)
      return fe.COMMERCIAL;
    let i = fe.COMMERCIAL;
    return e.nodeName === "AdInfo" && (i = this.mapStringToVariant(e.getAttribute("variant") || "")), e.nodeName === "variant" && e.textContent && (i = this.mapStringToVariant(e.textContent.trim())), i;
  }
  getDuration() {
    var i, r;
    const e = ((r = (i = ct(this.adXML, "Linear Duration")) == null ? void 0 : i.textContent) == null ? void 0 : r.trim()) || Vt.FALLBACK_LINEAR_DURATION;
    return Tt(e);
  }
  /**
   * Description object of the most recent ad error.
   *
   * @returns {Object} <error>
   */
  getError() {
    function e(r) {
      if (r.parentNode)
        return q(r.parentNode, ":scope > parsererror");
    }
    const i = q(this.adXML, "parsererror") || e(this.adXML);
    return i ? {
      code: ve(i, "code"),
      message: i.getAttribute("message") || "",
      timestamp: null
    } : this.flagCappedAds();
  }
  flagCappedAds() {
    return q(this.adXML, "InLine") && this.adXML.nodeName !== "Error" ? null : {
      code: w.WRAPPER.NO_RESPONSE.code,
      message: w.WRAPPER.NO_RESPONSE.message,
      timestamp: null
    };
  }
  getClickThroughURL() {
    const e = this.isLinear ? "VideoClicks ClickThrough" : "NonLinearClickThrough", i = ct(this.adXML, e);
    return ge((i == null ? void 0 : i.textContent) || "");
  }
}
Vt.FALLBACK_LINEAR_DURATION = "00:00:20";
class bo {
  /**
   * Creates an instance of AdSlotModel.
   *
   * @param {Document} xmlDoc - The XML document containing ad information.
   */
  constructor(e) {
    this.adList = [], this.handleXMLDoc(e);
  }
  handleXMLDoc(e) {
    let i = q(e, "parsererror"), r = te(e, ":root > *"), s;
    if (!(q(e, "html") && i)) {
      if (q(e, "html")) {
        s = document.createElement("VAST");
        const l = new Vt(s, e);
        this.adList.push(l);
        return;
      }
      if (e instanceof DocumentFragment && i) {
        s = document.createElement("VAST"), s.appendChild(i);
        const l = new Vt(s, e);
        this.adList.push(l);
      }
      for (let l = 0; l < r.length; l++) {
        const h = new Vt(r[l], e);
        this.adList.push(h);
      }
    }
  }
  /**
   * Gets the list of ads in the playlist.
   *
   * @returns {Ad[]} - The list of ads. Empty when no ad.
   */
  getAdList() {
    return this.adList;
  }
}
function Mo(c, e) {
  const i = Object.values(ci);
  let r = [];
  const s = document.createElement("video"), l = document.createElement("audio");
  let h = i;
  return e && e.length > 0 && (r = e, h = e), h.filter((g) => !("canPlayType" in s) || g === "application/javascript" || s.canPlayType(g) !== "" || l.canPlayType(g) !== "" ? r.push(g) : !1), (r.length <= 0 || r.length === 1 && r[0] === "application/javascript") && (r = h), c.filter((g) => r.find((y) => g.mimeType === y));
}
class Hi {
  static getProperCreative(e, i) {
    if (!e || e.length < 1)
      return null;
    let r = e.slice(0);
    return e[0].type === he.NON_LINEAR ? wo.select(r, i) : Po.select(r, i);
  }
  /**
   * Removes VPAID media files from unwanted vendors.
   * @param {Array} creativeFiles represents all available MediaFiles from an ad
   * @param {Array} vendorWhiteList specifies a list of accepted VPAID vendors.
   * Each String has to represent an unique identifier that can be found within the creative media file URL, most
   *  likely the domain name.
   * @returns {Array} Revised mediaFileList
   */
  static removeUnwantedVPAIDVendors(e, i = []) {
    return e.filter((r) => r.isVPAID ? this.isFriendlyVendorHost(r.fileURL, i) : !0);
  }
  static isFriendlyVendorHost(e, i = []) {
    return !i || i && i.length === 0 ? !0 : i.some((r) => {
      if (!r.includes("."))
        return !1;
      try {
        const s = new URL(e).hostname;
        return new RegExp(`(^|\\.)${r.replace(".", "\\.")}$`).test(s);
      } catch (s) {
        return !1;
      }
    });
  }
}
class Po {
  static select(e, i) {
    return e.forEach((s) => {
      s.selectedCreativeFile = null, s.selectedMediaFile = null;
      let l = s.mediaFiles || [];
      l.map((m) => {
        var g;
        !s.selectedCreativeFile && m.apiFramework && (m.isSIMID = (m.apiFramework + "").toUpperCase() === "SIMID", s.selectedCreativeFile = m.isSIMID ? m : null), (g = s.selectedCreativeFile) != null && g.isSIMID && (m.isSIMID = !0), m.isVPAID = (m.apiFramework + "").toUpperCase() === "VPAID";
      }), l = Hi.removeUnwantedVPAIDVendors(
        l,
        i.desiredVPAIDVendors
      );
      let h = Mo(l, i.desiredMimeTypes);
      s.selectedMediaFile = this.selectMediaFile(
        h,
        i.desiredBitrate || 1e3,
        i.desiredMimeTypes || []
      );
    }), e.filter((s) => !!s.selectedMediaFile).shift();
  }
  static selectMediaFile(e, i, r) {
    let s = e.filter((m) => m.isSIMID), l = e.filter((m) => m.isVPAID);
    if (s.length > 0)
      return s[0];
    if (l.length > 0)
      return l[0];
    let h = [];
    for (let m = 0; m < r.length; ) {
      if (m > 0 && h.length > 0) {
        e = h;
        break;
      }
      e.filter((g) => {
        g.mimeType === r[m] && h.push(g);
      }), m++;
    }
    return this.selectMediaFileByBitrate(e, i);
  }
  static selectMediaFileByBitrate(e, i) {
    let r = e.filter((l) => !l.isVPAID).sort((l, h) => h.bitrate - l.bitrate), s = r.filter((l) => l.bitrate <= i);
    return s.length > 0 ? s.shift() : r.pop() || e.shift();
  }
}
class wo {
  static select(e, i) {
    return e.forEach((s) => {
      const l = s.variations;
      l.map((h) => {
        h.selectedResource = null, (h.apiFramework + "").toUpperCase() === "VPAID" && (h.isVPAID = !0, h.resources = h.resources.filter((m) => Hi.isFriendlyVendorHost(
          m.resource,
          i.desiredVPAIDVendors
        )));
      });
      for (const h of l)
        h.resources.length <= 0 ? h.hasCreative = !1 : h.selectedResource = h.resources[0];
      s.variations = l.filter((h) => !!h.selectedResource);
    }), e.filter((s) => s.variations.length > 0).shift();
  }
}
function _r(c) {
  let e = 0, i = 0, r = 0;
  const s = c.length;
  for (let l = 0; l < c.length; l++) {
    let h = c[l];
    h.variant === fe.COMMERCIAL ? (h.currentCommercial = i += 1, (h.fallbackOnNoAd || !h.fallbackOnNoAd) && h.hasError && (e += 1), h.currentPodSequencing = i - e) : (h.fallbackOnNoAd || !h.fallbackOnNoAd) && h.hasError && (r += 1), h.variant !== fe.COMMERCIAL && (h.currentCommercial = -1), h.sequence = l + 1, h.currentClip = l + 1;
  }
  return {
    totalClips: s,
    totalPlayableClips: s - e - r,
    totalCommercials: i,
    totalPlayableCommercials: i - e
  };
}
const Xn = {
  HLS: "application/x-mpegURL",
  PROGRESSIVE: "video/mp4",
  MP4: "video/mp4",
  DASH: "application/dash+xml",
  WEBM: "video/webm",
  OGG: "video/ogg"
};
function xo(c, e, i, r) {
  let s = c;
  const l = i, h = r, m = e, g = {
    DIVIDER: fe.DIVIDER,
    CLOSER: fe.CLOSER,
    OPENER: fe.OPENER
  };
  function y(ee) {
    let Oe = [], Q = {
      adParameters: null,
      creativeTrackers: {},
      duration: Vt.FALLBACK_LINEAR_DURATION,
      icons: [],
      mediaFiles: [],
      supportedMediaFiles: [],
      skinDelay: NaN,
      type: he.LINEAR,
      universalAdId: ["unknown", "unknown"]
    };
    for (let z in ee)
      if (Object.prototype.hasOwnProperty.call(ee, z) && Object.prototype.hasOwnProperty.call(Xn, z.toUpperCase())) {
        let S = ee[z];
        if (typeof S == "string" && S.length > 0) {
          let I = {
            apiFramework: "",
            bitrate: 500,
            deliveryType: "progressive",
            fileURL: S,
            height: 360,
            id: "",
            isSIMID: !1,
            isVPAID: !1,
            maintainAspectRatio: !0,
            maxBitrate: 5e3,
            mimeType: Xn[z.toUpperCase()],
            minBitrate: 0,
            scalable: !0,
            width: 640
          };
          Q.mediaFiles.push(I);
        }
      }
    return Q.supportedMediaFiles = Q.mediaFiles, Oe.push(Q), Oe;
  }
  function L() {
    Object.keys(g).forEach((ee) => {
      if (l && Object.prototype.hasOwnProperty.call(l, g[ee])) {
        const Oe = l[g[ee]];
        if (!m && !Oe.forcePlay)
          return;
        let Q = {};
        Q.adTrackers = [], Q.creatives = y(Oe), Q.extensions = [], Q.id = Q.adId = g[ee], Q.isLinear = !0, Q.variant = g[ee], Q.properCreative = Q.creatives[0], Q.properCreative.selectedMediaFile = Q.properCreative.supportedMediaFiles[0], Q.config = h, Q.enrichment = new Ot(), Q.adReinsertion = new ce(h.adReinsertion, Q.enrichment), Q.expectedAdType = l.type, Q.isPaused = !0;
        let z = [];
        switch (g[ee]) {
          case g.DIVIDER:
            for (let S = 0; S < s.length; S++)
              S > 0 && s[S].variant !== s[S - 1].variant && z.push({
                offset: S,
                ad: Q
              });
            if (l[g[ee]].forcePlay && z.length === 0) {
              s[0].variant === fe.SPONSORED ? s.unshift(Q) : s.push(Q);
              break;
            }
            for (let S = 0; S < z.length; S++) {
              const I = z[S].offset + S;
              s.splice(I, 0, z[S].ad);
            }
            break;
          case g.CLOSER:
            s.push(Q);
            break;
          case g.OPENER:
            s.unshift(Q);
            break;
        }
      }
    });
  }
  L();
  let ie = _r(s);
  return { enrichedManifest: s, sequenceData: ie };
}
function qn(c) {
  let e = c;
  for (let i = 0; i < e.length; i++) {
    let s = e[i].extensions;
    for (let l of s)
      typeof l.extensionXML == "string" && (l.extensionXML = new DOMParser().parseFromString(l.extensionXML, "application/xml").getElementsByTagName("Extension").item(0));
  }
  return e;
}
class Vo {
  constructor(e, i, r, s) {
    this.adBreak = s, this.adList = e, this.adSlotBuffetList = [], this.adSlotModelList = [], this.config = i, this.environmentVars = r, this.NAME = "AdSltModGen::", this.decorateAdList(), this.createAdSlotModel(), this.extendWithSeparationClips(), qn(this.adSlotModelList), this.adSlotBuffetList = qn(this.adSlotBuffetList), p.debug.info(this.NAME + "adPod", this.adSlotModelList), p.debug.info(this.NAME + "adBuffet", this.adSlotBuffetList);
  }
  applyBuffetAd() {
    if (this.adSlotBuffetList.length > 0) {
      let e = this.adSlotModelList.filter((i) => i).sort(this.bySequence).reverse();
      for (let i = e.length - 1; i >= 0; i--) {
        const r = e[i];
        if (r.fallbackOnNoAd && this.adSlotBuffetList.length > 0) {
          let s = this.adSlotBuffetList.shift();
          s.sequence = r.sequence + 0.1, this.adSlotModelList.splice(r.sequence - 1, 0, s);
        }
      }
    }
  }
  decorateAdList() {
    for (let e = 0; e < this.adList.length; e++) {
      let i = this.adList[e];
      if (i.adBreakPosition = this.adBreak.adBreakPosition, i.config = this.config, i.enrichment = new Ot(), i.enrichment.setFromObject(i.publisherMacros), i.expectedAdType = this.adBreak.type, i.publisherMacros = this.environmentVars.vastMacros, i.adReinsertion = new ce(i.config.adReinsertion, i.enrichment), i.isPaused = !0, !i.hasError) {
        if (i.creatives.length < 1) {
          i.error = {}, i.error = w.WRAPPER.NO_RESPONSE;
          continue;
        }
        if (i.expectedAdType === he.LINEAR && i.creativeClass.linearAsArray[0].mediaFiles.length === 0 || i.expectedAdType === he.NON_LINEAR && i.creativeClass.nonLinear.length === 0) {
          i.error = {}, i.error = w.CREATIVE.EXPECTED_DIFFERENT_LINEARITY;
          continue;
        }
        i.expectedAdType === he.LINEAR ? (i.properCreative = Hi.getProperCreative(
          i.creativeClass.linearAsArray,
          this.environmentVars
        ), i.properCreative && (i.closedCaptions = i.properCreative.captions, i.icons = i.properCreative.icons)) : i.properCreative = Hi.getProperCreative(
          i.creativeClass.nonLinear,
          this.environmentVars
        ), i.properCreative || (i.error = {}, i.error = w.VAST.UNSUPPORTED_MIMETYPE);
      }
    }
  }
  createAdSlotModel() {
    this.getPodAdList().length > 0 ? (this.adSlotModelList = this.getPodAdList(), this.adSlotBuffetList = this.getBuffetAdList(), this.sequenceInfo = _r(this.adSlotModelList), this.hasPlayableAds || this.applyBuffetAd()) : (this.adSlotModelList = this.adList, this.adSlotBuffetList = [], this.sequenceInfo = _r(this.adSlotModelList));
  }
  extendWithSeparationClips() {
    if (this.adBreak.type !== he.LINEAR)
      return;
    const {
      enrichedManifest: e,
      sequenceData: i
    } = xo(
      this.adSlotModelList,
      this.hasPlayableAds,
      this.adBreak,
      this.config
    );
    this.adSlotModelList = e, this.sequenceInfo = i;
  }
  /**
   * We deliver ads that are either playable or at least trackable. So both states are considered valid.
   *
   * @returns {boolean} Whether we have found one or more deliverable ads.
   */
  get hasValidAds() {
    return !!this.adSlotModelList.filter((i) => !i.hasError || i.hasError).shift();
  }
  /**
   * The separation clip feature is applied to all adSlots that have at least one playable ad.
   * Note that playable doesn't include trackable ads!
   *
   * @returns {boolean} Whether we have found one or more playable ads.
   */
  get hasPlayableAds() {
    return !!this.adSlotModelList.filter((i) => !i.hasError).shift();
  }
  get hasSessionTimeoutError() {
    return this.adList.some((e) => e.adXML && q(e.adXML, `ParserError[code="${w.SESSION.TIMEOUT.code}"]`));
  }
  get adSlotModel() {
    return this.adSlotModelList;
  }
  get adSlotBuffet() {
    return this.adSlotBuffetList;
  }
  get sequenceData() {
    return this.sequenceInfo;
  }
  getPodAdList() {
    return this.adList.filter((e) => !isNaN(e.sequence)).sort(this.bySequence);
  }
  getBuffetAdList() {
    return this.adList.filter((e) => {
      const i = isNaN(e.sequence) && this.environmentVars.prefetchBuffetAds, r = isNaN(e.sequence) && !this.environmentVars.prefetchBuffetAds && !e.hasError;
      return i || r;
    });
  }
  bySequence(e, i) {
    return e.sequence - i.sequence;
  }
}
const kr = class kr {
  constructor(e) {
    this.adReinsertion = e.adReinsertion, this.adSlotTimeout = e.timeouts.adSlotRequest * 1e3, this.blockInsecureURL = e.blockInsecureURL || !1, this.callbackOnDoneLoading = null, this.hasSessionTimeoutError = !1, this.initialTimestamp = Date.now().toString(), this.maxWrapperDepth = e.maxWrapperDepth, this.urlHandlerOptions = e, this.wrapperChainTimeout = e.timeouts.adRequestChain * 1e3, this.NAME = "AdTagSvc", this.XMLsToLoad = 0, this.XMLDoc = null, e.adRequestObserver.requestTime = Date.now();
  }
  /**
   * Takes XML document and fetches all the URLs
   * On resolve the final XMLDoc of the aggregated files will be returned
   * @param XMLDoc
   * @param callbackOnDoneLoading
   * @returns {*|Promise<unknown>}
   */
  // eslint-disable-next-line @typescript-eslint/no-unsafe-function-type
  requestFinalXML(e, i) {
    this.callbackOnDoneLoading = i, this.requestXML(e);
  }
  /* c8 ignore start - no unitTests */
  /**
   * Takes URL and loads all wrappers, if needed
   * On resolve the final XMLDoc of the aggregated files will be returned
   * @returns {*|Promise<unknown>}
   * @param url
   * @param callbackOnDoneLoading
   */
  // eslint-disable-next-line @typescript-eslint/no-unsafe-function-type
  requestURL(e, i) {
    this.callbackOnDoneLoading = i, this.initialTimestamp = Date.now().toString(), this.loadURL(e).then((r) => (this.saveInitialURLToTag(e, r), this.saveInitialTimestampToTag(this.initialTimestamp, Date.now().toString(), r), this.requestXML(r)));
  }
  /* c8 ignore stop */
  requestXML(e) {
    this.XMLDoc = e, this.loadAllWrapperURLs(() => {
      --this.XMLsToLoad <= 0 && this.onAllAdWrappersWalked();
    });
  }
  // eslint-disable-next-line @typescript-eslint/no-unsafe-function-type
  loadAllWrapperURLs(e) {
    if (this.XMLDoc !== null && typeof this.XMLDoc.querySelectorAll == "function") {
      let i = te(this.XMLDoc, "VASTAdTagURI");
      if (this.XMLsToLoad = i.length, this.XMLsToLoad === 0) {
        e();
        return;
      }
      for (let r = 0; r < this.XMLsToLoad; r++) {
        let l = (i[r].textContent || "").trim();
        this.walkDownAdWrappers(
          l,
          0,
          i[r].parentNode,
          Date.now()
        ).then(() => {
          e();
        }).catch((h) => {
          e(h);
        });
      }
    }
  }
  walkDownAdWrappers(e, i, r, s) {
    return new Promise((l, h) => {
      let m = q(r, "VASTAdTagURI");
      if (m.setAttribute("_loadStart", Date.now().toString()), m.setAttribute("_loadEnd", Date.now().toString()), Date.now() - s > this.wrapperChainTimeout)
        return Ke(r, w.WRAPPER.CHAIN_TIMEOUT), h(), e;
      if (i >= this.maxWrapperDepth)
        return Ke(
          r,
          w.WRAPPER.LIMIT_REACHED
        ), h(), e;
      if (this.isInsecureURL(e))
        return Ke(r, w.SESSION.MIXED_CONTENT), h(), e;
      if (this.hasSessionTimeoutError)
        return h(), e;
      let g, y;
      this.loadURL(e, !0).then((L) => {
        let ie = q(L, "VASTAdTagURI");
        g = ((ie || {}).textContent || "").trim(), g && (y = ie.parentNode), this.addContentToWrapperNode(r, L), m.setAttribute("_loadEnd", Date.now().toString()), l([g, y]);
      });
    }).then((l) => {
      let [h, m] = l;
      return h ? this.walkDownAdWrappers(h, i + 1, m, s) : e;
    });
  }
  onAllAdWrappersWalked() {
    this.callbackOnDoneLoading(this.XMLDoc);
  }
  loadURL(e, i = !1) {
    return this.urlHandlerOptions.response = null, this.urlHandlerOptions.isWrapper = i, new Promise((r) => {
      new Pr().get(e, (s, l) => {
        if (Date.now() - parseInt(this.initialTimestamp, 10) > this.adSlotTimeout) {
          let h = l || document.createDocumentFragment(), m = q(h, "Ad") || h.documentElement || h;
          this.hasSessionTimeoutError = !0, Ke(m, w.SESSION.TIMEOUT), this.adReinsertion.setReinsertionReason({
            reason: ce.REASON.AD_SLOT_TIMEOUT,
            xmlResponse: l
          }), r(h);
        }
        if (!s && l && q(l, "parsererror")) {
          let h = document.createDocumentFragment();
          Ke(h, w.XML.INVALID_XML), this.adReinsertion.setReinsertionReason({
            reason: ce.REASON.XML_PARSING_ERROR,
            xmlResponse: l
          }), r(h);
        }
        if (!s && l && l.documentElement.nodeName.toUpperCase() === "VAST") {
          const h = q(l, "VAST");
          if (h && te(h, ":scope > *").length === 0) {
            let m = document.createDocumentFragment();
            Ke(m, w.WRAPPER.NO_RESPONSE), r(m);
          }
        }
        if (s && !l) {
          let h = document.createDocumentFragment();
          p.debug.warn(
            this.NAME + " XHR Request Error",
            s.code,
            s.description
          ), Ke(h, s), r(h);
        } else
          r(l);
      }, this.urlHandlerOptions);
    });
  }
  /* c8 ignore start - no unitTests */
  isInsecureURL(e) {
    return this.blockInsecureURL && !Qn(e);
  }
  /* c8 ignore stop */
  setAttributeToTag(e, i, r) {
    if (r) {
      let s = q(r, "VAST");
      s && s.setAttribute(e, i);
    }
  }
  saveInitialURLToTag(e, i) {
    this.setAttributeToTag("_initialURL", e, i);
  }
  saveInitialTimestampToTag(e, i, r) {
    this.setAttributeToTag("_loadStart", e, r), this.setAttributeToTag("_loadEnd", i, r);
  }
  addContentToWrapperNode(e, i) {
    let r = document.createElement("_VASTAdTagURIContent");
    r.appendChild(i.firstElementChild), e.appendChild(r);
  }
};
kr.EVENT = {
  PARSED: "AdTagService::parsed"
};
let Dr = kr;
class ko {
  // to not leak currentAd into public available API we have to define it in this "closure"
  // as with ES6 there's no good way to keep variables private yet
  // neither weakmaps nor symbols really help
  // pitfalls:
  // - use 'that' instead of 'this' in the getters
  // - mind to use commas between getters
  constructor(e) {
    if (!e)
      return {};
    function i(h, m) {
      const g = e[h];
      return !g || g.length <= 0 ? (p.debug.info(m), []) : g;
    }
    const r = (h, m) => {
      const g = e.creatives;
      if (g && g.length !== 0) {
        const y = g.find(
          (L) => L.type === h
        );
        if (y && y.variations && y.variations.length > 0)
          return y.variations;
      }
      return p.debug.info(m), [];
    };
    function s(h) {
      return h.charAt(0).toUpperCase() + h.slice(1);
    }
    const l = (h) => {
      var g, y;
      if (e.isLinear) {
        const L = e.properCreative && e.properCreative.selectedMediaFile;
        return L ? L[h] : -1;
      }
      const m = (y = (g = e.creativesArray) == null ? void 0 : g.nonLinearCreative[0]) == null ? void 0 : y.variations[0];
      if (m && e.isExpanded) {
        const L = `expanded${s(h)}`;
        return m[L] === -1 ? m[h] : m[L];
      }
      return m ? m[h] : -1;
    };
    return {
      /**
       * @returns {string|null} An ad server-defined identifier string for the ad.
       */
      get adId() {
        return e.adXML ? e.id : null;
      },
      /**
       * Provide the ad server’s unique identifier for the creative.
       * @returns {Array<string|null>} adId(s) of the ad creative node(s) in the creatives node.
       */
      get adIds() {
        return e.adXML ? e.adIds : [null];
      },
      /**
       * @return {string|null} a unique or pseudo-unique (long enough to be unique when combined with
       * timestamp data) GUID
       */
      get adServingId() {
        return e.adXML ? e.adServingId : null;
      },
      /**
       * The value of this property is an Array that provides ad verifications for the `<MediaFile>` element.
       * The video player should request this value whenever it receives the **ON_AD_VERIFICATIONS_DETECTED**
       *  add-on event.
       * @returns {Array.<AdVerification>} List of all ad verifications.
       */
      get adVerifications() {
        return i("adVerifications", "There are no ad verifications along with this ad.");
      },
      /**
       * The value of this property is an Array that provides closed captions for the `<MediaFile>` element.
       * The video player should request this value whenever it receives the **ON_CLOSED_CAPTIONS_DETECTED**
       *  add-on event.
       * @returns {Array.<ClosedCaption>} List of all closed captions.
       */
      get closedCaptions() {
        return i("closedCaptions", "There are no Closed Captions along with this ad.");
      },
      /**
       * The value of this property is an Array that provides ad companion details for each `<CompanionAd>`
       *  element. The video player should request this value whenever it receives the `ON_COMPANIONS_DETECTED`
       *  event.
       *
       * @returns {Array.<CompanionAd>} List of all companion ads.
       */
      get companions() {
        return r(pi.COMPANION, "There are no companions available.");
      },
      /**
       * Retrieves the creative identifiers for the current ad.
       * @returns {CreativeIds} An object containing the IDs of the creative nodes.
       * @property CreativeIds.adId - The unique ad server identifiers for the creative nodes.
       * @property CreativeIds.id - The ad server-defined identifiers for the creative nodes.
       */
      get creativeIds() {
        function h(g, y) {
          return y === 0 || !g.parentElement ? g : h(g.parentElement, y - 1);
        }
        function m(g) {
          const y = h(g, 3), L = y.getAttributeNames().find((ie) => ie.toLowerCase() === "adid");
          return {
            adId: y.getAttribute(L) || null,
            id: y.getAttribute("id")
          };
        }
        if (e.isLinear && e.adXML) {
          let g = null;
          if (e.isSIMID ? g = "InteractiveCreativeFile" : e.isVPAID ? g = 'MediaFile[type="application/javascript"]' : e.properCreative && e.properCreative.selectedMediaFile && (g = `MediaFile[bitrate="${e.properCreative.selectedMediaFile.bitrate}"]`), g) {
            const y = q(e.adXML, g);
            return m(y);
          }
        } else if (e.properCreative && e.properCreative.variations) {
          const g = e.properCreative.variations[0].selectedResource.type, y = e.properCreative.variations[0].selectedResource.creativeType, L = g !== Bi.IFRAME ? q(e.adXML, `${g}[creativeType="${y}"]`) : q(e.adXML, g);
          return m(L);
        }
        return null;
      },
      get currentTime() {
        return e.currentTime || -1;
      },
      get duration() {
        var h;
        return !e.isLinear && ((h = e.creativesArray) != null && h.nonLinearCreative.length) ? e.creativesArray.nonLinearCreative[0].variations[0].displayDuration : e.duration;
      },
      /**
       * Requests details about the most recent error that has occurred with the current ad.
       * @returns {AdError} Description object of the most recent ad error
       */
      get error() {
        return !e.error || !e.error.code ? (p.debug.info("The ad seems to have no error."), {
          code: -1,
          timestamp: Date.now(),
          message: "No error."
        }) : {
          code: e.error.code,
          timestamp: Date.now(),
          message: e.error.message
        };
      },
      /**
       * The value of this property is an Array that provides ad extension details for the
       *  `<Extensions>` element.
       * The video player should request this value whenever it receives the **ON_EXTENSIONS_DETECTED**
       *  add-on event.
       * @returns {Array.<Extension>} List of all extensions.
       */
      get extensions() {
        return i("extensions", "There is no VAST extension available.");
      },
      /**
       * Returns whether the current ad has a ClickThrough target (URL) or not.
       * Note: In the case of `Nonlinear` with `IFrameResource`, the result is always `false`.
       * @returns {boolean} - true if the current ad contains a ClickThrough URL.
       */
      get hasClickThrough() {
        if (e.isLinear)
          return !!e.clickThroughURL;
        try {
          return !!e.properCreative.variations[0].clickThroughURL && e.properCreative.variations[0].resources[0].type !== Bi.IFRAME;
        } catch (h) {
          return !1;
        }
      },
      get height() {
        return l("height");
      },
      /**
       * The value of this property is an Object that provides ad icon details for the `<Icon>` element.
       * The video player should request this value whenever it receives the **ON_ICONS_DETECTED** add-on event.
       * @returns { { [key: string]: IconProgram } | {} } Object of all industry icons.
       */
      get icons() {
        return !e.icons || Object.keys(e.icons).length <= 0 ? (p.debug.info("There are no Industry Icons along with this ad."), {}) : e.icons;
      },
      /**
       * Ad server’s unique identifier for the creative.
       * @returns {Array<string|null>} id(s) of the ad creative node(s) in the creatives node.
       */
      get ids() {
        return e.adXML ? e.ids : [null];
      },
      get isExpanded() {
        return e.isExpanded || !1;
      },
      /**
       * Returns whether the current ad is interactive (most likely by using __VPAID__) or not.
       * @returns {boolean} - true if the current ad has been specified as interactive.
       */
      get isInteractive() {
        return e.isInteractive || !1;
      },
      get isLinear() {
        return e.isLinear;
      },
      /**
       * Note: Up to version 4.x the `isSkippable` flag was used to check whether the ad can be skipped, depending
       * on the current progress. The following conditions must have been met:
       *  - the ad has specified a `skipoffset`
       *  - the parsed time of `skipoffset` is equal or greater than 0 seconds
       *  - the current playhead time is equal or greater than the `skipoffset`
       *
       * @returns {boolean} - true if the current Linear has attribute skipoffset.
       */
      get isSkippable() {
        return e.isSkippable;
      },
      /**
       * The value of this property is an Object that provides the linear ad detail for the current `<Linear>`
       *  element.
       * @returns { AdCreative | {}} with details about the linear ad.
       */
      get linear() {
        const h = e.properCreative;
        return h && h.length !== 0 ? h : (p.debug.info("There are no linear ads available."), {});
      },
      /**
       * The list outlines the various VAST macros and their current values.
       * @returns { [key: string]: any } Snapshot of the VAST Macros.
       */
      get macroList() {
        return e.enrichment ? e.enrichment.getMacroList() : {};
      },
      /**
       * The value of this property is an Array that provides ad nonLinear details for each `<NonLinearAds>`
       *  element.
       *
       * @returns {Array.<NonLinearAds>} List of all nonLinear ads.
       */
      get nonLinear() {
        return r(pi.NON_LINEAR, "There are no nonLinearAds available.");
      },
      get remainingTime() {
        var h;
        return !e.isLinear && ((h = e.creativesArray) != null && h.nonLinearCreative.length) ? e.duration - e.currentTime : e.remainingTime || e.duration || -1;
      },
      /**
       * @returns {number} Representing the playback time after a linear ad can be skipped. Defaulting to -1, not
       *  skippable.
       */
      get skipOffset() {
        return e.skipOffset;
      },
      /**
       * @returns {string|null} Title for the ad, defined by the ad serving party.
       */
      get title() {
        return e.title;
      },
      /**
       * @returns {string} The type of ad as specified by the ad-server (since VAST 4.1)
       */
      get type() {
        return e.adType;
      },
      /**
       * Note: VAST 4.0 had an attribute “idValue” that was a duplicate of the node value and so was removed as of
       *  4.1. Media players should not fail if this attribute is present, but should always use the Content as
       *  the source of truth for the creative ID value
       *
       * Content/"idValue" A string identifying the unique creative identifier.
       * Default value is “unknown” idRegistry*A string used to identify the URL for the registry website
       *  where the unique creative ID is cataloged. Default value is “unknown.
       *
       * _*Note:* Null is only the case if it is a request in the separationClip case._
       * @returns {Object | null} UniversalAdId
       */
      get universalAdId() {
        return e.adXML ? e.universalAdId : null;
      },
      /**
       * VAST 4.2 allows multiple UniversalAdId nodes to be provided
       *
       * _*Note:* Null is only the case if it is a request in the separationClip case._
       * @returns {Array | null} List of all Universal Ad IDs
       */
      get universalAdIds() {
        return e.adXML ? e.universalAdIds : null;
      },
      /**
       * @returns {string} variant of the ad (closer, divider, commercial, sponsored, opener).
       */
      get variant() {
        return e.variant;
      },
      /**
       * The value of this property is an Array that provides details for each `<Verification>` element.
       * The video player may request this value whenever it receives the **ON_VERIFICATIONS_DETECTED** add-on
       *  event, depending on whether the player takes care of the Open Measurement.
       * @returns {Array.<AdVerification>} List of all ad verification vendors (if configured, whitelisted
       *  vendors only)
       */
      get verifications() {
        return i("adVerifications", "There is no AdVerification vendor available.");
      },
      /**
       * Contains information about the visibility status, the corresponding threshold value and the
       * current visibility value.
       * @returns {Object} Overview about the status of visibility.
       */
      get viewability() {
        return e.viewability ? e.viewability : {};
      },
      set volume(h) {
        e.volume = h;
      },
      get volume() {
        return e.volume || -1;
      },
      get width() {
        return l("width");
      },
      /**
       * The value of this property is an Array of Objects whereas each Object represents the details for a
       *  Wrapper response. The video player may request this value whenever it requires more insights to a chain
       *  of ad server responses.
       * @returns {Array.<Object>} List of Wrapper objects, starting with the initial request up to the last
       *  Wrapper before the Inline tag.
       */
      get wrappers() {
        return i("wrappers", "The ad was not part of a wrapper chain.");
      }
    };
  }
}
class Uo {
  // to not leak the adSlot into public available API we have to define it in this "closure"
  // as with ES6 there's no good way to keep variables private yet
  // neither weakmaps nor symbols really help
  // pitfalls:
  // - mind to use commas between getters
  constructor(e, i) {
    return e.currentAd ? {
      /**
       * @returns {number} - of the current clip.
       */
      get currentClip() {
        return e.currentAd.currentClip;
      },
      /**
       * @returns {number} - of the current commercial.
       */
      get currentCommercial() {
        return e.currentAd.currentCommercial;
      },
      /**
       * @returns {number} - of the total commercials.
       */
      get totalCommercials() {
        return i.totalCommercials;
      },
      /**
       * @returns {number} - of the total time of commercials played.
       */
      get totalCommercialsCurrentTime() {
        return e.adSlotTimes.totalCommercialsCurrentTime;
      },
      /**
       * @returns {number} - of the total duration of playable commercials.
       */
      get totalCommercialsDuration() {
        return e.adSlotTimes.totalCommercialsDuration;
      },
      /**
       * @returns {number} - of the total playable clips.
       */
      get totalClips() {
        return i.totalClips;
      },
      /**
       * @returns {number} - of the total playable clips.
       */
      get totalPlayableClips() {
        return i.totalPlayableClips + (e.manifest.replaced || 0);
      },
      /**
       * @returns {number} - of the total playable commercials.
       */
      get totalPlayableCommercials() {
        return i.totalPlayableCommercials + (e.manifest.replaced || 0);
      }
    } : {};
  }
}
class ts {
  /**
   * Creates an instance of TCFAPIBase.
   * @param {any} apiRef - The reference to the consent API.
   * @param {Function} onConsentCallback - The callback function to be invoked on consent data retrieval.
   * @param {number} version - The version of the TCFAPI.
   */
  constructor(e, i, r) {
    this.consentAPI = e, this.callback = i, this.consentDataInfo = void 0, this.gdprAppliesBoolean = void 0, this.version = r, this.NAME = "TCFAPI::", p.debug.warn(`${this.NAME}Ctor - api found at`, this.consentAPI);
  }
  /**
   * Retrieves consent data using the specified API method.
   * @param {string} apiMethodName - The name of the API method to be called.
   * @param {string} eventDataKey - The key to extract consent data from the received event data.
   */
  getConsent(e, i) {
    this.consentAPI(e, this.version, (r) => {
      this.onConsentData(r, i);
    });
  }
  /**
   * Callback function triggered on consent data retrieval.
   * @param {any} eventData - The event data received from the consent API.
   * @param {string} eventDataKey - The key to extract consent data from the received event data.
   */
  onConsentData(e, i) {
    this.consentDataInfo = e[i], this.gdprAppliesBoolean = e.gdprApplies, p.debug.info(`${this.NAME}onConsentData, eventData:`, e), this.callback();
  }
  /**
   * Getter for consent data.
   * @type {undefined | string}
   */
  get consentData() {
    return this.consentDataInfo;
  }
  /**
   * Getter for GDPR applies boolean.
   * @type {undefined | boolean}
   */
  get gdprApplies() {
    return this.gdprAppliesBoolean;
  }
}
class Fo extends ts {
  /**
   * Creates an instance of TCFAPI__CMP.
   * @param {any} apiRef - The reference to the consent API.
   * @param {Function} onConsentCallback - The callback function to be invoked on consent data retrieval.
   */
  constructor(e, i) {
    super(e, i, 1);
  }
  /**
   * Retrieves consent data using the 'getConsentData' method.
   */
  getConsent() {
    super.getConsent("getConsentData", "consentData");
  }
}
class $o extends ts {
  /**
   * Creates an instance of TCFAPI__TCF.
   * @param {any} apiRef - The reference to the consent API.
   * @param {Function} onConsentCallback - The callback function to be invoked on consent data retrieval.
   */
  constructor(e, i) {
    super(e, i, 2);
  }
  /**
   * Retrieves consent data with the first addEventListener method for version 2.2, if no result, try 'getTCData'
   * method for version 2.0.
   */
  getConsent() {
    super.getConsent("addEventListener", "tcString"), this.consentData === void 0 && super.getConsent("getTCData", "tcString");
  }
}
class jo {
  constructor(e) {
    this.enrichment = e, this.NAME = "TCFAPI::";
    try {
      const i = window.top;
      i && (this.tcfAPI = i.__tcfapi, this.cmpAPI = i.__cmp);
    } catch (i) {
      p.debug.warn(`${this.NAME}Ctor No window?`, i);
    }
    this.hasTCF() ? this.api = new $o(this.tcfAPI, this.setMacro.bind(this)) : this.hasCMP() && (this.api = new Fo(this.cmpAPI, this.setMacro.bind(this))), this.api ? this.api.getConsent() : p.debug.warn(`${this.NAME}Ctor Site w/o API support`);
  }
  isFunction(e) {
    return typeof e == "function";
  }
  get consentData() {
    return (this.api || {}).consentData;
  }
  get gdprApplies() {
    return (this.api || {}).gdprApplies;
  }
  hasTCF() {
    return this.isFunction(this.tcfAPI);
  }
  hasCMP() {
    return this.isFunction(this.cmpAPI);
  }
  setMacro() {
    p.debug.info(
      `${this.NAME}setMacro consentData`,
      this.api.consentData,
      "gdprApplies",
      this.api.gdprApplies
    ), this.enrichment && this.api.gdprApplies && (this.enrichment.set("GDPRCONSENT", this.api.consentData), this.enrichment.set("REGULATIONS", "GDPR"));
  }
}
function xr(c) {
  if (typeof c != "object" || c === null)
    return c;
  const e = /* @__PURE__ */ Object.create(null);
  for (const i of Object.keys(c)) {
    const r = c[i];
    Jn(r) || (e[i] = xr(c[i]));
  }
  return e;
}
function Bo(c) {
  const e = document.implementation.createDocument(null, "VAST", null);
  e.documentElement.setAttribute("version", "3.0");
  for (const i of c) {
    const r = e.createElement("Ad"), s = e.createElement("Wrapper"), l = e.createElement("VASTAdTagURI");
    l.appendChild(e.createTextNode(i)), s.appendChild(l), r.appendChild(s), e.documentElement.appendChild(r);
  }
  return e;
}
function Ho(c) {
  let e = c;
  if (e.originConfig = xr(c), Array.isArray(e.tag) ? e.urls = e.tag : e.urls = e.tag ? [e.tag] : [], e.response && (e.responseXML = new DOMParser().parseFromString(e.response, "text/xml")), e.repeat = e.repeat && e.repeat > 1 ? e.repeat : 1, e.repeat > 1) {
    let i = e.urls[0];
    e.urls = [];
    for (let r = 0; r < e.repeat; r++)
      e.urls.push(i.replace("[count]", (r + 1).toString()));
  }
  return e.urls.length > 0 && !e.responseXML && (e.responseXML = Bo(e.urls)), e.requested = !1, e;
}
const Yn = "AdBreakValidation";
function Wo(c) {
  var s, l;
  if (!c || typeof c != "object" || Array.isArray(c) || Object.keys(c).length === 0)
    return p.debug.warn(Yn + ": Setup Error: No adBreak definition."), !1;
  const e = (typeof c.tag == "string" || Array.isArray(c.tag)) && c.tag.length > 0, i = ((l = (s = c.response) == null ? void 0 : s.length) != null ? l : 0) > 0, r = c[fe.CLOSER] || c[fe.DIVIDER] || c[fe.OPENER];
  return !e && !i && !r ? (p.debug.warn(Yn + ": Incomplete setup: No tag, response or separationClip provided."), !1) : !0;
}
function Xo(c, e, i, r, s) {
  var l = l || {};
  (function(h) {
    var m = {
      globalConfig: c,
      clientConfig: e,
      clientAPIs: i,
      utilsReady: r,
      onFailure: s
    };
    (function() {
      function g(S) {
        S = [(typeof globalThis == "undefined" ? "undefined" : Z(globalThis)) == "object" && globalThis, S, (typeof window == "undefined" ? "undefined" : Z(window)) == "object" && window, (typeof self == "undefined" ? "undefined" : Z(self)) == "object" && self, (typeof global == "undefined" ? "undefined" : Z(global)) == "object" && global];
        for (var I = 0; I < S.length; ++I) {
          var x = S[I];
          if (x && x.Math == Math) return x;
        }
        throw Error("Cannot find global object");
      }
      var y = g(this);
      function L(S) {
        var I = 0;
        return function() {
          return I < S.length ? {
            done: !1,
            value: S[I++]
          } : {
            done: !0
          };
        };
      }
      var ie = typeof Object.defineProperties == "function" ? Object.defineProperty : function(S, I, x) {
        return S == Array.prototype || S == Object.prototype || (S[I] = x.value), S;
      };
      function ee(S, I) {
        if (I) e: {
          var x = y;
          S = S.split(".");
          for (var Y = 0; Y < S.length - 1; Y++) {
            var W = S[Y];
            if (!(W in x)) break e;
            x = x[W];
          }
          S = S[S.length - 1], Y = x[S], I = I(Y), I != Y && I != null && ie(x, S, {
            configurable: !0,
            writable: !0,
            value: I
          });
        }
      }
      ee("Symbol", function(S) {
        function I(W) {
          if (this instanceof I) throw new TypeError("Symbol is not a constructor");
          return new x("jscomp_symbol_" + (W || "") + "_" + Y++, W);
        }
        function x(W, J) {
          this.j = W, ie(this, "description", {
            configurable: !0,
            writable: !0,
            value: J
          });
        }
        if (S) return S;
        x.prototype.toString = function() {
          return this.j;
        };
        var Y = 0;
        return I;
      }), ee("Symbol.iterator", function(S) {
        if (S) return S;
        S = Symbol("Symbol.iterator");
        for (var I = "Array Int8Array Uint8Array Uint8ClampedArray Int16Array Uint16Array Int32Array Uint32Array Float32Array Float64Array".split(" "), x = 0; x < I.length; x++) {
          var Y = y[I[x]];
          typeof Y == "function" && typeof Y.prototype[S] != "function" && ie(Y.prototype, S, {
            configurable: !0,
            writable: !0,
            value: function() {
              return Oe(L(this));
            }
          });
        }
        return S;
      });
      function Oe(S) {
        return S = {
          next: S
        }, S[Symbol.iterator] = function() {
          return this;
        }, S;
      }
      function Q(S) {
        var I = typeof Symbol != "undefined" && Symbol.iterator && S[Symbol.iterator];
        return I ? I.call(S) : {
          next: L(S)
        };
      }
      function z(S, I) {
        return Object.prototype.hasOwnProperty.call(S, I);
      }
      ee("WeakMap", function(S) {
        function I(N) {
          if (this.h = (D += Math.random() + 1).toString(), N) {
            N = Q(N);
            for (var P; !(P = N.next()).done; ) P = P.value, this.set(P[0], P[1]);
          }
        }
        function x() {
        }
        function Y(N) {
          var P = Z(N);
          return P === "object" && N !== null || P === "function";
        }
        function W(N) {
          if (!z(N, U)) {
            var P = new x();
            ie(N, U, {
              value: P
            });
          }
        }
        function J(N) {
          var P = Object[N];
          P && (Object[N] = function($) {
            return $ instanceof x ? $ : (Object.isExtensible($) && W($), P($));
          });
        }
        if (function() {
          if (!S || !Object.seal) return !1;
          try {
            var N = Object.seal({}), P = Object.seal({}), $ = new S([[N, 2], [P, 3]]);
            return $.get(N) != 2 || $.get(P) != 3 ? !1 : ($.delete(N), $.set(P, 4), !$.has(N) && $.get(P) == 4);
          } catch (re) {
            return !1;
          }
        }()) return S;
        var U = "$jscomp_hidden_" + Math.random();
        J("freeze"), J("preventExtensions"), J("seal");
        var D = 0;
        return I.prototype.set = function(N, P) {
          if (!Y(N)) throw Error("Invalid WeakMap key");
          if (W(N), !z(N, U)) throw Error("WeakMap key fail: " + N);
          return N[U][this.h] = P, this;
        }, I.prototype.get = function(N) {
          return Y(N) && z(N, U) ? N[U][this.h] : void 0;
        }, I.prototype.has = function(N) {
          return Y(N) && z(N, U) && z(N[U], this.h);
        }, I.prototype.delete = function(N) {
          return Y(N) && z(N, U) && z(N[U], this.h) ? delete N[U][this.h] : !1;
        }, I;
      }), ee("Map", function(S) {
        function I() {
          var D = {};
          return D.c = D.next = D.head = D;
        }
        function x(D, N) {
          var P = D.b;
          return Oe(function() {
            if (P) {
              for (; P.head != D.b; ) P = P.c;
              for (; P.next != P.head; ) return P = P.next, {
                done: !1,
                value: N(P)
              };
              P = null;
            }
            return {
              done: !0,
              value: void 0
            };
          });
        }
        function Y(D, N) {
          var P = N && Z(N);
          P == "object" || P == "function" ? J.has(N) ? P = J.get(N) : (P = "" + ++U, J.set(N, P)) : P = "p_" + N;
          var $ = D.g[P];
          if ($ && z(D.g, P)) for (D = 0; D < $.length; D++) {
            var re = $[D];
            if (N !== N && re.key !== re.key || N === re.key) return {
              id: P,
              list: $,
              index: D,
              a: re
            };
          }
          return {
            id: P,
            list: $,
            index: -1,
            a: void 0
          };
        }
        function W(D) {
          if (this.g = {}, this.b = I(), this.size = 0, D) {
            D = Q(D);
            for (var N; !(N = D.next()).done; ) N = N.value, this.set(N[0], N[1]);
          }
        }
        if (function() {
          if (!S || typeof S != "function" || !S.prototype.entries || typeof Object.seal != "function") return !1;
          try {
            var D = Object.seal({
              x: 4
            }), N = new S(Q([[D, "s"]]));
            if (N.get(D) != "s" || N.size != 1 || N.get({
              x: 4
            }) || N.set({
              x: 4
            }, "t") != N || N.size != 2) return !1;
            var P = N.entries(), $ = P.next();
            return $.done || $.value[0] != D || $.value[1] != "s" ? !1 : ($ = P.next(), !($.done || $.value[0].x != 4 || $.value[1] != "t" || !P.next().done));
          } catch (re) {
            return !1;
          }
        }()) return S;
        var J = /* @__PURE__ */ new WeakMap();
        W.prototype.set = function(D, N) {
          D = D === 0 ? 0 : D;
          var P = Y(this, D);
          return P.list || (P.list = this.g[P.id] = []), P.a ? P.a.value = N : (P.a = {
            next: this.b,
            c: this.b.c,
            head: this.b,
            key: D,
            value: N
          }, P.list.push(P.a), this.b.c.next = P.a, this.b.c = P.a, this.size++), this;
        }, W.prototype.delete = function(D) {
          return D = Y(this, D), D.a && D.list ? (D.list.splice(D.index, 1), D.list.length || delete this.g[D.id], D.a.c.next = D.a.next, D.a.next.c = D.a.c, D.a.head = null, this.size--, !0) : !1;
        }, W.prototype.clear = function() {
          this.g = {}, this.b = this.b.c = I(), this.size = 0;
        }, W.prototype.has = function(D) {
          return !!Y(this, D).a;
        }, W.prototype.get = function(D) {
          return (D = Y(this, D).a) && D.value;
        }, W.prototype.entries = function() {
          return x(this, function(D) {
            return [D.key, D.value];
          });
        }, W.prototype.keys = function() {
          return x(this, function(D) {
            return D.key;
          });
        }, W.prototype.values = function() {
          return x(this, function(D) {
            return D.value;
          });
        }, W.prototype.forEach = function(D, N) {
          for (var P = this.entries(), $; !($ = P.next()).done; ) $ = $.value, D.call(N, $[1], $[0], this);
        }, W.prototype[Symbol.iterator] = W.prototype.entries;
        var U = 0;
        return W;
      }), ee("Object.is", function(S) {
        return S || function(I, x) {
          return I === x ? I !== 0 || 1 / I === 1 / x : I !== I && x !== x;
        };
      }), ee("Array.prototype.includes", function(S) {
        return S || function(I, x) {
          var Y = this;
          Y instanceof String && (Y = String(Y));
          var W = Y.length;
          for (x = x || 0, 0 > x && (x = Math.max(x + W, 0)); x < W; x++) {
            var J = Y[x];
            if (J === I || Object.is(J, I)) return !0;
          }
          return !1;
        };
      }), ee("String.prototype.includes", function(S) {
        return S || function(I, x) {
          if (this == null) throw new TypeError("The 'this' value for String.prototype.includes must not be null or undefined");
          if (I instanceof RegExp) throw new TypeError("First argument to String.prototype.includes must not be a regular expression");
          return (this + "").indexOf(I, x || 0) !== -1;
        };
      }), ee("Array.from", function(S) {
        return S || function(I, x, Y) {
          x = x != null ? x : function(D) {
            return D;
          };
          var W = [], J = typeof Symbol != "undefined" && Symbol.iterator && I[Symbol.iterator];
          if (typeof J == "function") {
            I = J.call(I);
            for (var U = 0; !(J = I.next()).done; ) W.push(x.call(Y, J.value, U++));
          } else for (J = I.length, U = 0; U < J; U++) W.push(x.call(Y, I[U], U));
          return W;
        };
      }), function() {
        function S() {
          this.f = {}, this.global = {}, this.client = {}, this.i = {};
        }
        function I() {
          return "abcdef123456789abcdef123456789abcdef123456789".split("").sort(function() {
            return Math.random() - 0.5;
          }).join("").substr(0, 40);
        }
        function x(U) {
          return U == "True" || U == "true" || U == 1 || U == "1" || U == 1;
        }
        function Y() {
          var U = function() {
            var $ = (navigator.appCodeName + navigator.appName + navigator.appVersion + navigator.userAgent + navigator.platform + (navigator.language || navigator.m || "x")).split(" ").join(""), re = Math.max(Math.round(Date.now() / 1e3 / 60), Math.round((Date.now() / 1e3 + 10) / 60)).toString(), De = $.slice(0, $.length / 2).split("").reverse().join("");
            return $ = $.slice($.length / 2).split("").reverse().join(""), re + De + re + $ + re;
          }(), D = function($) {
            var re = 0, De;
            if ($.length == 0) return re;
            var Le = 0;
            for (De = $.length; Le < De; Le++) re = (re << 5) - re + $.charCodeAt(Le), re |= 0;
            return Math.abs(re);
          }(U).toString();
          D = (D + D.split("").reverse().join("")).split("").reverse().join("").match(/.{1,2}/g).map(Number), U = btoa(U).replace(/[^a-z]/gi, "").substr(0, 100);
          for (var N = "", P = 0; P < D.length; P++) N += U.charAt(D[P]);
          return N || "zork";
        }
        function W(U, D) {
          return U = Math.round(Math.abs(U)) || 10, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".split("").sort(function() {
            return Math.random() - 0.5;
          }).join("").substr(0, U);
        }
        S.prototype.getItem = function(U) {
          return this.i[U] || this.client[U] || this.f[U];
        }, S.prototype.l = function(U) {
          this.f = U.embed, this.global = U.global, this.client = U.client, this.i = U.customer;
        };
        var J = null;
        J = new S(), function(U) {
          function D(V, B, G) {
            var Ae = {
              homad_url_prefix_alias: "",
              homad_track_key: "*" + encodeURIComponent(V) + "*",
              homad_track_value: "*" + encodeURIComponent(B.toString()) + "*"
            }, le = G ? null : function() {
              D(V, B, !0);
            };
            G = G ? N(!0) : P(), He(G, null, le, Ae);
          }
          function N(V) {
            return V = V ? ["curloc", "com"] : window.location.host.split("."), ("https://ssl." + (Math.round(2 * Math.random()) + 1) + ".damoh." + V.slice(V.length - 2).join(".") + "/[hash]/").replace("[hash]", I(W()));
          }
          function P() {
            if (Re && Re.server) {
              var V = Re.server[Math.floor(Math.random() * Re.server.length)] + "";
              return V.replace("[hash]", I(W()));
            }
            return N(!1);
          }
          function $() {
            if (Array.from(document.getElementsByTagName("video")).forEach(function(B) {
              try {
                B.pause();
              } catch (G) {
              }
              B.parentNode.removeChild(B);
            }), Array.from(document.querySelectorAll("[class*='video']")).forEach(function(B) {
              B.parentNode.removeChild(B);
            }), window.self != window.top) for (var V = window.document; V.hasChildNodes(); ) V.removeChild(V.lastChild);
            Xe.get("setTimeout")($, Math.round(1e3 + 100 * Math.random()));
          }
          function re(V) {
            return We && clearTimeout(We), D("stats_embed_penalty", V), $(), !1;
          }
          function De() {
            Ue && Ue.enabled === !1 || Re && Re.enabled === !1 || be && be.enabled === !1 ? clearTimeout(We) : re("load_main");
          }
          function Le() {
            He(be.src.toString(), function(V) {
              be.src.toString() === V.responseURL ? (V = et(V.responseText), be.data = V, be.enabled = x(V.enabled), De()) : re("redirect_customer");
            }, function() {
              be.data = {}, be.enabled = void 0, De();
            });
          }
          function ft() {
            var V = Re.src;
            typeof V == "string" ? He(V.toString(), function(B) {
              V.toString() === B.responseURL ? (B = et(B.responseText), Re.data = B, Re.enabled = x(B.enabled), be.src = B.config, Le()) : re("redirect_client");
            }, function() {
              Re.data = {}, Re.enabled = void 0, Le();
            }) : (Re.data = typeof V == "function" ? V() : V, Le());
          }
          function kt() {
            He(Ue.src.toString(), function(V) {
              Ue.src.toString() === V.responseURL ? (V = et(V.responseText), Ue.data = V, Ue.enabled = x(V.enabled), ft()) : re("redirect_global");
            }, function() {
              Ue.data = {}, Ue.enabled = void 0, ft();
            });
          }
          function ze(V) {
            clearTimeout(We);
            var B = new V();
            B.init(J.f.globalConfig, J.f.clientConfig, !0, function() {
              J.f.utilsReady(B);
            }, function() {
              re("utils_init");
            }, J.f);
          }
          function dt(V) {
            var B = mt.shift();
            B ? !window[Y()] || V ? Nt(B) : V || clearTimeout(We) : kt();
          }
          function He(V, B, G, Ae) {
            Ae = Ae === void 0 ? null : Ae;
            var le = new XMLHttpRequest();
            if (le.onreadystatechange = function() {
              B && le.readyState == 4 && le.status == 200 && B(le), G && le.readyState == 4 && le.status != 200 && G(le);
            }, Ae) {
              var Et = "", Ct;
              for (Ct in Ae) Et += "&" + Ct + "=" + encodeURIComponent(Ae[Ct]);
              Et = Et.substr(1), le.open("POST", V, !0), le.setRequestHeader("Content-type", "application/x-www-form-urlencoded"), le.send(Et);
            } else le.open("GET", V, !0), le.send();
          }
          function Nt(V) {
            var B = document.createElement.toString().indexOf("native code") !== -1 ? document.createElement("script") : Xe.get("createElement")("script"), G;
            if (B.setAttribute("data-info", ut), B.src = V, B.onload = function(le) {
              le.currentTarget.getAttribute("id") === Y() ? At() ? (le = G[ut.split("").reverse().join("")], ze(le)) : clearTimeout(We) : mt.length ? dt(!0) : re("main_redirect");
            }, B.onerror = function() {
              dt(!0);
            }, window[Y()] || (window[Y()] = W(5 + Math.round(5 * Math.random()))), At()) {
              var Ae = document.createElement.toString().indexOf("native code") !== -1 ? document.createElement("iframe") : Xe.get("createElement")("iframe");
              if (!Ae || Ae.nodeName.toLowerCase() !== "iframe" || !Ae.nodeType) return re("utils_iframe");
              Ae.style.display = "none", Ae.onload = function() {
                if (G = Ae.contentWindow, G[ut] = U, Ae.contentWindow.document.body.appendChild(B) !== B) return re("utils_script");
              }, document.body.appendChild(Ae);
            } else document.head.appendChild(B);
          }
          function et(V) {
            var B = Xe.get("JSON");
            try {
              var G = B.parse(V);
            } catch (Ae) {
              G = {};
            }
            return G;
          }
          function At() {
            return J.f.utilsReady != null;
          }
          var ut = W(10 + Math.round(10 * Math.random()));
          window[ut] = U, J = new S(), J.l({
            embed: U
          }), J.f.version = "20230601_1407";
          var We = 0, Ut = ["https://hgc-cf-cache-1.svonm.com/hd-main.js", "https://s3.amazonaws.com/homad-global-configs.schneevonmorgen.com/hd-main.js"], Se = ["https://hgc-cf-cache-1.svonm.com/hd-utils.js", "https://s3.amazonaws.com/homad-global-configs.schneevonmorgen.com/hd-utils.js"], mt = At() ? Se : Ut, Ue = {
            src: U.globalConfig,
            enabled: void 0,
            data: null
          }, Re = {
            src: U.clientConfig,
            enabled: void 0,
            data: null
          }, be = {
            src: null,
            enabled: void 0,
            data: null
          }, Xe = /* @__PURE__ */ new Map();
          (function() {
            if (document.body) {
              var V = document.createElement("iframe");
              V.style.display = "none", document.body.appendChild(V);
              var B = V.contentWindow;
            } else document.head ? (V = document.createElement("iframe"), V.style.display = "none", document.head.appendChild(V), B = V.contentWindow) : B = window;
            Xe.set("JSON", B.JSON), Xe.set("createElement", B.document.createElement.bind(document)), Xe.set("setTimeout", B.setTimeout.bind(window)), V && V.parentNode && V.parentNode.removeChild(V);
          })(), function() {
            We = Xe.get("setTimeout")(function() {
              re("timeout_main");
            }, Math.round(14e3 + 2500 * Math.random()));
          }(), dt();
        }(m);
      }();
    })();
  }).bind(l)(l);
}
let Pe = null, xe = null;
const ue = class ue extends Rt {
  /**
   * @param {Object} playerFacade - A player proxy class
   * @param {Object} config - scc init configuration object
   */
  constructor(e, i) {
    super(), this.adBreak = {
      adBreakPosition: 0,
      // eslint-disable-next-line no-undefined
      originConfig: void 0,
      repeat: null,
      // eslint-disable-next-line no-undefined
      requested: void 0,
      response: "",
      responseXML: null,
      tag: [],
      type: he.LINEAR,
      urls: []
    }, this.adSlotBuffet = null, this.adSlotModelList = null, this.adSlotRequestTimeout = null, this.config = Pe = i, this.environmentVars = {}, this.error = null, this.initialURLHandler = i.urlhandler ? i.urlhandler : pt, this.player = e, this.rawAdSlotModel = [], this.rawXMLDocument = null, this.rejectSlotChanges = !1, this.removeStopSlotHandler = null, this.removeOnAdSlotFinishedHandler = super.addEventListener(f.ON_AD_SLOT_STOPPED, () => {
      this.stopAdSlot();
    }), this.removeOnAdReinsertionActivationHandler = ce.EventDispatcher.addEventListener(
      f.ON_AD_REINSERTION_ACTIVATION,
      () => {
        this.restartAdSlot();
      }
    ), this.slot = null, this.timeouts = Pe.timeouts, this.startAdSlotCounter = 0, this.initializeHOMAD(this.config), this.config.adReinsertion.homad.setup.forceActivation && this.forceHOMADActivation();
  }
  initializeHOMAD(e) {
    const i = new Ot();
    i.setFromObject(this.environmentVars.vastMacros), i.set("MEDIAMIME", this.environmentVars.desiredMimeTypes || Object.values(ci)), xe = new ce(this.config.adReinsertion, i);
    let r = (l) => {
      p.debug.info(ue.NAME + "initializeHOMAD - Utils ready.", l), p.debug.info(ue.NAME + "initializeHOMAD - Set vendor API.", l), xe.setVendorAPI(l), xe.setCorroborationCallback(this.onRequestAdReinsertionCorroboration.bind(this)), xe.setActivationCallback(this.onAdReinsertionActivation.bind(this)), e.adReinsertion.homad.utils = l;
    }, s = (l) => {
      p.debug.warn(ue.NAME + "initializeHOMAD Penalty"), r = () => {
      }, xe.vendorAPI ? (p.debug.warn("initializeHOMAD - Penalty during ad playback."), ot.call(this, w.SESSION.AD_REINSERTION_PENALTY)) : (p.debug.warn("initializeHOMAD - Error.", l), ot.call(this, w.SETUP.AD_REINSERTION_PENALTY)), this.dispatchEvent(f.ON_HOMAD_PENALTY);
    };
    if (e.adReinsertion.homad.enabled && e.adReinsertion.homad.setup) {
      const l = e.adReinsertion.homad.setup;
      Xo(
        l.globalConfig,
        l.clientConfig,
        {
          player: this.player,
          adSlotAPI: this
        },
        // any -> we don't know 3.party interface
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        (h) => {
          r(h);
        },
        (h) => {
          s(h);
        }
      );
    }
  }
  forceHOMADActivation() {
    this.error && this.error.code === w.SETUP.AD_REINSERTION_PENALTY.code || (xe.setReinsertionReason({
      reason: ce.REASON.FORCE_ACTIVATION,
      source: "",
      error: {
        code: 1020
      }
    }), xe.enable(
      () => {
        p.debug.info(
          ue.NAME + "forceHOMADActivation - Override default URLHandler with HOMADURLHandler."
        ), this.config.adReinsertion.homad.setup.enableSessionCoverage = !0, this.removeOnAdReinsertionActivationHandler(), super.dispatchEvent(f.ON_AD_REINSERTION_ACTIVATION);
      },
      () => {
        p.debug.warn("forceHOMADActivation - HOMAD Penalty while activation. HOMAD disabled.");
      }
    ));
  }
  /**
   * Removes all event listeners that the SDK itself had previously added.
   * @returns {void}
   */
  dispose() {
    this.removeOnAdSlotFinishedHandler(), this.removeOnAdReinsertionActivationHandler();
  }
  /**
   * Invokes a commercial break by requesting the specified ad setup from the ad server.
   * @param {AdBreak} adBreak - Configuration for the upcoming ad break.
   * @param {EnvironmentVars} environmentVars - Defines environment conditions for the upcoming ad break
   * @returns {Promise<String|Error>} Resolves if loading the ad manifests has been completed.
   */
  initAdSlot(e, i = {}) {
    this.adBreak = e, this.environmentVars = i, this.error = null;
    let r = null;
    return this.rejectSlotChanges ? (ot.call(this, w.SESSION.ALREADY_STARTED), Promise.reject(this.error)) : Wo(this.adBreak) ? (this.environmentVars.vastMacros = Object.assign(this.environmentVars.vastMacros || {}, {
      PLAYERSIZE: this.player.getPlayerSize().boundingRect,
      CONTENTPLAYHEAD: this.player.getContentCurrentTime(),
      MEDIAPLAYHEAD: this.player.getContentCurrentTime()
    }), this.timeouts = zt(Pe.timeouts, i.timeouts), this.environmentVars.omidServiceWindow = i.omidServiceWindow || this.config.adVerification.serviceWindow, p.debug.info(ue.NAME + "initAdSlot with", this.adBreak, this.environmentVars), this.rejectSlotChanges = !0, new Promise((s, l) => {
      this.adBreak.type || (this.adBreak.type = he.LINEAR), this.adBreak.adBreakPosition || (this.adBreak.type === he.NON_LINEAR ? this.adBreak.adBreakPosition = 4 : this.player.getContentCurrentTime() <= 0 ? this.adBreak.adBreakPosition = 1 : this.player.getContentCurrentTime() >= this.player.getContentDuration() ? this.adBreak.adBreakPosition = 3 : this.adBreak.adBreakPosition = 2), this.environmentVars.vastMacros = Object.assign(this.environmentVars.vastMacros, {
        BREAKPOSITION: this.adBreak.adBreakPosition
      }), this.adBreak.type === he.NON_LINEAR && !this.environmentVars.adContainer && p.debug.warn(ue.NAME + "initAdSlot - NonLinear adContainer not set. Using the video elements parent element as a fallback."), this.startAdSlotCounter = 0, r = super.addEventListener(f.ON_AD_MANIFEST_LOAD_ERROR, () => (p.debug.info(ue.NAME + "initAdSlot failed with error", this.errorAPI), this.rejectSlotChanges = !1, clearTimeout(this.adSlotRequestTimeout), l(this.error))), super.addEventListener(f.ON_AD_MANIFEST_LOADED, () => (clearTimeout(this.adSlotRequestTimeout), r && r(), this.rejectSlotChanges = !1, s("ok")));
      const h = this.timeouts.adSlotRequest + 0.2;
      clearTimeout(this.adSlotRequestTimeout), this.adSlotRequestTimeout = setTimeout(() => {
        p.debug.info(
          ue.NAME + "initAdSlot - timed out without response from the AdTagService."
        ), ot.call(this, w.SESSION.TIMEOUT), this.dispatchEvent(f.ON_AD_MANIFEST_LOAD_ERROR);
      }, h * 1e3), this.parse(this.adBreak);
    })) : (ot.call(this, w.SESSION.MANIFEST_SETUP_CORRUPT), Promise.reject(this.error));
  }
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  onRequestAdReinsertionCorroboration(e, i) {
    let r = "HOMADUtils.corroborate - ", s = "Utils not ready.";
    return new Promise((l, h) => {
      if (!Pe.adReinsertion.homad.utils)
        throw p.debug.info(r + s), new Error(r + s);
      Pe.adReinsertion.homad.utils.corroborate(i).then(() => {
        p.debug.info(r + "resolved."), l();
      }).catch((m) => {
        p.debug.info(r + "rejected.", m), h(m);
      });
    });
  }
  onAdReinsertionActivation(e) {
    return new Promise((i, r) => {
      if (!Pe.adReinsertion.homad.setup.activationCallback)
        return i();
      let s = Pe.adReinsertion.homad.setup.activationCallback.bind(this), l = !1, h = setTimeout(() => (l = !0, i()), ce.TIMEOUT.ACTIVATION_CALLBACK_RESPONSE), m = "onAdReinsertionActivation ";
      try {
        s(e).then(() => {
          if (clearTimeout(h), p.debug.info(m + "approved."), !l)
            return i();
        }, (g) => {
          if (clearTimeout(h), p.debug.warn(m + "declined.", typeof g), g && g.stack && g.message)
            return xe.disable(), i();
          if (!l)
            return xe.disable(), r();
        });
      } catch (g) {
        return clearTimeout(h), p.debug.warn(m + "failed. Error in activationCallback:", g), l = !0, xe.disable(), i();
      }
    });
  }
  setupEnrichmentAndTCF() {
    const e = new Ot();
    return e.setFromObject(this.environmentVars.vastMacros), e.set("MEDIAMIME", this.environmentVars.desiredMimeTypes || Object.values(ci)), this.environmentVars.vastMacros.GDPRCONSENT || new jo(e), e;
  }
  restartAdSlot() {
    p.debug.info(ue.NAME + "restartAdSlot - Override default URLHandler with HOMADURLHandler."), Pe.urlhandler = ji, clearTimeout(this.adSlotRequestTimeout), this.adBreak = this.adBreak.originConfig, this.rejectSlotChanges = !1, this.initAdSlot(this.adBreak, this.environmentVars).then(() => {
      this.slot ? (this.rejectSlotChanges = !0, this.slot.adSlotController.prepare(this.adSlotModelList, this.adSlotBuffet), this.slot.adSlotHasStarted = !0, this.slot.deliverNextAd()) : p.debug.warn(ue.NAME + "What to do next?");
    }).catch((e) => {
      p.debug.error("AdReinsertion error: Failed to restart the adSlot. Reset content.", e), this.resetContent();
    });
  }
  parse(e) {
    const i = Ho(e);
    p.debug.info(ue.NAME + "parse - Start parsing the ad slot", i);
    const r = this.setupEnrichmentAndTCF();
    xe = new ce(this.config.adReinsertion, r);
    let s = JSON.parse(JSON.stringify(Pe.timeouts));
    const l = {
      adReinsertion: xe,
      blockInsecureURL: Pe.blockInsecureURL,
      enrichment: r,
      maxWrapperDepth: Pe.maxWrapperDepth,
      prefetchBuffetAds: this.environmentVars.prefetchBuffetAds || !1,
      response: i.response ? i.responseXML : null,
      timeouts: s,
      urlhandler: Pe.urlhandler,
      withCredentials: !0,
      adRequestObserver: {
        originTimeouts: zt({}, s),
        initialTime: Date.now(),
        requestTime: 0,
        responseTime: 0
      }
    };
    let h = null, m = this.adBreak;
    if (typeof i == "object" && (m = i), m.urls.length === 1 && (h = m.urls[0], l.response = null), h || l.response) {
      let g = new Dr(l);
      h ? g.requestURL(m.urls[0], this.onXMLLoadDone.bind(this, l)) : g.requestFinalXML(l.response, this.onXMLLoadDone.bind(this, l));
    } else
      p.debug.warn(
        ue.NAME + "parse - AdSlot contains neither ad tag URL(s) nor a direct ad response."
      ), this.handleParserResponse([], l);
  }
  onXMLLoadDone(e, i) {
    this.rawXMLDocument = i, this.rawAdSlotModel = new bo(i), this.handleParserResponse(this.rawAdSlotModel.getAdList(), e);
  }
  handleParserResponse(e, i) {
    let r = i || {};
    if (!i) {
      let m = hi;
      r.adReinsertion = new ce(m.adReinsertion, new Ot()), r.timeouts = m.timeouts;
    }
    this.adSlotModelList = [], this.adSlotBuffet = [];
    let s = new Vo(
      e,
      Pe,
      this.environmentVars,
      this.adBreak
    );
    this.adSlotModelList = s.adSlotModel, this.adSlotBuffet = s.adSlotBuffet, this.sequenceData = s.sequenceData;
    const l = s.hasSessionTimeoutError, h = () => {
      if (!s.hasValidAds || l) {
        ot.call(this, l ? w.SESSION.TIMEOUT : w.SESSION.MANIFEST_LOAD_FAILED), this.dispatchEvent(f.ON_AD_MANIFEST_LOAD_ERROR);
        return;
      }
      this.adSlotController = new Tr(
        this.adSlotModelList,
        this.adSlotBuffet,
        this.environmentVars,
        this.player
      ), this.currentAd = this.adSlotController.getAd(), this.dispatchEvent(f.ON_AD_MANIFEST_LOADED);
    };
    if (r.adReinsertion.reinsertionReason && !r.adReinsertion.isActive) {
      p.debug.info(
        ue.NAME + "reinsertionReason - Found reason to enable AdReinsertion",
        r.adReinsertion.reinsertionReason
      ), r.adReinsertion.enable(
        () => {
          r.adReinsertion.setReinsertionReason(null), this.restartAdSlot();
        },
        (m) => {
          p.debug.info(
            ue.NAME + "reinsertionReason - AdReinsertion remains disabled.",
            m
          ), h();
        }
      );
      return;
    }
    h();
  }
  /**
   * Starts the ad break.
   * The add-on responds by sending an `ON_AD_SLOT_START` event notifying the video player the ad break is going
   *  to start.
   */
  startAdSlot() {
    if (!this.config.adVerification.playerHandles && this.player.getPlayerElement() === null) {
      p.debug.error("Failed to start ad slot due to player unavailability.");
      return;
    }
    if (this.rejectSlotChanges) {
      p.debug.warn("The current ad-break has already been started.");
      return;
    }
    if (this.adSlotModelList.length <= 0) {
      p.debug.warn(
        "The requested ad-break has no ads defined. Use initAdSlot() to request a new manifest."
      );
      return;
    }
    this.adBreak.type === he.NON_LINEAR && this.config.playerHandlesNonLinear && this.dispatchEvent(f.ON_NONLINEAR_DETECTED);
    const e = () => {
      this.dispatchEvent(f.ON_AD_SLOT_START), this.rejectSlotChanges = !0;
      const i = Cr;
      this.slot = new i(this.currentAd, this.adSlotController), ++this.startAdSlotCounter > 1 && (this.resetErrorWarning(), this.slot.adSlotController.addEventListener(f.ON_AD_IMPRESSION, () => {
        this.slot.adSlotController.onRewind();
      }));
      const r = (s) => {
        this.dispatchEvent(s.type);
      };
      for (const s of Object.values(f))
        this.slot.addEventListener(s, r), this.slot.adSlotController.addEventListener(s, r);
      this.slot.deliverNextAd();
    };
    this.adBreak.type === he.LINEAR ? (p.debug.info("startAdSlot - requests player to lock the current content."), this.player.saveContentState().then((i) => {
      p.debug.info("startAdSlot - player locked current content."), e();
    }, () => {
      p.debug.warn("startAdSlot - player failed to lock current content."), e();
    })) : e();
  }
  /**
   * If a creative was played completely and contained an error,
   *  this is reset here so that a replay is possible
   * The error message appears
   */
  resetErrorWarning() {
    const e = [
      w.WARNING.TRACKER_LOAD_FAILED.code,
      w.WARNING.TRACKER_TIMEOUT.code
    ];
    for (let i = 0; i < this.adSlotModelList.length; i++)
      e.indexOf(this.adSlotModelList[i].error.code) !== -1 && (this.adSlotModelList[i].error = {
        // eslint-disable-next-line no-undefined
        code: void 0,
        // eslint-disable-next-line no-undefined
        message: void 0,
        // eslint-disable-next-line no-undefined
        timestamp: null
      });
  }
  /**
   * Stops a running ad break.
   * The add-on responds by sending an `ON_AD_SLOT_COMPLETE` event notifying the video player it has closed and
   * cleaned up ad resources. Also the content of the video player has been reset.
   *
   * @returns {Promise}
   *  - resolve() - Whether the adSlot could be closed and cleaned up.
   *  - reject(string) - In the other case, the answer is a string.
   */
  stopAdSlot() {
    if (!this.rejectSlotChanges || !this.slot)
      return Promise.reject("Calling `stopAdSlot` requires a running ad-break.");
    this.slot.adSlotHasStarted = !1;
    const e = this.adBreak.type === he.LINEAR ? this.resetContent.bind(this) : this.closeAdSlot.bind(this);
    return new Promise((i) => {
      this.removeStopSlotHandler && this.removeStopSlotHandler(), this.removeStopSlotHandler = super.addEventListener(ue.EVENT.STOP_SLOT_SUCCESS, () => (this.dispatchEvent(f.ON_AD_SLOT_COMPLETE), i())), this.slot.stop().then(() => {
        e();
      }, (r) => {
        p.debug.critical("Calling AdSlot.stop() failed. Try to reset content...", r), e();
      });
    });
  }
  resetContent() {
    p.debug.info(ue.NAME + "Reset content.");
    let e = {
      code: w.SESSION.NOT_RESTORABLE.code,
      message: "SessionError: Reset content timed out. Player did not respond."
    }, i = !1, r = this.player.restoreContentState.bind(this.player), l = setTimeout(() => {
      i = !0, p.debug.error(ue.NAME + "resetContent - timeout"), ot.call(this, e), this.dispatchEvent(f.ON_GENERAL_ERROR), this.closeAdSlot();
    }, this.timeouts.contentRequest * 1e3);
    r().then(() => {
      i || (clearTimeout(l), p.debug.info(ue.NAME + "resetContent - complete"), this.closeAdSlot());
    }, (h) => {
      i || (clearTimeout(l), p.debug.error(
        ue.NAME + "resetContent - failed",
        this.player.getCurrentContentSource(),
        h
      ), e.message = "SessionError: Reset content failed.", ot.call(this, e), this.dispatchEvent(f.ON_GENERAL_ERROR), this.closeAdSlot());
    });
  }
  closeAdSlot() {
    xe && Pe.adReinsertion.homad.setup.enableSessionCoverage !== !0 && (xe.disable(), Pe.urlhandler = this.initialURLHandler), this.rejectSlotChanges = !1, this.dispatchEvent(ue.EVENT.STOP_SLOT_SUCCESS), this.slot = null;
  }
  /**
   * Skips (stops) a running single ad
   * The add-on responds by sending the `ON_AD_SKIPPED` event notifying the video player it has closed and cleaned up
   * a single ad.
   *
   * _Note:
   * The add-on does proceed with the next ad. Canceling the whole ad break requires calling `stopAdSlot()` instead.
   * @return {void}
   */
  skipAd() {
    this.slot && this.slot.onSkip();
  }
  /**
   * Following a resize of the video player, the video player calls `resize()` to allow the add-on to scale
   * and reposition itself within the display area. The add-on responds by sending an `ON_AD_SIZE_CHANGED` event.
   * @param {Rect} boundingRectangle - The video content display as a Rectangle {width, height, top, left}
   * @param {string} viewMode - Current viewing mode (normal, fullscreen, thumbnail, dynamic)
   * @return {void}
   */
  resize(e, i) {
    this.slot && this.slot.adSlotController.onResizeAd(e, i);
  }
  /**
   * Following a click on the ad, the video player calls `clickThrough()` to allow the add-on
   * to request the advertisers landing page and call the ClickThru tracking requests.
   * @param {Boolean} playerHandles - Whether the player takes responsibility for opening the landing page URL.
   * Defaulting to `false` if omitted.
   * @return {string|void} The landing page URL.
   */
  clickThrough(e = !1) {
    if (!this.slot)
      return;
    if (this.ad.hasClickThrough)
      return this.slot.adSlotController.onClickThrough(e);
  }
  /**
   * Following a click on an Industry Icon ad, the video player calls `iconClickThrough()` to allow the add-on
   * to request the advertisers landing page and call the ClickThru tracking requests.
   * @param {string} iconProgram - The program represented in the icon
   * @param {Boolean} playerHandles - Whether the player takes responsibility for opening the landing page URL.
   * Defaulting to `false` if omitted.
   * @return {string} The landing page URL.
   */
  iconClickThrough(e, i = !1) {
    if (this.slot)
      return this.dispatchEvent(f.ON_ICON_CLICKED), this.slot.adSlotController.onIconClickThrough(e, i);
  }
  /**
   * The view tracking for icons is used to track when the icon creative is displayed.
   * @param {string} iconProgram The program represented in the icon
   * @returns {void}
   */
  iconView(e) {
    this.slot && this.slot.adSlotController.onIconView(e);
  }
  /**
   * The player did not or was not able to execute the provided verification code.
   * @param {string} vendor An identifier for the verification vendor.
   * @param {string} reason The reason code corresponding to the cause of the failure.
   */
  verificationNotExecuted(e, i) {
    this.slot && this.slot.adSlotController.onVerificationNotExecuted(e, i);
  }
  /**
   * Requests the view trackers when a creative resource is displayed. The method should be called for each resource
   *  file of a `Companion Ad`.
   * @param {string} companionId Value of the `id` attribute from the `CompanionAd` object.
   * @returns {void}
   */
  companionView(e) {
    if (!this.slot)
      return;
    const i = this.ad.companions.filter((r) => r.id === e).shift();
    i && (this.dispatchEvent(f.ON_COMPANION_CREATIVE_VIEW), i.creativeViewTracker.length > 0 && (p.debug.table("Request companion creativeView trackers.", i.creativeViewTracker), this.slot.adSlotController.callTrackers(i.creativeViewTracker)));
  }
  /**
   * Following a click on a Companion ad, the video player calls `companionClickThrough()` to allow the add-on
   * to call the ClickThru tracking requests and request the advertisers landing page (most likely with
   * `StaticResource` creative resource only).
   * @param {string} companionId Value of the `id` attribute from the `CompanionAd` object.
   * @param {Boolean} playerHandles Whether the player takes responsibility for opening the landing page URL.
   * Defaulting to `true` since most companion creatives do handle clickthroughs by their own (`HTMLResource`,
   *  `IFrameResource`).
   * @return {string} The landing page URL.
   */
  companionClickThrough(e, i = !0) {
    if (!this.slot)
      return;
    const r = this.ad.companions.filter((s) => s.id === e).shift();
    if (r) {
      this.dispatchEvent(f.ON_COMPANION_CLICKED), r.clickTracker.length > 0 && (p.debug.table("Request companion click trackers.", r.clickTracker), this.slot.adSlotController.callTrackers(r.clickTracker));
      let s = r.clickThroughURL;
      if (s) {
        let l = this.slot.currentAd.enrichment.apply(s);
        if (!i) {
          const h = this.slot.currentAd.adReinsertion.isActive === !0 ? "_self" : "_blank";
          window.open(l, h);
        }
        return l;
      }
    }
  }
  /**
   * Pauses the current ad break. The add-on responds by sending the `ON_AD_PAUSED` event.
   */
  pauseAd() {
    this.slot && this.slot.pause();
  }
  /**
   * Resumes the current ad break. The add-on responds by sending the `ON_AD_PLAYING` event.
   */
  resumeAd() {
    this.slot && this.slot.play();
  }
  dispatchEvent(e) {
    return p.debug.info(ue.NAME + "dispatchEvent", e), super.dispatchEvent(e);
  }
  /**
   * Returns information about the current ad, like companions, icons, variations, verifications and more.
   * The contents of variations depend on the advertising medium, the following things can be found there:
   *
   * @returns {PublicAdAPI|null} Represents static information about the current ad.
   */
  get ad() {
    return this.adSlotController.currentAd ? new ko(this.adSlotController.currentAd) : (p.debug.warn("There is no loaded ad."), null);
  }
  /**
   * Returns information about the current ad-break, like times and more.
   *
   * @returns {PublicAdSlot|null} Represents static information about the current ad-break.
   */
  get adSlot() {
    return this.adSlotController.currentAd ? new Uo(this.adSlotController, this.sequenceData) : (p.debug.warn("There is no loaded ad."), null);
  }
  /**
   * Requests details about the most recent error that has occurred on the AdSlotAPI.
   *
   * @returns {error} Description object of the most recent error or `null`.
   */
  get errorAPI() {
    return Zn.call(this);
  }
  /**
   * Returns all of the collected XML that has been collected for the whole slot
   *
   * @returns {XML} XML as live parsable DOM representation, querySelector and similar work on this.
   */
  get rawXML() {
    return this.rawXMLDocument;
  }
};
ue.NAME = "AdSAPI::", ue.EVENT = {
  STOP_SLOT_SUCCESS: "AdSlotAPI::stopSlotSuccess"
};
let Lr = ue;
const Kt = class Kt {
  constructor(e, i) {
    this.adPlaylistAPI = null, this.adSlotAPI = null, this.config = e, this.playerFacade = i;
  }
  // TODO: Documentation: second or third scc init has to be started to run multi instances of an api.
  /**
   * @returns {AdSlotAPI} - API to work with VAST responses.
   */
  get AdSlotAPI() {
    return this.adSlotAPI || (p.debug.info(Kt.NAME + "AdSlotAPI ready"), this.adSlotAPI = new Lr(this.playerFacade, this.config)), this.adSlotAPI;
  }
  /**
   * @returns {AdPlaylistAPI} - API to work with VMAP responses.
   */
  get AdPlaylistAPI() {
    return this.adPlaylistAPI ? (p.debug.info(Kt.NAME + "AdPlaylist active"), this.adPlaylistAPI) : (p.debug.info(Kt.NAME + "AdPlaylist ready"), this.adPlaylistAPI = new Sr(this.playerFacade, this.AdSlotAPI), this.adPlaylistAPI);
  }
};
Kt.NAME = "MainCtlr::";
let br = Kt;
var is = /* @__PURE__ */ ((c) => (c.XHR = "xhr", c.JSONP = "jsonp", c))(is || {});
function qo() {
  var c = window;
  (function(e) {
    var i;
    function r(t) {
      var n = 0;
      return function() {
        return n < t.length ? {
          done: !1,
          value: t[n++]
        } : {
          done: !0
        };
      };
    }
    function s(t) {
      var n = typeof Symbol != "undefined" && Symbol.iterator && t[Symbol.iterator];
      if (n) return n.call(t);
      if (typeof t.length == "number") return {
        next: r(t)
      };
      throw Error(String(t) + " is not an iterable or ArrayLike");
    }
    function l(t) {
      if (!(t instanceof Array)) {
        t = s(t);
        for (var n, o = []; !(n = t.next()).done; ) o.push(n.value);
        t = o;
      }
      return t;
    }
    var h = typeof Object.create == "function" ? Object.create : function(t) {
      function n() {
      }
      return n.prototype = t, new n();
    }, m = typeof Object.defineProperties == "function" ? Object.defineProperty : function(t, n, o) {
      return t == Array.prototype || t == Object.prototype || (t[n] = o.value), t;
    };
    function g(t) {
      t = [(typeof globalThis == "undefined" ? "undefined" : Z(globalThis)) == "object" && globalThis, t, (typeof window == "undefined" ? "undefined" : Z(window)) == "object" && window, (typeof self == "undefined" ? "undefined" : Z(self)) == "object" && self, (typeof global == "undefined" ? "undefined" : Z(global)) == "object" && global];
      for (var n = 0; n < t.length; ++n) {
        var o = t[n];
        if (o && o.Math == Math) return o;
      }
      throw Error("Cannot find global object");
    }
    var y = g(this);
    function L(t, n) {
      if (n) e: {
        var o = y;
        t = t.split(".");
        for (var d = 0; d < t.length - 1; d++) {
          var A = t[d];
          if (!(A in o)) break e;
          o = o[A];
        }
        t = t[t.length - 1], d = o[t], n = n(d), n != d && n != null && m(o, t, {
          configurable: !0,
          writable: !0,
          value: n
        });
      }
    }
    var ie;
    if (typeof Object.setPrototypeOf == "function") ie = Object.setPrototypeOf;
    else {
      var ee;
      e: {
        var Oe = {
          a: !0
        }, Q = {};
        try {
          Q.__proto__ = Oe, ee = Q.a;
          break e;
        } catch (t) {
        }
        ee = !1;
      }
      ie = ee ? function(t, n) {
        if (t.__proto__ = n, t.__proto__ !== n) throw new TypeError(t + " is not extensible");
        return t;
      } : null;
    }
    var z = ie;
    function S(t, n) {
      if (t.prototype = h(n.prototype), t.prototype.constructor = t, z) z(t, n);
      else for (var o in n) if (o != "prototype") if (Object.defineProperties) {
        var d = Object.getOwnPropertyDescriptor(n, o);
        d && Object.defineProperty(t, o, d);
      } else t[o] = n[o];
      t.wa = n.prototype;
    }
    function I() {
      for (var t = Number(this), n = [], o = t; o < arguments.length; o++) n[o - t] = arguments[o];
      return n;
    }
    function x(t, n) {
      return Object.prototype.hasOwnProperty.call(t, n);
    }
    var Y = typeof Object.assign == "function" ? Object.assign : function(t, n) {
      for (var o = 1; o < arguments.length; o++) {
        var d = arguments[o];
        if (d) for (var A in d) x(d, A) && (t[A] = d[A]);
      }
      return t;
    };
    L("Object.assign", function(t) {
      return t || Y;
    }), L("Symbol", function(t) {
      function n(v) {
        if (this instanceof n) throw new TypeError("Symbol is not a constructor");
        return new o(d + (v || "") + "_" + A++, v);
      }
      function o(v, R) {
        this.g = v, m(this, "description", {
          configurable: !0,
          writable: !0,
          value: R
        });
      }
      if (t) return t;
      o.prototype.toString = function() {
        return this.g;
      };
      var d = "jscomp_symbol_" + (1e9 * Math.random() >>> 0) + "_", A = 0;
      return n;
    }), L("Symbol.iterator", function(t) {
      if (t) return t;
      t = Symbol("Symbol.iterator");
      for (var n = "Array Int8Array Uint8Array Uint8ClampedArray Int16Array Uint16Array Int32Array Uint32Array Float32Array Float64Array".split(" "), o = 0; o < n.length; o++) {
        var d = y[n[o]];
        typeof d == "function" && typeof d.prototype[t] != "function" && m(d.prototype, t, {
          configurable: !0,
          writable: !0,
          value: function() {
            return W(r(this));
          }
        });
      }
      return t;
    });
    function W(t) {
      return t = {
        next: t
      }, t[Symbol.iterator] = function() {
        return this;
      }, t;
    }
    L("WeakMap", function(t) {
      function n(_) {
        if (this.g = (T += Math.random() + 1).toString(), _) {
          _ = s(_);
          for (var M; !(M = _.next()).done; ) M = M.value, this.set(M[0], M[1]);
        }
      }
      function o() {
      }
      function d(_) {
        var M = Z(_);
        return M === "object" && _ !== null || M === "function";
      }
      function A(_) {
        if (!x(_, R)) {
          var M = new o();
          m(_, R, {
            value: M
          });
        }
      }
      function v(_) {
        var M = Object[_];
        M && (Object[_] = function(H) {
          return H instanceof o ? H : (Object.isExtensible(H) && A(H), M(H));
        });
      }
      if (function() {
        if (!t || !Object.seal) return !1;
        try {
          var _ = Object.seal({}), M = Object.seal({}), H = new t([[_, 2], [M, 3]]);
          return H.get(_) != 2 || H.get(M) != 3 ? !1 : (H.delete(_), H.set(M, 4), !H.has(_) && H.get(M) == 4);
        } catch (Ee) {
          return !1;
        }
      }()) return t;
      var R = "$jscomp_hidden_" + Math.random();
      v("freeze"), v("preventExtensions"), v("seal");
      var T = 0;
      return n.prototype.set = function(_, M) {
        if (!d(_)) throw Error("Invalid WeakMap key");
        if (A(_), !x(_, R)) throw Error("WeakMap key fail: " + _);
        return _[R][this.g] = M, this;
      }, n.prototype.get = function(_) {
        return d(_) && x(_, R) ? _[R][this.g] : void 0;
      }, n.prototype.has = function(_) {
        return d(_) && x(_, R) && x(_[R], this.g);
      }, n.prototype.delete = function(_) {
        return d(_) && x(_, R) && x(_[R], this.g) ? delete _[R][this.g] : !1;
      }, n;
    }), L("Map", function(t) {
      function n() {
        var T = {};
        return T.L = T.next = T.head = T;
      }
      function o(T, _) {
        var M = T.g;
        return W(function() {
          if (M) {
            for (; M.head != T.g; ) M = M.L;
            for (; M.next != M.head; ) return M = M.next, {
              done: !1,
              value: _(M)
            };
            M = null;
          }
          return {
            done: !0,
            value: void 0
          };
        });
      }
      function d(T, _) {
        var M = _ && Z(_);
        M == "object" || M == "function" ? v.has(_) ? M = v.get(_) : (M = "" + ++R, v.set(_, M)) : M = "p_" + _;
        var H = T.h[M];
        if (H && x(T.h, M)) for (T = 0; T < H.length; T++) {
          var Ee = H[T];
          if (_ !== _ && Ee.key !== Ee.key || _ === Ee.key) return {
            id: M,
            list: H,
            index: T,
            A: Ee
          };
        }
        return {
          id: M,
          list: H,
          index: -1,
          A: void 0
        };
      }
      function A(T) {
        if (this.h = {}, this.g = n(), this.size = 0, T) {
          T = s(T);
          for (var _; !(_ = T.next()).done; ) _ = _.value, this.set(_[0], _[1]);
        }
      }
      if (function() {
        if (!t || typeof t != "function" || !t.prototype.entries || typeof Object.seal != "function") return !1;
        try {
          var T = Object.seal({
            x: 4
          }), _ = new t(s([[T, "s"]]));
          if (_.get(T) != "s" || _.size != 1 || _.get({
            x: 4
          }) || _.set({
            x: 4
          }, "t") != _ || _.size != 2) return !1;
          var M = _.entries(), H = M.next();
          return H.done || H.value[0] != T || H.value[1] != "s" ? !1 : (H = M.next(), !(H.done || H.value[0].x != 4 || H.value[1] != "t" || !M.next().done));
        } catch (Ee) {
          return !1;
        }
      }()) return t;
      var v = /* @__PURE__ */ new WeakMap();
      A.prototype.set = function(T, _) {
        T = T === 0 ? 0 : T;
        var M = d(this, T);
        return M.list || (M.list = this.h[M.id] = []), M.A ? M.A.value = _ : (M.A = {
          next: this.g,
          L: this.g.L,
          head: this.g,
          key: T,
          value: _
        }, M.list.push(M.A), this.g.L.next = M.A, this.g.L = M.A, this.size++), this;
      }, A.prototype.delete = function(T) {
        return T = d(this, T), T.A && T.list ? (T.list.splice(T.index, 1), T.list.length || delete this.h[T.id], T.A.L.next = T.A.next, T.A.next.L = T.A.L, T.A.head = null, this.size--, !0) : !1;
      }, A.prototype.clear = function() {
        this.h = {}, this.g = this.g.L = n(), this.size = 0;
      }, A.prototype.has = function(T) {
        return !!d(this, T).A;
      }, A.prototype.get = function(T) {
        return (T = d(this, T).A) && T.value;
      }, A.prototype.entries = function() {
        return o(this, function(T) {
          return [T.key, T.value];
        });
      }, A.prototype.keys = function() {
        return o(this, function(T) {
          return T.key;
        });
      }, A.prototype.values = function() {
        return o(this, function(T) {
          return T.value;
        });
      }, A.prototype.forEach = function(T, _) {
        for (var M = this.entries(), H; !(H = M.next()).done; ) H = H.value, T.call(_, H[1], H[0], this);
      }, A.prototype[Symbol.iterator] = A.prototype.entries;
      var R = 0;
      return A;
    }), L("Object.values", function(t) {
      return t || function(n) {
        var o = [], d;
        for (d in n) x(n, d) && o.push(n[d]);
        return o;
      };
    });
    function J(t, n) {
      t instanceof String && (t += "");
      var o = 0, d = !1, A = {
        next: function() {
          if (!d && o < t.length) {
            var R = o++;
            return {
              value: n(R, t[R]),
              done: !1
            };
          }
          return d = !0, {
            done: !0,
            value: void 0
          };
        }
      };
      return A[Symbol.iterator] = function() {
        return A;
      }, A;
    }
    L("Array.prototype.keys", function(t) {
      return t || function() {
        return J(this, function(n) {
          return n;
        });
      };
    }), L("Set", function(t) {
      function n(o) {
        if (this.g = /* @__PURE__ */ new Map(), o) {
          o = s(o);
          for (var d; !(d = o.next()).done; ) this.add(d.value);
        }
        this.size = this.g.size;
      }
      return function() {
        if (!t || typeof t != "function" || !t.prototype.entries || typeof Object.seal != "function") return !1;
        try {
          var o = Object.seal({
            x: 4
          }), d = new t(s([o]));
          if (!d.has(o) || d.size != 1 || d.add(o) != d || d.size != 1 || d.add({
            x: 4
          }) != d || d.size != 2) return !1;
          var A = d.entries(), v = A.next();
          return v.done || v.value[0] != o || v.value[1] != o ? !1 : (v = A.next(), v.done || v.value[0] == o || v.value[0].x != 4 || v.value[1] != v.value[0] ? !1 : A.next().done);
        } catch (R) {
          return !1;
        }
      }() ? t : (n.prototype.add = function(o) {
        return o = o === 0 ? 0 : o, this.g.set(o, o), this.size = this.g.size, this;
      }, n.prototype.delete = function(o) {
        return o = this.g.delete(o), this.size = this.g.size, o;
      }, n.prototype.clear = function() {
        this.g.clear(), this.size = 0;
      }, n.prototype.has = function(o) {
        return this.g.has(o);
      }, n.prototype.entries = function() {
        return this.g.entries();
      }, n.prototype.values = function() {
        return this.g.values();
      }, n.prototype.keys = n.prototype.values, n.prototype[Symbol.iterator] = n.prototype.values, n.prototype.forEach = function(o, d) {
        var A = this;
        this.g.forEach(function(v) {
          return o.call(d, v, v, A);
        });
      }, n);
    }), L("Object.is", function(t) {
      return t || function(n, o) {
        return n === o ? n !== 0 || 1 / n === 1 / o : n !== n && o !== o;
      };
    }), L("Array.prototype.includes", function(t) {
      return t || function(n, o) {
        var d = this;
        d instanceof String && (d = String(d));
        var A = d.length;
        for (o = o || 0, 0 > o && (o = Math.max(o + A, 0)); o < A; o++) {
          var v = d[o];
          if (v === n || Object.is(v, n)) return !0;
        }
        return !1;
      };
    }), L("String.prototype.includes", function(t) {
      return t || function(n, o) {
        if (this == null) throw new TypeError("The 'this' value for String.prototype.includes must not be null or undefined");
        if (n instanceof RegExp) throw new TypeError("First argument to String.prototype.includes must not be a regular expression");
        return this.indexOf(n, o || 0) !== -1;
      };
    }), L("Array.prototype.values", function(t) {
      return t || function() {
        return J(this, function(n, o) {
          return o;
        });
      };
    });
    var U = {
      na: "loaded",
      ta: "start",
      ka: "firstQuartile",
      oa: "midpoint",
      ua: "thirdQuartile",
      ia: "complete",
      pa: "pause",
      ra: "resume",
      ha: "bufferStart",
      ga: "bufferFinish",
      sa: "skipped",
      va: "volumeChange",
      qa: "playerStateChange",
      fa: "adUserInteraction"
    }, D = {
      la: "full",
      ja: "domain",
      ma: "limited"
    };
    function N(t, n) {
      this.x = t.x != null ? t.x : t.left, this.y = t.y != null ? t.y : t.top, this.width = t.width, this.height = t.height, this.J = this.x + this.width, this.K = this.y + this.height, this.H = t.H || void 0, this.V = t.V || [], this.h = t.friendlyObstructionClass || void 0, this.i = t.friendlyObstructionPurpose || void 0, this.j = t.friendlyObstructionReason || void 0, this.P = t.P !== void 0 ? t.P === !0 : !0, this.m = t.hasWindowFocus !== void 0 ? t.hasWindowFocus === !0 : !0, this.D = t.D || void 0, this.aa = t.aa || void 0, this.W = t.W === "true" || t.W === !0 || !1, this.N = t.N || [], this.R = t.R || !1, this.g = n;
    }
    function P(t) {
      var n = {};
      return n.width = t.width, n.height = t.height, n;
    }
    function $(t) {
      var n = {};
      return Ie({}, P(t), (n.x = t.x, n.y = t.y, n));
    }
    function re(t) {
      var n = $(t), o = {};
      return Ie({}, n, (o.endX = t.J, o.endY = t.K, o));
    }
    N.prototype.T = function(t) {
      if (t == null) return !1;
      t = $(t);
      var n = t.y, o = t.width, d = t.height;
      return this.x === t.x && this.y === n && this.width === o && this.height === d;
    };
    function De(t) {
      return t.width * t.height;
    }
    function Le(t) {
      return t.width === 0 || t.height === 0;
    }
    function ft(t, n) {
      t = $(t);
      for (var o = [], d = [], A = 0; A < n.length; A++) {
        var v = $(n[A]);
        v = kt(t, v), ze(o, v.x), ze(o, v.J), ze(d, v.y), ze(d, v.K);
      }
      return o = o.sort(function(R, T) {
        return R - T;
      }), d = d.sort(function(R, T) {
        return R - T;
      }), {
        da: o,
        ea: d
      };
    }
    function kt(t, n) {
      return {
        x: Math.max(t.x, n.x),
        y: Math.max(t.y, n.y),
        J: Math.min(t.x + t.width, n.x + n.width),
        K: Math.min(t.y + t.height, n.y + n.height)
      };
    }
    function ze(t, n) {
      t.indexOf(n) === -1 && t.push(n);
    }
    function dt() {
      this.h = this.g = this.i = this.l = void 0, this.u = 0, this.o = [], this.v = [], this.B = 0, this.s = [], this.j = [], this.m = [];
    }
    dt.prototype.T = function(t) {
      return t == null ? !1 : JSON.stringify(He(this)) === JSON.stringify(He(t));
    };
    function He(t) {
      var n = [], o = [], d = {
        viewport: t.l,
        adView: {
          percentageInView: t.u,
          pixelsInView: t.B,
          reasons: t.m
        },
        declaredFriendlyObstructions: t.o.length
      };
      if (t.g !== void 0) {
        d.adView.geometry = $(t.g), d.adView.geometry.pixels = De(t.g), d.adView.onScreenGeometry = $(t.h), d.adView.onScreenGeometry.pixels = mt(t);
        for (var A = 0; A < t.j.length; A++) n.push($(t.j[A]));
        for (A = 0; A < t.v.length; A++) {
          var v = t.v[A], R = v, T = {};
          R.h && (T.obstructionClass = R.h), R.i && (T.obstructionPurpose = R.i), R.j && (T.obstructionReason = R.j), v = kt(t.g, v), o.push(Ie({}, {
            x: v.x,
            y: v.y,
            width: v.J - v.x,
            height: v.K - v.y
          }, T));
        }
        d.adView.onScreenGeometry.obstructions = n, d.adView.onScreenGeometry.friendlyObstructions = o;
      }
      return d;
    }
    function Nt(t, n) {
      n = P(n), t.l = {}, t.l.width = n.width, t.l.height = n.height, t.i = {}, t.i.x = 0, t.i.y = 0, t.i.width = n.width, t.i.height = n.height, t.i.endX = n.width, t.i.endY = n.height;
    }
    function et() {
      return {
        x: 0,
        y: 0,
        endX: 0,
        endY: 0,
        width: 0,
        height: 0
      };
    }
    function At(t, n) {
      var o = {};
      return o.x = Math.max(t.x, n.x), o.y = Math.max(t.y, n.y), o.endX = Math.min(t.endX, n.endX), o.endY = Math.min(t.endY, n.endY), o.width = Math.max(0, o.endX - o.x), o.height = Math.max(0, o.endY - o.y), o;
    }
    function ut(t, n) {
      return 0.01 < n.width - t.width || 0.01 < n.height - t.height;
    }
    function We(t) {
      if (t.m.indexOf("backgrounded") !== -1) t.u = 0, t.B = 0;
      else {
        var n = De(t.g);
        if (n !== 0) {
          var o = mt(t);
          t.u = Math.round(o / n * 100), t.B = o;
        }
      }
    }
    function Ut(t, n) {
      if (Le(n) || !t.h) n = !1;
      else {
        var o = re(t.h), d = o.y, A = o.endX;
        t = o.endY;
        var v = n.J;
        o = o.x, (v = v < o || 0.01 > Math.abs(v - o)) || (v = n.x, v = v > A || 0.01 > Math.abs(v - A)), (A = v) || (A = n.K, A = A < d || 0.01 > Math.abs(A - d)), (d = A) || (n = n.y, d = n > t || 0.01 > Math.abs(n - t)), n = !d;
      }
      return n;
    }
    function Se(t, n) {
      for (var o = !1, d = 0; d < t.m.length; d++) t.m[d] === n && (o = !0);
      o || t.m.push(n);
    }
    function mt(t) {
      var n = Math, o = n.max, d = De(t.h), A = t.j, v = 0;
      if (0 < A.length) {
        var R = ft(t.h, A);
        t = R.da, R = R.ea;
        for (var T = 0; T < t.length - 1; T++) for (var _ = (t[T] + (t[T] + 1)) / 2, M = t[T + 1] - t[T], H = 0; H < R.length - 1; H++) {
          for (var Ee = (R[H] + (R[H] + 1)) / 2, nt = R[H + 1] - R[H], ht = !1, Lt = 0; Lt < A.length; Lt++) {
            var $e = $(A[Lt]);
            if ($e.x < _ && $e.x + $e.width > _ && $e.y < Ee && $e.y + $e.height > Ee) {
              ht = !0;
              break;
            }
          }
          ht && (v += Math.round(M) * Math.round(nt));
        }
      }
      return o.call(n, 0, d - v);
    }
    function Ue() {
    }
    function Re() {
    }
    function be(t, n, o, d) {
      var A = n.R ? !0 : n.H === d;
      if (A) {
        o.g = n;
        var v = re(o.g);
        t = At(o.i, v);
        var R = o.g;
        R.D === "notAttached" || R.D === "noWindowFocus" || R.D === "noAdView" ? (Se(o, "notFound"), o.h = new N(et(), !1)) : (R = o.g, R.D === "viewInvisible" || R.D === "viewGone" || R.D === "viewNotVisible" || R.D === "viewAlphaZero" || R.D === "viewHidden" || o.g.D !== void 0 || Le(o.g) ? (Se(o, "hidden"), o.h = new N(et(), !1)) : (o.g.W && Se(o, "pictureInPicture"), o.g.m || (Se(o, "backgrounded"), Se(o, "noWindowFocus")), ut(t, v) && Se(o, "clipped"), o.h = new N(t, !1)));
      } else if (v = !0, n.g && (v = n.V.indexOf(d) !== -1 ? !1 : n.P === !1), v) {
        R = n.N;
        for (var T = 0; T < R.length; T++) v = o.g !== void 0, be(t, new N(R[T], v), o, d);
      }
      A || o.g === void 0 || (n.g ? n.V.indexOf(d) !== -1 ? o.o.push(n) : o.s.push(n) : (A = re(n), d = re(o.h), $(o.h), !Le(o.h) && n.P && (n = At(d, A), ut(n, d) && (Se(o, "clipped"), o.h = new N(n, !1)))));
    }
    function Xe() {
      this.g = /* @__PURE__ */ new Map(), this.h = null;
    }
    function V() {
      return B || (B = new Xe()), B;
    }
    var B = null;
    function G(t, n) {
      this.y = this.x = 0, this.width = t, this.height = n;
    }
    function Ae() {
      this.H = null, this.i = {
        apiVersion: "1.0",
        accessMode: "limited",
        environment: "web",
        omidJsInfo: {
          omidImplementer: "omsdk",
          serviceVersion: "1.5.6-iab144"
        },
        adSessionType: "html",
        supports: ["clid", "vlid"]
      }, this.C = null, this.B = "foregrounded", this.s = this.j = "none", this.o = this.l = this.m = this.G = this.h = this.g = this.M = this.v = null, this.u = /* @__PURE__ */ new Map();
    }
    var le = function() {
      if (typeof e != "undefined" && e) return e;
      if (typeof global != "undefined" && global) return global;
      if (typeof window != "undefined" && window) return window;
      if (typeof globalThis != "undefined" && globalThis) return globalThis;
      var t = Function("return this")();
      if (t) return t;
      throw Error("Could not determine global object context.");
    }();
    function Et(t) {
      if (t === le) return !1;
      try {
        if (typeof t.location.hostname == "undefined") return !0;
      } catch (n) {
        return !0;
      }
      return !1;
    }
    function Ct() {
      var t = e;
      if (t == null || typeof t.top == "undefined" || t.top == null) return null;
      try {
        var n = t.top;
        return Et(n) ? null : n.location.href;
      } catch (o) {
        return null;
      }
    }
    function fi(t, n) {
      this.g = t, this.h = n;
    }
    y.Object.defineProperties(fi.prototype, {
      event: {
        configurable: !0,
        enumerable: !0,
        get: function() {
          return this.g;
        }
      },
      origin: {
        configurable: !0,
        enumerable: !0,
        get: function() {
          return this.h;
        }
      }
    });
    function qe() {
      var t = I.apply(0, arguments);
      ne(function() {
        throw new (Function.prototype.bind.apply(Error, [null, "Could not complete the test successfully - "].concat(l(t))))();
      }, function() {
        return console.error.apply(console, l(t));
      });
    }
    function Ai() {
      var t = I.apply(0, arguments);
      ne(function() {
      }, function() {
        return console.error.apply(console, l(t));
      });
    }
    function ne(t, n) {
      typeof jasmine != "undefined" && jasmine ? t() : typeof console != "undefined" && console && console.error && n();
    }
    function Jt(t) {
      this.g = t, this.m = [], this.i = [], this.j = [], this.l = [], this.o = {};
    }
    function Zt(t, n) {
      if (t.g !== void 0 && t.g.H && Ei(t, n) !== !1) {
        var o = n.event;
        t.j.filter(function(d) {
          return d.type === o.type;
        }).forEach(function(d) {
          t.h(d.I, o);
        });
      }
    }
    function ye(t, n) {
      t.m.push(n), Zt(t, n);
    }
    function mi(t, n, o) {
      t.g !== void 0 && t.g.H && t.m.filter(function(d) {
        return d.event.type === n && Ei(t, d);
      }).map(function(d) {
        return d.event;
      }).forEach(function(d) {
        t.h(o.I, d);
      });
    }
    function Ei(t, n) {
      var o = n.event.type, d = Object.values(U).indexOf(o) !== -1 && o !== "volumeChange";
      return o === "impression" || o === "loaded" && t.g.h ? n.origin === t.g.s : d ? n.origin === t.g.j : !0;
    }
    function Fe(t, n, o) {
      Object.keys(U).forEach(function(d) {
        d = U[d];
        var A = {
          type: d,
          U: o,
          I: n
        };
        t.j.push(A), mi(t, d, A);
      });
    }
    function gi(t, n, o, d) {
      var A = {
        ba: o,
        U: d,
        I: n
      };
      t.l.push(A), t.i.forEach(function(v) {
        var R = j(v);
        v.event.type === "sessionStart" && u(t, R, A), t.h(A.I, R);
      });
    }
    function Ft(t, n, o) {
      var d = F(t, "sessionError", "native", {
        errorType: n,
        message: o
      });
      t.i.push(d), t.l.forEach(function(A) {
        t.h(A.I, d.event);
      });
    }
    function a(t, n) {
      if (t.o = Ie(t.o, n), n = t.g.i, n !== void 0) {
        n = Ie({}, X(tt(t, b(t, {
          context: n
        }), !0)), {
          supportsLoadedEvent: !!t.g.h || t.g.g == "video"
        }), Ie(n, {
          pageUrl: Ct(),
          contentUrl: t.g.C
        });
        var o = F(t, "sessionStart", "native", n);
        t.i.push(o), t.l.forEach(function(d) {
          var A = j(o);
          u(t, A, d), t.h(d.I, A);
        }, t), O(t);
      }
    }
    function u(t, n, o) {
      o.ba && (n.data.verificationParameters = t.o[o.ba]), o.U && (o = t.g.u.get(o.U)) && (n.data.verificationParameters = o.verificationParameters, n.data.context.accessMode = o.accessMode, o.accessMode === "full" && (t.g.l && (n.data.context.videoElement = t.g.l), t.g.m && (n.data.context.slotElement = t.g.m)));
    }
    function E(t) {
      var n = F(t, "sessionFinish", "native");
      t.i.push(n), t.l.forEach(function(o) {
        t.h(o.I, n.event);
      });
    }
    Jt.prototype.h = function(t) {
      var n = I.apply(1, arguments);
      try {
        t.apply(null, l(n));
      } catch (o) {
        Ai(o);
      }
    };
    function O(t) {
      var n = t.m.filter(function(v) {
        return Object.values(U).indexOf(v.event.type) !== -1 && t.g.g == "video" && v.origin === t.g.j || v.event.type == "loaded" && t.g.g == "display" && v.origin === t.g.s;
      }).map(function(v) {
        return v.event;
      }), o = t.g.H || "", d = {};
      n = s(n);
      for (var A = n.next(); !A.done; d = {
        F: d.F
      }, A = n.next()) {
        if (d.F = A.value, d.F.adSessionId || (d.F.adSessionId = o), d.F.type == "loaded") {
          if (!t.g.h && t.g.g == "display") continue;
          d.F.data = tt(t, b(t, d.F.data));
        }
        t.j.filter(/* @__PURE__ */ function(v) {
          return function(R) {
            return R.type === v.F.type;
          };
        }(d)).forEach(/* @__PURE__ */ function(v) {
          return function(R) {
            return R.I(v.F);
          };
        }(d));
      }
    }
    function C(t, n) {
      e: {
        n = new Set(n), t = s(t.m.concat(t.i));
        for (var o = t.next(); !o.done; o = t.next()) if (o = o.value, n.has(o.event.type) && o.origin != "javascript") {
          n = !0;
          break e;
        }
        n = !1;
      }
      return n ? (qe("Event owner cannot be registered after its events have already been published."), !1) : !0;
    }
    function se(t) {
      var n = t.g.s;
      return n != "none" && n != "javascript" ? (qe("Impression event is owned by " + (t.g.s + ", not javascript.")), !1) : !0;
    }
    function oe(t) {
      var n = t.g.j;
      return n != "none" && n != "javascript" ? (qe("Media events are owned by " + (t.g.j + ", not javascript.")), !1) : !0;
    }
    function tt(t, n, o) {
      return o = o === void 0 ? !1 : o, n = Ie({}, n), t.g.g && Ie(n, {
        mediaType: t.g.g
      }), t.g.h && (o || t.g.h !== "definedByJavaScript") && Ie(n, {
        creativeType: t.g.h
      }), n;
    }
    function X(t) {
      var n = V().h;
      return n ? Ie({}, t, {
        lastActivity: n
      }) : t;
    }
    function b(t, n) {
      return t.g.G ? Ie({}, n, {
        impressionType: t.g.G
      }) : n;
    }
    function F(t, n, o, d) {
      return new fi({
        adSessionId: t.g.H || "",
        timestamp: (/* @__PURE__ */ new Date()).getTime(),
        type: n,
        data: d
      }, o);
    }
    function j(t) {
      t = t.event;
      var n = t.data ? Ie({}, t.data) : void 0;
      return t.type === "sessionStart" && (n.context = Ie({}, n.context)), {
        adSessionId: t.adSessionId,
        timestamp: t.timestamp,
        type: t.type,
        data: n
      };
    }
    function it(t, n, o) {
      n !== "start" && n !== "volumeChange" || (o && o.deviceVolume) != null || (o.deviceVolume = t.g.v);
    }
    function _t(t, n, o) {
      if (o && (n === "start" || n === "volumeChange")) {
        n = o.videoPlayerVolume;
        var d = o.mediaPlayerVolume;
        n != null ? (Ie(o, {
          mediaPlayerVolume: n
        }), t.g.M = n) : d != null && (Ie(o, {
          videoPlayerVolume: d
        }), t.g.M = d);
      }
    }
    function rs(t, n) {
      this.h = t, this.g = n;
    }
    function Xi() {
      var t;
      this.g = t = t === void 0 ? e : t;
    }
    Xi.prototype.setInterval = function(t, n) {
      return vi(this, "setInterval")(t, n);
    }, Xi.prototype.clearInterval = function(t) {
      vi(this, "clearInterval")(t);
    };
    function ns(t, n) {
      vi(t, "clearTimeout")(n);
    }
    function vi(t, n) {
      return t.g && t.g[n] ? t.g[n] : qi(t, n);
    }
    function ss(t, n, o, d) {
      if (t.g.document && t.g.document.body) {
        var A = t.g.document.createElement("img");
        A.width = 1, A.height = 1, A.style.display = "none", A.src = n, o && A.addEventListener("load", function() {
          return o();
        }), d && A.addEventListener("error", function() {
          return d();
        }), t.g.document.body.appendChild(A);
      } else qi(t, "sendUrl")(n, o, d);
    }
    function qi(t, n) {
      if (t.g && t.g.omidNative && t.g.omidNative[n]) return t.g.omidNative[n].bind(t.g.omidNative);
      throw Error('Native interface method "' + n + '" not found.');
    }
    function Fr(t) {
      return !(!t || !t.tagName || t.tagName.toLowerCase() !== "iframe");
    }
    function rt(t, n, o, d, A) {
      this.j = t, this.ca = n, this.X = o, this.i = d, this.$ = A, this.h = null, this.g = this.m = this.M = void 0, this.Z = !0, this.o = void 0, Si(this);
    }
    function Si(t) {
      if (!t.h) {
        var n;
        e: {
          if ((n = t.j.document) && n.getElementsByClassName && (n = n.getElementsByClassName("omid-element"))) {
            if (n.length == 1) {
              n = n[0];
              break e;
            }
            1 < n.length && t.Z && (Ft(t.X, "generic", "More than one element with 'omid-element' class name."), t.Z = !1);
          }
          n = null;
        }
        if (n && n.tagName && n.tagName.toLowerCase() === "video") t.i.l = n;
        else if (n && n.tagName) t.i.m = n;
        else return;
        yi(t);
      }
    }
    function yi(t) {
      t.i.l ? (t.h = t.i.l, t.s()) : t.i.m && (t.h = t.i.m, Fr(t.h) ? t.i.o && t.s() : t.s());
    }
    function ei(t) {
      t.g && (Fr(t.h) ? t.i.o && (t.S(), $r(t)) : (t.S(), $r(t)));
    }
    rt.prototype.v = function() {
      this.o && (this.j.document.removeEventListener("visibilitychange", this.o), this.o = void 0);
    }, rt.prototype.s = function() {
      var t = this;
      this.o || (this.o = function() {
        t.i.B = t.j.document.hidden ? "backgrounded" : "foregrounded", ei(t);
      }, this.j.document.addEventListener("visibilitychange", this.o), this.o());
    };
    function $r(t) {
      if (t.M) {
        t.i.S = t.M, t = t.ca;
        var n = t.g.S, o = t.g.O;
        if (n && !n.T(o)) {
          o = He(n);
          var d = t.h;
          d.g.h != "audio" && ye(d, F(d, "geometryChange", "native", o)), t.g.O = n;
        }
      }
    }
    function jr(t) {
      if (t.g && t.i.o) {
        var n = new N(t.i.o, !1), o = t.g.x;
        return t = t.g.y, n.x += o, n.y += t, n.J += o, n.K += t, n.P = !0, n;
      }
    }
    function $t(t, n, o, d, A, v) {
      rt.call(this, t, o, d, A, v), this.u = n, this.l = void 0;
    }
    S($t, rt), $t.prototype.v = function() {
      this.l !== void 0 && (this.$.clearInterval(this.l), this.l = void 0), rt.prototype.v.call(this);
    }, $t.prototype.s = function() {
      var t = this;
      rt.prototype.s.call(this), this.h == null ? this.l = void 0 : this.l === void 0 && (this.l = this.$.setInterval(function() {
        return Br(t);
      }, 200), Br(this));
    }, $t.prototype.S = function() {
      if (this.m) {
        var t = jr(this);
        if (t) {
          this.g.R = !1, t.R = !0;
          for (var n = !1, o = 0; o < this.g.N.length; o++) if (this.g.N[o].R) {
            this.g.N[o] = t, n = !0;
            break;
          }
          n || this.g.N.push(t);
        } else this.g.R = !0;
        n = this.u, o = this.i.B;
        var d = this.i.H, A = this.O();
        t = new dt();
        var v = new N(this.m, !1);
        if (Nt(t, v), be(n, v, t, d), A)
          if (v.aa) Se(t, "backgrounded"), Se(t, "noOutputDevice");
          else if (o === "backgrounded") Se(t, "backgrounded");
          else if (t.g !== void 0) {
            for (n = 0; n < t.o.length; n++) Ut(t, t.o[n]) && t.v.push(t.o[n]);
            for (n = 0; n < t.s.length; n++) {
              if (o = Ut(t, t.s[n])) {
                e: {
                  for (o = t.s[n], d = 0; d < t.j.length; d++) if (t.j[d].T(o)) {
                    o = !0;
                    break e;
                  }
                  o = !1;
                }
                o = !o;
              }
              o && (Se(t, "obstructed"), t.j.push(t.s[n]));
            }
            We(t);
          } else Se(t, "notFound");
        else t.m = ["unmeasurable"], t.l = void 0, t.u = 0, t.j = [], t.g && (n = t.g, o = {}, n = new N((o.x = 0, o.y = 0, o.width = n.width, o.height = n.height, o), n.g), t.g = n), t.h = et();
        this.M = t;
      }
    }, $t.prototype.O = function() {
      return Hr(this);
    };
    function Br(t) {
      if (t.l !== void 0) {
        if (Hr(t)) {
          var n = t.j.top;
          n = new N(new G(n.innerWidth, n.innerHeight), !1);
        } else n = new N(new G(0, 0), !1);
        var o = t.h.getBoundingClientRect();
        (o.x == null || isNaN(o.x)) && (o.x = o.left), (o.y == null || isNaN(o.y)) && (o.y = o.top), o = new N(o, !1), n.T(t.m) && o.T(t.g) || (t.g = o, t.g.P = !0, t.m = n, t.m.N.push(t.g), ei(t));
      }
    }
    function Hr(t) {
      try {
        var n = t.j.top;
        return 0 <= n.innerHeight && 0 <= n.innerWidth;
      } catch (o) {
      }
      return !1;
    }
    function jt(t, n, o, d, A, v) {
      rt.call(this, t, o, d, A, v), this.C = this.u = this.B = this.l = void 0, this.Y = !1, this.G = void 0;
    }
    S(jt, rt), jt.prototype.v = function() {
      this.l && this.l.disconnect(), Wr(this), rt.prototype.v.call(this);
    }, jt.prototype.s = function() {
      if (rt.prototype.s.call(this), this.h && (this.l || (this.l = os(this)), Xr(this), qr(this.h) && as(this), this.i.B === "backgrounded")) {
        var t = Ii(new G(0, 0));
        this.G = this.g = this.m = t, ei(this);
      }
    }, jt.prototype.S = function() {
      if (this.g && this.G) {
        var t = jr(this);
        if (t) {
          var n = t, o = this.G, d = Math.max(t.x, o.x), A = Math.max(t.y, o.y), v = Math.min(t.J, o.J);
          t = Math.min(t.K, o.K), v <= d || t <= A ? d = null : (o = {}, d = new N((o.x = d, o.y = A, o.width = Math.abs(v - d), o.height = Math.abs(t - A), o), !1)), d || (d = new N({
            x: 0,
            y: 0,
            width: 0,
            height: 0
          }, !1));
        } else n = this.g, d = this.G;
        A = new dt(), this.m && Nt(A, this.m), (v = this.i.B == "backgrounded") && Se(A, "backgrounded"), A.g = n, A.h = d, We(A), this.Y ? !v && Le(A.g) ? Se(A, "hidden") : v || A.u === 100 || Se(A, "clipped") : Se(A, "viewport"), this.M = A;
      }
    }, jt.prototype.O = function() {
      return !0;
    };
    function Wr(t) {
      t.B && (t.B.disconnect(), t.B = void 0), t.u && (t.u.disconnect(), t.u = void 0), t.C && ((0, t.j.removeEventListener)("resize", t.C), t.C = void 0);
    }
    function Xr(t) {
      t.l && t.h && (t.l.unobserve(t.h), t.l.observe(t.h));
    }
    function qr(t) {
      return t = t.getBoundingClientRect(), t.width == 0 || t.height == 0;
    }
    function os(t) {
      return new t.j.IntersectionObserver(function(n) {
        try {
          if (n.length) {
            for (var o, d = n[0], A = 1; A < n.length; A++) n[A].time > d.time && (d = n[A]);
            o = d, t.m = Ii(o.rootBounds), t.g = Ii(o.boundingClientRect), t.G = Ii(o.intersectionRect), t.Y = !!o.isIntersecting, ei(t);
          }
        } catch (v) {
          t.v(), Ft(t.X, "generic", "Problem handling IntersectionObserver callback: " + v.message);
        }
      }, {
        root: null,
        rootMargin: "0px",
        threshold: [0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1]
      });
    }
    function as(t) {
      t.j.ResizeObserver ? t.B || (t.B = ls(t, function() {
        return Yi(t);
      }), t.B.observe(t.h)) : (t.C || (t.C = function() {
        return Yi(t);
      }, (0, t.j.addEventListener)("resize", t.C)), t.u || (t.u = new MutationObserver(function() {
        return Yi(t);
      }), t.u.observe(t.h, {
        childList: !1,
        attributes: !0,
        subtree: !1
      })));
    }
    function Yi(t) {
      t.h && !qr(t.h) && (Xr(t), Wr(t));
    }
    function ls(t, n) {
      return new t.j.ResizeObserver(n);
    }
    function Ii(t) {
      if (t && t.x !== null && t.y !== null && t.width !== null && t.height !== null) return new N(t, !1);
    }
    function Gi(t) {
      if (Z(t) === "object" && Z(t.webOSSystem) === "object") return t.webOSSystem;
    }
    function Oi(t) {
      return Z(Gi(t)) === "object";
    }
    function Bt(t) {
      if (Z(t) === "object" && Z(t.tizen) === "object") return t.tizen;
    }
    function Dt(t) {
      return Z(Bt(t)) === "object";
    }
    function ds(t, n) {
      this.h = t, this.g = n;
    }
    function Ki() {
      return "xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g, function(t) {
        var n = 16 * Math.random() | 0;
        return t === "y" ? (n & 3 | 8).toString(16) : n.toString(16);
      });
    }
    function us(t, n) {
      var o = o === void 0 ? le : o;
      this.i = t, this.g = o, this.j = n, this.h = [];
    }
    function Yr(t) {
      if (!t.g || !t.g.document) throw Error("OMID Service Script is not running within a window.");
      var n = t.h;
      t.h = [], n.forEach(function(o) {
        try {
          var d = o.accessMode, A = typeof d == "string" && Object.values(D).indexOf(d) !== -1 ? o.accessMode : null, v = A ? A == "domain" ? "limited" : A : "limited";
          o.accessMode = v;
          e: {
            var R = o.resourceUrl, T = t.g.location.origin;
            try {
              var _ = new URL(R, T);
              break e;
            } catch (nt) {
            }
            try {
              _ = new URL(R);
              break e;
            } catch (nt) {
            }
            _ = null;
          }
          if (d = _) {
            var M = Ki();
            hs(t, M, d, v);
            var H = o.vendorKey, Ee = o.verificationParameters;
            H = H === void 0 ? "" : H, Ee = Ee === void 0 ? "" : Ee, H && typeof H == "string" && H !== "" && Ee && typeof Ee == "string" && Ee !== "" && (t.i.o[H] = Ee), t.j.u.set(M, o);
          }
        } catch (nt) {
          Ai("OMID verification script " + o.resourceUrl + " failed to load: " + nt);
        }
      });
    }
    function hs(t, n, o, d) {
      var A = t.g.document, v = A.createElement("iframe");
      if (v.id = "omid-verification-script-frame-" + n, v.style.display = "none", d == "full") {
        var R = function() {
          var _ = v.contentWindow;
          _.omidVerificationProperties = {
            serviceWindow: t.g,
            injectionSource: "web",
            injectionId: n
          }, _ = _.document;
          var M = _.createElement("script");
          M.src = o.href, _.head.appendChild(M), v.removeEventListener("load", R);
        };
        v.addEventListener("load", R);
      } else d == "limited" && (v.srcdoc = `<html><head>
<script type="text/javascript">window['omidVerificationProperties'] = {
'serviceWindow': window.parent,
'injectionSource': 'web',
'injectionId': '` + (n + `',
};<\/script>
<script type="text/javascript" src="`) + o.href + `"><\/script>
</head><body></body></html>`, v.sandbox = "allow-scripts");
      A.body.appendChild(v), V().g.set(n, v);
    }
    function zi(t, n) {
      var o = window, d = this;
      if (Oi(o)) if (o)
        if (o.WebOSServiceBridge) {
          this.i = t, this.h = n, this.g = new o.WebOSServiceBridge(), this.g.onservicecallback = function(A) {
            try {
              var v = JSON.parse(A);
              if (v && v.errorCode) d.error(A);
              else if (!v) d.error("No object recieved from webOS bridge");
              else if (!Ti(d, A, v, "volumeStatus", "object")) {
                var R = v.volumeStatus;
                Ti(d, A, R, "muteStatus", "boolean") || Ti(d, A, R, "volume", "number") || Ti(d, A, R, "maxVolume", "number") || (0 >= R.maxVolume ? d.error("Invalid max volume status.") : d.i(R.muteStatus ? 0 : R.volume / R.maxVolume));
              }
            } catch (T) {
              d.error(T);
            }
          };
          try {
            this.g.call("luna://com.webos.service.audio/master/getVolume", '{"subscribe":true}');
          } catch (A) {
            this.error(A);
          }
        } else this.h("No WebOSServiceBridge on windowContext");
      else this.h("No window context");
    }
    zi.prototype.stop = function() {
      this.g && this.g.cancel && this.g.cancel(), this.g = null;
    }, zi.prototype.error = function(t) {
      this.stop(), this.h && this.h(t);
    };
    function Ti(t, n, o, d, A) {
      return Z(o[d]) === A ? !1 : (t.error('Unexpected formatting on message from webOS bridge: "' + n + '". Expected "' + d + '" to be of type "' + A + '" but was of type "' + Z(o[d]) + '".'), !0);
    }
    function Gr(t) {
      return Dt(t) ? Z(Bt(t).tvinputdevice) === "object" : !1;
    }
    function Ri(t, n) {
      var o = window, d = this;
      if (o)
        if (this.validate(o)) {
          this.h = n;
          var A = Bt(o).tvaudiocontrol;
          this.g = void 0, n = function() {
            var R = A.isMute() ? 0 : A.getVolume() / 100;
            (d.g === void 0 || d.g != R) && (d.g = R, t(d.g));
          }, n(), this.i = o.setInterval(n, 200), this.j = o;
        } else n("Invalid Tizen window context");
      else n("No window context");
    }
    Ri.prototype.stop = function() {
      this.i !== void 0 && typeof this.j.clearInterval == "function" && this.j.clearInterval(this.i), this.h = this.g = this.i = void 0;
    }, Ri.prototype.validate = function(t) {
      return Dt(t) && Gr(t) && Z(Bt(t).tvaudiocontrol) === "object" && typeof t.setInterval == "function" && typeof t.clearInterval == "function";
    }, Ri.prototype.error = function(t) {
      this.stop(), this.h && this.h(t);
    };
    function Kr(t, n, o, d, A) {
      var v = this;
      this.g = t, this.i = n, this.h = o, this.l = d, this.o = A, this.m = !1, Qi(this, function(R) {
        if (R.type === "sessionStart") {
          v.m = !0;
          try {
            Yr(v.l);
          } catch (T) {
            qe(T.message);
          }
        }
        R.type === "sessionFinish" && (v.m = !1);
      });
    }
    function Qi(t, n, o, d) {
      gi(t.i, n, o, d);
    }
    i = Kr.prototype, i.setSlotElement = function(t) {
      t && t.tagName ? (this.g.m = t, this.h && yi(this.h)) : qe("setSlotElement called with a non-HTMLElement.  It will be ignored.");
    }, i.setElementBounds = function(t) {
      this.g.o = t, this.h && yi(this.h), this.h && ei(this.h);
    }, i.error = function(t, n) {
      Ft(this.i, t, n);
    }, i.injectVerificationScriptResources = function(t) {
      var n = this.l;
      if (n.h.push.apply(n.h, l(t)), this.m) try {
        Yr(this.l);
      } catch (o) {
        qe(o.message);
      }
    }, i.setCreativeType = function(t, n) {
      n = n === void 0 ? null : n, (!this.g.g || this.g.h) && (this.g.h = t, t == "video" || t == "audio" ? this.g.g = "video" : t == "htmlDisplay" || t == "nativeDisplay" ? this.g.g = "display" : t == "definedByJavaScript" && n && (this.g.g = n == "none" ? "display" : "video"));
    }, i.setImpressionType = function(t) {
      (!this.g.g || this.g.h) && (this.g.G = t);
    }, i.setClientInfo = function(t, n, o) {
      var d = this.g.i || {};
      return d.omidJsInfo = Ie({}, d.omidJsInfo, {
        sessionClientVersion: t,
        partnerName: n,
        partnerVersion: o
      }), this.g.i = d, this.g.i.omidJsInfo.serviceVersion;
    };
    function cs(t) {
      if (Dt(window) || Oi(window)) {
        var n = function(A) {
          if (t.g.v !== A && t.i.g.j !== "none" && typeof A == "number" && !isNaN(A)) {
            t.g.v = A;
            var v = t.o, R = v.g.M;
            R != null && (A = v.h, v = {
              mediaPlayerVolume: R,
              deviceVolume: v.g.v
            }, it(A, "volumeChange", v), _t(A, "volumeChange", v), ye(A, F(A, "volumeChange", "native", v)));
          }
        }, o = function(A) {
          qe(A);
        };
        Oi(window) ? t.j = new zi(n, o) : Dt(window) && (t.j = new Ri(n, o));
      }
    }
    function zr(t, n) {
      if (!n) return t.g;
      for (var o = s(t.h.values()), d = o.next(); !d.done; d = o.next()) if (d = d.value, d.g.u.has(n)) return d;
      return t.g;
    }
    function we(t, n) {
      return n == null ? t.g : t.h.get(n) || t.g;
    }
    function Ji(t) {
      var n = new Ae(), o = new Jt(n), d = new Ue(), A = new Re(), v = new rs(o, n);
      t = t.i;
      var R = e;
      return d = R ? R.IntersectionObserver && (R.MutationObserver || R.ResizeObserver) ? new jt(R, d, v, o, n, t) : new $t(R, A, v, o, n, t) : null, new Kr(n, o, d, new us(o, n), new ds(o, n));
    }
    function Ht(t, n, o, d) {
      this.h = t, this.method = n, this.version = o, this.g = d;
    }
    function Qr(t) {
      return !!t && t.omid_message_guid !== void 0 && t.omid_message_method !== void 0 && t.omid_message_version !== void 0 && typeof t.omid_message_guid == "string" && typeof t.omid_message_method == "string" && typeof t.omid_message_version == "string" && (t.omid_message_args === void 0 || t.omid_message_args !== void 0);
    }
    function Jr(t) {
      return new Ht(t.omid_message_guid, t.omid_message_method, t.omid_message_version, t.omid_message_args);
    }
    function Zr(t) {
      var n = {};
      return n = (n.omid_message_guid = t.h, n.omid_message_method = t.method, n.omid_message_version = t.version, n), t.g !== void 0 && (n.omid_message_args = t.g), n;
    }
    function en(t) {
      this.i = t;
    }
    function Wt(t) {
      this.i = t, this.handleExportedMessage = Wt.prototype.j.bind(this);
    }
    S(Wt, en), Wt.prototype.h = function(t, n) {
      if (n = n === void 0 ? this.i : n, !n) throw Error("Message destination must be defined at construction time or when sending the message.");
      n.handleExportedMessage(Zr(t), this);
    }, Wt.prototype.j = function(t, n) {
      Qr(t) && this.g && this.g(Jr(t), n);
    };
    function Ni(t) {
      return Zi(t, "SessionService.");
    }
    function Zi(t, n) {
      return (t = t.match(new RegExp("^" + n + "(.*)"))) && t[1];
    }
    function er(t, n) {
      this.h = t, this.i = n;
    }
    er.prototype.g = function(t) {
      var n = I.apply(1, arguments);
      e: switch (t) {
        case "registerSessionObserver":
          var o = n.slice(1);
          break e;
        default:
          o = n;
      }
      return this.h("SessionService." + t, this.j.bind(this, t, n), o);
    }, er.prototype.j = function(t, n, o) {
      switch (t) {
        case "registerSessionObserver":
          t = s(n).next().value, t(o);
      }
    };
    function ae(t, n) {
      return t.g.bind(t, n);
    }
    function ps(t, n) {
      n = n === void 0 ? le : n, n.omidSessionInterface == null && (t = {
        setSessionClientWindow: t.i,
        setClientInfo: ae(t, "setClientInfo"),
        registerSessionObserver: ae(t, "registerSessionObserver"),
        startAdSession: ae(t, "startSession"),
        finishAdSession: ae(t, "finishSession"),
        reportError: ae(t, "sessionError"),
        registerAdEvents: ae(t, "registerAdEvents"),
        registerMediaEvents: ae(t, "registerMediaEvents"),
        injectVerificationScriptResources: ae(t, "injectVerificationScriptResources"),
        setSlotElement: ae(t, "setSlotElement"),
        setVideoElement: ae(t, "setVideoElement"),
        setElementBounds: ae(t, "setElementBounds"),
        setCreativeType: ae(t, "setCreativeType"),
        setImpressionType: ae(t, "setImpressionType"),
        setContentUrl: ae(t, "setContentUrl"),
        adEvents: {
          impressionOccurred: ae(t, "impressionOccurred"),
          loaded: ae(t, "loaded")
        },
        mediaEvents: {
          start: ae(t, "start"),
          firstQuartile: ae(t, "firstQuartile"),
          midpoint: ae(t, "midpoint"),
          thirdQuartile: ae(t, "thirdQuartile"),
          complete: ae(t, "complete"),
          pause: ae(t, "pause"),
          resume: ae(t, "resume"),
          bufferStart: ae(t, "bufferStart"),
          bufferFinish: ae(t, "bufferFinish"),
          skipped: ae(t, "skipped"),
          volumeChange: ae(t, "volumeChange"),
          playerStateChange: ae(t, "playerStateChange"),
          adUserInteraction: ae(t, "adUserInteraction")
        }
      }, t.mediaEvents.loaded = t.adEvents.loaded, t.videoEvents = t.mediaEvents, Object.freeze(t), Object.defineProperty(n, "omidSessionInterface", {
        value: t,
        writable: !1
      }));
    }
    function Ci(t, n) {
      this.i = n = n === void 0 ? le : n;
      var o = this;
      t.addEventListener("message", function(d) {
        if (Z(d.data) === "object") {
          var A = d.data;
          Qr(A) && d.source && o.g && o.g(Jr(A), d.source);
        }
      });
    }
    S(Ci, en), Ci.prototype.h = function(t, n) {
      if (n = n === void 0 ? this.i : n, !n) throw Error("Message destination must be defined at construction time or when sending the message.");
      n.postMessage(Zr(t), "*");
    };
    function tn() {
      this.g = An;
    }
    i = tn.prototype, i.registerSessionObserver = function(t, n) {
      Qi(we(this.g, t), n);
    }, i.setSlotElement = function(t, n) {
      we(this.g, t).setSlotElement(n);
    }, i.setElementBounds = function(t, n) {
      we(this.g, t).setElementBounds(n);
    }, i.error = function(t, n, o) {
      we(this.g, t).error(n, o);
    };
    function Ne(t, n, o, d) {
      t = we(t.g, n), o == "impression" ? se(t.i) && (o = t.i, d = (d = o.g.O) ? He(d) : null, d = tt(o, b(o, d)), ye(o, F(o, "impression", "javascript", d)), t.h && Si(t.h)) : (o == "loaded" ? (n = d, n = n === void 0 ? null : n, oe(t.i) && (d = t.i, d.g.h || d.g.g != "display") && (n = F(d, "loaded", "javascript", tt(d, b(d, n === void 0 ? null : n))), ye(d, n))) : oe(t.i) && (n = t.i, it(n, o, d), _t(n, o, d), ye(n, F(n, o, "javascript", d))), ["loaded", "start"].indexOf(o) !== -1 && t.h && Si(t.h));
    }
    i.injectVerificationScriptResources = function(t, n) {
      we(this.g, t).injectVerificationScriptResources(n);
    }, i.setCreativeType = function(t, n, o) {
      o = o === void 0 ? null : o, we(this.g, t).setCreativeType(n, o);
    }, i.setImpressionType = function(t, n) {
      we(this.g, t).setImpressionType(n);
    }, i.setClientInfo = function(t, n, o, d) {
      var A = this.g;
      if (t == null) t = A.g;
      else {
        var v = [].concat(l(A.h.values())).indexOf(A.g) !== -1 ? Ji(A) : A.g;
        A.h.set(t, v), t = v;
      }
      return t.setClientInfo(n, o, d);
    };
    function rn(t) {
      t = t.split("-")[0].split(".");
      for (var n = ["1", "0", "3"], o = 0; 3 > o; o++) {
        var d = parseInt(t[o], 10), A = parseInt(n[o], 10);
        if (d > A) break;
        if (d < A) return !1;
      }
      return !0;
    }
    function nn(t, n) {
      return /\d+\.\d+\.\d+(-.*)?/.test(t) && rn(t) ? n : JSON.stringify(n);
    }
    function sn(t, n) {
      return /\d+\.\d+\.\d+(-.*)?/.test(t) && rn(t) ? n || [] : n && typeof n == "string" ? JSON.parse(n) : [];
    }
    function tr() {
      var t = vs, n = this, o = o === void 0 ? e : o;
      this.g = t, this.h = o, this.j = new Wt(), this.h.omid = this.h.omid || {}, this.h.omid.v1_SessionServiceCommunication = this.j, this.i = o && o.addEventListener && o.postMessage ? new Ci(o) : null, this.m = null, this.j.g = this.l.bind(this), this.i && (this.i.g = this.o.bind(this)), this.s = new er(function(d, A, v) {
        try {
          an(n, d, A, v);
        } catch (R) {
          qe(ln(R));
        }
      }, function(d) {
        n.m = d;
        var A = Ki();
        n.i.h(new Ht(A, "identifyServiceWindow", "1.5.6-iab144"), d);
      }), ps(this.s, this.h);
    }
    tr.prototype.l = function(t, n) {
      Ni(t.method) != null && on(this, t, n, this.j);
    }, tr.prototype.o = function(t, n) {
      if (Ni(t.method) != null) {
        if (!this.m || n !== this.m) return qe("Unrecognized session client window. Cross-origin session clients must register via the setSessionClientWindow API. See https://interactiveadvertisingbureau.github.io/Open-Measurement-SDKJS/iframes.html#om-sdk-js-session-client"), !1;
        on(this, t, n, this.i);
      }
    };
    function on(t, n, o, d) {
      function A() {
        var _ = new Ht(v, "response", T, nn(T, I.apply(0, arguments)));
        d.h(_, o);
      }
      var v = n.h, R = n.method, T = n.version;
      n = sn(T, n.g);
      try {
        an(t, R, A, n);
      } catch (_) {
        d.h(new Ht(v, "error", T, ln(_)), o);
      }
    }
    function an(t, n, o, d) {
      if (Ni(n) != null) switch (Ni(n)) {
        case "registerAdEvents":
          var A = s(d).next().value, v = we(t.g.g, A).i;
          C(v, ["impression"]) && se(v) && (v.g.s = "javascript");
          break;
        case "registerMediaEvents":
          var R = s(d).next().value, T = we(t.g.g, R).i;
          C(T, Object.values(U)) && oe(T) && (T.g.j = "javascript");
          break;
        case "registerSessionObserver":
          var _ = s(d).next().value;
          t.g.registerSessionObserver(_, o);
          break;
        case "setSlotElement":
          var M = s(d), H = M.next().value, Ee = M.next().value;
          t.g.setSlotElement(Ee, H);
          break;
        case "setVideoElement":
          var nt = s(d), ht = nt.next().value, Lt = nt.next().value, $e = we(t.g.g, Lt);
          ht && ht.tagName && ht.tagName.toLowerCase() === "video" ? ($e.g.l = ht, $e.h && yi($e.h)) : qe("setVideoElement called with a non-HTMLVideoElement. It will be ignored.");
          break;
        case "setElementBounds":
          var Di = s(d), rr = Di.next().value, nr = Di.next().value;
          t.g.setElementBounds(nr, rr);
          break;
        case "startSession":
          var ti = s(d), Qe = ti.next().value, Li = ti.next().value, Je = t.h;
          if (Qe != null && Z(Qe) === "object") {
            var ii = Qe.customReferenceData, Me = Qe.underEvaluation, mn = Qe.universalAdId;
            typeof ii == "string" || (ii = void 0), typeof Me == "boolean" || (Me = !1);
            var gt = {
              customReferenceData: ii,
              underEvaluation: Me
            };
            if (typeof mn == "string" && (gt.universalAdId = mn), Oi(Je)) {
              var En = Gi(Je), bi;
              Z(En) === "object" && (bi = En.identifier), gt.app = {
                appId: bi && typeof bi == "string" ? bi : void 0
              };
              e: {
                var gn = Gi(Je);
                if (Z(gn) === "object") {
                  try {
                    var vn = JSON.parse(gn.deviceInfo);
                  } catch (oo) {
                    var sr = void 0;
                    break e;
                  }
                  sr = {
                    deviceType: vn.modelName || "Unknown",
                    osVersion: vn.platformVersion || "Unknown",
                    os: "webOS"
                  };
                } else sr = void 0;
              }
              gt.deviceInfo = sr, gt.deviceCategory = "ctv";
            } else if (Dt(Je)) {
              e: {
                if (Dt(Je)) {
                  try {
                    var Sn = Bt(Je).application.getCurrentApplication().appInfo.id;
                  } catch (oo) {
                    var or = void 0;
                    break e;
                  }
                  if (typeof Sn == "string") {
                    or = Sn;
                    break e;
                  }
                }
                or = void 0;
              }
              if (gt.app = {
                appId: or
              }, Dt(Je)) {
                var Mi = Bt(Je).systeminfo;
                if (Z(Mi) === "object" && typeof Mi.getCapability == "function")
                  var Ss = Mi.getCapability("http://tizen.org/system/model_name"), ys = Mi.getCapability("http://tizen.org/feature/platform.version");
                var yn = {
                  deviceType: Ss || "Unknown",
                  osVersion: ys || "Unknown",
                  os: "tizen"
                };
              } else yn = void 0;
              gt.deviceInfo = yn, Gr(Je) && (gt.deviceCategory = "ctv");
            }
            Qe = gt;
          } else Qe = null;
          if (Qe == null) break;
          var bt = Qe, ar = ar === void 0 ? null : ar, vt = we(t.g.g, Li), In = vt.g.i;
          In.sessionOwner || (In.sessionOwner = "javascript");
          var Is = Li || Ki();
          vt.g.H = Is, bt.canMeasureVisibility = vt.h.O();
          var lr = vt.g;
          bt.contentUrl !== void 0 && (lr.C = bt.contentUrl, bt.contentUrl = void 0);
          var On = lr.i || {};
          bt.omidJsInfo = Ie({}, On.omidJsInfo || {}, bt.omidJsInfo || {});
          var Os = Ie({}, On, bt);
          lr.i = Os, a(vt.i, ar), vt.h && Si(vt.h), cs(vt);
          break;
        case "finishSession":
          var Ts = s(d).next().value, Tn = t.g, ri = we(Tn.g, Ts), Rn = Tn.g;
          Rn.g = Ji(Rn), E(ri.i), ri.h.v(), ri.j && (ri.j.stop(), ri.j = null);
          break;
        case "impressionOccurred":
          var Rs = s(d).next().value;
          Ne(t.g, Rs, "impression");
          break;
        case "loaded":
          var Nn = s(d), Xt = Nn.next().value, Cn = Nn.next().value;
          if (Xt) {
            var _n = {
              skippable: Xt.isSkippable,
              autoPlay: Xt.isAutoPlay,
              position: Xt.position
            };
            Xt.isSkippable && (_n.skipOffset = Xt.skipOffset), Ne(t.g, Cn, "loaded", _n);
          } else Ne(t.g, Cn, "loaded");
          break;
        case "start":
          var dr = s(d), Ns = dr.next().value, Cs = dr.next().value, _s = dr.next().value;
          Ne(t.g, _s, "start", {
            duration: Ns,
            mediaPlayerVolume: Cs
          });
          break;
        case "firstQuartile":
          var Ds = s(d).next().value;
          Ne(t.g, Ds, "firstQuartile");
          break;
        case "midpoint":
          var Ls = s(d).next().value;
          Ne(t.g, Ls, "midpoint");
          break;
        case "thirdQuartile":
          var bs = s(d).next().value;
          Ne(t.g, bs, "thirdQuartile");
          break;
        case "complete":
          var Ms = s(d).next().value;
          Ne(t.g, Ms, "complete");
          break;
        case "pause":
          var Ps = s(d).next().value;
          Ne(t.g, Ps, "pause");
          break;
        case "resume":
          var ws = s(d).next().value;
          Ne(t.g, ws, "resume");
          break;
        case "bufferStart":
          var xs = s(d).next().value;
          Ne(t.g, xs, "bufferStart");
          break;
        case "bufferFinish":
          var Vs = s(d).next().value;
          Ne(t.g, Vs, "bufferFinish");
          break;
        case "skipped":
          var ks = s(d).next().value;
          Ne(t.g, ks, "skipped");
          break;
        case "volumeChange":
          var Dn = s(d), Us = Dn.next().value, Fs = Dn.next().value;
          Ne(t.g, Fs, "volumeChange", {
            mediaPlayerVolume: Us
          });
          break;
        case "playerStateChange":
          var Ln = s(d), $s = Ln.next().value, js = Ln.next().value;
          Ne(t.g, js, "playerStateChange", {
            state: $s
          });
          break;
        case "adUserInteraction":
          var bn = s(d), Bs = bn.next().value, Hs = bn.next().value;
          Ne(t.g, Hs, "adUserInteraction", {
            interactionType: Bs
          });
          break;
        case "setClientInfo":
          var Pi = s(d), Ws = Pi.next().value, Xs = Pi.next().value, qs = Pi.next().value, Ys = Pi.next().value, Gs = t.g.setClientInfo(Ys, Ws, Xs, qs);
          o(Gs);
          break;
        case "injectVerificationScriptResources":
          var Mn = s(d), Ks = Mn.next().value, zs = Mn.next().value;
          t.g.injectVerificationScriptResources(zs, Ks);
          break;
        case "setCreativeType":
          var Pn = s(d), Qs = Pn.next().value, Js = Pn.next().value;
          t.g.setCreativeType(Js, Qs);
          break;
        case "setImpressionType":
          var wn = s(d), Zs = wn.next().value, eo = wn.next().value;
          t.g.setImpressionType(eo, Zs);
          break;
        case "setContentUrl":
          var xn = s(d), to = xn.next().value, io = xn.next().value;
          we(t.g.g, io).g.C = to;
          break;
        case "sessionError":
          var ur = s(d), ro = ur.next().value, no = ur.next().value, so = ur.next().value;
          t.g.error(so, ro, no);
      }
    }
    function ln(t) {
      return `
        name: ` + t.name + `
        message: ` + t.message + `
        filename: ` + t.filename + `
        lineNumber: ` + t.lineNumber + `
        columnNumber: ` + t.columnNumber + `
        stack: ` + t.stack + `
        toString(): ` + t.toString();
    }
    function ir() {
      var t = An, n = fn, o = this, d = d === void 0 ? le : d;
      this.j = t, this.g = n, this.l = {}, this.m = {}, this.i = new Wt(), d.omid = d.omid || {}, d.omid.v1_VerificationServiceCommunication = this.i, this.h = null, d && d.addEventListener && d.postMessage && (this.h = new Ci(d)), this.i.g = function(A, v) {
        un(o, A, v, o.i);
      }, this.h && (this.h.g = function(A, v) {
        o.h && un(o, A, v, o.h);
      });
    }
    function dn(t) {
      t({
        adSessionId: "",
        timestamp: (/* @__PURE__ */ new Date()).getTime(),
        type: "sessionError",
        data: {
          errorType: "generic",
          message: "Registration to session events is only allowed for verification clients injected by the OM-SDK service itself. Please note that in a future release registration in this manner will be rejected."
        }
      });
    }
    function fs(t, n, o, d) {
      t = zr(t.j, d), d !== void 0 && t.g.u.has(d) ? (t = t.i, n === "media" || n === "video" ? Fe(t, o, d) : (o = {
        type: n,
        U: d,
        I: o
      }, t.j.push(o), mi(t, n, o))) : dn(o);
    }
    function As(t, n, o, d) {
      t = zr(t.j, d), d !== void 0 && t.g.u.has(d) ? Qi(t, n, o, d) : dn(n);
    }
    function ms(t, n, o, d) {
      ss(t.g, n, o, d);
    }
    ir.prototype.setInterval = function(t, n) {
      return this.g.setInterval(t, n);
    }, ir.prototype.clearInterval = function(t) {
      this.g.clearInterval(t);
    };
    function Es(t, n, o, d) {
      qi(t.g, "downloadJavaScriptResource")(n, o, d);
    }
    function un(t, n, o, d) {
      function A() {
        var Me = new Ht(v, "response", T, nn(T, I.apply(0, arguments)));
        d.h(Me, o);
      }
      var v = n.h, R = n.method, T = n.version;
      if (n = sn(T, n.g), Zi(R, "VerificationService.") != null) {
        R = Zi(R, "VerificationService.");
        try {
          switch (R) {
            case "addEventListener":
              var _ = s(n), M = _.next().value, H = _.next().value || hn(o);
              fs(t, M, A, H);
              break;
            case "addSessionListener":
              var Ee = s(n), nt = Ee.next().value, ht = Ee.next().value || hn(o);
              As(t, A, nt, ht);
              break;
            case "sendUrl":
              var Lt = s(n).next().value;
              ms(t, Lt, function() {
                return A(!0);
              }, function() {
                return A(!1);
              });
              break;
            case "setTimeout":
              var $e = s(n), Di = $e.next().value, rr = $e.next().value;
              t.l[Di] = vi(t.g, "setTimeout")(A, rr);
              break;
            case "clearTimeout":
              var nr = s(n).next().value;
              ns(t.g, t.l[nr]);
              break;
            case "setInterval":
              var ti = s(n), Qe = ti.next().value, Li = ti.next().value;
              t.m[Qe] = t.setInterval(A, Li);
              break;
            case "clearInterval":
              var Je = s(n).next().value;
              t.clearInterval(t.m[Je]);
              break;
            case "injectJavaScriptResource":
              var ii = s(n).next().value;
              Es(t, ii, function(Me) {
                return A(!0, Me);
              }, function() {
                return A(!1);
              });
              break;
            case "getVersion":
              A("1.5.6-iab144");
          }
        } catch (Me) {
          d.h(new Ht(v, "error", T, `
              name: ` + Me.name + `
              message: ` + Me.message + `
              filename: ` + Me.filename + `
              lineNumber: ` + Me.lineNumber + `
              columnNumber: ` + Me.columnNumber + `
              stack: ` + Me.stack + `
              toString(): ` + Me.toString() + `
          `), o);
        }
      }
    }
    function hn(t) {
      for (var n = V().g, o = s(n.keys()), d = o.next(); !d.done; d = o.next()) {
        d = d.value;
        var A = n.get(d);
        if (A) {
          if (A.contentWindow === t) return d;
          try {
            if (A.contentWindow.Object.prototype.isPrototypeOf(t)) return d;
          } catch (v) {
          }
        }
      }
    }
    function cn(t) {
      var n = {};
      return (n.app = "omid_v1_present_app", n.web = "omid_v1_present_web", n)[t];
    }
    function pn(t, n) {
      t.document.write('<iframe style="display:none" id="' + (n + '" name="' + n + '" sandbox></iframe>'));
    }
    function _i(t, n) {
      var o = t.document.createElement("iframe");
      o.id = n, o.name = n, o.style.display = "none", o.sandbox = "", t.document.body.appendChild(o);
    }
    function gs(t, n) {
      var o = new MutationObserver(function(d) {
        d.forEach(function(A) {
          A.addedNodes[0].nodeName === "BODY" && (A = cn(n), _i(t, "omid_v1_present"), _i(t, A), o.disconnect());
        });
      });
      o.observe(t.document.documentElement, {
        childList: !0
      });
    }
    var fn = new Xi(), An = new function() {
      this.i = fn, this.h = /* @__PURE__ */ new Map(), this.g = Ji(this);
    }(), vs = new tn();
    new ir(), new tr(), function(t, n) {
      t.frames && t.document && !["omid_v1_present", "omid_v1_present_web", "omid_v1_present_app"].some(function(o) {
        return !!t.frames[o];
      }) && (t.document.body == null && "MutationObserver" in t ? gs(t, n) : (n = cn(n), t.document.body ? (_i(t, "omid_v1_present"), _i(t, n)) : (pn(t, "omid_v1_present"), pn(t, n))));
    }(le, "web");
  }).call(c, c);
}
const Gn = "4.0", Kn = ["4.0"], Ur = class Ur {
  constructor() {
    this.OmidServiceClient = qo();
  }
  detectOMID(e) {
    const i = "omid_v1_present", r = window;
    let s = !1;
    try {
      const l = e.omidServiceWindow;
      s = l.frames ? !!l.frames[i] : !1;
    } catch (l) {
      p.debug.warn("detectOMID: Publisher-Service could not be recognized.", l);
    }
    s || (p.debug.info("detectOMID: Publisher-Service not present. Using internal service."), e.omidServiceWindow = r);
  }
  hasValidHandshake(e, i = Gn, r = Kn) {
    if (!e.handshakeVersion)
      return !1;
    const s = e.handshakeVersion(i);
    return r.includes(s);
  }
  hasValidFacadeImplementation(e, i = uo) {
    return Object.getOwnPropertyNames(Object.getPrototypeOf(new i())).filter((l) => !(l in e)).length <= 0;
  }
  validate(e) {
    if (!e) {
      this.error = w.SETUP.NO_FACADE;
      return;
    }
    if (!this.hasValidHandshake(e)) {
      this.error = w.SETUP.INVALID_HANDSHAKE;
      return;
    }
    if (!this.hasValidFacadeImplementation(e)) {
      this.error = w.SETUP.INCORRECT_FACADE;
      return;
    }
    this.error = {};
  }
  /**
   * Sets up a new core instance with the given configuration, as specified in Global Configuration.
   * Returns a promise that either resolves with the APIs or rejects with a facade error.
   *
   * @param {PlayerFacade} playerFacade - The player facade object to establish a connection with.
   * @param {config} config - Basic configuration for the APIs (core instance)
   * @returns {Promise<MainController|Error>} Resolves with MainController - Reject with Error (Facade failure)
   */
  init(e, i) {
    let r = zt(hi, i);
    return new Promise((s, l) => {
      this.validate(e), this.detectOMID(r.adVerification);
      function h(m) {
        p.debug.critical("init - error", m), l(m);
      }
      Object.keys(this.initError).length > 0 ? h(this.initError) : s(new br(r, e));
    });
  }
  /**
   * @returns {number} Ad request methods
   */
  get AD_REQUEST_METHOD() {
    return is;
  }
  /**
   * @returns {Object} Ad types
   */
  get AD_TYPE() {
    return he;
  }
  /**
   * @returns {Object} Ad variants
   */
  get AD_VARIANT() {
    return fe;
  }
  /**
   * @returns {Object} the default config.
   */
  get CONFIG() {
    return xr(hi);
  }
  /**
   * @returns {Object} the default mimetypes.
   */
  get DEFAULT_MIMETYPES() {
    return ci;
  }
  /**
   * @returns {Object} List of event types as ENUMs
   */
  get EVENT() {
    return f;
  }
  /**
   * @returns {Array} List of event types
   */
  get EVENTS() {
    return Object.values(f);
  }
  get LOGLEVEL() {
    return lt;
  }
  /**
   * Set the log level.
   * @param {LOGLEVEL} level - The log level to set. ( SILENT - 0, ERROR - 1, NORMAL - 2, VERBOSE - 3)
   * @returns {void}
   */
  set debugLevel(e) {
    p.logLevel = e;
  }
  /**
   * Get the current log level.
   * @returns {number} Returns '0' by default, or the value set by the 'debugLevel' setter.
   */
  get debugLevel() {
    return p.logLevel;
  }
  /**
   * Get the debug log object.
   * @returns {Object} Debug log object with log functions.
   */
  get debugger() {
    return p.debug;
  }
  /**
   * @returns {string} Facade version string
   */
  get facadeVersion() {
    return Gn;
  }
  /**
   * @returns {Object} InitError object
   */
  get initError() {
    return this.error;
  }
  /**
   * @returns {Array} Array of supported Facades by version
   */
  get supportedFacadeVersions() {
    return Kn;
  }
  /**
   * @returns {string} smartclientcore version string
   */
  get version() {
    return "7.6.0-dev";
  }
};
Ur.NAME = "Core::";
let Wi = Ur;
const Yo = new Wi();
typeof window != "undefined" && (window.smartclientcore = Yo);
typeof exports == "object" && (exports = {
  smartclientcore: Wi
});
export {
  uo as FacadeBase,
  Yo as default
};
