//
//  SCAdEvent.h
//  SCTVOSSDK
//
//  Copyright © 2018 smartclip. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN
/**
 * This class describes a certain adEvent, as being sent for eventCallbacks.
 */
@interface SCAdEvent : NSObject

///EventType: type of events that are fired during the progress of an ad slot.
typedef enum EventType {
    EVENT_TYPE_UNDEFINED = -1,
    ON_AD_CLICKED,
    ON_AD_ERROR,
    ON_AD_FINISHED,
    ON_AD_STOPPED,
    ON_AD_LINEARITY_CHANGE,
    ON_AD_MANIFEST_LOADED,
    ON_AD_MANIFEST_LOAD_ERROR,
    ON_AD_PLAYBACK_FINISHED,
    ON_AD_LOADED,
    ON_AD_SKIPPED,
    ON_AD_START,
    ON_AD_STARTED,
    ON_AD_FIRST_QUARTILE,
    ON_AD_IMPRESSION,
    ON_AD_CREATIVE_VIEW,
    ON_AD_MID_POINT,
    ON_AD_PAUSED,
    ON_AD_PLAYBACK_START,
    ON_AD_PLAYING,
    ON_AD_THIRD_QUARTILE,
    ON_AD_SIZE_CHANGED,
    ON_AD_PROGRESS,
    ON_AD_REWIND,
    ON_AD_VOLUME_CHANGED,
    ON_AD_UNMUTED,
    ON_AD_MUTED,
    ON_ENTER_FULLSCREEN,
    ON_EXIT_FULLSCREEN,
    ON_PLAYER_EXPAND,
    ON_PLAYER_COLLAPSE,
    ON_CLOSED_CAPTIONS_DETECTED,
    ON_COMPANIONS_DETECTED,
    ON_EXTENSIONS_DETECTED,
    ON_NONLINEAR_DETECTED,
    ON_VERIFICATION_DETECTED,
    ON_ICONS_DETECTED,
    ON_ICON_CLICKED,
    ON_AD_SKIPPABLE_STATE_CHANGE,
    ON_COMPANION_CREATIVE_VIEW,
    ON_COMPANION_CLICKED,
    ON_AD_NONLINEAR_FINISHED,
    ON_AD_NONLINEAR_STOPPED,
    ON_AD_SLOT_START,
    ON_AD_SLOT_STARTED,
    ON_AD_SLOT_FINISHED,
    ON_AD_SLOT_STOPPED,
    ON_AD_SLOT_COMPLETE,
    ON_AD_SLOT_DURATION_CHANGE,
    ON_AD_VIEWABLE,
    ON_AD_NOT_VIEWABLE,
    ON_AD_VIEWABLE_STATE_CHANGE,
    ON_AD_VIEWABLE_UNDETERMINED,
    ON_AD_WARNING,
    ON_AD_REINSERTION_ACTIVATION,
    ON_GENERAL_ERROR,
    ON_HOMAD_PENALTY,
    ON_PLAYBACK_FINISHED,
    ON_SIMID_ERROR,
    ON_AD_PLAYLIST_LOADED,
    ON_AD_PLAYLIST_START,
    ON_AD_PLAYLIST_STARTED,
    ON_AD_PLAYLIST_STOPPED,
    ON_AD_PLAYLIST_COMPLETE
} EventType;

///Event type
@property (nonatomic)       EventType          type;

///Always smartclip
@property (nonatomic, copy) NSString           *issuer;

///Adopted from the Bitmovin Player Events. Current client time
@property (nonatomic)       NSTimeInterval      timestamp;

/**
 * Initalizer, takes a JSON formatted description string
 * - Parameter description: description as JSON formatted string
 */
- (id)initWithDescription:(NSString*)description;

/**
 * Gives back a string describing the current event
 */
- (NSString*)eventString;
@end

NS_ASSUME_NONNULL_END
