//
//  SCAdPlaylistSetup.h
//  SCTVOSSDK
//

#import <Foundation/Foundation.h>
#import <CoreGraphics/CoreGraphics.h>

NS_ASSUME_NONNULL_BEGIN

@class SCAdVariants;

/// VMAP Ad playlist configuration for the upcoming content video.
/// Can be used to configure different variant clips for pre-, mid- and postroll
/// adSlots of a VMAP playlist
@interface SCAdPlaylistSetup : NSObject
/// prefetchOffset for midrolls (defaults to 5 seconds)
@property (nonatomic) CGFloat prefetchOffsetMidroll;
/// prefetchOffset for midrolls (defaults to 5 seconds)
@property (nonatomic) CGFloat prefetchOffsetPostroll;

/// Initialiser to configure different variants for pre-, mid- and postroll
- (instancetype)initWithAdTag:(nullable NSString*)adTag
                      preroll:(nullable SCAdVariants*)preroll
                      midroll:(nullable SCAdVariants*)midroll
                     postroll:(nullable SCAdVariants*)postroll;
@end

NS_ASSUME_NONNULL_END
