//
//  SCAdSessionController.h
//  SCTVOSSDK
//
//  Copyright © 2018 smartclip. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <AVKit/AVKit.h>
#import <SCTVOSSDK/SCAdFacadeDelegate.h>

@class SCAdSlotController;
@protocol SCAdSessionStateListener;
/**
* The SCAdSessionController is a singleton configuration for the Smartclip advertising SDK, it is the initial component that establishes
* the basic connection to the Ad server and creates the AdSlots.
*/
@interface SCAdSessionController : NSObject
/// CompletionBlock that delivers a String
typedef void (^SCStringCompletionBlock)(NSString* _Nullable string);

@property (nonatomic, weak) id<SCAdSessionStateListener> _Nullable sessionStateListener;
///Get the shared instance of this controller
+ (instancetype _Nonnull )sharedInstance;

/// Use this function to get your SCAdSlotController, the object that handles an adSlot
- (SCAdSlotController*_Nonnull)createAdSlotWithFacadeDelegate:(id<SCAdFacadeDelegate>_Nonnull)listener;
/// Get version string of core
- (void)getCoreVersion:(SCStringCompletionBlock _Nonnull )completion;
/// OMID requires to be informed about last user activities, call this function to achieve this
- (void)updateLastActivity;
@end
