//
//  SCElementSize.h
//  SCTVOSSDK
//
//  Copyright © 2020 smartclip. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN

/// Class that describes the size of the video player and its view mode
@interface SCElementSize : NSObject
///View Mode (self explanatory)
typedef enum ViewMode {
    ViewModeNormal,
    ViewModeFullscreen
} ViewMode;

///Initializer for this class give in view mode and bounding rect of the video player view
- (instancetype)initWithViewMode:(ViewMode)viewMode boundingRect:(CGRect)boundingRect;
@end

NS_ASSUME_NONNULL_END
